/*
 * $Id: zuse23_matrix_gui.c,v 1.1 2012-11-28 11:08:21 vrsieh Exp $ 
 *
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-gui.h"

#include "zuse23_matrix_gui.h"
#ifdef HAVE_GTK
#include "zuse23_matrix_gui_gtk.h"
#endif

#define COMP_(x)	zuse23_matrix_ ## x

void *
COMP_(gui_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_sperr0,
	struct sig_boolean *port_sperr1,
	struct sig_boolean *port_sperr2,
	struct sig_boolean *port_sperr3,
	struct sig_boolean *port_sperr4,
	struct sig_boolean *port_sperr5,
	struct sig_boolean *port_sperr6,
	struct sig_boolean *port_sperr7,
	struct sig_boolean *port_sperr8,
	struct sig_boolean *port_sperr9,
	struct sig_boolean *port_sperr10,
	struct sig_boolean *port_sperr11,
	struct sig_boolean *port_sperr12,
	struct sig_boolean *port_sperr13,
	struct sig_boolean *port_sperr14,
	struct sig_boolean *port_sperr15
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return COMP_(gui_gtk_create)(page, name, port_manage,
				port_sperr0, port_sperr1,
				port_sperr2, port_sperr3,
				port_sperr4, port_sperr5,
				port_sperr6, port_sperr7,
				port_sperr8, port_sperr9,
				port_sperr10, port_sperr11,
				port_sperr12, port_sperr13,
				port_sperr14, port_sperr15);
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
COMP_(gui_destroy)(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_destroy)(_cpssp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0);
	}
}

void
COMP_(gui_suspend)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_suspend)(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0);
	}
}

void
COMP_(gui_resume)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_resume)(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0);
	}
}
