/*
 * $Id: zuse23_console_gui_gtk.c,v 1.3 2012-11-27 19:27:59 vrsieh Exp $ 
 *
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "umutil.h"
#include "glue-gui-gtk.h"

#include "sig_boolean.h"

#include "zuse23_console_gui.h"

struct cpssp {
	int x;
};

static GdkPixbuf *black = NULL;
static GdkPixbuf *lamp_on = NULL;
static GdkPixbuf *lamp_off = NULL;

static void
reset_cb(GtkWidget *w, gpointer _row)
{
	GtkWidget **row = _row;
	int i;

	for (i = 0; i < 10; i++) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(row[i]), 0);
	}
}

static void
lamp_cb(void *_image, unsigned int val)
{
	GtkWidget *image = _image;

	gtk_image_set_from_pixbuf(GTK_IMAGE(image), val ? lamp_on : lamp_off);
}

static void
sw_cb(GtkWidget *w, gpointer _sig)
{
	struct sig_boolean *sig = _sig;

	sig_boolean_set(sig, w,
			gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)));
}

static void
bt_pressed_cb(GtkWidget *w, gpointer _sig)
{
	struct sig_boolean *sig = _sig;

	sig_boolean_set(sig, w, 1);
}

static void
bt_released_cb(GtkWidget *w, gpointer _sig)
{
	struct sig_boolean *sig = _sig;

	sig_boolean_set(sig, w, 0);
}

static void
console_switch(
	GtkWidget *table,
	struct sig_boolean *sig_sw0,
	struct sig_boolean *sig_lamp0,
	struct sig_boolean *sig_sw1,
	struct sig_boolean *sig_lamp1,
	struct sig_boolean *sig_sw2,
	struct sig_boolean *sig_lamp2,
	struct sig_boolean *sig_sw3,
	struct sig_boolean *sig_lamp3,
	struct sig_boolean *sig_sw4,
	struct sig_boolean *sig_lamp4,
	struct sig_boolean *sig_sw5,
	struct sig_boolean *sig_lamp5,
	struct sig_boolean *sig_sw6,
	struct sig_boolean *sig_lamp6,
	struct sig_boolean *sig_sw7,
	struct sig_boolean *sig_lamp7,
	struct sig_boolean *sig_sw8,
	struct sig_boolean *sig_lamp8,
	struct sig_boolean *sig_sw9,
	struct sig_boolean *sig_lamp9,
	int left,
	int top
)
{
	GtkWidget *reset_button;
	GtkWidget *image;
	GtkWidget **button;
	int i;

	if (! black) {
		const char *path;

		path = buildpath(PNGDIR, "button_black.png");
		black = gdk_pixbuf_new_from_file(path, NULL);
		assert(black);
		path = buildpath(PNGDIR, "button_lamp_on.png");
		lamp_on = gdk_pixbuf_new_from_file(path, NULL);
		assert(lamp_on);
		path = buildpath(PNGDIR, "button_lamp_off.png");
		lamp_off = gdk_pixbuf_new_from_file(path, NULL);
		assert(lamp_off);
	}

	reset_button = gtk_button_new();
	gtk_widget_show(reset_button);

	image = gtk_image_new();
	gtk_widget_show(image);

	gtk_image_set_from_pixbuf(GTK_IMAGE(image), black);

	gtk_container_add(GTK_CONTAINER(reset_button), image);

	gtk_table_attach_defaults(GTK_TABLE(table), reset_button,
			left, left + 1, top, top + 1);

	button = malloc(sizeof(*button) * 10);
	assert(button);
	for (i = 0; i < 10; i++) {
		static const struct sig_boolean_funcs lamp_cb_funcs = {
			.set = lamp_cb,
		};
		struct sig_boolean *sig;

		/* Switch */
		button[i] = gtk_toggle_button_new();
		gtk_widget_show(button[i]);

		/* Lamp within lamp */
		image = gtk_image_new();
		gtk_widget_show(image);

		gtk_image_set_from_pixbuf(GTK_IMAGE(image), lamp_off);

		gtk_container_add(GTK_CONTAINER(button[i]), image);

		gtk_table_attach_defaults(GTK_TABLE(table), button[i],
				left + 1 + i, left + 1 + i + 1, top, top + 1);

		/* Register switch callback. */
		switch (i) {
		case 0: sig = sig_sw0; break;
		case 1: sig = sig_sw1; break;
		case 2: sig = sig_sw2; break;
		case 3: sig = sig_sw3; break;
		case 4: sig = sig_sw4; break;
		case 5: sig = sig_sw5; break;
		case 6: sig = sig_sw6; break;
		case 7: sig = sig_sw7; break;
		case 8: sig = sig_sw8; break;
		case 9: sig = sig_sw9; break;
		default: assert(0);
		}
		sig_boolean_connect_out(sig, button[i], 0);
		g_signal_connect(button[i], "clicked", G_CALLBACK(sw_cb), sig);
		
		/* Register lamp callback. */
		switch (i) {
		case 0: sig = sig_lamp0; break;
		case 1: sig = sig_lamp1; break;
		case 2: sig = sig_lamp2; break;
		case 3: sig = sig_lamp3; break;
		case 4: sig = sig_lamp4; break;
		case 5: sig = sig_lamp5; break;
		case 6: sig = sig_lamp6; break;
		case 7: sig = sig_lamp7; break;
		case 8: sig = sig_lamp8; break;
		case 9: sig = sig_lamp9; break;
		default: assert(0);
		}
		if (sig) {
			sig_boolean_connect_in(sig, image, &lamp_cb_funcs);
		}
	}

	g_signal_connect(reset_button, "pressed",
			G_CALLBACK(reset_cb), button);
}

static void
console_button(GtkWidget *table, struct sig_boolean *sig, int left, int top)
{
	GtkWidget *button;

	button = gtk_button_new();
	gtk_widget_show(button);

	sig_boolean_connect_out(sig, button, 0);
	g_signal_connect(button, "pressed",
			G_CALLBACK(bt_pressed_cb), sig);
	g_signal_connect(button, "released",
			G_CALLBACK(bt_released_cb), sig);

	gtk_table_attach_defaults(GTK_TABLE(table), button,
			left, left + 1, top, top + 1);
}

static void
console_label(GtkWidget *table, const char *s, int big, int left, int right, int top)
{
	char text[256];
	GtkWidget *label;

	if (big) {
		sprintf(text, "%s", s);
	} else {
		sprintf(text, "<small><small>%s</small></small>", s);
	}
	label = gtk_label_new(text);
	gtk_label_set_markup(GTK_LABEL(label), text);
	gtk_widget_show(label);

	gtk_table_attach_defaults(GTK_TABLE(table), label,
			left, right, top, top + 1);
}

void *
zuse23_console_gui_gtk_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_misc_lamp0,
	struct sig_boolean *port_misc_lamp1,
	struct sig_boolean *port_misc_lamp2,
	struct sig_boolean *port_misc_lamp3,
	struct sig_boolean *port_misc_lamp4,
	struct sig_boolean *port_misc_lamp5,
	struct sig_boolean *port_misc_lamp6,
	struct sig_boolean *port_misc_lamp7,
	struct sig_boolean *port_misc_lamp8,
	struct sig_boolean *port_misc_lamp9,
	struct sig_boolean *port_bef_lamp39,
	struct sig_boolean *port_bef_lamp38,
	struct sig_boolean *port_bef_lamp37,
	struct sig_boolean *port_bef_lamp36,
	struct sig_boolean *port_bef_lamp35,
	struct sig_boolean *port_bef_lamp34,
	struct sig_boolean *port_bef_lamp33,
	struct sig_boolean *port_bef_lamp32,
	struct sig_boolean *port_bef_lamp31,
	struct sig_boolean *port_bef_lamp30,
	struct sig_boolean *port_bef_lamp29,
	struct sig_boolean *port_bef_lamp28,
	struct sig_boolean *port_bef_lamp27,
	struct sig_boolean *port_bef_lamp26,
	struct sig_boolean *port_bef_lamp25,
	struct sig_boolean *port_bef_lamp24,
	struct sig_boolean *port_bef_lamp23,
	struct sig_boolean *port_bef_lamp22,
	struct sig_boolean *port_bef_lamp21,
	struct sig_boolean *port_bef_lamp20,
	struct sig_boolean *port_bef_lamp19,
	struct sig_boolean *port_bef_lamp18,
	struct sig_boolean *port_bef_lamp17,
	struct sig_boolean *port_bef_lamp16,
	struct sig_boolean *port_bef_lamp15,
	struct sig_boolean *port_bef_lamp14,
	struct sig_boolean *port_bef_lamp13,
	struct sig_boolean *port_bef_lamp12,
	struct sig_boolean *port_bef_lamp11,
	struct sig_boolean *port_bef_lamp10,
	struct sig_boolean *port_bef_lamp9,
	struct sig_boolean *port_bef_lamp8,
	struct sig_boolean *port_bef_lamp7,
	struct sig_boolean *port_bef_lamp6,
	struct sig_boolean *port_bef_lamp5,
	struct sig_boolean *port_bef_lamp4,
	struct sig_boolean *port_bef_lamp3,
	struct sig_boolean *port_bef_lamp2,
	struct sig_boolean *port_bef_lamp1,
	struct sig_boolean *port_bef_lamp0,
	struct sig_boolean *port_akku_lamp39,
	struct sig_boolean *port_akku_lamp38,
	struct sig_boolean *port_akku_lamp37,
	struct sig_boolean *port_akku_lamp36,
	struct sig_boolean *port_akku_lamp35,
	struct sig_boolean *port_akku_lamp34,
	struct sig_boolean *port_akku_lamp33,
	struct sig_boolean *port_akku_lamp32,
	struct sig_boolean *port_akku_lamp31,
	struct sig_boolean *port_akku_lamp30,
	struct sig_boolean *port_akku_lamp29,
	struct sig_boolean *port_akku_lamp28,
	struct sig_boolean *port_akku_lamp27,
	struct sig_boolean *port_akku_lamp26,
	struct sig_boolean *port_akku_lamp25,
	struct sig_boolean *port_akku_lamp24,
	struct sig_boolean *port_akku_lamp23,
	struct sig_boolean *port_akku_lamp22,
	struct sig_boolean *port_akku_lamp21,
	struct sig_boolean *port_akku_lamp20,
	struct sig_boolean *port_akku_lamp19,
	struct sig_boolean *port_akku_lamp18,
	struct sig_boolean *port_akku_lamp17,
	struct sig_boolean *port_akku_lamp16,
	struct sig_boolean *port_akku_lamp15,
	struct sig_boolean *port_akku_lamp14,
	struct sig_boolean *port_akku_lamp13,
	struct sig_boolean *port_akku_lamp12,
	struct sig_boolean *port_akku_lamp11,
	struct sig_boolean *port_akku_lamp10,
	struct sig_boolean *port_akku_lamp9,
	struct sig_boolean *port_akku_lamp8,
	struct sig_boolean *port_akku_lamp7,
	struct sig_boolean *port_akku_lamp6,
	struct sig_boolean *port_akku_lamp5,
	struct sig_boolean *port_akku_lamp4,
	struct sig_boolean *port_akku_lamp3,
	struct sig_boolean *port_akku_lamp2,
	struct sig_boolean *port_akku_lamp1,
	struct sig_boolean *port_akku_lamp0,
	struct sig_boolean *port_misc_switch0,
	struct sig_boolean *port_misc_switch1,
	struct sig_boolean *port_misc_switch2,
	struct sig_boolean *port_misc_switch3,
	struct sig_boolean *port_misc_switch4,
	struct sig_boolean *port_misc_switch5,
	struct sig_boolean *port_misc_switch6,
	struct sig_boolean *port_misc_switch7,
	struct sig_boolean *port_misc_switch8,
	struct sig_boolean *port_misc_switch9,
	struct sig_boolean *port_sperr_switch7,
	struct sig_boolean *port_sperr_switch6,
	struct sig_boolean *port_sperr_switch5,
	struct sig_boolean *port_sperr_switch4,
	struct sig_boolean *port_sperr_switch3,
	struct sig_boolean *port_sperr_switch2,
	struct sig_boolean *port_sperr_switch1,
	struct sig_boolean *port_loe_aus_switch,
	struct sig_boolean *port_misc_switch18,
	struct sig_boolean *port_adr_p1_aus_switch,
	struct sig_boolean *port_bed_switch4,
	struct sig_boolean *port_bed_switch3,
	struct sig_boolean *port_bed_switch2,
	struct sig_boolean *port_bed_switch1,
	struct sig_boolean *port_bed_switch0,
	struct sig_boolean *port_bed_ein_switch,
	struct sig_boolean *port_adr_stop_ein_switch,
	struct sig_boolean *port_adr_stop_switch12,
	struct sig_boolean *port_adr_stop_switch11,
	struct sig_boolean *port_adr_stop_switch10,
	struct sig_boolean *port_adr_stop_switch9,
	struct sig_boolean *port_adr_stop_switch8,
	struct sig_boolean *port_adr_stop_switch7,
	struct sig_boolean *port_adr_stop_switch6,
	struct sig_boolean *port_adr_stop_switch5,
	struct sig_boolean *port_adr_stop_switch4,
	struct sig_boolean *port_adr_stop_switch3,
	struct sig_boolean *port_adr_stop_switch2,
	struct sig_boolean *port_adr_stop_switch1,
	struct sig_boolean *port_adr_stop_switch0,
	struct sig_boolean *port_bef_switch39,
	struct sig_boolean *port_bef_switch38,
	struct sig_boolean *port_bef_switch37,
	struct sig_boolean *port_bef_switch36,
	struct sig_boolean *port_bef_switch35,
	struct sig_boolean *port_bef_switch34,
	struct sig_boolean *port_bef_switch33,
	struct sig_boolean *port_bef_switch32,
	struct sig_boolean *port_bef_switch31,
	struct sig_boolean *port_bef_switch30,
	struct sig_boolean *port_bef_switch29,
	struct sig_boolean *port_bef_switch28,
	struct sig_boolean *port_bef_switch27,
	struct sig_boolean *port_bef_switch26,
	struct sig_boolean *port_bef_switch25,
	struct sig_boolean *port_bef_switch24,
	struct sig_boolean *port_bef_switch23,
	struct sig_boolean *port_bef_switch22,
	struct sig_boolean *port_bef_switch21,
	struct sig_boolean *port_bef_switch20,
	struct sig_boolean *port_bef_switch19,
	struct sig_boolean *port_bef_switch18,
	struct sig_boolean *port_bef_switch17,
	struct sig_boolean *port_bef_switch16,
	struct sig_boolean *port_bef_switch15,
	struct sig_boolean *port_bef_switch14,
	struct sig_boolean *port_bef_switch13,
	struct sig_boolean *port_bef_switch12,
	struct sig_boolean *port_bef_switch11,
	struct sig_boolean *port_bef_switch10,
	struct sig_boolean *port_bef_switch9,
	struct sig_boolean *port_bef_switch8,
	struct sig_boolean *port_bef_switch7,
	struct sig_boolean *port_bef_switch6,
	struct sig_boolean *port_bef_switch5,
	struct sig_boolean *port_bef_switch4,
	struct sig_boolean *port_bef_switch3,
	struct sig_boolean *port_bef_switch2,
	struct sig_boolean *port_bef_switch1,
	struct sig_boolean *port_bef_switch0,
	struct sig_boolean *port_akku_switch39,
	struct sig_boolean *port_akku_switch38,
	struct sig_boolean *port_akku_switch37,
	struct sig_boolean *port_akku_switch36,
	struct sig_boolean *port_akku_switch35,
	struct sig_boolean *port_akku_switch34,
	struct sig_boolean *port_akku_switch33,
	struct sig_boolean *port_akku_switch32,
	struct sig_boolean *port_akku_switch31,
	struct sig_boolean *port_akku_switch30,
	struct sig_boolean *port_akku_switch29,
	struct sig_boolean *port_akku_switch28,
	struct sig_boolean *port_akku_switch27,
	struct sig_boolean *port_akku_switch26,
	struct sig_boolean *port_akku_switch25,
	struct sig_boolean *port_akku_switch24,
	struct sig_boolean *port_akku_switch23,
	struct sig_boolean *port_akku_switch22,
	struct sig_boolean *port_akku_switch21,
	struct sig_boolean *port_akku_switch20,
	struct sig_boolean *port_akku_switch19,
	struct sig_boolean *port_akku_switch18,
	struct sig_boolean *port_akku_switch17,
	struct sig_boolean *port_akku_switch16,
	struct sig_boolean *port_akku_switch15,
	struct sig_boolean *port_akku_switch14,
	struct sig_boolean *port_akku_switch13,
	struct sig_boolean *port_akku_switch12,
	struct sig_boolean *port_akku_switch11,
	struct sig_boolean *port_akku_switch10,
	struct sig_boolean *port_akku_switch9,
	struct sig_boolean *port_akku_switch8,
	struct sig_boolean *port_akku_switch7,
	struct sig_boolean *port_akku_switch6,
	struct sig_boolean *port_akku_switch5,
	struct sig_boolean *port_akku_switch4,
	struct sig_boolean *port_akku_switch3,
	struct sig_boolean *port_akku_switch2,
	struct sig_boolean *port_akku_switch1,
	struct sig_boolean *port_akku_switch0,
	struct sig_boolean *port_stop,
	struct sig_boolean *port_weiter,
	struct sig_boolean *port_start,
	struct sig_boolean *port_akku_ueb,
	struct sig_boolean *port_bef_ueb
)
{
	struct cpssp *cpssp;
	GtkWidget *table;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	table = gtk_table_new(14, 49, 1);
	gtk_widget_show(table);

	console_label(table, "Nacht", 0, 2, 3, 1);
	console_label(table, "Trommel", 1, 3, 5, 0);
	console_label(table, "Ein", 0, 3, 4, 1);
	console_label(table, "Aus", 0, 4, 5, 1);
	console_label(table, "Maschine", 1, 5, 7, 0);
	console_label(table, "Ein", 0, 5, 6, 1);
	console_label(table, "Aus", 0, 6, 7, 1);
	console_label(table, "FS", 1, 7, 8, 0);
	console_label(table, "Ein", 0, 7, 8, 1);
	console_label(table, "Abtaster", 1, 8, 10, 0);
	console_label(table, "Ein", 0, 8, 9, 1);
	console_label(table, "a.Dr.", 0, 9, 10, 1);
	console_label(table, "Testst.", 1, 10, 12, 0);
	console_label(table, "2/1", 0, 10, 11, 1);
	console_label(table, "3/40", 0, 11, 12, 1);
	console_switch(table,
		port_misc_switch0, port_misc_lamp0,
		port_misc_switch1, port_misc_lamp1,
		port_misc_switch2, port_misc_lamp2,
		port_misc_switch3, port_misc_lamp3,
		port_misc_switch4, port_misc_lamp4,
		port_misc_switch5, port_misc_lamp5,
		port_misc_switch6, port_misc_lamp6,
		port_misc_switch7, port_misc_lamp7,
		port_misc_switch8, port_misc_lamp8,
		port_misc_switch9, port_misc_lamp9,
		1, 2);
	console_label(table, "Schreibsprerre", 1, 14, 21, 0);
	console_label(table, "7168", 0, 14, 15, 1);
	console_label(table, "6144", 0, 15, 16, 1);
	console_label(table, "5120", 0, 16, 17, 1);
	console_label(table, "4096", 0, 17, 18, 1);
	console_label(table, "3072", 0, 18, 19, 1);
	console_label(table, "2048", 0, 19, 20, 1);
	console_label(table, "1024", 0, 20, 21, 1);
	console_label(table, "Loe.", 0, 21, 22, 0);
	console_label(table, "aus", 0, 21, 22, 1);
	console_label(table, "R0", 0, 22, 23, 0);
	console_label(table, "aus", 0, 22, 23, 1);
	console_label(table, "+1", 0, 23, 24, 0);
	console_label(table, "aus", 0, 23, 24, 1);
	console_switch(table,
		port_sperr_switch7, NULL,
		port_sperr_switch6, NULL,
		port_sperr_switch5, NULL,
		port_sperr_switch4, NULL,
		port_sperr_switch3, NULL,
		port_sperr_switch2, NULL,
		port_sperr_switch1, NULL,
		port_loe_aus_switch, NULL,
		port_misc_switch18, NULL,
		port_adr_p1_aus_switch, NULL,
		13, 2);
	console_label(table, "Bedingungsschalter", 1, 26, 31, 0);
	console_label(table, "16", 0, 26, 27, 1);
	console_label(table, "8", 0, 27, 28, 1);
	console_label(table, "4", 0, 28, 29, 1);
	console_label(table, "2", 0, 29, 30, 1);
	console_label(table, "1", 0, 30, 31, 1);
	console_label(table, "Bed.", 0, 31, 32, 0);
	console_label(table, "Ein", 0, 31, 32, 1);
	console_label(table, "Adressenstop", 1, 32, 36, 0);
	console_label(table, "Ein", 0, 32, 33, 1);
	console_label(table, "4096", 0, 33, 34, 1);
	console_label(table, "2048", 0, 34, 35, 1);
	console_label(table, "1024", 0, 35, 36, 1);
	console_switch(table,
		port_bed_switch4, NULL,
		port_bed_switch3, NULL,
		port_bed_switch2, NULL,
		port_bed_switch1, NULL,
		port_bed_switch0, NULL,
		port_bed_ein_switch, NULL,
		port_adr_stop_ein_switch, NULL,
		port_adr_stop_switch12, NULL,
		port_adr_stop_switch11, NULL,
		port_adr_stop_switch10, NULL,
		25, 2);
	console_label(table, "Adressenstop", 1, 38, 48, 0);
	console_label(table, "512", 0, 38, 39, 1);
	console_label(table, "256", 0, 39, 40, 1);
	console_label(table, "128", 0, 40, 41, 1);
	console_label(table, "64", 0, 41, 42, 1);
	console_label(table, "32", 0, 42, 43, 1);
	console_label(table, "16", 0, 43, 44, 1);
	console_label(table, "8", 0, 44, 45, 1);
	console_label(table, "4", 0, 45, 46, 1);
	console_label(table, "2", 0, 46, 47, 1);
	console_label(table, "1", 0, 47, 48, 1);
	console_switch(table,
		port_adr_stop_switch9, NULL,
		port_adr_stop_switch8, NULL,
		port_adr_stop_switch7, NULL,
		port_adr_stop_switch6, NULL,
		port_adr_stop_switch5, NULL,
		port_adr_stop_switch4, NULL,
		port_adr_stop_switch3, NULL,
		port_adr_stop_switch2, NULL,
		port_adr_stop_switch1, NULL,
		port_adr_stop_switch0, NULL,
		37, 2);

	/* Befehlsregister */
	console_label(table, "Befehlsregister", 1, 10, 15, 3);
	console_label(table, "Befehlsregister", 1, 22, 27, 3);
	console_label(table, "Befehlsregister", 1, 34, 39, 3);
	console_label(table, "Start", 0, 2, 3, 4);
	console_label(table, "Stop", 0, 3, 4, 4);
	console_label(table, "PP", 0, 4, 5, 4);
	console_label(table, "P", 0, 5, 6, 4);
	console_label(table, "QQ", 0, 6, 7, 4);
	console_label(table, "Q", 0, 7, 8, 4);
	console_label(table, "Y", 0, 8, 9, 4);
	console_label(table, "C", 0, 9, 10, 4);
	console_label(table, "N", 0, 10, 11, 4);
	console_label(table, "LL", 0, 11, 12, 4);
	console_switch(table,
		port_bef_switch39, port_bef_lamp39,
		port_bef_switch38, port_bef_lamp38,
		port_bef_switch37, port_bef_lamp37,
		port_bef_switch36, port_bef_lamp36,
		port_bef_switch35, port_bef_lamp35,
		port_bef_switch34, port_bef_lamp34,
		port_bef_switch33, port_bef_lamp33,
		port_bef_switch32, port_bef_lamp32,
		port_bef_switch31, port_bef_lamp31,
		port_bef_switch30, port_bef_lamp30,
		1, 5);
	console_label(table, "R", 0, 14, 15, 4);
	console_label(table, "U", 0, 15, 16, 4);
	console_label(table, "A", 0, 16, 17, 4);
	console_label(table, "S", 0, 17, 18, 4);
	console_label(table, "F", 0, 18, 19, 4);
	console_label(table, "K", 0, 19, 20, 4);
	console_label(table, "H", 0, 20, 21, 4);
	console_label(table, "G", 0, 21, 22, 4);
	console_label(table, "V", 0, 22, 23, 4);
	console_label(table, "128", 0, 23, 24, 4);
	console_switch(table,
		port_bef_switch29, port_bef_lamp29,
		port_bef_switch28, port_bef_lamp28,
		port_bef_switch27, port_bef_lamp27,
		port_bef_switch26, port_bef_lamp26,
		port_bef_switch25, port_bef_lamp25,
		port_bef_switch24, port_bef_lamp24,
		port_bef_switch23, port_bef_lamp23,
		port_bef_switch22, port_bef_lamp22,
		port_bef_switch21, port_bef_lamp21,
		port_bef_switch20, port_bef_lamp20,
		13, 5);
	console_label(table, "64", 0, 26, 27, 4);
	console_label(table, "32", 0, 27, 28, 4);
	console_label(table, "16", 0, 28, 29, 4);
	console_label(table, "8", 0, 29, 30, 4);
	console_label(table, "4", 0, 30, 31, 4);
	console_label(table, "2", 0, 31, 32, 4);
	console_label(table, "1", 0, 32, 33, 4);
	console_label(table, "4096", 0, 33, 34, 4);
	console_label(table, "2048", 0, 34, 35, 4);
	console_label(table, "1024", 0, 35, 36, 4);
	console_switch(table,
		port_bef_switch19, port_bef_lamp19,
		port_bef_switch18, port_bef_lamp18,
		port_bef_switch17, port_bef_lamp17,
		port_bef_switch16, port_bef_lamp16,
		port_bef_switch15, port_bef_lamp15,
		port_bef_switch14, port_bef_lamp14,
		port_bef_switch13, port_bef_lamp13,
		port_bef_switch12, port_bef_lamp12,
		port_bef_switch11, port_bef_lamp11,
		port_bef_switch10, port_bef_lamp10,
		25, 5);
	console_label(table, "512", 0, 38, 39, 4);
	console_label(table, "256", 0, 39, 40, 4);
	console_label(table, "128", 0, 40, 41, 4);
	console_label(table, "64", 0, 41, 42, 4);
	console_label(table, "32", 0, 42, 43, 4);
	console_label(table, "16", 0, 43, 44, 4);
	console_label(table, "8", 0, 44, 45, 4);
	console_label(table, "4", 0, 45, 46, 4);
	console_label(table, "2", 0, 46, 47, 4);
	console_label(table, "1", 0, 47, 48, 4);
	console_switch(table,
		port_bef_switch9, port_bef_lamp9,
		port_bef_switch8, port_bef_lamp8,
		port_bef_switch7, port_bef_lamp7,
		port_bef_switch6, port_bef_lamp6,
		port_bef_switch5, port_bef_lamp5,
		port_bef_switch4, port_bef_lamp4,
		port_bef_switch3, port_bef_lamp3,
		port_bef_switch2, port_bef_lamp2,
		port_bef_switch1, port_bef_lamp1,
		port_bef_switch0, port_bef_lamp0,
		37, 5);

	/* Akkumulator */
	console_label(table, "Akkumulator", 1, 10, 15, 6);
	console_label(table, "Akkumulator", 1, 22, 27, 6);
	console_label(table, "Akkumulator", 1, 34, 39, 6);
	console_label(table, "Start", 0, 2, 3, 7);
	console_label(table, "Stop", 0, 3, 4, 7);
	console_label(table, "PP", 0, 4, 5, 7);
	console_label(table, "P", 0, 5, 6, 7);
	console_label(table, "QQ", 0, 6, 7, 7);
	console_label(table, "Q", 0, 7, 8, 7);
	console_label(table, "Y", 0, 8, 9, 7);
	console_label(table, "C", 0, 9, 10, 7);
	console_label(table, "N", 0, 10, 11, 7);
	console_label(table, "LL", 0, 11, 12, 7);
	console_switch(table,
		port_akku_switch39, port_akku_lamp39,
		port_akku_switch38, port_akku_lamp38,
		port_akku_switch37, port_akku_lamp37,
		port_akku_switch36, port_akku_lamp36,
		port_akku_switch35, port_akku_lamp35,
		port_akku_switch34, port_akku_lamp34,
		port_akku_switch33, port_akku_lamp33,
		port_akku_switch32, port_akku_lamp32,
		port_akku_switch31, port_akku_lamp31,
		port_akku_switch30, port_akku_lamp30,
		1, 8);
	console_label(table, "R", 0, 14, 15, 7);
	console_label(table, "U", 0, 15, 16, 7);
	console_label(table, "A", 0, 16, 17, 7);
	console_label(table, "S", 0, 17, 18, 7);
	console_label(table, "F", 0, 18, 19, 7);
	console_label(table, "K", 0, 19, 20, 7);
	console_label(table, "H", 0, 20, 21, 7);
	console_label(table, "G", 0, 21, 22, 7);
	console_label(table, "V", 0, 22, 23, 7);
	console_label(table, "128", 0, 23, 24, 7);
	console_switch(table,
		port_akku_switch29, port_akku_lamp29,
		port_akku_switch28, port_akku_lamp28,
		port_akku_switch27, port_akku_lamp27,
		port_akku_switch26, port_akku_lamp26,
		port_akku_switch25, port_akku_lamp25,
		port_akku_switch24, port_akku_lamp24,
		port_akku_switch23, port_akku_lamp23,
		port_akku_switch22, port_akku_lamp22,
		port_akku_switch21, port_akku_lamp21,
		port_akku_switch20, port_akku_lamp20,
		13, 8);
	console_label(table, "64", 0, 26, 27, 7);
	console_label(table, "32", 0, 27, 28, 7);
	console_label(table, "16", 0, 28, 29, 7);
	console_label(table, "8", 0, 29, 30, 7);
	console_label(table, "4", 0, 30, 31, 7);
	console_label(table, "2", 0, 31, 32, 7);
	console_label(table, "1", 0, 32, 33, 7);
	console_label(table, "4096", 0, 33, 34, 7);
	console_label(table, "2048", 0, 34, 35, 7);
	console_label(table, "1024", 0, 35, 36, 7);
	console_switch(table,
		port_akku_switch19, port_akku_lamp19,
		port_akku_switch18, port_akku_lamp18,
		port_akku_switch17, port_akku_lamp17,
		port_akku_switch16, port_akku_lamp16,
		port_akku_switch15, port_akku_lamp15,
		port_akku_switch14, port_akku_lamp14,
		port_akku_switch13, port_akku_lamp13,
		port_akku_switch12, port_akku_lamp12,
		port_akku_switch11, port_akku_lamp11,
		port_akku_switch10, port_akku_lamp10,
		25, 8);
	console_label(table, "512", 0, 38, 39, 7);
	console_label(table, "256", 0, 39, 40, 7);
	console_label(table, "128", 0, 40, 41, 7);
	console_label(table, "64", 0, 41, 42, 7);
	console_label(table, "32", 0, 42, 43, 7);
	console_label(table, "16", 0, 43, 44, 7);
	console_label(table, "8", 0, 44, 45, 7);
	console_label(table, "4", 0, 45, 46, 7);
	console_label(table, "2", 0, 46, 47, 7);
	console_label(table, "1", 0, 47, 48, 7);
	console_switch(table,
		port_akku_switch9, port_akku_lamp9,
		port_akku_switch8, port_akku_lamp8,
		port_akku_switch7, port_akku_lamp7,
		port_akku_switch6, port_akku_lamp6,
		port_akku_switch5, port_akku_lamp5,
		port_akku_switch4, port_akku_lamp4,
		port_akku_switch3, port_akku_lamp3,
		port_akku_switch2, port_akku_lamp2,
		port_akku_switch1, port_akku_lamp1,
		port_akku_switch0, port_akku_lamp0,
		37, 8);

	console_label(table, "Stop", 0, 13, 14, 10);
	console_button(table, port_stop, 13, 11); /* Stop (links) */
	console_label(table, "Weiter", 0, 15, 16, 10);
	console_button(table, port_weiter, 15, 11); /* Weiter (links) */
	console_label(table, "Start", 0, 17, 18, 10);
	console_button(table, port_start, 17, 11); /* Start (links) */
	console_label(table, "Akku-", 0, 18, 21, 9);
	console_label(table, "Ueb.", 0, 18, 21, 10);
	console_button(table, port_akku_ueb, 19, 11); /* Akku-Uebernahme */

	console_label(table, "Befehls-", 0, 28, 31, 9);
	console_label(table, "Ueb.", 0, 28, 31, 10);
	console_button(table, port_bef_ueb, 29, 11); /* Befehls-Uebernahme */
	console_label(table, "Stop", 0, 31, 32, 10);
	console_button(table, port_stop, 31, 11); /* Stop (links) */
	console_label(table, "Weiter", 0, 33, 34, 10);
	console_button(table, port_weiter, 33, 11); /* Weiter (links) */
	console_label(table, "Start", 0, 35, 36, 10);
	console_button(table, port_start, 35, 11); /* Start (links) */

	gui_gtk_comp_add(page, "Zuse23-Console", name, table,
			FALSE, FALSE, NULL);

	return cpssp;
}

void
zuse23_console_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}

void
zuse23_console_gui_gtk_suspend(void *_cpssp, FILE *fp)
{
	/* FIXME */
}

void
zuse23_console_gui_gtk_resume(void *_cpssp, FILE *fp)
{
	/* FIXME */
}
