/*
 * $Id: zuse23.c,v 1.12 2013-05-06 15:48:15 vrsieh Exp $ 
 *
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 *
 * Derived from sources from http://www.nitzler.de/.
 * Copyright 1996-1997 by Bernd-Gunter Nitzler.
 */

#define DEBUG_CONTROL_FLOW	0

#include <assert.h>
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "glue-main.h"
#include "glue-shm.h"
#include "glue-storage.h"
#include "conv_gen.h"

#include "zuse23.h"
extern unsigned char zuse23_matrix_sperr[16]; /* FIXME */

struct cpssp {
	/* Ports */
#define S(x) \
	struct sig_boolean *port_bef_lamp ## x
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
	S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
	S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
	S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S
#define S(x) \
	struct sig_boolean *port_akku_lamp ## x
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
	S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
	S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
	S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S
#define S(n) \
	struct sig_boolean *port_ferranti ## n ## _start
	S(1); S(2);
#undef S
	struct sig_serial *port_fernschreiber;

	/* State */
	struct storage *media;

	/* Process */
	struct process process;
};
static struct cpssp *cpssp;

#ifndef TRUE
#define	FALSE	0
#define	TRUE	1
#endif

typedef struct Wort {
	unsigned int	c:1;	/* byteweise verdreht wegen INTEL und Borland */
	unsigned int	y:1;
	unsigned int	q:1;
	unsigned int	qq:1;
	unsigned int	p:1;
	unsigned int	pp:1;
	unsigned int	op:2;

	unsigned int	k:1;
	unsigned int	f:1;
	unsigned int	s:1;
	unsigned int	a:1;
	unsigned int	u:1;
	unsigned int	r:1;
	unsigned int	ll:1;
	unsigned int	n:1;

	unsigned int	ssp1:5;	/* nur ein Teil wegen verdrehten Bytes bei INTEL */
	unsigned int	v:1;
	unsigned int	g:1;
	unsigned int	h:1;

	unsigned char	trommel1;	/* wieder stark getrickst wegen INTEL */
	unsigned char	trommel2;
} Wort;

typedef struct Wortx {
	unsigned char	bt0;
	unsigned char	bt1;
	unsigned char	bt2;
	unsigned char	bt3;
	unsigned char	bt4;
} Wortx;

typedef union Worty {
	struct Wort	w;
	struct Wortx	wx;
} Worty;

#define	E3	(!E11&&E2&&(W1||R0&&!R1&&!W2))
#define	E13	(E11&&E2&&(W1||R0&&!R1&&!W2))
#define	Es	(!b.w.u&&!b.w.a&&!b.w.s)
#define	Jn	(r.w.k&&E0&&W1&&!W7&&TrA0s&&SspAgg16)	/* Sprung im Schnellspeicher */
#define	K1	(!K4&&(U0||!r.w.c)&&(E0&&r.w.v&&!r.w.ll&&!r.w.r||r.w.g&&!r.w.c&&r.w.v&&!r.w.ll&&!r.w.r||!E0&&r.w.k&&!r.w.g))
#define	T3	(Ssp3.bt4&1)
#define	T4	(Ssp4.bt0&0x80)
#define	T40	((Ssp4.bt0|Ssp4.bt1|Ssp4.bt2|Ssp4.bt3|Ssp4.bt4)==0)
#define	T412	(((Ssp4.bt0>>6)&3) == 1 || ((Ssp4.bt0>>6)&3) == 2)
#define	Ts	(Ss.bt0&0x80)
#define	DL	(Ssp4.bt0>=0x50)	/* T4|T41&(403|404) */
#define	Korrektur	(DL&&ROK0)
#define	W1	(!r.w.g&&W&&!R1)
#define	W1a	(r.w.g&&W&&!R1)
#define	W0	(W2&&!R1||W&&!R1)
#define	W13s	(!b.w.c&&!Es&&!r.w.g&&!G1&&!G2&&!b.w.ll&&!b.w.r&&b.w.v)
#define	vHY	(b.w.h&&b.w.y&&!r.w.ll&&!r.w.r)
#define	CU	(r.w.c&&!r.w.g&&U0)

#define	SspAkl16	(get_ssp(&r)<16)
#define	SspAgg16	(get_ssp(&r)>=16&&!HY)
#define	TrA0ss	(get_trommel(&b)==0)
#define	SonderAdr	(Adr[1]||Adr[7]||Adr[8]||Adr[9]||Adr[10]||Adr[15])
#define	SWohneW1	(!r.w.g&&!r.w.c&&!r.w.k&&U0)
#define	SWmitW1	(SWohneW1&&W1)
#define	Blockfreigabe	(BF||!SWohneW1)
#define	K9	(r.w.k&&Adr[9]&&HY)
#define	UK1	(U0&&Adr[1]&&r.w.k)

#define	E0	(!r.w.u&&!r.w.a&&!r.w.s)
#define	S0	(!r.w.u&&!r.w.a&&r.w.s)
#define	A0	(!r.w.u&&r.w.a&&!r.w.s)
#define	O0	(!r.w.u&&r.w.a&&r.w.s)
#define	U0	(r.w.u&&!r.w.a&&!r.w.s)
#define	T0	(r.w.u&&!r.w.a&&r.w.s)
#define	I0	(r.w.u&&r.w.a&&!r.w.s)
#define	IS0	(r.w.u&&r.w.a&&r.w.s)
#define	OK0	((W2||TrA0s)&&W0&&r.w.k&&!G1&&!G2&&O0&&!r.w.g&&Adr[0])
#define	ROK0	(OK0&&r.w.r&&!r.w.ll)

#define	PPPQQQRA	(W6&&!R1&&(!r.w.v||!T40save)&&(r.w.v||Ssp13))
#define	U1	(W1&&!tmp1||J1&&J2||U0&&W1&&!r.w.c&&r.w.k&&TrA0s||r.w.c&&r.w.g&&W&&!R1)

#define	Adr2	(get_ssp(&r)==2)
#define	Adr4	(Adr[4]&&!HY)

#define	SJ	(S3||P(1,23)&&r.w.c&&W&&!R1||W&&!R1&&!E3||R0&&!R1&&!E3)

#define	PL(x,y)	(cur_step==(x)*2+((y)/5)-1||cur_step==(x)*2+((y)/5))
#define	PSL(x,y)	(cur_step==(x)*2+((y)/5))
#define	P(x,y)	(cur_step>=(x)*2&&cur_step<(y)*2)
#define	PS(x,y)	(cur_step>=(x)*2&&cur_step/2<=(y))	// gilt für S0 und S1/2-Takte
#define	X35	((Ssp3.bt0&0x40)!=0)
/*	hier die vollständige Lösung, anschließend etwas vereinfacht
#define	Schreib	((r.w.c&&r.w.g&&W&&!R1||!K3&&W1&&!tmp1) ? a :\
(U0&&W1&&!r.w.c&&r.w.k&&TrA0s) ? D33 : (J1&&J2) ? D37 : !U1 ? D35 : 0)
*/
#define	Schreib	((r.w.c&&r.w.g&&W&&!R1||!K3&&W1&&!tmp1) ? a :\
(U0&&W1&&!r.w.c&&r.w.k&&TrA0s) ? D33 : (J1&&J2) ? D37 : D35)

#define AN_Sel	(K9&&U0||SU9&&!U0&&W131)
#define AN_Schreib	((tmp1&&!r.w.g&&!K3)?a:D40)

#define	Ksp_len	(8192)

Wortx	Ssp[256];
Wortx	Ksp[Ksp_len];		/* [8192] */
Worty	b;		/* Befehlsregister */
Worty	r;		/* temp. Register */
Worty	c;		/* Befehlszähler */
Wortx	Ss;		/* Speicherregister vor dem Schnellspeicher */
Wortx	Ssp3;		// Akkuverlängerung
Wortx	Ssp4;		// Akku
Wortx	Ssp5;		// Rücksprungadresse
short	Ssp13;		// Zählerzelle
unsigned char	lsleser1;	// Lochstreifenleser 1
unsigned char	lsleser2;	// Lochstreifenleser 2
unsigned char	fs;		// Fernschreiber
unsigned char	locher;		// Lochstreifenstanzer
unsigned char	hand;		// Handeingabe

char	ub;		/* temporäres Flag unerfüllte Bedingung */
char	auesw;
char	buesw;
char	wesw;
char	start;
char	*cp;
Wortx	val_b;		/* Schalterstellung B */
Wortx	val_a;		/* Schalterstellung A */

char	aue;		/* Akkuübernahme-FF */
char	bue;		/* Befehlsübernahme-FF */
char	we;	  	/* Weiter-FF */
char	stopT;		/* stop-Taste */
char	start_rel;	/* start-FF */
char	bed_stop_sch;	/* Bedingungsstop */
char	adr_stop_ein;	/* Adressstop-Schalter eingeschaltet */
char	adr_stop;	/* Adressstop-FF */
short	adr_stop_adr;	/* Adressstop-Schalter */
char	loeschung_sch;	/* Verhindert das Löschen des Befehlsregisters */
char	plus1_sch;	/* Verhindert die Adressenerhöhung */
char	langsam_sch;
char	langsam_sch2;
char	PrUSch;
char	tmp1;
char	tmp2;
char	zOpW;		// temp Eingang Opwerk
char	opsw;		/* Schalter für Teiloperationen */
char	ue;		/* Überlauf Nebeneingang ins Op. Werk */
char	AnelexFrei;	// ANelelex-Drucker frei
char	FsFrei;		// Fernschreiber frei
char	MBFrei;		// Magnetband frei
char	SchnDrFrei;	// Schnelldrucker frei
char	Reader1Ready;	// Lochstreifenleser 1 fertig gelesen
char	R1_8Kanal;	// Schalter für Ls-Leser 1 8-Kanal-Verarbeitung
char	Reader2Ready;	// Lochstreifenleser 2 fertig gelesen
char	R2_8Kanal;	// Schalter für Ls-Leser 2 8-Kanal-Verarbeitung
char	LocherFrei;	// Lochstreifenstanzer frei
char	Sch8Kanal;	// Schalter für Ls-Stanzer 8-Kanal-Verarbeitung
char	sonder;		// Ausführung frei auch für Sonderadressen
short	sektor_zhl;	// laufende Sektornummer der Trommel
char	sektor;		// gesuchter Sektor erreicht
char	kernsp_sch;	// Kernspeicher-Schalter (für Adress-Stop)

char	BF;	// Blockfreigabe, Sperrschalter nicht gesetzt
char	BK;	// Setzen der Kernspeicheradresse bei BÜ und Ssp-Ablauf
char	D1;	/* Startzustand */
char	D7;	/* synchronisiert die Trommel mit der Uhr */

char	E1;	/* Sprung in den Schnellspeicher oder Kernspeicher */
char	E2;	// Ablauf im Schnellspeicher oder Kernspeicher
char	E4;	/* nur im Takt Ps41 definiert */
char	E5;
char	E6;
char	E11;	// Sprung in den Kernspeicher

char	G1;	/* indirekter Befehl auf der Trommel */
char	G2;	/* indirekter Befehl im Schnellspeicher */

char	HY;	// spezielle Befehlsmodifikation für E/A-Befehle
char	SU9;	/* Anelex */

char	J1;
char	J2;	/* Sprung und J1 */
char	Js;	/* undefiniert ??? */

char	K2;
char	K3;
char	K4;

char	R0;	/* gesetzt, wenn Bedingung nicht erfüllt */
char	R1;	/* Stopzustand */

char	T2;	// Testzelle für Ssp2

char	U2;	/* Lesesperre */

char	S3;	// M. Sch. b
char	S6;	// M. Sch. c

char	W;	// System kann ablaufen, alle Kanäle frei
char	W2;	/* Wiederholungsbefehl PQ(A) */
char	W3;	/* Befehl PQY, Multiplikation Ssp3 * s -> Akku*/
char	W4;	/* Befehl PQPP, Division Akku-Ssp3 / s -> Ssp3, Rest -> Akku*/
char	W5;	/* Test einer beliebigen Ssp-Zelle anstelle Zelle 2 */
char	W6;	/* Serienschiebungen */
char	W7;	/* schnelles Zahlenlesen (CKGLA) */
char	W13;	/* Blocktransfer */
char	W20;	/* undefiniert, Signal vom Magnetband */
char	W21;	/* undefiniert, Signal vom Magnetband */
char	W131;	/* Blocktransfer spezial */

char	D30;	// erster Operand Op. Werk
char	D31;	// zweiter Operand Op. Werk
char	D32;	// Verbindung Trommel nach b
char	D33;	// Verbindung Ssp4 zur Schreibleitung für UKn+0 Befehle
char	D34;	// Rotation Ssp3
char	D35;	// Speicher der Leseleitung
char	D36;	// Anfang des Befehlszählers
char	D37;	// Ende des Befehlszählers
char	D38;	// Zwischenstation Befehl-Ssp des Befehlszählers
char	D39;	// Zwischenstation Ssp-Trommel des Befehlszählers
char	D40;	// Rotation Ssp4
char	D43;	// Verbindung LSB 4 nach MSB 3
char	X31;	// Ssp3-Verlängerung
char	X32;	// Ssp3-Verlängerung
char	X41;	// Ssp4-Verlängerung
char	X42;	// Ssp4-Verlängerung
char	X43;	// Verbindung LSB 4 nach MSB 3 bei RV
char	X44;	// Ssp4-Verlängerung
char	X45;	// Ssp4-Verlängerung
char	X51;	// Ssp5-Verlängerung
char	UE1;	// Überlauf Op. Werk
char	UE2;	// Überlauf Op. Werk
char	UE11;	// +1 Addierwerk
char	UE12;	// +1 Addierwerk
char	UE21;	// Hilfs-Addierwerk
char	UE22;	// Hilfs-Addierwerk
char	SV1;	/* Schreib-FF Trommel */
char	L2;	/* Lese-FF Trommel */
char	S;	// Schreibleitung
char	Q5;	// Schnellspeicher-Ausgang seriell
char	DM1;	// zum Magnetband-Puffer

Wortx	p1;	// Speicherregister vor dem Kernspeicher
Wortx	p2;	// Speicherregister zwischen Ksp und b-Register
short	bk;	// b- Register des Kernspeichers (nur Trommeladreßteil)
char	Qk;	// Kernspeicherausgang
short	rk;	// r- Register des Kernspeichers (nur Trommeladreßteil)
char	Dk;	// zur Rotation des p1-Registers
char	Dk1;	// zur Rotation des bk-Registers
char	UE31;	// Hilfs-Addierwerk Kernspeicher
char	UE32;	// Hilfs-Addierwerk Kernspeicher
char	UE41;	// Hilfs-Addierwerk Kernspeicher für Blocktransfer
char	UE42;	// Hilfs-Addierwerk Kernspeicher für Blocktransfer

unsigned char	AN_format_w;	// 0 solange in das Formatwort gespeichert wird
char	AN_alarm;	// Alarm-Signal bei unzulässigen Werten
short	AN_len;		// Stellenzahl aus dem Formatwort
Wortx	AN_puffer[25];	// interner ANelex-Puffer mit Formatwort = 0

char	SspA0s;
char	TrA0s;
char	TrA0sss;

char	Adr[16];
char	VerbAdr;

char	sperr[8];	/* Sperrschalter */

char	quick_sim = TRUE;	// Standard auf EIN

static int	cur_step = 0;

static char	preSV1;
static char	a;

static char ls1;
static char ls2;

static void
put_ccitt(unsigned char c)
{
	sig_serial_send(cpssp->port_fernschreiber, cpssp, c);
}

static void
put_anelex(unsigned char *p)
{
	/* FIXME */
}

static void
put_stanzer(unsigned char c)
{
	/* FIXME */
	fprintf(stderr, "%s 0x%02x\n", __FUNCTION__, c);
}

static void
ls_lesen(void)
{
	sig_boolean_set(cpssp->port_ferranti1_start, cpssp, 1);
	sig_boolean_set(cpssp->port_ferranti1_start, cpssp, 0);
}

static void
ls_lesen2(void)
{
	sig_boolean_set(cpssp->port_ferranti2_start, cpssp, 1);
	sig_boolean_set(cpssp->port_ferranti2_start, cpssp, 0);
}

/* Wegen besserer Performance als Assembler-Routinen ausgeführt */

/* Hier die C-Implementation als Ersatz, wenn nötig */
int get_ssp(Worty *pw)
{
    return (pw->w.ssp1<<3) | (pw->w.trommel1>>5);
}

void put_ssp(Worty *pw,int i)
{
    pw->w.ssp1 = i >> 3;
    pw->w.trommel1 &= 0x1f;
    pw->w.trommel1 |= i << 5;
}


int get_trommel(Worty *pw)
{
    return ((pw->w.trommel1&0x1f)<<8) | pw->w.trommel2;
}

void put_trommel(Worty *pw,int i)
{
    pw->w.trommel1 &= 0xe0;
    pw->w.trommel1 |= (i >> 8)&0x1f;
    pw->w.trommel2 = i;
}

short shl(Wortx *wp)
{
    char	tmpshift;

    tmpshift = wp->bt0 >> 7;
    wp->bt0 = (wp->bt0 << 1) | (wp->bt1 >> 7);
    wp->bt1 = (wp->bt1 << 1) | (wp->bt2 >> 7);
    wp->bt2 = (wp->bt2 << 1) | (wp->bt3 >> 7);
    wp->bt3 = (wp->bt3 << 1) | (wp->bt4 >> 7);
    wp->bt4 = wp->bt4 << 1;
    return tmpshift;
}

short shr(Wortx *wp,char x)
{
    char	tmpshift;

    tmpshift = wp->bt4 & 1;
    wp->bt4 = (wp->bt4 >> 1) | (wp->bt3 << 7);
    wp->bt3 = (wp->bt3 >> 1) | (wp->bt2 << 7);
    wp->bt2 = (wp->bt2 >> 1) | (wp->bt1 << 7);
    wp->bt1 = (wp->bt1 >> 1) | (wp->bt0 << 7);
    wp->bt0 = (wp->bt0 >> 1) | (x << 7);
    return tmpshift;
}

short shra(Wortx *wp)
{
    char	tmpshift;

    tmpshift = wp->bt4 & 1;
    wp->bt4 = (wp->bt4 >> 1) | (wp->bt3 << 7);
    wp->bt3 = (wp->bt3 >> 1) | (wp->bt2 << 7);
    wp->bt2 = (wp->bt2 >> 1) | (wp->bt1 << 7);
    wp->bt1 = (wp->bt1 >> 1) | (wp->bt0 << 7);
    wp->bt0 = ((signed char)wp->bt0) >> 1;
    return tmpshift;
}

void shrbef(Wortx *wp)
{
    wp->bt2 = (wp->bt2&~0xe0) | ((wp->bt2&0xc0) >> 1) | (wp->bt1 << 7);
    wp->bt1 = (wp->bt1 >> 1) | (wp->bt0 << 7);
    wp->bt0 = wp->bt0 >> 1;
}

void shrssp(Wortx *wp)
{
    wp->bt3 = (wp->bt3&~0xe0) | ((wp->bt3&0xc0) >> 1) | (wp->bt2 << 7);
    wp->bt2 = (wp->bt2&~0x1f) | ((wp->bt2&0x1e) >> 1);
}

short shrtrommel(Wortx *wp)
{
    char	tmpshift;

    tmpshift = wp->bt4 & 1;
    wp->bt4 = (wp->bt4 >> 1) | (wp->bt3 << 7);
    wp->bt3 = (wp->bt3&~0x1f) | ((wp->bt3&0x1e) >> 1);
    return tmpshift;
}

#if DEBUG_CONTROL_FLOW
void
dump(union Worty *w)
{
	switch (w->w.op) {
	case 0: fprintf(stderr, "00"); break;
	case 1: fprintf(stderr, "Stop "); break;
	case 2: fprintf(stderr, "Start "); break;
	case 3: fprintf(stderr, "11"); break;
	}

	if (w->w.pp) fprintf(stderr, "PP");
	if (w->w.p) fprintf(stderr, "P");
	if (w->w.qq) fprintf(stderr, "QQ");
	if (w->w.q) fprintf(stderr, "Q");
	if (w->w.y) fprintf(stderr, "Y");

	if (w->w.c) fprintf(stderr, "C");
	if (w->w.n) fprintf(stderr, "N");
	if (w->w.ll) fprintf(stderr, "LL");
	if (w->w.r) fprintf(stderr, "R");
	if (w->w.u) fprintf(stderr, "U");
	if (w->w.a) fprintf(stderr, "A");
	if (w->w.s) fprintf(stderr, "S");
	if (w->w.f) fprintf(stderr, "F");
	if (w->w.k) fprintf(stderr, "K");
	if (w->w.h) fprintf(stderr, "H");
	if (w->w.g) fprintf(stderr, "G");
	if (w->w.v) fprintf(stderr, "V");

	fprintf(stderr, "%d+%d", get_ssp(w), get_trommel(w));
}
#endif

static char
get_bit(int off, short bit)	// Die Bits zählen von 39..0 !!!
{
    Wortx wort;
    Wortx *wp;
    int ret;

    ret = storage_read(cpssp->media, &wort, sizeof(wort), sizeof(wort) * off);
    assert(ret == sizeof(wort));

    wp = &wort;

    if (bit < 8)
	return (wp->bt4 >> bit) & 1;
    bit -= 8;
    if (bit < 8)
	return (wp->bt3 >> bit) & 1;
    bit -= 8;
    if (bit < 8)
	return (wp->bt2 >> bit) & 1;
    bit -= 8;
    if (bit < 8)
	return (wp->bt1 >> bit) & 1;
    bit -= 8;
    return (wp->bt0 >> bit) & 1;
}

static void
put_bit(int off, short bit, char val) // Die Bits zählen von 39..0 !!!
{
    Wortx wort;
    Wortx *wp;
    char maske;
    int ret;

    ret = storage_read(cpssp->media, &wort, sizeof(wort), sizeof(wort) * off);
    assert(ret == sizeof(wort));

#if DEBUG_CONTROL_FLOW
    fprintf(stderr, "Trommel[%d]: ", off);
    dump((Worty *) &wort);
#endif

    wp = &wort;
    maske = ~(1 << (bit & 7));
    val <<= bit & 7;
    if (bit < 8)
	wp->bt4 = (wp->bt4 & maske) | val;
    else if (bit < 16)
	wp->bt3 = (wp->bt3 & maske) | val;
    else if (bit < 24)
	wp->bt2 = (wp->bt2 & maske) | val;
    else if (bit < 32)
	wp->bt1 = (wp->bt1 & maske) | val;
    else
	wp->bt0 = (wp->bt0 & maske) | val;

#if DEBUG_CONTROL_FLOW
    fprintf(stderr, " -> ");
    dump((Worty *) &wort);
    fprintf(stderr, "\n");
#endif

    ret = storage_write(cpssp->media, &wort, sizeof(wort), sizeof(wort) * off);
    assert(ret == sizeof(wort));
}
/* */

static char Operation(char Add,char t0,char i0,char is0,char o0,char Subt,
			char e1,char e2,char es,char *pas)
{
    char	a;

    a = Add&&!e1&&!e2&&es || (t0||o0||Add)&&!e1&&e2&&!es ||
	(Subt||o0||Add)&&e1&&!e2&&!es || Add&&e1&&e2&&es ||
	(o0||i0)&&e1&&e2 || (t0||Subt)&&!e1&&!e2&&es ||
	Subt&&!e1&&e2&&!es || (t0||Subt)&&e1&&e2&&es ||
	t0&&e1&&!e2&&!es || is0&&e1&&!e2&&es || is0&&e1&&e2&&!es;
    *pas = Add&&e1&&e2 || (Subt||o0||Add)&&!e1&&e2&&es ||
	(o0||Add|t0)&&e1&&!e2&&es || (t0||Subt)&&!e1&&!e2&&es ||
	Subt&&!e1&&e2&&!es || (t0||Subt)&&e1&&e2&&es ||
	t0&&e1&&!e2&&!es || is0&&e2&&!es || is0&&es;
    return a;
}

static void step0(void)
{
    if (bue)
	G1 = G2 = J1 = J2 = E2 = W7 = K2 = K3 = FALSE;
    UE1 = FALSE;
    if (bue || (!W7&&W&&!R1&&loeschung_sch&&!W20&&(!W13||!W1))) {
	b.wx.bt0 &= 0xc0;	// pp bis c
	b.wx.bt1 &= 0x01;	// n bis f
     /*	b.w.pp = FALSE;
	b.w.p = FALSE;
	b.w.qq = FALSE;
	b.w.q = FALSE;
	b.w.y = FALSE;
	b.w.c = FALSE;
	b.w.n = FALSE;
	b.w.ll = FALSE;
	b.w.r = FALSE;
	b.w.u = FALSE;
	b.w.a = FALSE;
	b.w.s = FALSE;
	b.w.f = FALSE; */
	b.w.h = FALSE;
	if (bue || W5 || r.w.g || G2 || r.w.c&&r.w.k) {
	    b.w.g = FALSE;
	    b.w.k = !(!G2 || W5);
	    if (!G2 || W5)
		put_ssp(&b,0);
	    if (!W5)
		b.w.v = FALSE;
	}
	if (!r.w.c && (!E0 || r.w.ll || r.w.r))
	    b.w.v = FALSE;
    }
    if (bue || G2)
	put_trommel(&b,0);
    if (!R1)
	D1 = TRUE;
    if ((G1 || G2) && W && !R1)
	b.w.op = 2;
    if (Jn) {
	E11 = FALSE;
	if (get_ssp(&b) == 255)
	    J2 = FALSE;
	if (!langsam_sch)
	    E1 = TRUE;
    }
    if (E0 && W1 && K1) {
	E11 = TRUE;
	if (!langsam_sch)
	    E1 = TRUE;
    }
    if ((E0 && W1) || J1 || W7 || W13s || W20)
	E2 = FALSE;
    U2 = FALSE;
    if (Adr[15] && !(r.w.c&&!r.w.g) && W && !R1 && !U0) {
	lsleser1 = ls1;
	if (!R1_8Kanal)
	    lsleser1 &= 0x1f;
	ls_lesen();
    }
    if (Adr[10] && !(r.w.c&&!r.w.g) && W && !R1 && !U0) {
	lsleser2 = ls2;
	if (!R2_8Kanal)
	    lsleser2 &= 0x1f;
	ls_lesen2();
    }
}

static void step1(void)
{
    int	i;

    aue = auesw;
    opsw = 0;
    if (bue) {
	i = b.w.op;
	b.wx = val_b;
	b.w.op = i;
    }
    if (SWmitW1)
	U2 = TRUE;
    X43 = X42;	// eigentlich von X41, aber der ist schon verschoben worden
}

static void step2(void)
{
    sektor_zhl++;
    if ((sektor_zhl & 31) == 0)	// 32 Sektoren pro Spur
	sektor_zhl = 0;
    if (sektor_zhl == 0)
	D7 = TRUE;
    D7 = FALSE;		// eigentlich vom Signal EJ0 ??? gesteuert zur Synchronisation
    if (W13&&W1) {
	Ssp13--;	// rückwärts zählen
	Ssp13 &= 0x1fff;	// nur 13 Bit
    }
}

static void step15(void)
{
    if (E13)
	p2 = Ksp[rk];
}

static void step23(void)
{
    if (E3)	{
	b.wx.bt0 = 0;	// op bis c
	b.wx.bt1 = 0;	// n bis k
	b.wx.bt2 &= 0x20;	// ohne v
	b.wx.bt3 = 0;	// Ssp und Trommel
	b.wx.bt4 = 0;	// Trommel
     /*	b.w.op = 0;
	b.w.pp = FALSE;
	b.w.p = FALSE;
	b.w.qq = FALSE;
	b.w.q = FALSE;
	b.w.y = FALSE;
	b.w.c = FALSE;
	b.w.n = FALSE;
	b.w.ll = FALSE;
	b.w.r = FALSE;
	b.w.u = FALSE;
	b.w.a = FALSE;
	b.w.s = FALSE;
	b.w.f = FALSE;
	b.w.k = FALSE;
	b.w.h = FALSE;
	b.w.g = FALSE;
	put_trommel(&b,0);
	put_ssp(&b,0); */
	if (!r.w.c && (!E0 || r.w.ll || r.w.r))
	    b.w.v = FALSE;
	if (!W5)
	    b.w.v = FALSE;
    }
}

static void step24(void)
{
    if (E3)
	b.wx = Ssp[get_ssp(&r)];	/* Ausbl. imp. b */
}

static void step25_5(void)
{
    if (bue || E3)
	BK = TRUE;
}

static void
step38(void)
{
	bue = buesw;
	if (! r.w.k && W1a)
		G1 = TRUE;
	if (r.w.k && W1a)
		G2 = TRUE;
}

static void step38_5(void)
{
    we = wesw;
    start_rel = start;
}

static void step39(void)
{
    if (aue || U0&&W1&&Adr4)	// eigentlich im Takt 39.00 und 40.00
	Ssp4 = val_a;		// Handeinstellung
    if (ROK0)
	Ssp3.bt4 |= Ssp4.bt0 >> 4;
}

static void step39_5(void)
{
    if (ROK0)
	Ssp4.bt0 &= 0x0f;	// vorderstes Nibble löschen
}

static void step40(void)
{
    if (Adr2)
	T2 = Schreib;
    if (W1)
	G1 = G2 = FALSE;
    W5 = FALSE;
    K4 = FALSE;
    BF = FALSE;
    if (K9) {
	if (O0&&W1)		// ANelex drucken
	    put_anelex((unsigned char *)AN_puffer);
	if ((O0||I0)&&W1) {	// ANelex löschen
	    memset(AN_puffer,0,sizeof(AN_puffer));
	    AN_format_w = 0;
	    AN_len = 0;
	    AN_alarm = FALSE;
	}
    }
}

static void step40_5(void)
{
    SspA0s = FALSE;
    TrA0s = FALSE;
    if (G2 || b.w.p&&b.w.q&&!b.w.qq || TrA0ss)
	K4 = TRUE;
    E5 = FALSE;
    if (AN_Sel) {
	AN_puffer[AN_format_w].bt0 -= 0x33;	// Drei-Exzeß-code
	AN_puffer[AN_format_w].bt1 -= 0x33;	// Drei-Exzeß-code
	AN_puffer[AN_format_w].bt2 -= 0x33;	// Drei-Exzeß-code
	AN_puffer[AN_format_w].bt3 -= 0x33;	// Drei-Exzeß-code
	AN_puffer[AN_format_w].bt4 -= 0x33;	// Drei-Exzeß-code
	if (AN_format_w++ == 0) {	// Wortnummer weiterschalten
	    AN_len = AN_puffer[0].bt2 * 100;
	    AN_len += (AN_puffer[0].bt3 >> 4) * 10;
	    AN_len += AN_puffer[0].bt3 & 0xf;		// Stellenzahl
	}
    }
}

static void step41(void)
{
    R0 = W6 = FALSE;
    adr_stop = TRUE;
    TrA0sss = FALSE;
    sektor = TRUE;
    if (U0&&Adr[15]&&W&&!R1) {	// muß vor dem Überschreiben von r passieren
//	fs = (fs & 0x7c) | 0x81;	// Start- und Stop-Bits (hier überflüssig)
	put_ccitt((fs >> 2) & 0x1f);
    }
    Ssp[get_ssp(&r)] = Ss;	// eigentlich Inhibit 1
    Ksp[rk] = p1;
    if (UK1&&W&&!R1)
	put_stanzer(Sch8Kanal ? locher : (locher >> 3));
    if (start_rel && !D1)
	b.w.op = 2;
    if (G1 && E0 && !r.w.ll && !r.w.r && r.w.v)
	b.w.v = TRUE;
    if (E0 && W1)
	W7 = FALSE;
    if (J2 && W0)
	J1 = FALSE;
    if (!G1 && !G2) {
	r.w.c = b.w.c;
	r.wx.bt1 = b.wx.bt1;	// n bis k
     /*	r.w.n = b.w.n;
	r.w.ll = b.w.ll;
	r.w.r = b.w.r;
	r.w.u = b.w.u;
	r.w.a = b.w.a;
	r.w.s = b.w.s;
	r.w.f = b.w.f;
	r.w.k = b.w.k; */
	r.w.h = b.w.h;
	r.w.g = b.w.g;
	r.w.v = b.w.v;
    }
    ub = b.w.p&&!b.w.q&&!W5&&T2 || !b.w.p&&b.w.q&&!W5&&!T2 ||
	    b.w.op == 0 || b.w.op == 3 ||
	    b.w.pp&&!b.w.qq&&!(b.w.p&&b.w.q)&&T4 ||
	    b.w.qq&&!b.w.pp&&!(b.w.p&&b.w.q)&&!T4 ||
	    b.w.pp&&b.w.qq&&!(b.w.p&&b.w.q)&&!T40 ||
	    b.w.p&&b.w.q&&b.w.qq&!b.w.pp&&!T412 ||
	    b.w.y&&!vHY&&!(b.w.p&&b.w.q)&&!(b.w.p&&b.w.q&&!b.w.qq)&&!T3;
    E4 = (ub||!Es)&&(ub&&!(b.w.u&&!b.w.a&&!b.w.s)&&get_ssp(&b)==0||b.w.k||b.w.c)&&
	    !J1&&!b.w.g&&!G1&&!G2&&!c.w.v&&
	    !(b.w.p&&b.w.q&&!b.w.qq)&&!c.w.k&&!K1&&!W13s&&!langsam_sch2;
    if (!E4 && !G2)
	put_trommel(&r,get_trommel(&b));
    if (E4)
	put_trommel(&r,get_trommel(&c));
    if (G1 || G2) {
	r.w.c = FALSE;
	r.w.g = FALSE;
	if (!r.w.ll && !r.w.r && !E0 && r.w.v) {
	    r.w.v = FALSE;
	    r.w.k = TRUE;
	}
    }
    if (K2 && W13s)
	K3 = TRUE;
    if (W13s)
	W131 = TRUE;
    if (Es) {
	K3 = FALSE;
	W131 = FALSE;
	SU9 = FALSE;
    }
}

static void step41_5(void)
{
    int	i;

    if (get_ssp(&b) == 0)
	SspA0s = TRUE;
    for (i = 0; i < 16; i++)
	Adr[i] = FALSE;
    VerbAdr = TRUE;
    W2 = W3 = W4 = FALSE;
    if (E4)
	E5 = TRUE;
}

static void step42(void)
{
    W = FALSE;
    if (adr_stop_adr != get_trommel(&r) || kernsp_sch != K1)
	adr_stop = FALSE;
    if (!b.w.k && Es && !G1 && !G2 && !r.w.g && !SspA0s)
	W5 = TRUE;
    if (stopT || we || bue) {
	b.w.op = 1;
	R1 = TRUE;
    }
    W13 = W13s && Ssp13 != 0;
    if (J1 && Es)
	J2 = TRUE;
    put_ssp(&r,get_ssp(&b));
    rk = bk;		// Befehlskernspeicheradresse holen
    HY = b.w.h && b.w.y && !r.w.ll && !r.w.r;
    if (G2 || TrA0ss)
	TrA0s = TRUE;
    BK = FALSE;
    BF = sperr[get_trommel(&r) >> 10] == 0; // nur die vordersten 3 Bit zaehlen
    BF &= ! zuse23_matrix_sperr[get_trommel(&r) >> 9];
//    if (sektor_zhl != (get_trommel(&r) & 31))	// ein Warten auf die Trommel unnötig
//	sektor = FALSE;		// gesuchter Sektor noch nicht erreicht
    Ss.bt0 = Ss.bt1 = Ss.bt2 = Ss.bt3 = Ss.bt4 = 0;
    Q5 = FALSE;
    if (!E5)
	E6 = FALSE;
    p1.bt0 = p1.bt1 = p1.bt2 = p1.bt3 = p1.bt4 = 0;
    Qk = FALSE;
}

static void step42_5(void)
{
    if (TrA0ss)
	TrA0sss = TRUE;
    if (HY)			// war vorher in Takt 41
	r.w.h = FALSE;
    ub = b.w.p&&!b.w.q&&!W5&&T2 || !b.w.p&&b.w.q&&!W5&&!T2 ||
		b.w.op == 0 || b.w.op == 3 ||
		b.w.pp&&!b.w.qq&&!(b.w.p&&b.w.q)&&T4 ||
		b.w.qq&&!b.w.pp&&!(b.w.p&&b.w.q)&&!T4 ||
		b.w.pp&&b.w.qq&&!(b.w.p&&b.w.q)&&!T40 ||
		b.w.p&&b.w.q&&b.w.qq&!b.w.pp&&!T412 ||
		b.w.y&&!vHY&&!(b.w.p&&b.w.q)&&!(b.w.p&&b.w.q&&!b.w.qq)&&!T3;
    if (!G1 && !G2 && !W5 && !ub && b.w.op == 1)
	R1 = TRUE;
    if (!G1 && !G2 && (b.w.op == 3 || b.w.op == 0) && bed_stop_sch)
	R1 = TRUE;
    if (!G1 && !G2 && ub) {
	if (!R0)
	    W13 = FALSE;
	R0 = TRUE;
    }
    if (!G1&&!G2&&b.w.p&&b.w.q&&!b.w.qq) {
	if (!R0)
	    W13 = FALSE;
	R0 = TRUE;
    }
    if (!G1&&!G2&&b.w.p&&b.w.pp&&b.w.q&&b.w.qq&&!b.w.y) {
	if (!R0)
	    W13 = FALSE;
	R0 = W6 = TRUE;
    }
    if (!U0&&W13s&&SspAkl16&&r.w.h&&!(b.w.p&&b.w.q&&!b.w.qq)&&T40) {
	if (!R0)
	    W13 = FALSE;
	R0 = TRUE;
    }
    if (SspAkl16) {
	Adr[get_ssp(&r)] = TRUE;
	if (Adr[7])
	    E5 = FALSE;
    }
    if (!(Adr[0]||Adr[3]||Adr[4]||Adr[5]||Adr[12]||Adr[13]||Adr[14])&&!SonderAdr&&!HY)
	VerbAdr = FALSE;
    if (b.w.p && b.w.q && !b.w.qq && !TrA0s)
	W2 = TRUE;
}

static void step43(void)
{
    Ss = Ssp[get_ssp(&r)];	// eigentlich Ausblendimpuls S
    p1 = Ksp[rk];
    sonder = (!E5&&(K1||r.w.c||r.w.k) || get_ssp(&b)&&r.w.g ||
		sektor && (U0&&!D7 || !U2)) &&
	     (r.w.c&&!r.w.g || R0 || !SonderAdr || (!U0||!Adr[0])&&Adr[1] ||
		!(SU9&&!U0&&W131) || (SU9&&!U0&&W131||K9)&&AnelexFrei ||
		!r.w.k&&!Adr[7]&&!Adr[8]&&!Adr[10]&&!Adr[15] ||
		Adr[15]&&!U0&&Reader1Ready || Adr[15]&&U0&&FsFrei ||
		Adr[10]&&!U0&&Reader2Ready || Adr[7]&&MBFrei || Adr[0]&&SchnDrFrei ||
		UK1&&LocherFrei);
    if (!G1 && !G2 && b.w.op == 2 && sonder)
	R1 = FALSE;
    if (!W5 && we && !D1 && sonder)
	R1 = FALSE;
    if (!W5 && (!r.w.k||Adr[7]) && !R0 && Blockfreigabe && sonder)
	W = TRUE;
    if (!W20 && !W7 && PrUSch && Js && !W13 && !W2 && !r.w.g && !E0 && !J2)
	J1 = TRUE;
    if (!E0 && !r.w.c)
	K2 = FALSE;
    if (adr_stop_ein && adr_stop && (D1||!start_rel&&!we)) {
	b.w.op = 1;
	R1 = TRUE;
    }
    if (Adr[9] && CU)
	SU9 = TRUE;
    if (R0)
	Adr[7] = FALSE;
    if (!we && !start_rel && sonder)
	D1 = FALSE;		// erst nach der Benutzung löschen
    if (E5)
	E6 = TRUE;
    X41 = FALSE;
    if (bue) {
	lsleser1 = 0;
	lsleser2 = 0;
    }
}

static void step44(void)
{
    if (W5 && b.w.op == 1 && (b.w.p&&!b.w.q&&Ts || !b.w.p&&b.w.q&&!Ts))
	R1 = TRUE;
    if (W5 && (b.w.p&&!b.w.q&&Ts || !b.w.p&&b.w.q&&!Ts)) {
	if (!R0)
	    W13 = FALSE;
	R0 = TRUE;
    }
    if (E1)
	E2 = TRUE;
    E1 = FALSE;
    if (Ts && W7 && G2) {
	r.wx.bt1 &= 0x83;	// ll bis s
     /*	r.w.ll = FALSE;
	r.w.r = FALSE;
	r.w.u = FALSE;
	r.w.a = FALSE;
	r.w.s = FALSE; */
	r.w.h = FALSE;
    }
    if (J1) {
	E5 = FALSE;
	E6 = FALSE;
    }
    if (r.w.c && U0 && !r.w.g && SspA0s)
	K2 = TRUE;
    if (W2 && !R1 && b.w.y && !vHY && !T3)
	W3 = TRUE;
    if (W2 && !R1 && b.w.pp && !T4)
	W4 = TRUE;
}

static void step44_5(void)
{
    if (U0 && W1 && !(K1||K3) && !r.w.c && !r.w.k && !W21) { // Trommel schreiben
	if (SspA0s)
	    preSV1 = Ssp4.bt4 & 1;
	else
	    preSV1 = Adr[3]&&T3 || (Adr[5]||Adr[12])&&(Ssp5.bt4&1) ||
		     !VerbAdr&&(Ss.bt4&1);
    }
    if ((K1 || K3) && !W21)
	preSV1 = p1.bt4 & 1;	// vom Kernspeicher
    sonder = (!E5&&(K1||r.w.c||r.w.k) || get_ssp(&b)&&r.w.g ||
		sektor && (U0&&!D7 || !U2)) &&
	     (r.w.c&&!r.w.g || R0 || !SonderAdr || (!U0||!Adr[0])&&Adr[1] ||
		!(SU9&&!U0&&W131) || (SU9&&!U0&&W131||K9)&&AnelexFrei ||
		!r.w.k&&!Adr[7]&&!Adr[8]&&!Adr[10]&&!Adr[15] ||
		Adr[15]&&!U0&&Reader1Ready || Adr[15]&&U0&&FsFrei ||
		Adr[10]&&!U0&&Reader2Ready || Adr[7]&&MBFrei || Adr[0]&&SchnDrFrei ||
		UK1&&LocherFrei);
    if (W5 && we && !D1 && sonder)
	R1 = FALSE;
}

static void step45_5(void)
{
    if ((W5 || r.w.k) && !R0 && Blockfreigabe && sonder)
	W = TRUE;
    if ((Adr[10] || Adr[15]) && !U0 && W1a && r.w.c)	// braucht W
	W7 = TRUE;	// kein Takt in der Schaltung angegeben
    if (R0)
	W5 = FALSE;
    if (AN_Sel) {
	if (AN_len > 120 || AN_format_w > (AN_len+4)/5)
	    AN_alarm = TRUE;
    }
}

void	(*steps[])(void) = {
	step0,		NULL,		step1,		NULL,	   //  0 .. 1,5
	step2,		NULL,		NULL,		NULL,	   //  2 .. 3,5
	NULL,		NULL,		NULL,		NULL,	   //  4 .. 5,5
	NULL,		NULL,		NULL,		NULL,	   //  6 .. 7,5
	NULL,		NULL,		NULL,		NULL,	   //  8 .. 9,5
	NULL,		NULL,		NULL,		NULL,	   // 10 ..11,5
	NULL,		NULL,		NULL,		NULL,	   // 12 ..13,5
	NULL,		NULL,		step15,		NULL,	   // 14 ..15,5
	NULL,		NULL,		NULL,		NULL,	   // 16 ..17,5
	NULL,		NULL,		NULL,		NULL,	   // 18 ..19,5
	NULL,		NULL,		NULL,		NULL,	   // 20 ..21,5
	NULL,		NULL,		step23,		NULL,	   // 22 ..23,5
	step24,		NULL,		NULL,		step25_5,  // 24 ..25,5
	NULL,		NULL,		NULL,		NULL,	   // 26 ..27,5
	NULL,		NULL,		NULL,		NULL,	   // 28 ..29,5
	NULL,		NULL,		NULL,		NULL,	   // 30 ..31,5
	NULL,		NULL,		NULL,		NULL,	   // 32 ..33,5
	NULL,		NULL,		NULL,		NULL,	   // 34 ..35,5
	NULL,		NULL,		NULL,		NULL,	   // 36 ..37,5
	step38,		step38_5,	step39,		step39_5,  // 38 ..39,5
	step40,		step40_5,	step41,		step41_5,  // 40 ..41,5
	step42,		step42_5,	step43,		NULL,	   // 42 ..43,5
	step44,		step44_5,	NULL,  		step45_5 };// 44 ..45,5

static void
slowstep(void)
{
	char	as;
	char	Sst;
	char	bit0;
	char	T40save;	// gesicherter Akkuzustand vor Veränderung
	char	loktmp;

	tmp2 = W2 || !r.w.c&&!r.w.k&&SspA0s || E0&&W1 || r.w.c&&!r.w.k ||
		!r.w.c&&r.w.k&&TrA0s || K1&&SspA0s || r.w.c&&r.w.k&&SspA0s;
	tmp1 = tmp2 || K3 || !K3&&IS0&&W1 || !K3&&I0&&W1 || !U0&&SU9&&W131 ||
		r.w.v&&!r.w.ll&&!r.w.r&&SspAkl16&&W1&&!U0&&!SonderAdr;
	if (cur_step & 1) {	// S 1/2
	    S = FALSE;	// ab hier Setzen der Leseleitung (S)
	    if (!VerbAdr)
		S = Q5;
	    if (Adr[1])
		S = PL(39,5);
	    if (Adr[3])
		S = X31;
	    if (Adr4)
		S = X41;
	    if (Adr[5] || Adr[12])
		S = X51;
	    if (Adr[13]&&!HY&&P(0,13)&&(r.w.c || P(0,8)))
		S = Ssp13 & 1;
	    if (Adr[14] && !(r.w.c&&!r.w.k) && W && !R1 && !U0 && P(0,5))
		S = (hand >> (cur_step/2)) & 1;	/* Handeingabe */
	    if (Adr[15] && !(r.w.c&&!r.w.g) && W && !R1 && !U0) {
		/* Lochstreifenleser 1 */
		if (PL(0,5))
		    S = (lsleser1 >> 0) & 1;
		else if (PL(1,5))
		    S = (lsleser1 >> 1) & 1;
		else if (PL(2,5))
		    S = (lsleser1 >> 2) & 1;
		else if (PL(3,5))
		    S = (lsleser1 >> 3) & 1;
		else if (PL(4,5))
		    S = (lsleser1 >> 4) & 1;
	    }
	    if (Adr[10] && !(r.w.c&&!r.w.g) && W && !R1 && !U0) {
		/* Lochstreifenleser 2 */
		if (PL(0,5))
		    S = (lsleser2 >> 0) & 1;
		else if (PL(1,5))
		    S = (lsleser2 >> 1) & 1;
		else if (PL(2,5))
		    S = (lsleser2 >> 2) & 1;
		else if (PL(3,5))
		    S = (lsleser2 >> 3) & 1;
		else if (PL(4,5))
		    S = (lsleser2 >> 4) & 1;
	    }
	    if (K9 && A0)
		S = AN_alarm;
			// bis hier Setzen der Leseleitung (S)

	    if (cur_step < 38*2 || cur_step >= 45*2) {	// nur im Halbtakt notwendig
		if (U0 && W1 && !(K1||K3) && !r.w.c && !r.w.k && !W21) { // Trommel schreiben
		    if (SspA0s)
			preSV1 = (Ssp4.bt4 & 2) >> 1;			// von 439
		    else
			preSV1 = Adr[3]&& (Ssp3.bt4&2) != 0 ||	// von 339
				 (Adr[5]||Adr[12])&& (Ssp5.bt4&2) != 0 ||
				 !VerbAdr&& (Ss.bt4&2) != 0;	// jeweils Bit 39
		}
		if ((K1 || K3) && !W21)
		    preSV1 = (p1.bt4 & 2) >> 1;	// vom Kernspeicher
	    }
	    zOpW = FALSE;	// wird anschließend verodert
	    if (!r.w.r&&!r.w.ll || W1a)
		zOpW |= X41;
	    if (r.w.r&&r.w.ll&&!W1a) {
		if (PSL(0,5))
		    zOpW |= r.w.v&&(Ssp3.bt0&0x40);
		else
		    zOpW |= X42;
	    }
	    if (!r.w.r&&r.w.ll&&!W1a&&!PSL(0,5)&&!PSL(1,5))
		zOpW |= X44;
	    if (r.w.r&&!r.w.ll&&!W1a) {
		if (PSL(39,5))
		    zOpW |= X41;
		else
		    zOpW |= Ssp4.bt4 & 1;		// von 440
	    }
	    if (Korrektur && PS(2,37)) {	// Ps x,5
		X41 = TRUE;
		if (T4) {
		    if (Ssp4.bt0 & 0x10)	// 404
			Ssp4.bt0 |= 0x40;	// T41 auf TRUE
		    else
			Ssp4.bt0 |= 0x20;	// 403 auf TRUE
		} else {
		    Ssp4.bt0 &= ~0x40;	// T41 auf FALSE
		    if (!(Ssp4.bt0 & 0x10))	// !404
			Ssp4.bt0 &= ~0x20;	// 403 auf FALSE;
		}
		Ssp4.bt0 ^= 0x10;		// 404 <- !404
	    }
	    D43 = Ssp4.bt4 & 1;		// von 440
	    D30 = FALSE;
	    if ((!Adr[0]&&K3 || !K3) && W1 && !r.w.n && !tmp2)
		D30 = S;
	    if (W0&&!K3&&!r.w.n&&!r.w.g&&tmp2)
		D30 = zOpW;
	    if (W1a && !(!r.w.c&&!r.w.k&&SspA0s) && !PSL(38,5) && !PSL(39,5))
		D30 = b.wx.bt4 & 1;
	    if (W1&&K3&&!K1&&!U0&&!r.w.n&&Adr[0])
		D30 = Qk & 1;
	    D31 = FALSE;
	    loktmp = r.w.r&&r.w.ll&&!W1a&&(W7&&!r.w.g || OK0&&!K1);
	    Sst = loktmp && !P(0,3) && X45 || !(loktmp && PSL(3,5)) && S;	// S*
	    if (W1a&&!(!r.w.c&&!r.w.k&&SspA0s))
		D31 = Sst;
	    if (W2&&!W3 || W1 && !(E0&&W1) &&!U0&&!r.w.c&&r.w.k&&TrA0s)
		D31 = Sst;
	    if (W1a&&!r.w.c&&!r.w.k&&SspA0s&&!(r.w.v&&!r.w.ll&&!r.w.r) ||
			    !U0&&W1&&!r.w.c&&!r.w.k&& !(E0&&W1))
		D31 = L2 && !K1 && !W21;
	    if (W1&&!U0&&r.w.c&&!(E0&&W1)&&P(0,22))
		D31 = b.wx.bt4 & 1;	/* nur Bit 1-22 */
	    if (K1&&W1&&!U0&&!r.w.c&&!(E0&&W1) ||
			W1a&&!r.w.c&&!r.w.k&&SspA0s&&r.w.v&&!r.w.ll&&!r.w.r)
		D31 = Qk & 1;
	    D32 = !r.w.k&&E0&&W1&&!K1&&!W21&&L2 || E5&&!W21&&L2;
	    D33 = X41;
	    D34 = !PSL(0,5)&&r.w.v&&r.w.r&&r.w.ll&&!W1a&&X32 ||
		    !ROK0&&!(r.w.v&&(r.w.r||r.w.ll)&&!W1a)&&X31 ||
		    ROK0&&T3 ||
		    !PSL(39,5)&&r.w.v&&r.w.r&&!r.w.ll&&!W1a&&T3 ||
		    PSL(39,5)&&r.w.v&&r.w.r&&!r.w.ll&&!W1a&&X43;
	    D35 = S;
	    Dk = Qk;		// Kernspeicherrotation
	    D37 = get_trommel(&c) & 1;
	    D40 = zOpW;
	    UE2 = UE1 || loktmp && PSL(3,5) && S;
	    bit0 = (E5 ? c.wx.bt4 : b.wx.bt4) & 1;
	    char ue_temp = UE12 ||
		    PSL(0,5)&&(!r.w.g||R0)&&plus1_sch&&!(!E5&&r.w.k&&TrA0s) ||
		    PSL(13,5)&&(!r.w.g||R0)&&plus1_sch&&(!E5&&r.w.k&&TrA0s || W13&&W1&&SspAgg16);
	    UE11 = bit0 && ue_temp && plus1_sch;	// muß vor D36 sein
	    D36 = (bit0 || ue_temp) && !UE11;
	    D37 = c.wx.bt4 & 1;
	    UE21 = (r.wx.bt3&0x20) && (UE22 || PSL(30,5)&&E3);	// muß vor D38 sein
	    D38 = E3 ? (((r.wx.bt3&0x20) || UE22 || PSL(30,5)&&E3) && !UE21) : c.w.v;
	    UE31 = (rk&1) && (UE32 || PSL(27,5)&&E13);		// muß vor D39 sein
	    D39 = E13 ? (((rk&1) || UE32 || PSL(27,5)&&E13) && !UE31) :	// oder 0,5???
				((c.wx.bt3&0x20) != 0);
	    UE41 = (bk&1) && (UE42 || PSL(27,5)&&K3);	// muß vor Dk1 sein
	    Dk1 = ((bk&1)||UE42||PSL(27,5)&&K3) && !UE41;
	    DM1 = !K1&&L2 || K1&&Qk;
	} else {		// S 0
	    a = Operation(W1a||OK0||E0&&W1||W2&&!W4||U0&&W1||A0&&W1,
		    T0&&W1,I0&&W1,IS0&&W1,O0&&W1&&!OK0,S0&&W1||W4,D30,D31,UE2,&as);
	    X32 = X31;
	    X45 = X44;		// Die Reihenfolge ist wichtig!
	    X44 = X42;
	    X42 = X41;
	    if (PS(0,40)) {
		Q5 = shr(&Ss,Schreib);
		if (K3&&!U0&&W1)	// W1-Abfrage besser global ???
		    bit0 = a;
		else if (!K3&&K1&&U0&&W1&&!SspA0s)
		    bit0 = D35;
		else if (!K3&&K1&&U0&&W1&&Adr[0]&&D33)
		    bit0 = D33;
		else
		    bit0 = Dk;
		Qk = shr(&p1,bit0);
		bit0 = 0;
		if ((Adr[5] || Adr[12]) && !r.w.f)
		    bit0 = Schreib;
		if (W1 && r.w.f)
		    bit0 = D37;
		if ((Adr[5] || Adr[12] || r.w.f) && W0)
		    X51 = shr(&Ssp5,bit0);
		T40save = T40;
		if (W0&&!ROK0 || PPPQQQRA || ROK0&&PS(1,8)) {
		    bit0 = 0;
		    if (!W6 && !Adr[3])
			bit0 = D34;
		    if ((W1 || W4) && r.w.h && PSL(1,0))
			bit0 = 1;
		    if (Adr[3])
			bit0 = Schreib;
		    if (W6 && !R1)
			bit0 = D43;
		    X31 = shr(&Ssp3,bit0);
		}
		if (W0&&!ROK0 || PPPQQQRA) {
		    if (!ROK0&&!(U0&&W1&&Adr4)) {
			X41 = Ssp4.bt4 & 1;
			shra(&Ssp4);
			if (W0) {	// wenn ein neues Bit hereingeschoben wird
			    Ssp4.bt0 &= 0x7f;	// T4 löschen
			    if (tmp1&&!r.w.g&&!K3) {
				if (a)
				    Ssp4.bt0 |= 0x80;	// T4 setzen
			    } else {
				if (D40)
				    Ssp4.bt0 |= 0x80;	// T4 setzen
			    }
			}
		    }
		}
		if (PPPQQQRA && (W6 || W13&&W1)) {
		    Ssp13--;	// rückwärts zählen
		    Ssp13 &= 0x1fff;	// nur 13 Bit
		}
		if (U0&&Adr[15]&&W&&!R1)	// Fernschreib-Byte setzen
		    fs = (fs >> 1) | (Schreib << 7);
	    }
	    if (ROK0&&PS(3,38)) {
		shl(&Ssp4);
		Ssp4.bt4 |= X41;
		X41 = FALSE;
	    }
	    if (UK1&&W&&!R1) {
		if (!Sch8Kanal && PS(35,39)) {
		    locher = (locher >> 1) | (Schreib << 7);
		    locher &= 0xf8;		// hier nur 5 Bit benutzt
		}
		if (Sch8Kanal && PS(1,8))
		    locher = (locher >> 1) | (Schreib << 7);	// Drehung unnötig
	    }
	    if (PS(1,13)) {
		if (Adr[13]&&!HY&&W1) {
		    Ssp13 >>= 1;
		    Ssp13 |= Schreib << 12;
		}
	    }
	    if (PS(1,40)) {
		if (!(K2||K3&&W13)&&PS(28,40)) {	// Adresse von b-Register
		    bk >>= 1;
		    if (BK)	// muß vor der Rotation der Trommeladresse sein
			bk |= (b.wx.bt4 & 1) << 12;
		    else
			bk |= (b.wx.bt3 & 0x20) << 7;
		}
		if (SJ&&(!r.w.k||!r.w.g||R0||S3||PS(1,27))) {
		    shr((Wortx *)&b,0);
		    if (BK)	// Trommeladresse rotieren
			b.wx.bt3 = (b.wx.bt3 & 0xef) | ((b.wx.bt4 & 1) << 4);
		    if (D32)
			b.wx.bt0 |= 0x80;	// hereinschieben
		    else if ((W13&&W1 || W2 || W20) && D36)	// mit Erhöhung rotieren
			b.wx.bt0 |= 0x80;	// hereinschieben
		    else if (!E5&&W1&&!(W13&&W1)&&!(E0&&W1)&&!W20 || !E5&&R0&&!R1&&!W2) {
			if (!E13&&!(J1&&!J2) && D37)
			    b.wx.bt0 |= 0x80;	// hereinschieben
			if (J1&&!J2 && (cur_step<22*2||cur_step>=39*2))	// ergibt P 39,5..21,5
			    b.wx.bt0 |= 0x80;	// hereinschieben
		    } else if (r.w.k&&E0&&W1&&!K1 && D35)
			b.wx.bt0 |= 0x80;	// hereinschieben
		    else if (W1a&&PS(1,13))	// ergibt P 0,5..13,5
			b.wx.bt0 |= a << 7;	// hereinschieben
		    else if (E0&&K1)
			b.wx.bt0 |= Dk << 7;	// hereinschieben
		    if (E13 && PS(21,40)) {
			b.wx.bt0 |= (p2.bt2 & 0x10) << 3;
			b.wx.bt2 |= (p2.bt4 & 1) << 3;
			shr(&p2,0);
		    }
		} else if (W&&!R1&&W7 || BK&&PS(28,40)) {
		    bit0 = shrtrommel((Wortx *)&b);
		    if (BK) {
			if (bit0)	// Trommeladresse rotieren
			    b.wx.bt3 |= 0x10;
		    } else {		// normaler shift
			if (b.wx.bt3 & 0x20)
			    b.wx.bt3 |= 0x10;
		    }
		}
		if ((K2 || K3 && W13) && PS(28,40)) {
		    bk >>= 1;
		    bk |= Dk1 << 12;
		}
		if (E3&&(PS(11,18)||PS(31,38))) {
		    shrssp((Wortx *)&r);
		    if (D39)
			r.wx.bt2 |= 0x10;
		}
		if (E13&&(PS(1,13)||PS(28,40))) {
		    rk >>= 1;
		    if (D37)
			rk |= 0x1000;
		}
		if (SJ&&!W20&&(S6||!W2)&&!(J1&&!J2)&&!(W7&&E0&&W1)&&!(W13&&W1)&&
			(W7&&r.w.g||!r.w.g||R0)&&!E3&&!E13) {
		    shrbef((Wortx *)&c);
		    if (D36)
			c.wx.bt0 |= 0x80;
		    shrssp((Wortx *)&c);
		    if (D38)
			c.wx.bt2 |= 0x10;
		    shrtrommel((Wortx *)&c);
		    if (D39)
			c.wx.bt3 |= 0x10;
		} else {
		    if (E3&&(PS(11,18)||PS(31,38))) {
			shrssp((Wortx *)&c);
			if (D38)
			    c.wx.bt2 |= 0x10;
		    }
		    if (E13&&(PS(1,13)||PS(28,40))) {
			shrtrommel((Wortx *)&c);
			if (D39)
			    c.wx.bt3 |= 0x10;
		    }
		}
		if (AN_Sel && W1) {	// Selektion mit Wortspannung und Schiebeimpuls
		    if (!AN_alarm)
			shr(&AN_puffer[AN_format_w],AN_Schreib);
		}
	    }
	    if (sektor && PS(0,39))
		L2 = get_bit(get_trommel(&r), cur_step/2);	// von der Trommel
	    UE1 = as && !PSL(0,0);
	    UE12 = UE11;
	    UE22 = UE21;
	    UE32 = UE31;
	    UE42 = UE41;
	}
	if (steps[cur_step])
	    (steps[cur_step])();
	if (sektor && SWmitW1 && (cur_step & 1)) {	// S 1/2
	    SV1 = preSV1;	// zur Trommel
	    if (cur_step < 38*2)	// in Ps 44,5..37,5
		put_bit(get_trommel(&r), cur_step/2+2, SV1);
	    if (cur_step >= 44*2)	// in Ps 44,5..37,5
		put_bit(get_trommel(&r), cur_step/2-44, SV1);
	}

	cur_step++;
	if (cur_step >= 46*2)
		cur_step = 0;
}

void
step(void)
{
	do {
		slowstep();
	} while (cur_step != 0);
}

static void __attribute__((__noreturn__))
zuse23_process(void *_cpssp)
{
	for (;;) {
		cpssp = _cpssp;
		while (cpssp->process.inst_cnt < cpssp->process.inst_limit) {
			step();
#if DEBUG_CONTROL_FLOW
			{
				static Worty b_old;
				static Worty c_old;
				static Wortx Ssp_old[256];
				int i;
				int diff;

				memcpy(&Ssp[3], &Ssp3, sizeof(Ssp[3]));
				memcpy(&Ssp[4], &Ssp4, sizeof(Ssp[4]));
				memcpy(&Ssp[5], &Ssp5, sizeof(Ssp[5]));
				Ssp[13].bt4 = Ssp13;

				diff = 0;
				for (i = 0; i < 256; i++) {
					if (i != 2
					 && i != 3
					 && i != 4
					 && i != 5
					 && i != 13
					 && i < 16) continue;
					diff |= memcmp(&Ssp[i], &Ssp_old[i], sizeof(Ssp[i]));
				}

				if (memcmp(&b, &b_old, sizeof(b)) != 0
				 || memcmp(&c, &c_old, sizeof(c)) != 0
				 || diff) {
					fprintf(stderr, "\n");

					fprintf(stderr, "b: ");
					dump(&b_old);
					fprintf(stderr, " -> ");
					dump(&b);
					fprintf(stderr, "\n");
					memcpy(&b_old, &b, sizeof(b_old));

					fprintf(stderr, "c: ");
					dump(&c_old);
					fprintf(stderr, " -> ");
					dump(&c);
					fprintf(stderr, "\n");
					memcpy(&c_old, &c, sizeof(c_old));

					for (i = 0; i < 256; i++) {
						if (i != 2
						 && i != 3
						 && i != 4
						 && i != 5
						 && i != 13
						 && i < 16) continue;
						if (memcmp(&Ssp[i], &Ssp_old[i], sizeof(Ssp[i])) != 0) {
							fprintf(stderr, "Ssp[%d]: ", i);
							dump((Worty *) &Ssp_old[i]);
							fprintf(stderr, " -> ");
							dump((Worty *) &Ssp[i]);
							fprintf(stderr, "\n");
							memcpy(&Ssp_old[i], &Ssp[i], sizeof(Ssp_old[i]));
						}
					}
				}
			}
#endif
			cpssp->process.inst_cnt += 46;
		}

#define S(x) \
		switch (x / 8) { \
		case 4: sig_boolean_set(cpssp->port_bef_lamp ## x, cpssp, (b.wx.bt0 >> (x % 8)) & 1); break; \
		case 3: sig_boolean_set(cpssp->port_bef_lamp ## x, cpssp, (b.wx.bt1 >> (x % 8)) & 1); break; \
		case 2: sig_boolean_set(cpssp->port_bef_lamp ## x, cpssp, (b.wx.bt2 >> (x % 8)) & 1); break; \
		case 1: sig_boolean_set(cpssp->port_bef_lamp ## x, cpssp, (b.wx.bt3 >> (x % 8)) & 1); break; \
		case 0: sig_boolean_set(cpssp->port_bef_lamp ## x, cpssp, (b.wx.bt4 >> (x % 8)) & 1); break; \
		};
		S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
		S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
		S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
		S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S
#define S(x) \
		switch (x / 8) { \
		case 4: sig_boolean_set(cpssp->port_akku_lamp ## x, cpssp, (Ssp4.bt0 >> (x % 8)) & 1); break; \
		case 3: sig_boolean_set(cpssp->port_akku_lamp ## x, cpssp, (Ssp4.bt1 >> (x % 8)) & 1); break; \
		case 2: sig_boolean_set(cpssp->port_akku_lamp ## x, cpssp, (Ssp4.bt2 >> (x % 8)) & 1); break; \
		case 1: sig_boolean_set(cpssp->port_akku_lamp ## x, cpssp, (Ssp4.bt3 >> (x % 8)) & 1); break; \
		case 0: sig_boolean_set(cpssp->port_akku_lamp ## x, cpssp, (Ssp4.bt4 >> (x % 8)) & 1); break; \
		};
		S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
		S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
		S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
		S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S
		sched_to_scheduler();
	}
}

#define S(x) \
static void \
zuse23_ ## sperr_switch ## x ## _set(void *_cpssp, unsigned int val) \
{ \
	sperr[x] = val; \
}
S(1); S(2); S(3); S(4); S(5); S(6); S(7);
#undef S

static void
zuse23_loe_aus_set(void *_cpssp, unsigned int val)
{
	/* struct cpssp *cpssp = _cpssp; */

	loeschung_sch = ! val;
}

static void
zuse23_adr_p1_aus_set(void *_cpssp, unsigned int val)
{
	/* struct cpssp *cpssp = _cpssp; */

	plus1_sch = ! val;
}

#define S(x) \
static void \
zuse23_ ## bed_switch ## x ## _set(void *_cpssp, unsigned int val) \
{ \
	hand &= ~(1 << x); \
	hand |= val << x; \
}
S(0); S(1); S(2); S(3); S(4);
#undef S

static void
zuse23_bed_ein_set(void *_cpssp, unsigned int val)
{
	/* struct cpssp *cpssp = _cpssp; */

	bed_stop_sch = val;
}

static void
zuse23_adr_stop_ein_set(void *_cpssp, unsigned int val)
{
	/* struct cpssp *cpssp = _cpssp; */

	adr_stop_ein = val;
}

#define S(x) \
static void \
zuse23_adr_stop_switch ## x ## _set(void *_cpssp, unsigned int val) \
{ \
	/* struct cpssp *cpssp = _cpssp; */ \
 \
	adr_stop_adr &= ~(1 << x); \
	adr_stop_adr |= val << x; \
}
S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
S(10); S(11); S(12);
#undef S

#define S(x) \
static void \
zuse23_bef_switch ## x ## _set(void *_cpssp, unsigned int val) \
{ \
	/* struct cpssp *cpssp = _cpssp; */\
	\
	switch (x / 8) { \
	case 4: val_b.bt0 &= ~(1 << (x % 8)); val_b.bt0 |= val << (x % 8); break; \
	case 3: val_b.bt1 &= ~(1 << (x % 8)); val_b.bt1 |= val << (x % 8); break; \
	case 2: val_b.bt2 &= ~(1 << (x % 8)); val_b.bt2 |= val << (x % 8); break; \
	case 1: val_b.bt3 &= ~(1 << (x % 8)); val_b.bt3 |= val << (x % 8); break; \
	case 0: val_b.bt4 &= ~(1 << (x % 8)); val_b.bt4 |= val << (x % 8); break; \
	} \
}
S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S

#define S(x) \
static void \
zuse23_akku_switch ## x ## _set(void *_cpssp, unsigned int val) \
{ \
	/* struct cpssp *cpssp = _cpssp; */\
	\
	switch (x / 8) { \
	case 4: val_a.bt0 &= ~(1 << (x % 8)); val_a.bt0 |= val << (x % 8); break; \
	case 3: val_a.bt1 &= ~(1 << (x % 8)); val_a.bt1 |= val << (x % 8); break; \
	case 2: val_a.bt2 &= ~(1 << (x % 8)); val_a.bt2 |= val << (x % 8); break; \
	case 1: val_a.bt3 &= ~(1 << (x % 8)); val_a.bt3 |= val << (x % 8); break; \
	case 0: val_a.bt4 &= ~(1 << (x % 8)); val_a.bt4 |= val << (x % 8); break; \
	} \
}
S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S

static void
zuse23_stop_set(void *_cpssp, unsigned int val)
{
	// struct cpssp *cpssp = _cpssp;

	stopT = val;
}

static void
zuse23_weiter_set(void *_cpssp, unsigned int val)
{
	// struct cpssp *cpssp = _cpssp;

	wesw = val;
}

static void
zuse23_start_set(void *_cpssp, unsigned int val)
{
	// struct cpssp *cpssp = _cpssp;

	start = val;
}

static void
zuse23_bef_ueb_set(void *_cpssp, unsigned int val)
{
	// struct cpssp *cpssp = _cpssp;

	buesw = val;
}

static void
zuse23_akku_ueb_set(void *_cpssp, unsigned int val)
{
	// struct cpssp *cpssp = _cpssp;

	auesw = val;
}

#define S(n, x) \
static void \
zuse23_ferranti ## n ## _bit ## x ## _set(void *_cpssp, unsigned int val) \
{ \
	/* struct cpssp *cpssp = _cpssp; */ \
 \
	ls ## n &= ~(1 << x); \
	ls ## n |= val << x; \
}
#define R(n) \
static void \
zuse23_ferranti ## n ## _ready_set(void *_cpssp, unsigned int val) \
{ \
	Reader ## n ## Ready = val; \
}
S(1, 0); S(1, 1); S(1, 2); S(1, 3); S(1, 4); R(1);
S(2, 0); S(2, 1); S(2, 2); S(2, 3); S(2, 4); R(2);
#undef R
#undef S

void *
zuse23_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *misc_lamp0,
	struct sig_boolean *misc_lamp1,
	struct sig_boolean *misc_lamp2,
	struct sig_boolean *misc_lamp3,
	struct sig_boolean *misc_lamp4,
	struct sig_boolean *misc_lamp5,
	struct sig_boolean *misc_lamp6,
	struct sig_boolean *misc_lamp7,
	struct sig_boolean *misc_lamp8,
	struct sig_boolean *misc_lamp9,
#if 0
	struct sig_boolean *sperr_lamp7,
	struct sig_boolean *sperr_lamp6,
	struct sig_boolean *sperr_lamp5,
	struct sig_boolean *sperr_lamp4,
	struct sig_boolean *sperr_lamp3,
	struct sig_boolean *sperr_lamp2,
	struct sig_boolean *sperr_lamp1,
	struct sig_boolean *loe_aus_lamp,
	struct sig_boolean *misc_lamp18,
	struct sig_boolean *adr_p1_aus_lamp,
	struct sig_boolean *bed_lamp4,
	struct sig_boolean *bed_lamp3,
	struct sig_boolean *bed_lamp2,
	struct sig_boolean *bed_lamp1,
	struct sig_boolean *bed_lamp0,
	struct sig_boolean *bed_ein_lamp,
	struct sig_boolean *adr_stop_ein_lamp,
	struct sig_boolean *adr_stop_lamp12,
	struct sig_boolean *adr_stop_lamp11,
	struct sig_boolean *adr_stop_lamp10,
	struct sig_boolean *adr_stop_lamp9,
	struct sig_boolean *adr_stop_lamp8,
	struct sig_boolean *adr_stop_lamp7,
	struct sig_boolean *adr_stop_lamp6,
	struct sig_boolean *adr_stop_lamp5,
	struct sig_boolean *adr_stop_lamp4,
	struct sig_boolean *adr_stop_lamp3,
	struct sig_boolean *adr_stop_lamp2,
	struct sig_boolean *adr_stop_lamp1,
	struct sig_boolean *adr_stop_lamp0,
#endif
	struct sig_boolean *bef_lamp39,
	struct sig_boolean *bef_lamp38,
	struct sig_boolean *bef_lamp37,
	struct sig_boolean *bef_lamp36,
	struct sig_boolean *bef_lamp35,
	struct sig_boolean *bef_lamp34,
	struct sig_boolean *bef_lamp33,
	struct sig_boolean *bef_lamp32,
	struct sig_boolean *bef_lamp31,
	struct sig_boolean *bef_lamp30,
	struct sig_boolean *bef_lamp29,
	struct sig_boolean *bef_lamp28,
	struct sig_boolean *bef_lamp27,
	struct sig_boolean *bef_lamp26,
	struct sig_boolean *bef_lamp25,
	struct sig_boolean *bef_lamp24,
	struct sig_boolean *bef_lamp23,
	struct sig_boolean *bef_lamp22,
	struct sig_boolean *bef_lamp21,
	struct sig_boolean *bef_lamp20,
	struct sig_boolean *bef_lamp19,
	struct sig_boolean *bef_lamp18,
	struct sig_boolean *bef_lamp17,
	struct sig_boolean *bef_lamp16,
	struct sig_boolean *bef_lamp15,
	struct sig_boolean *bef_lamp14,
	struct sig_boolean *bef_lamp13,
	struct sig_boolean *bef_lamp12,
	struct sig_boolean *bef_lamp11,
	struct sig_boolean *bef_lamp10,
	struct sig_boolean *bef_lamp9,
	struct sig_boolean *bef_lamp8,
	struct sig_boolean *bef_lamp7,
	struct sig_boolean *bef_lamp6,
	struct sig_boolean *bef_lamp5,
	struct sig_boolean *bef_lamp4,
	struct sig_boolean *bef_lamp3,
	struct sig_boolean *bef_lamp2,
	struct sig_boolean *bef_lamp1,
	struct sig_boolean *bef_lamp0,
	struct sig_boolean *akku_lamp39,
	struct sig_boolean *akku_lamp38,
	struct sig_boolean *akku_lamp37,
	struct sig_boolean *akku_lamp36,
	struct sig_boolean *akku_lamp35,
	struct sig_boolean *akku_lamp34,
	struct sig_boolean *akku_lamp33,
	struct sig_boolean *akku_lamp32,
	struct sig_boolean *akku_lamp31,
	struct sig_boolean *akku_lamp30,
	struct sig_boolean *akku_lamp29,
	struct sig_boolean *akku_lamp28,
	struct sig_boolean *akku_lamp27,
	struct sig_boolean *akku_lamp26,
	struct sig_boolean *akku_lamp25,
	struct sig_boolean *akku_lamp24,
	struct sig_boolean *akku_lamp23,
	struct sig_boolean *akku_lamp22,
	struct sig_boolean *akku_lamp21,
	struct sig_boolean *akku_lamp20,
	struct sig_boolean *akku_lamp19,
	struct sig_boolean *akku_lamp18,
	struct sig_boolean *akku_lamp17,
	struct sig_boolean *akku_lamp16,
	struct sig_boolean *akku_lamp15,
	struct sig_boolean *akku_lamp14,
	struct sig_boolean *akku_lamp13,
	struct sig_boolean *akku_lamp12,
	struct sig_boolean *akku_lamp11,
	struct sig_boolean *akku_lamp10,
	struct sig_boolean *akku_lamp9,
	struct sig_boolean *akku_lamp8,
	struct sig_boolean *akku_lamp7,
	struct sig_boolean *akku_lamp6,
	struct sig_boolean *akku_lamp5,
	struct sig_boolean *akku_lamp4,
	struct sig_boolean *akku_lamp3,
	struct sig_boolean *akku_lamp2,
	struct sig_boolean *akku_lamp1,
	struct sig_boolean *akku_lamp0,
	struct sig_boolean *misc_switch0,
	struct sig_boolean *misc_switch1,
	struct sig_boolean *misc_switch2,
	struct sig_boolean *misc_switch3,
	struct sig_boolean *misc_switch4,
	struct sig_boolean *misc_switch5,
	struct sig_boolean *misc_switch6,
	struct sig_boolean *misc_switch7,
	struct sig_boolean *misc_switch8,
	struct sig_boolean *misc_switch9,
	struct sig_boolean *sperr_switch7,
	struct sig_boolean *sperr_switch6,
	struct sig_boolean *sperr_switch5,
	struct sig_boolean *sperr_switch4,
	struct sig_boolean *sperr_switch3,
	struct sig_boolean *sperr_switch2,
	struct sig_boolean *sperr_switch1,
	struct sig_boolean *loe_aus_switch,
	struct sig_boolean *misc_switch18,
	struct sig_boolean *adr_p1_aus_switch,
	struct sig_boolean *bed_switch4,
	struct sig_boolean *bed_switch3,
	struct sig_boolean *bed_switch2,
	struct sig_boolean *bed_switch1,
	struct sig_boolean *bed_switch0,
	struct sig_boolean *bed_ein_switch,
	struct sig_boolean *adr_stop_ein_switch,
	struct sig_boolean *adr_stop_switch12,
	struct sig_boolean *adr_stop_switch11,
	struct sig_boolean *adr_stop_switch10,
	struct sig_boolean *adr_stop_switch9,
	struct sig_boolean *adr_stop_switch8,
	struct sig_boolean *adr_stop_switch7,
	struct sig_boolean *adr_stop_switch6,
	struct sig_boolean *adr_stop_switch5,
	struct sig_boolean *adr_stop_switch4,
	struct sig_boolean *adr_stop_switch3,
	struct sig_boolean *adr_stop_switch2,
	struct sig_boolean *adr_stop_switch1,
	struct sig_boolean *adr_stop_switch0,
	struct sig_boolean *bef_switch39,
	struct sig_boolean *bef_switch38,
	struct sig_boolean *bef_switch37,
	struct sig_boolean *bef_switch36,
	struct sig_boolean *bef_switch35,
	struct sig_boolean *bef_switch34,
	struct sig_boolean *bef_switch33,
	struct sig_boolean *bef_switch32,
	struct sig_boolean *bef_switch31,
	struct sig_boolean *bef_switch30,
	struct sig_boolean *bef_switch29,
	struct sig_boolean *bef_switch28,
	struct sig_boolean *bef_switch27,
	struct sig_boolean *bef_switch26,
	struct sig_boolean *bef_switch25,
	struct sig_boolean *bef_switch24,
	struct sig_boolean *bef_switch23,
	struct sig_boolean *bef_switch22,
	struct sig_boolean *bef_switch21,
	struct sig_boolean *bef_switch20,
	struct sig_boolean *bef_switch19,
	struct sig_boolean *bef_switch18,
	struct sig_boolean *bef_switch17,
	struct sig_boolean *bef_switch16,
	struct sig_boolean *bef_switch15,
	struct sig_boolean *bef_switch14,
	struct sig_boolean *bef_switch13,
	struct sig_boolean *bef_switch12,
	struct sig_boolean *bef_switch11,
	struct sig_boolean *bef_switch10,
	struct sig_boolean *bef_switch9,
	struct sig_boolean *bef_switch8,
	struct sig_boolean *bef_switch7,
	struct sig_boolean *bef_switch6,
	struct sig_boolean *bef_switch5,
	struct sig_boolean *bef_switch4,
	struct sig_boolean *bef_switch3,
	struct sig_boolean *bef_switch2,
	struct sig_boolean *bef_switch1,
	struct sig_boolean *bef_switch0,
	struct sig_boolean *akku_switch39,
	struct sig_boolean *akku_switch38,
	struct sig_boolean *akku_switch37,
	struct sig_boolean *akku_switch36,
	struct sig_boolean *akku_switch35,
	struct sig_boolean *akku_switch34,
	struct sig_boolean *akku_switch33,
	struct sig_boolean *akku_switch32,
	struct sig_boolean *akku_switch31,
	struct sig_boolean *akku_switch30,
	struct sig_boolean *akku_switch29,
	struct sig_boolean *akku_switch28,
	struct sig_boolean *akku_switch27,
	struct sig_boolean *akku_switch26,
	struct sig_boolean *akku_switch25,
	struct sig_boolean *akku_switch24,
	struct sig_boolean *akku_switch23,
	struct sig_boolean *akku_switch22,
	struct sig_boolean *akku_switch21,
	struct sig_boolean *akku_switch20,
	struct sig_boolean *akku_switch19,
	struct sig_boolean *akku_switch18,
	struct sig_boolean *akku_switch17,
	struct sig_boolean *akku_switch16,
	struct sig_boolean *akku_switch15,
	struct sig_boolean *akku_switch14,
	struct sig_boolean *akku_switch13,
	struct sig_boolean *akku_switch12,
	struct sig_boolean *akku_switch11,
	struct sig_boolean *akku_switch10,
	struct sig_boolean *akku_switch9,
	struct sig_boolean *akku_switch8,
	struct sig_boolean *akku_switch7,
	struct sig_boolean *akku_switch6,
	struct sig_boolean *akku_switch5,
	struct sig_boolean *akku_switch4,
	struct sig_boolean *akku_switch3,
	struct sig_boolean *akku_switch2,
	struct sig_boolean *akku_switch1,
	struct sig_boolean *akku_switch0,
	struct sig_boolean *port_stop,
	struct sig_boolean *port_weiter,
	struct sig_boolean *port_start,
	struct sig_boolean *akku_ueb,
	struct sig_boolean *bef_ueb,
	struct sig_boolean *port_ferranti1_power,
	struct sig_boolean *port_ferranti1_start,
	struct sig_boolean *port_ferranti1_bit0,
	struct sig_boolean *port_ferranti1_bit1,
	struct sig_boolean *port_ferranti1_bit2,
	struct sig_boolean *port_ferranti1_bit3,
	struct sig_boolean *port_ferranti1_bit4,
	struct sig_boolean *port_ferranti1_ready,
	struct sig_boolean *port_ferranti2_power,
	struct sig_boolean *port_ferranti2_start,
	struct sig_boolean *port_ferranti2_bit0,
	struct sig_boolean *port_ferranti2_bit1,
	struct sig_boolean *port_ferranti2_bit2,
	struct sig_boolean *port_ferranti2_bit3,
	struct sig_boolean *port_ferranti2_bit4,
	struct sig_boolean *port_ferranti2_ready,
	struct sig_serial *port_fernschreiber
)
{
#define S(x) \
	static const struct sig_boolean_funcs sperr_switch ## x ## _funcs = { \
		.set = zuse23_ ## sperr_switch ## x ## _set, \
	}
	S(1); S(2); S(3); S(4); S(5); S(6); S(7);
#undef S
	static const struct sig_boolean_funcs loe_aus_funcs = {
		zuse23_loe_aus_set,
	};
	static const struct sig_boolean_funcs adr_p1_aus_funcs = {
		zuse23_adr_p1_aus_set,
	};
#define S(x) \
	static const struct sig_boolean_funcs bed_switch ## x ## _funcs = { \
		.set = zuse23_ ## bed_switch ## x ## _set, \
	}
	S(0); S(1); S(2); S(3); S(4);
#undef S
	static const struct sig_boolean_funcs bed_ein_funcs = {
		zuse23_bed_ein_set,
	};
	static const struct sig_boolean_funcs adr_stop_ein_funcs = {
		zuse23_adr_stop_ein_set,
	};
#define S(x) \
	static const struct sig_boolean_funcs adr_stop_ ## x ## _funcs = { \
		.set = zuse23_ ## adr_stop_switch ## x ## _set, \
	}
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
	S(10); S(11); S(12);
#undef S
#define S(x) \
	static const struct sig_boolean_funcs bef_switch ## x ## _funcs = { \
		.set = zuse23_ ## bef_switch ## x ## _set, \
	}
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
	S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
	S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
	S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S
#define S(x) \
	static const struct sig_boolean_funcs akku_switch ## x ## _funcs = { \
		.set = zuse23_ ## akku_switch ## x ## _set, \
	}
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
	S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
	S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
	S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S
	static const struct sig_boolean_funcs stop_funcs = {
		zuse23_stop_set,
	};
	static const struct sig_boolean_funcs weiter_funcs = {
		zuse23_weiter_set,
	};
	static const struct sig_boolean_funcs start_funcs = {
		zuse23_start_set,
	};
	static const struct sig_boolean_funcs bef_ueb_funcs = {
		zuse23_bef_ueb_set,
	};
	static const struct sig_boolean_funcs akku_ueb_funcs = {
		zuse23_akku_ueb_set,
	};
#define S(n, x) \
	static const struct sig_boolean_funcs ferranti ## n ## _bit ## x ## _funcs = { \
		zuse23_ferranti ## n ## _bit ## x ## _set, \
	};
#define R(n) \
	static const struct sig_boolean_funcs ferranti ## n ## _ready_funcs = { \
		zuse23_ferranti ## n ## _ready_set, \
	};
	S(1, 0); S(1, 1); S(1, 2); S(1, 3); S(1, 4); R(1);
	S(2, 0); S(2, 1); S(2, 2); S(2, 3); S(2, 4); R(2);
#undef R
#undef S
	/* struct cpssp *cpssp; */ /* Use global variable. FIXME */

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->media = storage_create(name, sizeof(Wortx) * 8192, NULL,
			conv_gen_open, conv_gen_close, conv_gen_read);

	stopT = TRUE;
	step();
	stopT = FALSE;

#define S(x) \
	cpssp->port_bef_lamp ## x = bef_lamp ## x; \
	sig_boolean_connect_out(cpssp->port_bef_lamp ## x, cpssp, 0);
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
	S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
	S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
	S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S
#define S(x) \
	cpssp->port_akku_lamp ## x = akku_lamp ## x; \
	sig_boolean_connect_out(cpssp->port_akku_lamp ## x, cpssp, 0);
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
	S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
	S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
	S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S
#define S(x) \
	cpssp->port_ferranti ## x ## _start = port_ferranti ## x ## _start; \
	sig_boolean_connect_out(cpssp->port_ferranti ## x ## _start, cpssp, 0);
	S(1); S(2);
#undef S
	cpssp->port_fernschreiber = port_fernschreiber;

#define S(x) \
	sig_boolean_connect_in(sperr_switch ## x, cpssp, &sperr_switch ## x ## _funcs);
	S(1); S(2); S(3); S(4); S(5); S(6); S(7);
#undef S
	sig_boolean_connect_in(loe_aus_switch, cpssp, &loe_aus_funcs);
	loeschung_sch = 1;
	sig_boolean_connect_in(adr_p1_aus_switch, cpssp, &adr_p1_aus_funcs);
	plus1_sch = 1;
#define S(x) \
	sig_boolean_connect_in(bed_switch ## x, cpssp, &bed_switch ## x ## _funcs);
	S(0); S(1); S(2); S(3); S(4);
#undef S
	sig_boolean_connect_in(bed_ein_switch, cpssp, &bed_ein_funcs);
	sig_boolean_connect_in(adr_stop_ein_switch, cpssp, &adr_stop_ein_funcs);
#define S(x) \
	sig_boolean_connect_in(adr_stop_switch ## x, cpssp, &adr_stop_ ## x ## _funcs);
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
	S(10); S(11); S(12);
#undef S
#define S(x) \
	sig_boolean_connect_in(bef_switch ## x, cpssp, &bef_switch ## x ## _funcs)
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
	S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
	S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
	S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S
#define S(x) \
	sig_boolean_connect_in(akku_switch ## x, cpssp, &akku_switch ## x ## _funcs)
	S(0); S(1); S(2); S(3); S(4); S(5); S(6); S(7); S(8); S(9);
	S(10); S(11); S(12); S(13); S(14); S(15); S(16); S(17); S(18); S(19);
	S(20); S(21); S(22); S(23); S(24); S(25); S(26); S(27); S(28); S(29);
	S(30); S(31); S(32); S(33); S(34); S(35); S(36); S(37); S(38); S(39);
#undef S
#define S(n, x) \
	sig_boolean_connect_in(port_ferranti ## n ## _bit ## x, cpssp, &ferranti ## n ## _bit ## x ## _funcs)
#define R(n) \
	sig_boolean_connect_in(port_ferranti ## n ## _ready, cpssp, &ferranti ## n ## _ready_funcs)
	S(1, 0); S(1, 1); S(1, 2); S(1, 3); S(1, 4); R(1);
	S(2, 0); S(2, 1); S(2, 2); S(2, 3); S(2, 4); R(2);
#undef R
#undef S

	sig_boolean_connect_in(port_stop, cpssp, &stop_funcs);
	sig_boolean_connect_in(port_weiter, cpssp, &weiter_funcs);
	sig_boolean_connect_in(port_start, cpssp, &start_funcs);
	sig_boolean_connect_in(bef_ueb, cpssp, &bef_ueb_funcs);
	sig_boolean_connect_in(akku_ueb, cpssp, &akku_ueb_funcs);

	cpssp->process.inst_hz = 1472000;
	sched_process_init(&cpssp->process, zuse23_process, cpssp);

	return cpssp;
}

void
zuse23_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	int ret;

	ret = storage_destroy(cpssp->media);
	assert(0 <= ret);

	shm_free(cpssp);
}

void
zuse23_suspend(void *_cpssp, FILE *fp)
{
}

void
zuse23_resume(void *_cpssp, FILE *fp)
{
}
