/*
 * $Id: siemens_fernschreiber_gui_gtk.c,v 1.5 2012-11-30 12:52:28 vrsieh Exp $ 
 *
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define LINES	5
#define COLS	80

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include "glue-shm.h"
#include "glue-gui-gtk.h"

#include "siemens_fernschreiber_gui_gtk.h"

#define COMP		"siemens_fernschreiber"
#define COMP_(x)	siemens_fernschreiber_ ## x

struct cpssp {
	int cursor_x;
	int cursor_y;
	char text[LINES][COLS + 1];
	GtkWidget *gui_text[LINES];
};

static void
COMP_(gui_gtk_paper)(void *_cpssp, uint8_t c)
{
	struct cpssp *cpssp = _cpssp;

	switch (c) {
	case '\n':
		cpssp->cursor_y = (cpssp->cursor_y + 1) % LINES;
		cpssp->text[cpssp->cursor_y][0] = '\0';
		break;
	case '\r':
		cpssp->cursor_x = 0;
		break;
	default:
		if (cpssp->cursor_x < COLS) {
			cpssp->text[cpssp->cursor_y][cpssp->cursor_x++] = c;
			cpssp->text[cpssp->cursor_y][cpssp->cursor_x] = '\0';
		}
		gtk_label_set_label(GTK_LABEL(cpssp->gui_text[cpssp->cursor_y]),
				cpssp->text[cpssp->cursor_y]);
		break;
	}
}

void *
COMP_(gui_gtk_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_serial *port_in,
	struct sig_serial *port_paper
)
{
	static const struct sig_serial_funcs paper_funcs = {
		.recv = COMP_(gui_gtk_paper),
	};
	struct cpssp *cpssp;
	GtkWidget *vbox;
	int i;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->cursor_x = 0;
	cpssp->cursor_y = 0;
	for (i = 0; i < LINES; i++) {
		strcpy(cpssp->text[i], "");
	}

	vbox = gtk_vbox_new(FALSE, 1);
	gtk_widget_show(vbox);

	for (i = 0; i < LINES; i++) {
		cpssp->gui_text[i] = gtk_label_new(cpssp->text[i]);
		gtk_label_set_width_chars(GTK_LABEL(cpssp->gui_text[i]), COLS);
		gtk_misc_set_alignment(GTK_MISC(cpssp->gui_text[i]), 0.0, 0.5);
		gtk_widget_show(cpssp->gui_text[i]);
		gtk_box_pack_start(GTK_BOX(vbox), cpssp->gui_text[i],
				TRUE, FALSE, 0);
	}

	gui_gtk_comp_add(page, COMP, name, vbox, FALSE, FALSE, 0);

	sig_serial_connect(port_paper, cpssp, &paper_funcs);

	return NULL;
}

void
COMP_(gui_gtk_destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(gui_gtk_suspend)(void *_cpssp, FILE *fp)
{
}

void
COMP_(gui_gtk_resume)(void *_cpssp, FILE *fp)
{
}
