/*
 * $Id: siemens_fernschreiber_gui.c,v 1.2 2012-11-29 21:09:07 vrsieh Exp $ 
 *
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-gui.h"

#include "siemens_fernschreiber_gui.h"
#ifdef HAVE_GTK
#include "siemens_fernschreiber_gui_gtk.h"
#endif

#define COMP_(x)	siemens_fernschreiber_ ## x

void *
COMP_(gui_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_serial *port_in,
	struct sig_serial *port_paper
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return COMP_(gui_gtk_create)(page, name, port_manage,
				port_in, port_paper);
#endif /* HAVE_GTK */
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
COMP_(gui_destroy)(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_destroy)(_cpssp);
		break;
#endif /* HAVE_GTK */
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0);
	}
}

void
COMP_(gui_suspend)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_suspend)(_cpssp, fp);
		break;
#endif /* HAVE_GTK */
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0);
	}
}

void
COMP_(gui_resume)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_resume)(_cpssp, fp);
		break;
#endif /* HAVE_GTK */
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0);
	}
}
