/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue.h"

#include "seg7_sa5211cgkwa.h"

#define COMP_(x) seg7_sa5211cgkwa_ ## x

struct cpssp {
	int state_anode;
	int state_a;
	int state_b;
	int state_c;
	int state_d;
	int state_e;
	int state_f;
	int state_g;
	int state_dp;

	struct sig_opt_rgb *port_opt_a;
	struct sig_opt_rgb *port_opt_b;
	struct sig_opt_rgb *port_opt_c;
	struct sig_opt_rgb *port_opt_d;
	struct sig_opt_rgb *port_opt_e;
	struct sig_opt_rgb *port_opt_f;
	struct sig_opt_rgb *port_opt_g;
	struct sig_opt_rgb *port_opt_dp;
};

static void
COMP_(update)(struct cpssp *cpssp)
{
	uint8_t col;

	col = cpssp->state_a < cpssp->state_anode ? 0x00 : 0xff;
	sig_opt_rgb_pixel_set(cpssp->port_opt_a, cpssp, 0, 0, 0x00, col, 0x00);
	col = cpssp->state_b < cpssp->state_anode ? 0x00 : 0xff;
	sig_opt_rgb_pixel_set(cpssp->port_opt_b, cpssp, 0, 0, 0x00, col, 0x00);
	col = cpssp->state_c < cpssp->state_anode ? 0x00 : 0xff;
	sig_opt_rgb_pixel_set(cpssp->port_opt_c, cpssp, 0, 0, 0x00, col, 0x00);
	col = cpssp->state_d < cpssp->state_anode ? 0x00 : 0xff;
	sig_opt_rgb_pixel_set(cpssp->port_opt_d, cpssp, 0, 0, 0x00, col, 0x00);
	col = cpssp->state_e < cpssp->state_anode ? 0x00 : 0xff;
	sig_opt_rgb_pixel_set(cpssp->port_opt_e, cpssp, 0, 0, 0x00, col, 0x00);
	col = cpssp->state_f < cpssp->state_anode ? 0x00 : 0xff;
	sig_opt_rgb_pixel_set(cpssp->port_opt_f, cpssp, 0, 0, 0x00, col, 0x00);
	col = cpssp->state_g < cpssp->state_anode ? 0x00 : 0xff;
	sig_opt_rgb_pixel_set(cpssp->port_opt_g, cpssp, 0, 0, 0x00, col, 0x00);
	col = cpssp->state_dp < cpssp->state_anode ? 0x00 : 0xff;
	sig_opt_rgb_pixel_set(cpssp->port_opt_dp, cpssp, 0, 0, 0x00, col, 0x00);
}

static void
COMP_(a_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_a = SIG_mV(val);
	COMP_(update)(cpssp);
}

static void
COMP_(b_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_b = SIG_mV(val);
	COMP_(update)(cpssp);
}

static void
COMP_(c_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_c = SIG_mV(val);
	COMP_(update)(cpssp);
}

static void
COMP_(d_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_d = SIG_mV(val);
	COMP_(update)(cpssp);
}

static void
COMP_(e_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_e = SIG_mV(val);
	COMP_(update)(cpssp);
}

static void
COMP_(f_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_f = SIG_mV(val);
	COMP_(update)(cpssp);
}

static void
COMP_(g_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_g = SIG_mV(val);
	COMP_(update)(cpssp);
}

static void
COMP_(dp_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_dp = SIG_mV(val);
	COMP_(update)(cpssp);
}

static void
COMP_(anode_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_anode = 5000 - SIG_mV(val); /* FIXME */
	COMP_(update)(cpssp);
}

void *
COMP_(create)(
	const char *name,
	struct sig_manage *manage,
	struct sig_std_logic *port_e,
	struct sig_std_logic *port_d,
	struct sig_std_logic *port_anode0,
	struct sig_std_logic *port_c,
	struct sig_std_logic *port_dp,
	struct sig_std_logic *port_b,
	struct sig_std_logic *port_a,
	struct sig_std_logic *port_anode1,
	struct sig_std_logic *port_f,
	struct sig_std_logic *port_g,
	struct sig_opt_rgb *port_opt_a,
	struct sig_opt_rgb *port_opt_b,
	struct sig_opt_rgb *port_opt_c,
	struct sig_opt_rgb *port_opt_d,
	struct sig_opt_rgb *port_opt_e,
	struct sig_opt_rgb *port_opt_f,
	struct sig_opt_rgb *port_opt_g,
	struct sig_opt_rgb *port_opt_dp
)
{
	static const struct sig_std_logic_funcs anode0_funcs = {
		.std_logic_set = COMP_(anode_set),
	};
	static const struct sig_std_logic_funcs a_funcs = {
		.std_logic_set = COMP_(a_set),
	};
	static const struct sig_std_logic_funcs b_funcs = {
		.std_logic_set = COMP_(b_set),
	};
	static const struct sig_std_logic_funcs c_funcs = {
		.std_logic_set = COMP_(c_set),
	};
	static const struct sig_std_logic_funcs d_funcs = {
		.std_logic_set = COMP_(d_set),
	};
	static const struct sig_std_logic_funcs e_funcs = {
		.std_logic_set = COMP_(e_set),
	};
	static const struct sig_std_logic_funcs f_funcs = {
		.std_logic_set = COMP_(f_set),
	};
	static const struct sig_std_logic_funcs g_funcs = {
		.std_logic_set = COMP_(g_set),
	};
	static const struct sig_std_logic_funcs dp_funcs = {
		.std_logic_set = COMP_(dp_set),
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* Out */
	cpssp->port_opt_a = port_opt_a;
	cpssp->port_opt_b = port_opt_b;
	cpssp->port_opt_c = port_opt_c;
	cpssp->port_opt_d = port_opt_d;
	cpssp->port_opt_e = port_opt_e;
	cpssp->port_opt_f = port_opt_f;
	cpssp->port_opt_g = port_opt_g;
	cpssp->port_opt_dp = port_opt_dp;

	/* In */
	cpssp->state_anode = 0;
	sig_std_logic_connect_in(port_anode0, cpssp, &anode0_funcs);
	cpssp->state_a = 0;
	sig_std_logic_connect_in(port_a, cpssp, &a_funcs);
	cpssp->state_b = 0;
	sig_std_logic_connect_in(port_b, cpssp, &b_funcs);
	cpssp->state_c = 0;
	sig_std_logic_connect_in(port_c, cpssp, &c_funcs);
	cpssp->state_d = 0;
	sig_std_logic_connect_in(port_d, cpssp, &d_funcs);
	cpssp->state_e = 0;
	sig_std_logic_connect_in(port_e, cpssp, &e_funcs);
	cpssp->state_f = 0;
	sig_std_logic_connect_in(port_f, cpssp, &f_funcs);
	cpssp->state_g = 0;
	sig_std_logic_connect_in(port_g, cpssp, &g_funcs);
	cpssp->state_dp = 0;
	sig_std_logic_connect_in(port_dp, cpssp, &dp_funcs);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}
