/*
 * $Id: power_supply.c,v 1.1 2013-05-13 16:04:12 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "glue.h"

#include "power_supply.h"

#define COMP		power_supply
#define COMP_(x)	power_supply_ ## x

struct cpssp {
	unsigned int state_power_230v;
	unsigned int state_mech_power_switch;
	unsigned int state_n_ps_on;

	struct sig_atx_conn *port_power_board;
	struct sig_molex_ide_power_conn *port_power_device[8];
};

static void
COMP_(power_update)(struct cpssp *cpssp)
{
	unsigned int suspend_well;
	unsigned int core_well;
	unsigned int i;

	/* Suspend Well Power */
	suspend_well = cpssp->state_power_230v
		&& cpssp->state_mech_power_switch;

	sig_std_logic_or_set(cpssp->port_power_board->_plus_5Vsb, cpssp,
			suspend_well);

	/* Core Well Power */
	core_well = cpssp->state_power_230v
		&& cpssp->state_mech_power_switch
		&& ! cpssp->state_n_ps_on;
	
	if (! core_well) {
		/* Must be first in case of power-fail. */
		sig_std_logic_or_set(cpssp->port_power_board->pwr_ok, cpssp,
				core_well);
	}
	sig_std_logic_or_set(cpssp->port_power_board->_plus_3_3V, cpssp,
			core_well);
	sig_std_logic_or_set(cpssp->port_power_board->_plus_5V, cpssp,
			core_well);
	sig_std_logic_or_set(cpssp->port_power_board->_minus_5V, cpssp,
			core_well);
	sig_std_logic_or_set(cpssp->port_power_board->_plus_12V, cpssp,
			core_well);
	sig_std_logic_or_set(cpssp->port_power_board->_minus_12V, cpssp,
			core_well);
	if (core_well) {
		/* Must be last in case of power-ok. */
		sig_std_logic_or_set(cpssp->port_power_board->pwr_ok, cpssp,
				core_well);
	}
	for (i = 0; i < 8; i++) {
		sig_std_logic_or_set(cpssp->port_power_device[i]->_plus_5V,
				cpssp, core_well);
		sig_std_logic_or_set(cpssp->port_power_device[i]->_plus_12V,
				cpssp, core_well);
	}
}

static void
COMP_(power_230V_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->state_power_230v = val;

	COMP_(power_update)(cpssp);
}

static void
COMP_(switch_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->state_mech_power_switch = val;

	COMP_(power_update)(cpssp);
}

static void
COMP_(n_ps_on_set)(void *_cpssp, unsigned int n_val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->state_n_ps_on = n_val;

	COMP_(power_update)(cpssp);
}

void *
COMP_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power_230v,
	struct sig_boolean *port_mech_power_switch,
	struct sig_atx_conn *port_power_board,
	struct sig_molex_ide_power_conn *port_power_device0,
	struct sig_molex_ide_power_conn *port_power_device1,
	struct sig_molex_ide_power_conn *port_power_device2,
	struct sig_molex_ide_power_conn *port_power_device3,
	struct sig_molex_ide_power_conn *port_power_device4,
	struct sig_molex_ide_power_conn *port_power_device5,
	struct sig_molex_ide_power_conn *port_power_device6,
	struct sig_molex_ide_power_conn *port_power_device7
)
{
	static const struct sig_boolean_funcs power_230V_funcs = {
		.set = COMP_(power_230V_set),
	};
	static const struct sig_boolean_funcs switch_funcs = {
		.set = COMP_(switch_set),
	};
	static const struct sig_std_logic_funcs n_ps_on_funcs = {
		.boolean_or_set = COMP_(n_ps_on_set),
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* Out */
	cpssp->port_power_board = port_power_board;
	sig_std_logic_connect_out(port_power_board->gnd, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_board->pwr_ok, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_board->_plus_5Vsb, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_board->_plus_3_3V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_board->_plus_5V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_board->_minus_5V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_board->_plus_12V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_board->_minus_12V, cpssp,
			SIG_STD_LOGIC_0);

	cpssp->port_power_device[0] = port_power_device0;
	sig_std_logic_connect_out(port_power_device0->gnd, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device0->_plus_5V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device0->_plus_12V, cpssp,
			SIG_STD_LOGIC_0);

	cpssp->port_power_device[1] = port_power_device1;
	sig_std_logic_connect_out(port_power_device1->gnd, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device1->_plus_5V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device1->_plus_12V, cpssp,
			SIG_STD_LOGIC_0);

	cpssp->port_power_device[2] = port_power_device2;
	sig_std_logic_connect_out(port_power_device2->gnd, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device2->_plus_5V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device2->_plus_12V, cpssp,
			SIG_STD_LOGIC_0);

	cpssp->port_power_device[3] = port_power_device3;
	sig_std_logic_connect_out(port_power_device3->gnd, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device3->_plus_5V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device3->_plus_12V, cpssp,
			SIG_STD_LOGIC_0);

	cpssp->port_power_device[4] = port_power_device4;
	sig_std_logic_connect_out(port_power_device4->gnd, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device4->_plus_5V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device4->_plus_12V, cpssp,
			SIG_STD_LOGIC_0);

	cpssp->port_power_device[5] = port_power_device5;
	sig_std_logic_connect_out(port_power_device5->gnd, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device5->_plus_5V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device5->_plus_12V, cpssp,
			SIG_STD_LOGIC_0);

	cpssp->port_power_device[6] = port_power_device6;
	sig_std_logic_connect_out(port_power_device6->gnd, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device6->_plus_5V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device6->_plus_12V, cpssp,
			SIG_STD_LOGIC_0);

	cpssp->port_power_device[7] = port_power_device7;
	sig_std_logic_connect_out(port_power_device7->gnd, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device7->_plus_5V, cpssp,
			SIG_STD_LOGIC_0);
	sig_std_logic_connect_out(port_power_device7->_plus_12V, cpssp,
			SIG_STD_LOGIC_0);

	/* Pullup */
	sig_std_logic_connect_out(port_power_board->n_ps_on, cpssp,
			SIG_STD_LOGIC_H);

	/* In */
	cpssp->state_power_230v = 0;
	sig_boolean_connect_in(port_power_230v, cpssp,
			&power_230V_funcs);

	cpssp->state_mech_power_switch = 0;
	sig_boolean_connect_in(port_mech_power_switch, cpssp,
			&switch_funcs);

	cpssp->state_n_ps_on = 1;
	sig_std_logic_connect_in(port_power_board->n_ps_on, cpssp,
			&n_ps_on_funcs);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
COMP_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
