/*
 * $Id: pata_disk_seagate_st3660a_def.h,v 1.1 2013-05-13 16:04:10 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define SERIAL_NUMBER(x)	pata_disk_seagate_st3660a_serial_number(x)
#define FIRMWARE_REVISION	"04.04.02"
#define MODEL_NUMBER		"ST3660A"

#define ATA1_SUPPORT		1
#define ATA2_SUPPORT		1
#define ATA3_SUPPORT		0
#define ATA4_SUPPORT		0
#define ATA5_SUPPORT		0 /* Not supported, yet. */
#define ATA6_SUPPORT		0 /* Not supported, yet. */
#define ATA7_SUPPORT		0 /* Not supported, yet. */

#define DISK_MULTIPLE_SUPPORT		(ATA3_SUPPORT || ATA4_SUPPORT || 1)
#define     MAX_IDE_MULTIPLE_SECTOR	16
#define DISK_DMA_SUPPORT		(ATA3_SUPPORT || ATA4_SUPPORT || 1)
#define DISK_READWRITE_LONG_SUPPORT	(ATA1_SUPPORT || 1)
#define     READWRITE_LONG_BYTES	16
#define DISK_RECALIBRATE_SUPPORT	(ATA1_SUPPORT || 0)
#define DISK_NOP_SUPPORT		1
#define DISK_READ_BUFFER_SUPPORT	1
#define DISK_WRITE_BUFFER_SUPPORT	1
#define DISK_SMART_SUPPORT		1
#define DISK_POWER_MANAGEMENT_SUPPORT	(ATA4_SUPPORT || 0)
#define DISK_LOOK_AHEAD_SUPPORT		1
#define DISK_WRITE_CACHE_SUPPORT	1
#define DISK_DOWNLOAD_MICROCODE_SUPPORT	1

#define CONFIG_PIO_MODE_0_SUPPORTED		1
#define CONFIG_PIO_MODE_1_SUPPORTED		1
#define CONFIG_PIO_MODE_2_SUPPORTED		1
#define CONFIG_PIO_MODE_3_SUPPORTED		1
#define CONFIG_PIO_MODE_4_SUPPORTED		0

#define CONFIG_SW_DMA_MODE_0_SUPPORTED		0
#define CONFIG_SW_DMA_MODE_1_SUPPORTED		0
#define CONFIG_SW_DMA_MODE_2_SUPPORTED		0

#define CONFIG_MW_DMA_MODE_0_SUPPORTED		1
#define CONFIG_MW_DMA_MODE_1_SUPPORTED		1
#define CONFIG_MW_DMA_MODE_2_SUPPORTED		0

#define CONFIG_ULTRA_DMA_MODE_0_SUPPORTED	1
#define CONFIG_ULTRA_DMA_MODE_1_SUPPORTED	1
#define CONFIG_ULTRA_DMA_MODE_2_SUPPORTED	1

#define CYLINDERS			1057
#define HEADS				16
#define SECTORS				63
#define LINEAR				(CYLINDERS*HEADS*SECTORS)

#define COMP_(x)	pata_disk_seagate_st3660a_ ## x
#define COMP		pata_disk_seagate_st3660a
#define SCOMP		"pata_disk_seagate_st3660a"
