/*
 * $Id: monitor_template.c,v 1.3 2013-05-09 20:18:12 vrsieh Exp $
 *
 * Implemenation of the monitor component simulator.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>

#include "glue.h"
#include "umutil.h"

#define MONITOR_WIDTH  1600
#define MONITOR_HEIGHT 1200

struct cpssp {

	/* Ports */
	struct sig_opt_rgb *port_opt_video;

	/* Signals */

	/* State */
	uint8_t pixel_buffer[MAX_WIDTH * MAX_HEIGHT * MAX_DEPTH / 8];
	int last_width;
	int last_height;
	unsigned int width;
	unsigned int height;
	unsigned int x;
	unsigned int y;
	enum {
		BLANKING,
		SHOW_SYNC_MSG,
		INVALID,
		VALID
	} sync_state;

	/* Processes */

	/* Components */
	/* -- EEPROM with EDID information connected to ddc */
	#define NAME	edid_eeprom
	#define STATE
	#include "arch_philips_pcx8582X-2.c"
	#undef STATE
	#undef NAME
};

#define NAME		edid_eeprom
#define NAME_(x) 	edid_eeprom_ ## x
#define BEHAVIOR
#include "arch_philips_pcx8582X-2.c"
#undef BEHAVIOR
#undef NAME_
#undef NAME

static unsigned char edidblock[128];

/*  GIMP header image file format (RGB) */
/*  RGB data for the text: "sync out of range" */

#define MSG_IMAGE_WIDTH  273
#define MSG_IMAGE_HEIGHT  29

/*  Call this macro repeatedly.  After each use, the pixel data can be extracted  */
#define HEADER_PIXEL(data,pixel) {\
  pixel[0] = (((data[0] - 33) << 2) | ((data[1] - 33) >> 4)); \
  pixel[1] = ((((data[1] - 33) & 0xF) << 4) | ((data[2] - 33) >> 2)); \
  pixel[2] = ((((data[2] - 33) & 0x3) << 6) | ((data[3] - 33))); \
  data += 4; \
}
static const char *header_data =
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!``]!"
	"``]!``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!"
	"!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!``]!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!"
	"``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!``]!``]!``]!"
	"``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!``]!``]!``]!"
	"``]!``]!``]!``]!``]!``]!``]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";

/* callback for power_230v */

static void
monitor_power_230v_set(void *_cpssp, unsigned int val)
{
	/* FIXME */
}

/* callbacks and helpers for sig_video */

static void
monitor_pixel_set(
	struct cpssp *cpssp,
	unsigned int x, unsigned int y,
	uint8_t r, uint8_t g, uint8_t b
)
{
	uint8_t *buffer = &cpssp->pixel_buffer[y * MAX_HEIGHT * 4 + x * 4];

	if (   buffer[0] != b
	    || buffer[1] != g
	    || buffer[2] != r ) {
		buffer[0] = b;
		buffer[1] = g;
		buffer[2] = r;
		sig_opt_rgb_pixel_set(cpssp->port_opt_video, 
				cpssp, x, y, r, g, b);
	}
}

static void
monitor_check_sync(void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	int y;
	int x;
	int xmin, ymin;
	uint8_t rgb[4];
	const char *data = header_data;

	if (cpssp->sync_state == VALID) {
		cpssp->last_width  = MONITOR_WIDTH;
		cpssp->last_height = MONITOR_HEIGHT;
		cpssp->width = 0;
		cpssp->height = 0;
		cpssp->sync_state = BLANKING;
	} else if (cpssp->sync_state == BLANKING) {
		cpssp->sync_state = SHOW_SYNC_MSG;
	} else if (cpssp->sync_state == SHOW_SYNC_MSG) {
		cpssp->sync_state = INVALID;
	}

	/* reset monitor state */
	sig_opt_rgb_size_set(cpssp->port_opt_video, cpssp,
			MONITOR_WIDTH, MONITOR_HEIGHT);

	xmin = (MONITOR_WIDTH / 2) - (MSG_IMAGE_WIDTH / 2);
	ymin = (MONITOR_HEIGHT / 2) - (MSG_IMAGE_HEIGHT / 2);
	for (y = 0; y < MONITOR_HEIGHT; y++) {
		for (x = 0; x < MONITOR_WIDTH; x++) {
			if (cpssp->sync_state == SHOW_SYNC_MSG
					&& xmin <= x
					&& x < xmin + MSG_IMAGE_WIDTH
					&& ymin <= y
					&& y < ymin + MSG_IMAGE_HEIGHT) {

				HEADER_PIXEL(data, rgb);
				monitor_pixel_set(cpssp, x, y,
						rgb[0], rgb[1], rgb[2]);
			} else {
				monitor_pixel_set(cpssp, x, y, 0, 0, 0);
			}
		}
	}

	if (cpssp->sync_state == BLANKING
		|| cpssp->sync_state == SHOW_SYNC_MSG) {

		time_call_after(TIME_HZ * 5, monitor_check_sync, cpssp);
	}
}

static void
monitor_found_sync(struct cpssp *cpssp)
{
	time_call_delete(monitor_check_sync, cpssp);
	cpssp->sync_state = VALID;
}

static void
monitor_no_sync(void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (cpssp->sync_state == VALID) { 
		monitor_check_sync(cpssp);
	}

	sig_opt_rgb_sync(cpssp->port_opt_video, cpssp);
}

static void
monitor_out(
	void *_cpssp,
	uint8_t red,
	uint8_t green,
	uint8_t blue
)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	monitor_pixel_set(cpssp,
			cpssp->x & MAX_WIDTH_MASK,
			cpssp->y & MAX_HEIGHT_MASK,
			red, green, blue);

	cpssp->x++;
}

static void
monitor_hor_retrace(void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->width = cpssp->x;
	cpssp->y++;
	if (cpssp->x < MONITOR_WIDTH && cpssp->y <= MONITOR_HEIGHT) {

		if (cpssp->width < cpssp->last_width && cpssp->last_width != -1) {
			/* lines became shorter
			 * -> fill the rest with ,,black'' */
			while (cpssp->x < cpssp->last_width) {
				monitor_out(cpssp, 0, 0, 0);
			}
		}
	}

	cpssp->x = 0;
}


static void
monitor_vert_retrace(void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (cpssp->width < MONITOR_WIDTH && cpssp->y < MONITOR_HEIGHT) {

		monitor_found_sync(cpssp);

		cpssp->height = cpssp->y;

		if (cpssp->width != cpssp->last_width
				|| cpssp->height != cpssp->last_height) {

			if (cpssp->height < cpssp->last_height && cpssp->last_height != -1) {
				/* fewer lines
				 * -> fill the rest with black */
				while (cpssp->y < cpssp->last_height) {
					while (cpssp->x < cpssp->last_width) {
						monitor_out(cpssp, 0, 0, 0);
					}
					cpssp->x = 0;
					cpssp->y++;
				}
			}

			cpssp->last_width = cpssp->width;
			cpssp->last_height = cpssp->height;

			sig_opt_rgb_size_set(cpssp->port_opt_video, cpssp, cpssp->width, cpssp->height);
		}
	} else {
		monitor_no_sync(cpssp);
	}

	sig_opt_rgb_sync(cpssp->port_opt_video, cpssp);

	cpssp->x = 0;
	cpssp->y = 0;
}

/* callbacks for ddc */

static void
monitor_stop_transaction(void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	edid_eeprom_stop_transaction(cpssp);
}

static void
monitor_read_byte(void *_cpssp, unsigned char *val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	edid_eeprom_read_byte(cpssp, val);
}

static bool
monitor_write_byte(void *_cpssp, unsigned char val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return edid_eeprom_write_byte(cpssp, val);
}

static bool
monitor_ack_addr(void *_cpssp, unsigned char addr)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return edid_eeprom_ack_addr(cpssp, addr);
}

void *
COMP_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power_230v,
	struct sig_vga_conn *port_vga,
	struct sig_opt_rgb *port_opt_video,
	struct sig_boolean *port_screenshot,
	struct sig_boolean *port_rec
)
{
	static const struct sig_boolean_funcs power_230v_funcs = {
		.set = monitor_power_230v_set,
	};
	static const struct sig_video_funcs video_funcs = {
		.out = monitor_out,
		.vert_retrace = monitor_vert_retrace,
		.hor_retrace = monitor_hor_retrace,
		.no_sync = monitor_no_sync,
	};
	static const struct sig_i2c_bus_funcs ddc_funcs = {
		.ack_addr = monitor_ack_addr,
		.stop_transaction = monitor_stop_transaction,
		.read_byte = monitor_read_byte,
		.write_byte = monitor_write_byte,
	};
	struct cpssp *cpssp;
	const char *path;
	int fd;
	int ret;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	path = buildpath(ROMDIR, SCOMP ".eeprom");
	fd = open(path, O_RDONLY);
	assert(0 <= fd);

	ret = read(fd, edidblock, sizeof(edidblock));
	assert(ret == sizeof(edidblock));

	ret = close(fd);
	assert(0 <= ret);

	edid_eeprom_init(cpssp, edidblock);
	edid_eeprom_a2_set(cpssp, 0);
	edid_eeprom_a1_set(cpssp, 0);
	edid_eeprom_a0_set(cpssp, 0);

	memset(cpssp->pixel_buffer, 0, sizeof(cpssp->pixel_buffer));
	cpssp->last_width = -1;
	cpssp->last_height = -1;
	cpssp->width = 0;
	cpssp->height = 0;
	cpssp->x = 0;
	cpssp->y = 0;
	cpssp->sync_state = VALID;

	/* Call */
	sig_i2c_bus_connect_cooked(port_vga->ddc, cpssp, &ddc_funcs);

	/* Out */
	cpssp->port_opt_video = port_opt_video;

	/* In */
	sig_boolean_connect_in(port_power_230v, cpssp, &power_230v_funcs);
	sig_video_connect(port_vga->video, cpssp, &video_funcs);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
COMP_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
