/*
 * $Id: media_gen_lochstreifen.c,v 1.4 2012-11-26 21:07:23 vrsieh Exp $
 *
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "glue.h"

#include "conv_gen.h"
#include "conv_zero.h"

#include "media_gen_lochstreifen.h"

#define COMP_(x) media_gen_lochstreifen_ ## x

struct cpssp {
	/* Config */
	char name[1024];
	const char *image;
	unsigned int size;

	void *media;
};

static int
COMP_(read)(
	void *_cpssp,
	int32_t blk,
	uint8_t *data,
	uint8_t *psub, /* Ignored */
	uint8_t *qsub /* Ignored */
)
{
	struct cpssp *cpssp = _cpssp;

	blk *= 7; /* strlen("***.**\n") == 7 */
	if (cpssp->size < blk + 7) {
		return 0;
	}

	storage_read(cpssp->media, data, 7, (unsigned long long) blk);
	return 1;
}

static int
COMP_(write)(
	void *_cpssp,
	int32_t blk,
	const uint8_t *data,
	const uint8_t *psub, /* Ignored */
	const uint8_t *qsub /* Ignored */
)
{
	struct cpssp *cpssp = _cpssp;

	if (cpssp->size <= blk) {
		return 0;
	}
	
	storage_write(cpssp->media, data, 1, (unsigned long long) blk);
	return 1;
}

void *
COMP_(create)(
	const char *name,
	const char *size,
	const char *image,
	struct sig_manage *manage,
	struct sig_magneto_optical *port_connect
)
{
	static const struct sig_magneto_optical_funcs connect_funcs = {
		.read = COMP_(read),
		.write = COMP_(write),
	};
	struct cpssp *cpssp;
	char path[1024];

	if (! size) size = "100000";

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	system_name_push(name);

	/* name */
	strcpy(cpssp->name, system_path());

	/* size */
	cpssp->size = atoi(size);

	/* contents */
	cpssp->image = image;

	assert(strlen(system_path()) + strlen(".media") < sizeof(path));
	sprintf(path, "%s.media", system_path());
	cpssp->media = storage_create(path,
			(uint64_t) cpssp->size,
			image, conv_gen_open, conv_gen_close, conv_gen_read);
	assert(cpssp->media);

	/* Write magic? FIXME */

	/* Call */
	sig_magneto_optical_connect(port_connect, cpssp, &connect_funcs);

	/* Out */
	/* In */

	system_name_pop();

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	int ret;

	ret = storage_destroy(cpssp->media);
	assert(0 <= ret);

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
COMP_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	void *savemedia = cpssp->media;
	const char *saveimage = cpssp->image;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
	
	cpssp->media = savemedia;
	cpssp->image = saveimage;
}
