/*
 * $Id: mb_ibm_at_dmaglue.c,v 1.20 2013-04-16 10:13:33 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "mb_ibm_at_dmaglue.h"

struct cpssp {
	struct sig_isa_dma *port_dma0_ext;
	struct sig_isa_dma *port_dma1_ext;
	struct sig_isa_dma *port_dma2_ext;
	struct sig_isa_dma *port_dma3_ext;
	struct sig_cs *port_dma1_cs_in;
	struct sig_isa_bus *port_dma1_bus_in;
	struct sig_isa_dma *port_dma5_ext;
	struct sig_isa_dma *port_dma6_ext;
	struct sig_isa_dma *port_dma7_ext;
	struct sig_isa_dma *port_dma0_int;
	struct sig_isa_dma *port_dma1_int;
	struct sig_isa_dma *port_dma2_int;
	struct sig_isa_dma *port_dma3_int;
	struct sig_cs *port_dma1_cs_out;
	struct sig_isa_bus *port_dma1_bus_out;
	struct sig_isa_dma *port_dma5_int;
	struct sig_isa_dma *port_dma6_int;
	struct sig_isa_dma *port_dma7_int;
	struct sig_integer *port_ma;
	unsigned int state_md;
};

static int
mb_ibm_at_dmaglue_inb(void *_cpssp, uint32_t port, unsigned char *valp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return sig_cs_readb(cpssp->port_dma1_cs_out, cpssp, port << 1, valp);
}

static int
mb_ibm_at_dmaglue_outb(void *_cpssp, uint32_t port, unsigned char val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return sig_cs_writeb(cpssp->port_dma1_cs_out, cpssp, port << 1, val);
}

static const unsigned int chan2index[8] = {
	0x7, 0x3, 0x1, 0x2, 0xf, 0xb, 0x9, 0xa,
};

#define define_inX(X) \
static int \
mb_ibm_at_dmaglue_in ## X(void *_cpssp, uint32_t offset, unsigned int tc) \
{ \
	struct cpssp *cpssp = (struct cpssp *) _cpssp; \
	uint32_t addr; \
	uint8_t val8; \
	uint16_t val16; \
	\
	sig_integer_set(cpssp->port_ma, cpssp, chan2index[X]); \
	if (X < 4) { \
		addr = (cpssp->state_md << 16) | (offset << 0); \
		sig_isa_dma_ack_inb(cpssp->port_dma ## X ## _ext, cpssp, tc, &val8); \
		sig_isa_bus_writeb(cpssp->port_dma1_bus_in, cpssp, addr, val8); \
	} else { \
		addr = ((cpssp->state_md & ~1) << 16) | (offset << 1); \
		sig_isa_dma_ack_inw(cpssp->port_dma ## X ## _ext, cpssp, tc, &val16); \
		sig_isa_bus_writew(cpssp->port_dma1_bus_in, cpssp, addr, val16); \
	} \
	return 0; \
}
#define define_outX(X) \
static int \
mb_ibm_at_dmaglue_out ## X(void *_cpssp, uint32_t offset, unsigned int tc) \
{ \
	struct cpssp *cpssp = (struct cpssp *) _cpssp; \
	uint32_t addr; \
	uint8_t val8; \
	uint16_t val16; \
	\
	sig_integer_set(cpssp->port_ma, cpssp, chan2index[X]); \
	if (X < 4) { \
		addr = (cpssp->state_md << 16) | (offset << 0); \
		sig_isa_bus_readb(cpssp->port_dma1_bus_in, cpssp, addr, &val8); \
		sig_isa_dma_ack_outb(cpssp->port_dma ## X ## _ext, cpssp, tc, val8); \
	} else { \
		addr = ((cpssp->state_md & ~1) << 16) | (offset << 1); \
		sig_isa_bus_readw(cpssp->port_dma1_bus_in, cpssp, addr, &val16); \
		sig_isa_dma_ack_outw(cpssp->port_dma ## X ## _ext, cpssp, tc, val16); \
	} \
	return 0; \
}

define_inX(0)
define_outX(0)
define_inX(1)
define_outX(1)
define_inX(2)
define_outX(2)
define_inX(3)
define_outX(3)
// define_inX(4)
// define_outX(4)
define_inX(5)
define_outX(5)
define_inX(6)
define_outX(6)
define_inX(7)
define_outX(7)

#undef define_inX
#undef define_outX


#define define_reqX(X) \
static int \
mb_ibm_at_dmaglue_req ## X(void *_cpssp) \
{ \
	struct cpssp *cpssp = (struct cpssp *) _cpssp; \
	\
	return sig_isa_dma_req(cpssp->port_dma ## X ## _int, cpssp); \
}

define_reqX(0)
define_reqX(1)
define_reqX(2)
define_reqX(3)
// define_reqX(4)
define_reqX(5)
define_reqX(6)
define_reqX(7)

#undef define_reqX

static void
mb_ibm_at_dmaglue_md_set(void *_cpssp, int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->state_md = val;
}

void *
mb_ibm_at_dmaglue_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_isa_dma *port_dma0_ext,
	struct sig_isa_dma *port_dma1_ext,
	struct sig_isa_dma *port_dma2_ext,
	struct sig_isa_dma *port_dma3_ext,
	struct sig_cs *port_dma1_cs_in,
	struct sig_isa_bus *port_dma1_bus_in,
	struct sig_isa_dma *port_dma5_ext,
	struct sig_isa_dma *port_dma6_ext,
	struct sig_isa_dma *port_dma7_ext,
	struct sig_isa_dma *port_dma0_int,
	struct sig_isa_dma *port_dma1_int,
	struct sig_isa_dma *port_dma2_int,
	struct sig_isa_dma *port_dma3_int,
	struct sig_cs *port_dma1_cs_out,
	struct sig_isa_bus *port_dma1_bus_out,
	struct sig_isa_dma *port_dma5_int,
	struct sig_isa_dma *port_dma6_int,
	struct sig_isa_dma *port_dma7_int,
	struct sig_integer *port_ma,
	struct sig_integer *port_md
)
{
	static const struct sig_isa_dma_funcs dma0_ext_funcs = {
                .req = mb_ibm_at_dmaglue_req0,
        };
        static const struct sig_isa_dma_funcs dma1_ext_funcs = {
                .req = mb_ibm_at_dmaglue_req1,
        };
        static const struct sig_isa_dma_funcs dma2_ext_funcs = {
                .req = mb_ibm_at_dmaglue_req2,
        };
        static const struct sig_isa_dma_funcs dma3_ext_funcs = {
                .req = mb_ibm_at_dmaglue_req3,
        };
	/* No dma4_ext_funcs! */
        static const struct sig_isa_dma_funcs dma5_ext_funcs = {
                .req = mb_ibm_at_dmaglue_req5,
        };
        static const struct sig_isa_dma_funcs dma6_ext_funcs = {
                .req = mb_ibm_at_dmaglue_req6,
        };
        static const struct sig_isa_dma_funcs dma7_ext_funcs = {
                .req = mb_ibm_at_dmaglue_req7,
        };
        static const struct sig_isa_dma_funcs dma0_int_funcs = {
                .ack_in = mb_ibm_at_dmaglue_in0,
                .ack_out = mb_ibm_at_dmaglue_out0,
        };
        static const struct sig_isa_dma_funcs dma1_int_funcs = {
                .ack_in = mb_ibm_at_dmaglue_in1,
                .ack_out = mb_ibm_at_dmaglue_out1,
        };
        static const struct sig_isa_dma_funcs dma2_int_funcs = {
                .ack_in = mb_ibm_at_dmaglue_in2,
                .ack_out = mb_ibm_at_dmaglue_out2,
        };
        static const struct sig_isa_dma_funcs dma3_int_funcs = {
                .ack_in = mb_ibm_at_dmaglue_in3,
                .ack_out = mb_ibm_at_dmaglue_out3,
        };
	/* No dma4_int_funcs! */
        static const struct sig_isa_dma_funcs dma5_int_funcs = {
                .ack_in = mb_ibm_at_dmaglue_in5,
                .ack_out = mb_ibm_at_dmaglue_out5,
        };
        static const struct sig_isa_dma_funcs dma6_int_funcs = {
                .ack_in = mb_ibm_at_dmaglue_in6,
                .ack_out = mb_ibm_at_dmaglue_out6,
        };
        static const struct sig_isa_dma_funcs dma7_int_funcs = {
                .ack_in = mb_ibm_at_dmaglue_in7,
                .ack_out = mb_ibm_at_dmaglue_out7,
        };
	static const struct sig_cs_funcs dma1_cs_in_funcs = {
		.writeb = mb_ibm_at_dmaglue_outb,
		.readb = mb_ibm_at_dmaglue_inb,
	};
	static const struct sig_integer_funcs md_funcs = {
		.set = mb_ibm_at_dmaglue_md_set,
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(cpssp));
	assert(cpssp);

	cpssp->port_dma0_ext = port_dma0_ext;
	cpssp->port_dma1_ext = port_dma1_ext;
	cpssp->port_dma2_ext = port_dma2_ext;
	cpssp->port_dma3_ext = port_dma3_ext;
	cpssp->port_dma1_cs_in = port_dma1_cs_in;
	cpssp->port_dma1_bus_in = port_dma1_bus_in;
	cpssp->port_dma5_ext = port_dma5_ext;
	cpssp->port_dma6_ext = port_dma6_ext;
	cpssp->port_dma7_ext = port_dma7_ext;
	cpssp->port_dma0_int = port_dma0_int;
	cpssp->port_dma1_int = port_dma1_int;
	cpssp->port_dma2_int = port_dma2_int;
	cpssp->port_dma3_int = port_dma3_int;
	cpssp->port_dma1_cs_out = port_dma1_cs_out;
	cpssp->port_dma1_bus_out = port_dma1_bus_out;
	cpssp->port_dma5_int = port_dma5_int;
	cpssp->port_dma6_int = port_dma6_int;
	cpssp->port_dma7_int = port_dma7_int;
	cpssp->port_ma = port_ma;

	/* Out */
	sig_integer_connect_out(port_ma, cpssp, 0);

	/* Call */
	sig_isa_dma_connect(port_dma0_ext, cpssp, &dma0_ext_funcs);
	sig_isa_dma_connect(port_dma1_ext, cpssp, &dma1_ext_funcs);
	sig_isa_dma_connect(port_dma2_ext, cpssp, &dma2_ext_funcs);
	sig_isa_dma_connect(port_dma3_ext, cpssp, &dma3_ext_funcs);
	sig_isa_dma_connect(port_dma5_ext, cpssp, &dma5_ext_funcs);
	sig_isa_dma_connect(port_dma6_ext, cpssp, &dma6_ext_funcs);
	sig_isa_dma_connect(port_dma7_ext, cpssp, &dma7_ext_funcs);

	sig_isa_dma_connect(port_dma0_int, cpssp, &dma0_int_funcs);
	sig_isa_dma_connect(port_dma1_int, cpssp, &dma1_int_funcs);
	sig_isa_dma_connect(port_dma2_int, cpssp, &dma2_int_funcs);
	sig_isa_dma_connect(port_dma3_int, cpssp, &dma3_int_funcs);
	sig_isa_dma_connect(port_dma5_int, cpssp, &dma5_int_funcs);
	sig_isa_dma_connect(port_dma6_int, cpssp, &dma6_int_funcs);
	sig_isa_dma_connect(port_dma7_int, cpssp, &dma7_int_funcs);

	sig_cs_connect(port_dma1_cs_in, cpssp, &dma1_cs_in_funcs);

	/* In */
	sig_integer_connect_in(port_md, cpssp, &md_funcs);

	return cpssp;
}

void
mb_ibm_at_dmaglue_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
mb_ibm_at_dmaglue_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
mb_ibm_at_dmaglue_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
