/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-led3.h"

#include "glue.h"

#include "ledblue_gui_gtk.h"

#define COMP "ledblue"

struct cpssp {
	GtkWidget *led;
	
	unsigned int state_led;
};

/*
 * Simulator Callbacks
 */
static void
gui_ledblue_opt_led_set(void *_cpssp, unsigned int x, unsigned int y, uint8_t r, uint8_t g, uint8_t b)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_led3_set(GUI_GTK_LED3(cpssp->led), 0, 0, b);
	cpssp->state_led = b;
	
	gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
/* none */

void *
ledblue_gui_gtk_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_a,
	struct sig_std_logic *port_c,
	struct sig_opt_rgb *port_opt_led
)
{
	static const struct sig_opt_rgb_funcs opt_led_funcs = {
		.pixel_set = gui_ledblue_opt_led_set,
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* LED */
	cpssp->led = gui_gtk_led3_new("LED");
	cpssp->state_led = 0;
	gtk_widget_show(cpssp->led);

	gui_gtk_comp_add(page, COMP, name, cpssp->led, FALSE, FALSE, NULL);

	/* In */
	sig_opt_rgb_connect(port_opt_led, cpssp, &opt_led_funcs);

	return cpssp;
}

void
ledblue_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
ledblue_gui_gtk_suspend(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
ledblue_gui_gtk_resume(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;
	
	GtkWidget *save_led = cpssp->led;
	
	generic_resume(cpssp, sizeof(*cpssp), fp);
	
	cpssp->led = save_led;
	
	gui_ledblue_opt_led_set(cpssp, 0, 0, 0, 0, cpssp->state_led);
}
