/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "glue.h"

#include "ledblue.h"

#define COMP_(x)	ledblue_ ## x

struct cpssp {
	unsigned int state_a;
	unsigned int state_c;

	struct sig_opt_rgb *port_opt_led;
};

static void
COMP_(update)(struct cpssp *cpssp)
{
	unsigned int val;

	val = cpssp->state_a > cpssp->state_c;

	sig_opt_rgb_pixel_set(cpssp->port_opt_led, cpssp,
			0, 0, 0, 0, val ? 0xff : 0x00);
}

static void
COMP_(a_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->state_a = val;

	COMP_(update)(cpssp);
}

static void
COMP_(c_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->state_c = val;

	COMP_(update)(cpssp);
}

void *
COMP_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_a,
	struct sig_std_logic *port_c,
	struct sig_opt_rgb *port_opt_led
)
{
	static const struct sig_std_logic_funcs a_funcs = {
		.boolean_or_set = COMP_(a_set),
	};
	static const struct sig_std_logic_funcs c_funcs = {
		.boolean_or_set = COMP_(c_set),
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* Call */
	/* Out */
	cpssp->port_opt_led = port_opt_led;

	/* In */
	sig_std_logic_connect_in(port_a, cpssp, &a_funcs);
	sig_std_logic_connect_in(port_c, cpssp, &c_funcs);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fp);
}
