/*
 * $Id: floppy_gen_floppydrive_gui.c,v 1.1 2013-05-13 16:04:10 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "floppy_gen_floppydrive_gui.h"

#ifdef HAVE_GTK
#include "floppy_gen_floppydrive_gui_gtk.h"
#endif

#define GUI_(x)	floppy_gen_floppydrive_gui_ ## x

void *
GUI_(create)(
	unsigned int page,
	const char *name,
	const char *model,
	const char *unit,
	struct sig_manage *port_manage,
	struct sig_molex_ide_power_conn *port_power,
	struct sig_shugart_conn *port_shugart,
	struct sig_boolean *port_opt_busy_led,
	struct sig_floppy *port_media,
	struct sig_string *port_change
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return GUI_(gtk_create)(
				page,
				name,
				model,
				unit,
				port_manage,
				port_power,
				port_shugart,
				port_opt_busy_led,
				port_media,
				port_change);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
GUI_(destroy)(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		GUI_(gtk_destroy)(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
GUI_(suspend)(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		GUI_(gtk_suspend)(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
GUI_(resume)(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		GUI_(gtk_resume)(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
