/*
 * $Id: ferranti_abtaster_gui_gtk.c,v 1.8 2012-12-05 17:17:42 vrsieh Exp $ 
 *
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "umutil.h"
#include "glue-gui.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-change.h"
#include "glue-gui-gtk-led.h"

#include "ferranti_abtaster_gui_gtk.h"

#define COMP "ferranti_abtaster"
#define COMP_(x) ferranti_abtaster_ ## x

struct cpssp {
	struct sig_string *port_change;

	GtkWidget *gui_lamp[6];
	GtkWidget *gui_change;
};

static GdkPixbuf *icon_power_led = NULL;
static GdkPixbuf *icon_power_led_off = NULL;
static GdkPixbuf *icon_power_led_small = NULL;
static GdkPixbuf *icon_power_led_off_small = NULL;

/*
 * Simulator Callbacks
 */
static void
COMP_(change_set)(void *_cpssp, const char *path)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_change_set(GUI_GTK_CHANGE(cpssp->gui_change), path);
}

static void
COMP_(hole_set)(void *_cpssp, int nr, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;
	GdkPixbuf *image;
	
	if (nr == 2) {
		if (val) {
			image = icon_power_led_small;
		} else {
			image = icon_power_led_off_small;
		}
	} else {
		if (val) {
			image = icon_power_led;
		} else {
			image = icon_power_led_off;
		}
	}
	gtk_image_set_from_pixbuf(GTK_IMAGE(cpssp->gui_lamp[nr]), image);
}

static void
COMP_(hole0_set)(void *_cpssp, unsigned int val)
{
	COMP_(hole_set)(_cpssp, 0, val);
}

static void
COMP_(hole1_set)(void *_cpssp, unsigned int val)
{
	COMP_(hole_set)(_cpssp, 1, val);
}

static void
COMP_(hole2_set)(void *_cpssp, unsigned int val)
{
	COMP_(hole_set)(_cpssp, 2, val);
}

static void
COMP_(hole3_set)(void *_cpssp, unsigned int val)
{
	COMP_(hole_set)(_cpssp, 3, val);
}

static void
COMP_(hole4_set)(void *_cpssp, unsigned int val)
{
	COMP_(hole_set)(_cpssp, 4, val);
}

static void
COMP_(hole5_set)(void *_cpssp, unsigned int val)
{
	COMP_(hole_set)(_cpssp, 5, val);
}

/*
 * GUI Callbacks
 */
static void
COMP_(insert_event)(GtkWidget *w, const char *string, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_string_set(cpssp->port_change, cpssp, string);
}

static void
COMP_(remove_event)(GtkWidget *w, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_string_set(cpssp->port_change, cpssp, "");
}

void *
COMP_(gui_gtk_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *manage,
	struct sig_boolean *port_power,
	struct sig_boolean *port_start,
	struct sig_boolean *port_bit0,
	struct sig_boolean *port_bit1,
	struct sig_boolean *port_bit2,
	struct sig_boolean *port_bit3,
	struct sig_boolean *port_bit4,
	struct sig_boolean *port_ready,
	struct sig_magneto_optical *port_media,
	struct sig_string *port_change,
	struct sig_boolean *port_hole0,
	struct sig_boolean *port_hole1,
	struct sig_boolean *port_hole2,
	struct sig_boolean *port_hole3,
	struct sig_boolean *port_hole4,
	struct sig_boolean *port_hole5
)
{
	static const struct sig_string_funcs change_funcs = {
		.set = COMP_(change_set),
	};
	static const struct sig_boolean_funcs hole0_funcs = {
		.set = COMP_(hole0_set),
	};
	static const struct sig_boolean_funcs hole1_funcs = {
		.set = COMP_(hole1_set),
	};
	static const struct sig_boolean_funcs hole2_funcs = {
		.set = COMP_(hole2_set),
	};
	static const struct sig_boolean_funcs hole3_funcs = {
		.set = COMP_(hole3_set),
	};
	static const struct sig_boolean_funcs hole4_funcs = {
		.set = COMP_(hole4_set),
	};
	static const struct sig_boolean_funcs hole5_funcs = {
		.set = COMP_(hole5_set),
	};
	struct cpssp *cpssp;
	GtkWidget *hbox;
	GtkWidget *vbox;
	int i;

	if (! icon_power_led) {
		const char *path;

		path = buildpath(PNGDIR, "power_led_off.png");
		icon_power_led_off = gdk_pixbuf_new_from_file(path, NULL);
		assert(icon_power_led_off);
		path = buildpath(PNGDIR, "power_led.png");
		icon_power_led = gdk_pixbuf_new_from_file(path, NULL);
		assert(icon_power_led);
		path = buildpath(PNGDIR, "power_led_off_small.png");
		icon_power_led_off_small = gdk_pixbuf_new_from_file(path, NULL);
		assert(icon_power_led_off_small);
		path = buildpath(PNGDIR, "power_led_small.png");
		icon_power_led_small = gdk_pixbuf_new_from_file(path, NULL);
		assert(icon_power_led_small);
	}

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->port_change = port_change;

	sig_string_connect(port_change, cpssp, &change_funcs);
	sig_boolean_connect_in(port_hole0, cpssp, &hole0_funcs);
	sig_boolean_connect_in(port_hole1, cpssp, &hole1_funcs);
	sig_boolean_connect_in(port_hole2, cpssp, &hole2_funcs);
	sig_boolean_connect_in(port_hole3, cpssp, &hole3_funcs);
	sig_boolean_connect_in(port_hole4, cpssp, &hole4_funcs);
	sig_boolean_connect_in(port_hole5, cpssp, &hole5_funcs);

	hbox = gtk_hbox_new(FALSE, 1);
	gtk_widget_show(hbox);

	cpssp->gui_change = gui_gtk_change_new("Lochstreifen");
	GTK_WIDGET_UNSET_FLAGS(cpssp->gui_change, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(cpssp->gui_change), "change-inserted",
			G_CALLBACK(COMP_(insert_event)), cpssp);
	g_signal_connect(G_OBJECT(cpssp->gui_change), "change-removed",
			G_CALLBACK(COMP_(remove_event)), cpssp);
	gtk_widget_show(cpssp->gui_change);

	gtk_box_pack_start(GTK_BOX(hbox), cpssp->gui_change, TRUE, FALSE, 0);

	vbox = gtk_vbox_new(FALSE, 1);
	gtk_widget_show(vbox);

	for (i = 0; i < 6; i++) {
		cpssp->gui_lamp[i] = gtk_image_new();
		if (i == 2) {
			gtk_image_set_from_pixbuf(GTK_IMAGE(cpssp->gui_lamp[i]),
						icon_power_led_off_small);
		} else {
			gtk_image_set_from_pixbuf(GTK_IMAGE(cpssp->gui_lamp[i]),
						icon_power_led_off);
		}
		gtk_widget_show(cpssp->gui_lamp[i]);

		gtk_box_pack_start(GTK_BOX(vbox), cpssp->gui_lamp[i], TRUE, FALSE, 0);
	}

	gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, FALSE, 0);
	
	gui_gtk_comp_add(page, COMP, name, hbox,
			FALSE, FALSE, NULL);

	return cpssp;
}

void
COMP_(gui_gtk_destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}

void
COMP_(gui_gtk_suspend)(void *_cpssp, FILE *fp)
{
}

void
COMP_(gui_gtk_resume)(void *_cpssp, FILE *fp)
{
}
