/*
 * $Id: elevator_rc_gui.c,v 1.11 2013-05-08 14:03:17 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "elevator_rc_gui.h"

#ifdef HAVE_GTK
#include "elevator_rc_gui_gtk.h"
#endif

void *
elevator_rc_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_dio48_conn *port_dio48
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return elevator_rc_gui_gtk_create(page, name,
				port_manage,
				port_dio48);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
elevator_rc_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		elevator_rc_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
elevator_rc_gui_suspend(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		elevator_rc_gui_gtk_suspend(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
elevator_rc_gui_resume(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		elevator_rc_gui_gtk_resume(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
