/*
 * $Id: dio48_loopback.c,v 1.18 2013-05-08 14:03:17 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "dio48_loopback.h"

struct cpssp {
	struct sig_std_logic_merge *forward_a00_b00;
	struct sig_std_logic_merge *forward_a01_b01;
	struct sig_std_logic_merge *forward_a02_b02;
	struct sig_std_logic_merge *forward_a03_b03;
	struct sig_std_logic_merge *forward_a04_b04;
	struct sig_std_logic_merge *forward_a05_b05;
	struct sig_std_logic_merge *forward_a06_b06;
	struct sig_std_logic_merge *forward_a07_b07;

	struct sig_std_logic_merge *forward_c00_c04;
	struct sig_std_logic_merge *forward_c01_c05;
	struct sig_std_logic_merge *forward_c02_c06;
	struct sig_std_logic_merge *forward_c03_c07;

	struct sig_std_logic_merge *forward_a10_b10;
	struct sig_std_logic_merge *forward_a11_b11;
	struct sig_std_logic_merge *forward_a12_b12;
	struct sig_std_logic_merge *forward_a13_b13;
	struct sig_std_logic_merge *forward_a14_b14;
	struct sig_std_logic_merge *forward_a15_b15;
	struct sig_std_logic_merge *forward_a16_b16;
	struct sig_std_logic_merge *forward_a17_b17;

	struct sig_std_logic_merge *forward_c10_c14;
	struct sig_std_logic_merge *forward_c11_c15;
	struct sig_std_logic_merge *forward_c12_c16;
	struct sig_std_logic_merge *forward_c13_c17;
};

void *
dio48_loopback_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_dio48_conn *port_dio48
)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->forward_a00_b00 = sig_std_logic_merge(
		port_dio48->sig00, port_dio48->sig08);
	cpssp->forward_a01_b01 = sig_std_logic_merge(
		port_dio48->sig01, port_dio48->sig09);
	cpssp->forward_a02_b02 = sig_std_logic_merge(
		port_dio48->sig02, port_dio48->sig10);
	cpssp->forward_a03_b03 = sig_std_logic_merge(
		port_dio48->sig03, port_dio48->sig11);
	cpssp->forward_a04_b04 = sig_std_logic_merge(
		port_dio48->sig04, port_dio48->sig12);
	cpssp->forward_a05_b05 = sig_std_logic_merge(
		port_dio48->sig05, port_dio48->sig13);
	cpssp->forward_a06_b06 = sig_std_logic_merge(
		port_dio48->sig06, port_dio48->sig14);
	cpssp->forward_a07_b07 = sig_std_logic_merge(
		port_dio48->sig07, port_dio48->sig15);

	cpssp->forward_c00_c04 = sig_std_logic_merge(
		port_dio48->sig16, port_dio48->sig20);
	cpssp->forward_c01_c05 = sig_std_logic_merge(
		port_dio48->sig17, port_dio48->sig21);
	cpssp->forward_c02_c06 = sig_std_logic_merge(
		port_dio48->sig18, port_dio48->sig22);
	cpssp->forward_c03_c07 = sig_std_logic_merge(
		port_dio48->sig19, port_dio48->sig23);

	cpssp->forward_a10_b10 = sig_std_logic_merge(
		port_dio48->sig24, port_dio48->sig32);
	cpssp->forward_a11_b11 = sig_std_logic_merge(
		port_dio48->sig25, port_dio48->sig33);
	cpssp->forward_a12_b12 = sig_std_logic_merge(
		port_dio48->sig26, port_dio48->sig34);
	cpssp->forward_a13_b13 = sig_std_logic_merge(
		port_dio48->sig27, port_dio48->sig35);
	cpssp->forward_a14_b14 = sig_std_logic_merge(
		port_dio48->sig28, port_dio48->sig36);
	cpssp->forward_a15_b15 = sig_std_logic_merge(
		port_dio48->sig29, port_dio48->sig37);
	cpssp->forward_a16_b16 = sig_std_logic_merge(
		port_dio48->sig30, port_dio48->sig38);
	cpssp->forward_a17_b17 = sig_std_logic_merge(
		port_dio48->sig31, port_dio48->sig30);

	cpssp->forward_c10_c14 = sig_std_logic_merge(
		port_dio48->sig40, port_dio48->sig44);
	cpssp->forward_c11_c15 = sig_std_logic_merge(
		port_dio48->sig41, port_dio48->sig45);
	cpssp->forward_c12_c16 = sig_std_logic_merge(
		port_dio48->sig42, port_dio48->sig46);
	cpssp->forward_c13_c17 = sig_std_logic_merge(
		port_dio48->sig43, port_dio48->sig47);

	return cpssp;
}

void
dio48_loopback_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
dio48_loopback_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
dio48_loopback_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
