/*
 * $Id: dio24_loopback.c,v 1.17 2013-05-08 14:03:17 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "dio24_loopback.h"

struct cpssp {
	struct sig_std_logic_merge *forward_a0_b0;
	struct sig_std_logic_merge *forward_a1_b1;
	struct sig_std_logic_merge *forward_a2_b2;
	struct sig_std_logic_merge *forward_a3_b3;
	struct sig_std_logic_merge *forward_a4_b4;
	struct sig_std_logic_merge *forward_a5_b5;
	struct sig_std_logic_merge *forward_a6_b6;
	struct sig_std_logic_merge *forward_a7_b7;

	struct sig_std_logic_merge *forward_c0_c4;
	struct sig_std_logic_merge *forward_c1_c5;
	struct sig_std_logic_merge *forward_c2_c6;
	struct sig_std_logic_merge *forward_c3_c7;
};

void *
dio24_loopback_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_dio24_conn *port_dio24
)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->forward_a0_b0 = sig_std_logic_merge(
			port_dio24->sig00, port_dio24->sig08);
	cpssp->forward_a1_b1 = sig_std_logic_merge(
			port_dio24->sig01, port_dio24->sig09);
	cpssp->forward_a2_b2 = sig_std_logic_merge(
			port_dio24->sig02, port_dio24->sig10);
	cpssp->forward_a3_b3 = sig_std_logic_merge(
			port_dio24->sig03, port_dio24->sig11);
	cpssp->forward_a4_b4 = sig_std_logic_merge(
			port_dio24->sig04, port_dio24->sig12);
	cpssp->forward_a5_b5 = sig_std_logic_merge(
			port_dio24->sig05, port_dio24->sig13);
	cpssp->forward_a6_b6 = sig_std_logic_merge(
			port_dio24->sig06, port_dio24->sig14);
	cpssp->forward_a7_b7 = sig_std_logic_merge(
			port_dio24->sig07, port_dio24->sig15);

	cpssp->forward_c0_c4 = sig_std_logic_merge(
			port_dio24->sig16, port_dio24->sig20);
	cpssp->forward_c1_c5 = sig_std_logic_merge(
			port_dio24->sig17, port_dio24->sig21);
	cpssp->forward_c2_c6 = sig_std_logic_merge(
			port_dio24->sig18, port_dio24->sig22);
	cpssp->forward_c3_c7 = sig_std_logic_merge(
			port_dio24->sig19, port_dio24->sig23);

	return cpssp;
}

void
dio24_loopback_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
dio24_loopback_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
dio24_loopback_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
