/*
 * $Id: chassis_aui_gen.c,v 1.13 2013-05-11 19:44:42 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue-aui-gen.h"
#include "glue-shm.h"

#include "chassis_aui.h"

struct cpssp {
	AuiGenChannel *channel;
};

static void
chassis_aui_audio_speaker_samples_set(void *_cpssp, int16_t *samples)
{
	struct cpssp *cpssp = _cpssp;

	aui_gen_channel_play(cpssp->channel, samples);
}

void *
chassis_aui_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_mech_power_button,
	struct sig_std_logic *port_n_power_button,
	struct sig_boolean *port_mech_reset_button,
	struct sig_std_logic *port_n_reset_button,
	struct sig_std_logic_conn *port_power_led,
	struct sig_boolean *port_opt_power_led,
	struct sig_std_logic *port_ide_led,
	struct sig_boolean *port_opt_ide_led,
	struct sig_sound *port_speaker,
	struct sig_sound *port_audio_speaker
)
{
	static const struct sig_sound_funcs audio_speaker_funcs = {
		.samples_set = chassis_aui_audio_speaker_samples_set,
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->channel = aui_gen_channel_new("middle");

	/* In */
	sig_sound_connect(port_audio_speaker, cpssp, &audio_speaker_funcs);

	return cpssp;
}

void
chassis_aui_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
chassis_aui_suspend(void *_cpssp, FILE *fComp)
{
	
}

void
chassis_aui_resume(void *_cpssp, FILE *fComp)
{
	
}
