/*
 * $Id: arch_ata_disk_gui_gtk.c,v 1.1 2013-05-30 12:08:04 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

struct cpssp {
	char name[1024];

	unsigned long nblks;

	GtkWidget *gui_fi;

	int comp_id;

	int fault_disk_sig_id;
	struct sig_boolean *fault_disk_sig_ptr;

	struct {
		uint32_t blkno;
		unsigned int val;

		int sig_id;
		struct sig_integer *sig_ptr;
	} fault[256];
	unsigned int nfaults;
};

/*
 * Simulator Callbacks
 */

/*
 * GUI Callbacks
 */
static void
NAME_(gui_disk_fault_event)(
	GtkWidget *w,
	gpointer _fault,
	gpointer _cpssp
)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = (struct fault *) _fault;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (! cpssp->fault_disk_sig_ptr) {
		char path[1024];

		snprintf(path, sizeof(path)-1, "%s:disk_fault", cpssp->name);
		path[sizeof(path)-1] = '\0';
		cpssp->fault_disk_sig_id = system_sig_create("boolean", path);
		assert(0 <= cpssp->fault_disk_sig_id);
		cpssp->fault_disk_sig_ptr = system_sig_get(cpssp->fault_disk_sig_id);
		assert(cpssp->fault_disk_sig_ptr);

		system_comp_connect(cpssp->comp_id, "disk_fault",
				cpssp->fault_disk_sig_id);
	}
	assert(cpssp->fault_disk_sig_ptr);

	sig_boolean_set(cpssp->fault_disk_sig_ptr, cpssp, fault->state);

	free(fault);
}

static void
NAME_(gui_block_fault_event)(
	GtkWidget *w,
	gpointer _fault,
	gpointer _cpssp
)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = (struct fault *) _fault;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	uint32_t blkno;
	unsigned int i;

	blkno = strtoul(fault->loc0[0], NULL, 0);

	for (i = 0; ; i++) {
		if (i == cpssp->nfaults) {
			/* Not Found */
			char path[1024];
			char port[256];

			cpssp->fault[i].blkno = blkno;

			snprintf(path, sizeof(path)-1, "%s:fault%u", cpssp->name, i);
			path[sizeof(path)-1] = '\0';
			cpssp->fault[i].sig_id = system_sig_create("integer", path);
			assert(0 <= cpssp->fault[i].sig_id);
			cpssp->fault[i].sig_ptr = system_sig_get(cpssp->fault[i].sig_id);
			assert(cpssp->fault[i].sig_ptr);

			sprintf(port, "block_fault/%u", blkno);
			system_comp_connect(cpssp->comp_id, port,
					cpssp->fault[i].sig_id);

			cpssp->nfaults++;
			break;
		}
		if (cpssp->fault[i].blkno == blkno) {
			/* Found */
			break;
		}
	}
	assert(cpssp->fault[i].sig_ptr);

	sig_integer_set(cpssp->fault[i].sig_ptr, cpssp, fault->state);

	free(fault);
}

static void *
NAME_(gui_gtk_create)(
	unsigned int page,
	const char *name,
	unsigned long nblks,
	struct sig_manage *port_manage
)
{
	struct cpssp *cpssp;
	GtkWidget *w;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	system_name_push(name);

	strcpy(cpssp->name, system_path());
	
	cpssp->comp_id = system_comp_lookup(cpssp->name);
	assert(0 <= cpssp->comp_id);

	cpssp->nblks = nblks;

	cpssp->gui_fi = gtk_vbox_new(FALSE, 1);
	
	w = gui_gtk_fi_new("Disk Fault", "Boolean");
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(NAME_(gui_disk_fault_event)),
			cpssp);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->gui_fi), w, FALSE, FALSE, 1);

	w = gui_gtk_fi_pattern_new(
		"Block Fault", "Tristate",
		1, "Block", 0ULL, (unsigned long long) cpssp->nblks - 1, NULL,
		0);
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(NAME_(gui_block_fault_event)),
			cpssp);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->gui_fi), w, FALSE, FALSE, 1);

	gui_gtk_comp_add(page, SCOMP, name, NULL, FALSE, FALSE, cpssp->gui_fi);

	cpssp->fault_disk_sig_id = -1;
	cpssp->fault_disk_sig_ptr = NULL;
	cpssp->nfaults = 0;

	system_name_pop();

	return cpssp;
}

static void
NAME_(gui_gtk_destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

static void
NAME_(gui_gtk_suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

static void
NAME_(gui_gtk_resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	GtkWidget *savegui_fi = cpssp->gui_fi;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
	
	cpssp->gui_fi = savegui_fi;

	fprintf(stdout, "\t\t\ttoDo: Handle GtkWidget gui_fi and faults\n", 0);
}
