/*
 * $Id: cpu_jit_ops_template.h,v 1.1 2013-05-13 18:03:43 vrsieh Exp $
 *
 *  i386 micro operations (included several times to generate
 *  different operand sizes)
 * 
 *  Copyright (c) 2003 Fabrice Bellard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#define DATA_BITS (1 << (3 + SHIFT))
#define SHIFT_MASK (DATA_BITS - 1)
#define SIGN_MASK (((target_ulong)1) << (DATA_BITS - 1))
#if DATA_BITS <= 32
#define SHIFT1_MASK 0x1f
#else
#define SHIFT1_MASK 0x3f
#endif

#if DATA_BITS == 8
#define SUFFIX b
#define DATA_TYPE uint8_t
#define DATA_STYPE int8_t
#define DATA_MASK 0xff
#elif DATA_BITS == 16
#define SUFFIX w
#define DATA_TYPE uint16_t
#define DATA_STYPE int16_t
#define DATA_MASK 0xffff
#elif DATA_BITS == 32
#define SUFFIX l
#define DATA_TYPE uint32_t
#define DATA_STYPE int32_t
#define DATA_MASK 0xffffffff
#elif DATA_BITS == 64
#define SUFFIX q
#define DATA_TYPE uint64_t
#define DATA_STYPE int64_t
#define DATA_MASK 0xffffffffffffffffULL
#else
#error unhandled operand size
#endif

/* various optimized jumps cases */

void glue(NAME_(op_jb_sub), SUFFIX)(void)
{
    target_long src1, src2;
    src1 = CC_DST + CC_SRC;
    src2 = CC_SRC;

    if ((DATA_TYPE)src1 < (DATA_TYPE)src2) {
	STACK_CLEANUP();
        GOTO_LABEL_PARAM(1);
    }
    FORCE_RET();
}

void glue(NAME_(op_jz_sub), SUFFIX)(void)
{
    if ((DATA_TYPE)CC_DST == 0)
        GOTO_LABEL_PARAM(1);
    FORCE_RET();
}

void glue(NAME_(op_jnz_sub), SUFFIX)(void)
{
    if ((DATA_TYPE)CC_DST != 0)
        GOTO_LABEL_PARAM(1);
    FORCE_RET();
}

void glue(NAME_(op_jbe_sub), SUFFIX)(void)
{
    target_long src1, src2;
    src1 = CC_DST + CC_SRC;
    src2 = CC_SRC;

    if ((DATA_TYPE)src1 <= (DATA_TYPE)src2) {
	STACK_CLEANUP();
        GOTO_LABEL_PARAM(1);
    }
    FORCE_RET();
}

void glue(NAME_(op_js_sub), SUFFIX)(void)
{
    if (CC_DST & SIGN_MASK)
        GOTO_LABEL_PARAM(1);
    FORCE_RET();
}

void glue(NAME_(op_jl_sub), SUFFIX)(void)
{
    target_long src1, src2;
    src1 = CC_DST + CC_SRC;
    src2 = CC_SRC;

    if ((DATA_STYPE)src1 < (DATA_STYPE)src2) {
	STACK_CLEANUP();
        GOTO_LABEL_PARAM(1);
    }
    FORCE_RET();
}

void glue(NAME_(op_jle_sub), SUFFIX)(void)
{
    target_long src1, src2;
    src1 = CC_DST + CC_SRC;
    src2 = CC_SRC;

    if ((DATA_STYPE)src1 <= (DATA_STYPE)src2) {
	STACK_CLEANUP();
        GOTO_LABEL_PARAM(1);
    }
    FORCE_RET();
}

/* oldies */

#if DATA_BITS >= 16

void glue(NAME_(op_loopnz), SUFFIX)(void)
{
    if ((DATA_TYPE)ECX != 0 && !(T0 & CC_Z)) {
        GOTO_LABEL_PARAM(1);
    }
    FORCE_RET();
}

void glue(NAME_(op_loopz), SUFFIX)(void)
{
    if ((DATA_TYPE)ECX != 0 && (T0 & CC_Z)) {
        GOTO_LABEL_PARAM(1);
    }
    FORCE_RET();
}

void glue(NAME_(op_jz_ecx), SUFFIX)(void)
{
    if ((DATA_TYPE)ECX == 0)
        GOTO_LABEL_PARAM(1);
    FORCE_RET();
}

void glue(NAME_(op_jnz_ecx), SUFFIX)(void)
{
    if ((DATA_TYPE)ECX != 0)
        GOTO_LABEL_PARAM(1);
    FORCE_RET();
}

#endif

/* various optimized set cases */

void glue(NAME_(op_setb_T0_sub), SUFFIX)(void)
{
    target_long src1, src2;
    src1 = CC_DST + CC_SRC;
    src2 = CC_SRC;

    T0 = ((DATA_TYPE)src1 < (DATA_TYPE)src2);
}

void glue(NAME_(op_setz_T0_sub), SUFFIX)(void)
{
    T0 = ((DATA_TYPE)CC_DST == 0);
}

void glue(NAME_(op_setbe_T0_sub), SUFFIX)(void)
{
    target_long src1, src2;
    src1 = CC_DST + CC_SRC;
    src2 = CC_SRC;

    T0 = ((DATA_TYPE)src1 <= (DATA_TYPE)src2);
}

void glue(NAME_(op_sets_T0_sub), SUFFIX)(void)
{
    T0 = lshift(CC_DST, -(DATA_BITS - 1)) & 1;
}

void glue(NAME_(op_setl_T0_sub), SUFFIX)(void)
{
    target_long src1, src2;
    src1 = CC_DST + CC_SRC;
    src2 = CC_SRC;

    T0 = ((DATA_STYPE)src1 < (DATA_STYPE)src2);
}

void glue(NAME_(op_setle_T0_sub), SUFFIX)(void)
{
    target_long src1, src2;
    src1 = CC_DST + CC_SRC;
    src2 = CC_SRC;

    T0 = ((DATA_STYPE)src1 <= (DATA_STYPE)src2);
}

/* shifts */

void glue(glue(NAME_(op_shl), SUFFIX), _T0_T1)(void)
{
    int count;
    count = T1 & SHIFT1_MASK;
    T0 = T0 << count;
    FORCE_RET();
}

void glue(glue(NAME_(op_shr), SUFFIX), _T0_T1)(void)
{
    int count;
    count = T1 & SHIFT1_MASK;
    T0 &= DATA_MASK;
    T0 = T0 >> count;
    FORCE_RET();
}

void glue(glue(NAME_(op_sar), SUFFIX), _T0_T1)(void)
{
    int count;
    target_long src;
    
    count = T1 & SHIFT1_MASK;
    src = (DATA_STYPE)T0;
    T0 = src >> count;
    FORCE_RET();
}

#undef MEM_WRITE
#include "cpu_jit_ops_template_mem.h"

#define MEM_WRITE 0
#include "cpu_jit_ops_template_mem.h"
#undef MEM_WRITE

#define MEM_WRITE 1
#include "cpu_jit_ops_template_mem.h"
#undef MEM_WRITE

/* bit operations */
#if DATA_BITS >= 16

void glue(glue(NAME_(op_bt), SUFFIX), _T0_T1_cc)(void)
{
    int count;
    count = T1 & SHIFT_MASK;
    CC_SRC = T0 >> count;
}

void glue(glue(NAME_(op_bts), SUFFIX), _T0_T1_cc)(void)
{
    int count;
    count = T1 & SHIFT_MASK;
    T1 = T0 >> count;
    T0 |= (((target_long)1) << count);
}

void glue(glue(NAME_(op_btr), SUFFIX), _T0_T1_cc)(void)
{
    int count;
    count = T1 & SHIFT_MASK;
    T1 = T0 >> count;
    T0 &= ~(((target_long)1) << count);
}

void glue(glue(NAME_(op_btc), SUFFIX), _T0_T1_cc)(void)
{
    int count;
    count = T1 & SHIFT_MASK;
    T1 = T0 >> count;
    T0 ^= (((target_long)1) << count);
}

void glue(glue(NAME_(op_add_bit), SUFFIX), _A0_T1)(void)
{
    A0 += ((DATA_STYPE)T1 >> (3 + SHIFT)) << SHIFT;
}

void glue(glue(NAME_(op_bsf), SUFFIX), _T0_cc)(void)
{
	target_long res;
	int count;

	res = T0 & DATA_MASK;
        count = 0;
        while ((res & 1) == 0 && count <= DATA_BITS - 1) {
		count++;
		res >>= 1;
        }
	if (count <= DATA_BITS - 1) {
		T1 = count;
		CC_DST = 1; /* ZF = 0 */
	} else {
		CC_DST = 0; /* ZF = 1 */
	}
	FORCE_RET();
}

void glue(glue(NAME_(op_bsr), SUFFIX), _T0_cc)(void)
{
	target_long res;
	int count;

	res = T0 & DATA_MASK;
	count = DATA_BITS - 1;
	while ((res & SIGN_MASK) == 0 && 0 <= count) {
		count--;
		res <<= 1;
	}
	if (0 <= count) {
		T1 = count;
		CC_DST = 1; /* ZF = 0 */
	} else {
		CC_DST = 0; /* ZF = 1 */
	}
	FORCE_RET();
}

#endif

#if DATA_BITS == 32
void NAME_(op_update_bt_cc)(void)
{
    CC_SRC = T1;
}
#endif

/* string operations */

void glue(NAME_(op_movl_T0_Dshift), SUFFIX)(void)
{
    T0 = DF << SHIFT;
}

/* port I/O */

#if DATA_BITS <= 32
void glue(glue(NAME_(op_out), SUFFIX), _T0_T1)(void)
{
    glue(NAME_(out), SUFFIX)(env, T1 & DATA_MASK, T0);
}

void glue(glue(NAME_(op_out), SUFFIX), _DX_T0)(void)
{
    glue(NAME_(out), SUFFIX)(env, T0, EDX & 0xffff);
}

void glue(glue(NAME_(op_in), SUFFIX), _T0_T1)(void)
{
    T1 = glue(NAME_(in), SUFFIX)(env, T0);
}

void glue(glue(NAME_(op_in), SUFFIX), _DX_T0)(void)
{
    T0 = glue(NAME_(in), SUFFIX)(env, EDX & 0xffff);
}

void glue(glue(NAME_(op_check_io), SUFFIX), _T0)(void)
{
    glue(glue(NAME_(check_io), SUFFIX), _T0)();
}

void glue(glue(NAME_(op_check_io), SUFFIX), _DX)(void)
{
    glue(glue(NAME_(check_io), SUFFIX), _DX)();
}
#endif

#undef DATA_BITS
#undef SHIFT_MASK
#undef SHIFT1_MASK
#undef SIGN_MASK
#undef DATA_TYPE
#undef DATA_STYPE
#undef DATA_MASK
#undef SUFFIX
