/*
 * $Id: chip_cirrus_gd5446_gen.c,v 1.1 2013-05-13 18:03:36 vrsieh Exp $ 
 *
 * Copyright (C) 2006-2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef GEN_NAME
#error chip_cirrus_gd5446_gen.c needs GEN_NAME defined
#endif
#ifndef GEN_RGB
#error chip_cirrus_gd5446_gen.c needs GEN_RGB defined
#endif
#ifndef REFRESH_CYCLES
#error chip_cirrus_gd5446_gen.c needs REFRESH_CYCLES defined
#endif

extern void
GEN_NAME(
	struct cpssp *cpssp,
	struct sig_video *video,
	unsigned int hor_end,
	unsigned int vert_end,
	unsigned long offset,
	unsigned int pitch
)
{
	uint8_t r, g, b;
	int count;

	unsigned long cursor_ptr_base;
	unsigned long cursor_ptr;
	unsigned cursor_size;
	unsigned cursor_line_offset;
	unsigned cursor_plane_offset;
	unsigned cursor_x;
	unsigned cursor_y;
	unsigned char cursor_val;

	cursor_ptr_base = CIRRUS_MAX_VRAM_SIZE - 16 * 1024;

	if (! (cpssp->ext_graph_curs_attr & 0x01)) {
		/* no hardware cursor enabled */
		cursor_size = 0;
		cursor_line_offset = 0;  /* make gcc happy */
		cursor_plane_offset = 0; /* make gcc happy */

	} else if (cpssp->ext_graph_curs_attr & 0x04) {
		/* 64x64px in 1024 bytes
		 * 512 byte-per-plane * 2 cursor planes
		 * "Stored one cursor scanline at a time; 8 bytes
		 *  written across the four logical display planes
		 *  (2-bytes-per-plane). One cursor scanline is loaded
		 *  from Cursor Plane 0 followed by one cursor scanline
		 *  from Cursor Plane 1. This is done until all 64
		 *  scanlines from the Cursor Plane 0 and Cursor Plane 1
		 *  are loaded into display memory."
		 */
		cursor_size = 64;
		cursor_line_offset = 16;
		cursor_plane_offset = 8;
		cursor_ptr_base |= (cpssp->ext_graph_curs_pattern_addr_offset & 0x3c) << 8;
	} else {
		/* 32x32px in 256 bytes
		 * 128 byte-per-plane * 2 cursor planes
		 * "The 256 bytes are stored across the four logical
		 *  Display Memory planes - 64 bytes per plane, the
		 *  first 32 bytes of each memory plane are from
		 *  Cursor Plane 0, and the last 32 bytes are from
		 *  Cursor Plane 1."
		 */
		cursor_size = 32;
		cursor_line_offset = 4;
		cursor_plane_offset = 128;
		cursor_ptr_base |= (cpssp->ext_graph_curs_pattern_addr_offset & 0x3f) << 8;
	}

	for (count = 1 + (hor_end * 8 * vert_end) / REFRESH_CYCLES;
	    0 < count;
	    count--) {

		GEN_RGB;

		if (cpssp->hw_cursor_y <= cpssp->y
		 && cpssp->y < cpssp->hw_cursor_y + cursor_size
		 && cpssp->hw_cursor_x <= cpssp->x
		 && cpssp->x < cpssp->hw_cursor_x + cursor_size) {
			/*
			 * In cursor square.
			 */
			cursor_x = cpssp->x - cpssp->hw_cursor_x;
			cursor_y = cpssp->y - cpssp->hw_cursor_y;
			cursor_ptr = cursor_ptr_base + cursor_y * cursor_line_offset;

			cursor_val = 0;

			/* select correct bit of byte on cursor plane 0 */
			if (video_readb(cpssp, cursor_ptr + (cursor_x / 8)) & (0x80 >> (cursor_x % 8))) {
				/* left bit is 1 */
				cursor_val |= 0x01;
			}

			/* select correct bit of byte on cursor plane 1 */
			if (video_readb(cpssp, cursor_ptr + cursor_plane_offset + (cursor_x / 8)) & (0x80 >> (cursor_x % 8))) {
				/* right bit is 1 */
				cursor_val |= 0x02;
			}

			switch (cursor_val) {
			case 0:
				/* transparent */
				/* Nothing to do... */
				break;
			case 1:
				/* invert */
				r ^= 0xff;
				g ^= 0xff;
				b ^= 0xff;
				break;
			case 2:
				/* foreground */
				r = video_col_get(cpssp, 256, 0);
				g = video_col_get(cpssp, 256, 1);
				b = video_col_get(cpssp, 256, 2);
				break;
			case 3:
				/* background */
				r = video_col_get(cpssp, 257, 0);
				g = video_col_get(cpssp, 257, 1);
				b = video_col_get(cpssp, 257, 2);
				break;
			default:
				assert(0); /* can't happen */
			}
		}

		sig_video_out(video, cpssp, r, g, b);

		if (cpssp->x == ((hor_end << 3) | 0b111)) {
			cpssp->x = 0;

			sig_video_hor_retrace(video, cpssp);
			if (cpssp->y == vert_end) {
				cpssp->y = 0;
				cpssp->offset_line = offset;
				sig_video_vert_retrace(video, cpssp);
			} else {
				cpssp->offset_line += pitch;
				cpssp->y++;
				cpssp->y &= (1 << 11) - 1;
			}
			cpssp->offset_cur = cpssp->offset_line;
		} else {
			cpssp->x++;
			cpssp->x &= (1 << 11) - 1;
		}
	}
}
