/*
 * $Id: chip_adaptec_7880.c,v 1.17 2013-04-15 16:59:18 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "chip_lsi_53C810.h"

#include "chip_adaptec_7880.h"

void *
chip_adaptec_7880_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_power,
	struct sig_std_logic *port_n_reset,
	struct sig_pci_idsel *port_idsel,
	struct sig_pci_bus *port_bus,
	struct sig_std_logic *port_intA,
	struct sig_scsi_bus *port_scsi,
	struct sig_i2c_bus *port_gp01
)
{
	return chip_lsi_53C810_create(name, (const char *) 0, port_manage,
			port_power, port_n_reset, port_idsel, port_bus,
			port_intA, port_scsi, port_gp01);
}

void
chip_adaptec_7880_destroy(void *_cpssp)
{
	chip_lsi_53C810_destroy(_cpssp);
}

void
chip_adaptec_7880_suspend(void *_cpssp, FILE *fComp)
{
	chip_lsi_53C810_suspend(_cpssp, fComp);
}

void
chip_adaptec_7880_resume(void *_cpssp, FILE *fComp)
{
	chip_lsi_53C810_resume(_cpssp, fComp);
}
