/*
 * Copyright (C) 2007-2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* ---------------------------- */
/* read/write control registers */
/* ---------------------------- */

void
NAME_(update_cr0)(struct cpssp *cpssp, uint32_t new_cr0)
{
	int pe_state;
    
	if ((new_cr0 & (CPU_CR0_PG_MASK | CPU_CR0_WP_MASK | CPU_CR0_PE_MASK))
	 != (cpssp->cr[0] & (CPU_CR0_PG_MASK | CPU_CR0_WP_MASK | CPU_CR0_PE_MASK))) {
		NAME_(mmui_flush_all)(cpssp, 1);
		NAME_(mmud_flush_all)(cpssp, 1);
	}
#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT
	if (!(cpssp->cr[0] & CPU_CR0_PG_MASK) && (new_cr0 & CPU_CR0_PG_MASK)
	 && (cpssp->efer & MSR_EFER_LME)) {
		/* enter in long mode */
		/* XXX: generate an exception */
		if (!(cpssp->cr[4] & CPU_CR4_PAE_MASK))
			return;
		cpssp->efer |= MSR_EFER_LMA;
		cpssp->hflags |= HF_LMA_MASK;
	} else if ((cpssp->cr[0] & CPU_CR0_PG_MASK) && !(new_cr0 & CPU_CR0_PG_MASK)
	        && (cpssp->efer & MSR_EFER_LMA)) {
		/* exit long mode */
		cpssp->efer &= ~MSR_EFER_LMA;
		cpssp->hflags &= ~(HF_LMA_MASK | HF_CS64_MASK);
		cpssp->eip &= 0xffffffff;
	}
#endif
	cpssp->cr[0] = new_cr0 | CPU_CR0_ET_MASK;

	/* update PE flag in hidden flags */
	pe_state = (cpssp->cr[0] & CPU_CR0_PE_MASK);
	cpssp->hflags = (cpssp->hflags & ~HF_PE_MASK)
		| (pe_state << HF_PE_SHIFT);
	/* ensure that ADDSEG is always set in real mode */
	cpssp->hflags |= ((pe_state ^ 1) << HF_ADDSEG_SHIFT);
	/* update FPU flags */
	cpssp->hflags = (cpssp->hflags & ~(HF_MP_MASK | HF_EM_MASK | HF_TS_MASK))
		| ((new_cr0 << (HF_MP_SHIFT - 1)) & (HF_MP_MASK | HF_EM_MASK | HF_TS_MASK));
	if(new_cr0 & CPU_CR0_NE_MASK) {
		cpssp->hflags |= HF_NE_MASK;
	}
}

/* XXX: in legacy PAE mode, generate a GPF if reserved bits are set in
   the PDPT */
void
NAME_(update_cr3)(struct cpssp *cpssp, target_ulong new_cr3)
{
	cpssp->cr[3] = new_cr3;
	if (cpssp->cr[0] & CPU_CR0_PG_MASK) {
		NAME_(mmui_flush_all)(cpssp, 0);
		NAME_(mmud_flush_all)(cpssp, 0);
	}
}

void
NAME_(update_cr4)(struct cpssp *cpssp, uint32_t new_cr4)
{
	if ((new_cr4 & (CPU_CR4_PGE_MASK | CPU_CR4_PAE_MASK | CPU_CR4_PSE_MASK))
	 != (cpssp->cr[4] & (CPU_CR4_PGE_MASK | CPU_CR4_PAE_MASK | CPU_CR4_PSE_MASK))) {
		NAME_(mmui_flush_all)(cpssp, 1);
		NAME_(mmud_flush_all)(cpssp, 1);
	}
	/* SSE handling */
	if (
#ifdef CONFIG_CPU_SSE_SUPPORT
	    ! CONFIG_CPU_SSE_SUPPORT
#else
	    1
#endif
	) {
		new_cr4 &= ~CPU_CR4_OSFXSR_MASK;
	} else if (new_cr4 & CPU_CR4_OSFXSR_MASK) {
		cpssp->hflags |= HF_OSFXSR_MASK;
	} else {
		cpssp->hflags &= ~HF_OSFXSR_MASK;
	}
	cpssp->cr[4] = new_cr4;
}
