/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "sig_manage.h"
#include "sig_boolean.h"

#include "system.h"
#include "glue-gui.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-fi.h"
#include "glue.h"

struct cpssp {
	char name[1024];
	int comp_id;

	struct {
		unsigned int regno;
		unsigned int bitno;
		int sig_id;
		void *sig_ptr;
	} fault[16];
	unsigned int nfaults;
};

static void
NAME_(gui_gtk_error_event)(
	struct cpssp *cpssp,
	unsigned int regno,
	unsigned int bitno,
	unsigned int val
)
{
	unsigned int i;

	for (i = 0; ; i++) {
		if (i == cpssp->nfaults) {
			/* Not Found */
			char path[1024];
			char port[256];

			cpssp->fault[i].regno = regno;
			cpssp->fault[i].bitno = bitno;

			sprintf(path, "%s:fault%u", cpssp->name, i);
			cpssp->fault[i].sig_id = system_sig_create("boolean", path);
			assert(0 <= cpssp->fault[i].sig_id);
			cpssp->fault[i].sig_ptr = system_sig_get(cpssp->fault[i].sig_id);
			assert(cpssp->fault[i].sig_ptr);

			sprintf(port, "bitflip/%u/%u", regno, bitno);
			system_comp_connect(cpssp->comp_id, port,
					cpssp->fault[i].sig_id);
			cpssp->nfaults++;
			break;
		}
		if (cpssp->fault[i].regno == regno
		 && cpssp->fault[i].bitno == bitno) {
			/* Found */
			break;
		}
	}

	sig_boolean_set(cpssp->fault[i].sig_ptr, cpssp, val);
}

static void
NAME_(gui_gtk_bit_flip_event)(GtkWidget *w, gpointer _fault, gpointer _cpssp)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = _fault;
	struct cpssp *cpssp = _cpssp;

	NAME_(gui_gtk_error_event)(cpssp,
			strtoul(fault->loc0[0], NULL, 0),
			strtoul(fault->loc0[1], NULL, 0),
			fault->state);
}

void *
NAME_(gui_gtk_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *manage
)
{
	struct cpssp *cpssp;
	GtkWidget *w;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	system_name_push(name);
	strcpy(cpssp->name, system_path());
	cpssp->comp_id = system_comp_lookup(name);

	w = gui_gtk_fi_pattern_new(
		"Bit Flip", "Trigger",
#if 80486 <= CONFIG_CPU && CONFIG_CPU_LM_SUPPORT
		/* 16 Regs with 64 bits each. */
		2, "Reg#", 0ULL, 15ULL, NULL, "Bit", 0ULL, 63ULL, NULL,
#elif 80386 <= CONFIG_CPU
		/* 8 Regs with 32 bits each. */
		2, "Reg#", 0ULL, 7ULL, NULL, "Bit", 0ULL, 31ULL, NULL,
#else
		/* 8 Regs with 16 bits each. */
		2, "Reg#", 0ULL, 7ULL, NULL, "Bit", 0ULL, 15ULL, NULL,
#endif
		0);
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(NAME_(gui_gtk_bit_flip_event)), cpssp);
	gtk_widget_show(w);

	gui_gtk_comp_add(page, SNAME, name, NULL, FALSE, FALSE, w);

	system_name_pop();

	return cpssp;
}

void
NAME_(gui_gtk_destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
NAME_(gui_gtk_suspend)(void *_cpssp, FILE *fp)
{
	/* FIXME */
}

void
NAME_(gui_gtk_resume)(void *_cpssp, FILE *fp)
{
	/* FIXME */
}
