/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "arch_gen_cpu_x86_state.h"

extern void *
NAME_(gui_create)(
unsigned int page,
        const char *name,
	struct sig_manage *manage,
	struct sig_std_logic *port_power,
	struct sig_std_logic *port_n_reset,
#if 80386 < CONFIG_CPU
	struct sig_std_logic *port_n_init,
#endif
	struct sig_std_logic *port_irq,
	struct sig_std_logic *port_nmi,
#if 80386 <= CONFIG_CPU
	struct sig_std_logic *port_smi,
#endif
	struct sig_std_logic *port_n_ferr,
	struct sig_std_logic *port_n_ignne,
#if 80386 <= CONFIG_CPU
	struct sig_std_logic *port_a20,
#endif
#if 80486 <= CONFIG_CPU && CONFIG_CPU_APIC_SUPPORT
	struct sig_icc_bus *port_icc,
#endif
#if defined(CONFIG_CPU_SOCKET_ISA)
	struct sig_isa_bus *port_bus
#elif defined(CONFIG_CPU_SOCKET_HOST) \
   || defined(CONFIG_CPU_SOCKET_SLOT1)
	struct sig_host_bus *port_bus
#elif defined(CONFIG_CPU_SOCKET_775)
	struct sig_host775_bus *port_bus
#else
#error "Unknown socket."
#endif
);

extern void
NAME_(gui_destroy)(void *_cpssp);

extern void
NAME_(gui_suspend)(void *_cpssp, FILE *fp);
extern void
NAME_(gui_resume)(void *_cpssp, FILE *fp);
