/*
 * Copyright (C) 2007-2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "arch_gen_cpu_x86_state.h"

static int
NAME_(core_port)(
	struct cpssp *cpssp,
	const char *port,
	unsigned int *regnop,
	unsigned int *bitnop
)
{
	char *port2;

	/* Get Fault Type */
	if (strncmp(port, "bitflip", strlen("bitflip")) == 0) {
		port += strlen("bitflip");
	} else {
		return 1;
	}

	/* Skip '/' */
	if (*port == '/') {
		port++;
	} else {
		return 1;
	}

	/* Get register number. */
	*regnop = strtoul(port, &port2, 0);
	if (CPU_NB_REGS <= *regnop) {
		return 1;
	}
	port = port2;

	/* Skip '/' */
	if (*port == '/') {
		port++;
	} else {
		return 1;
	}

	/* Get bit number. */
	*bitnop = strtoul(port, &port2, 0);
#if 80486 <= CONFIG_CPU && CONFIG_CPU_LM_SUPPORT
	if (64 <= *bitnop) {
		return 1;
	}
#elif 80386 <= CONFIG_CPU
	if (32 <= *bitnop) {
		return 1;
	}
#else
	if (16 <= *bitnop) {
		return 1;
	}
#endif
	port = port2;

	if (*port != '\0') {
		return 1;
	}

	return 0;
}

static void
NAME_(core_fault_set)(void *_cpssp, unsigned int i, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int regno;
	unsigned int bitno;

	if (! val) {
		return;
	}

	assert(cpssp->fault[i].used);

	regno = cpssp->fault[i].regno;
	bitno = cpssp->fault[i].bitno;

	fprintf(stderr, "Flip bit %d in reg %d\n", bitno, regno);
}

static void
NAME_(core_fault_set0)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 0, val);
}

static void
NAME_(core_fault_set1)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 1, val);
}

static void
NAME_(core_fault_set2)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 2, val);
}

static void
NAME_(core_fault_set3)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 3, val);
}

static void
NAME_(core_fault_set4)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 4, val);
}

static void
NAME_(core_fault_set5)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 5, val);
}

static void
NAME_(core_fault_set6)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 6, val);
}

static void
NAME_(core_fault_set7)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 7, val);
}


static void
NAME_(core_fault_set8)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 8, val);
}

static void
NAME_(core_fault_set9)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 9, val);
}

static void
NAME_(core_fault_set10)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 10, val);
}

static void
NAME_(core_fault_set11)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 11, val);
}

static void
NAME_(core_fault_set12)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 12, val);
}

static void
NAME_(core_fault_set13)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 13, val);
}

static void
NAME_(core_fault_set14)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 14, val);
}

static void
NAME_(core_fault_set15)(void *_cpssp, unsigned int val)
{
	NAME_(core_fault_set)(_cpssp, 15, val);
}

static void
NAME_(connect)(void *_cpssp, const char *port, void *_sig)
{
	static const struct sig_boolean_funcs fault_funcs[] = {
		{ .set = NAME_(core_fault_set0), },
		{ .set = NAME_(core_fault_set1), },
		{ .set = NAME_(core_fault_set2), },
		{ .set = NAME_(core_fault_set3), },
		{ .set = NAME_(core_fault_set4), },
		{ .set = NAME_(core_fault_set5), },
		{ .set = NAME_(core_fault_set6), },
		{ .set = NAME_(core_fault_set7), },
		{ .set = NAME_(core_fault_set8), },
		{ .set = NAME_(core_fault_set9), },
		{ .set = NAME_(core_fault_set10), },
		{ .set = NAME_(core_fault_set11), },
		{ .set = NAME_(core_fault_set12), },
		{ .set = NAME_(core_fault_set13), },
		{ .set = NAME_(core_fault_set14), },
		{ .set = NAME_(core_fault_set15), },
	};
	struct cpssp *cpssp = _cpssp;
	struct sig_boolean *sig = (struct sig_boolean *) _sig;
	unsigned int regno;
	unsigned int bitno;
	unsigned int i;

	assert(sizeof(fault_funcs) / sizeof(fault_funcs[0])
			== sizeof(cpssp->fault) / sizeof(cpssp->fault[0]));

	if (NAME_(core_port)(cpssp, port, &regno, &bitno)) {
		return;
	}
fprintf(stderr, "%s %s\n", __FUNCTION__, port);

	/* Lookup Unused Entry */
	for (i = 0; ; i++) {
		assert(i < sizeof(cpssp->fault) / sizeof(cpssp->fault[0]));
		if (! cpssp->fault[i].used) {
			break;
		}
	}

	/* Add Entry */
	cpssp->fault[i].used = 1;
	cpssp->fault[i].regno = regno;
	cpssp->fault[i].bitno = bitno;

	cpssp->fault[i].sig = sig;

	sig_boolean_connect_in(cpssp->fault[i].sig, cpssp, &fault_funcs[i]);
}

static void
NAME_(disconnect)(void *_cpssp, const char *port)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int regno;
	unsigned int bitno;
	unsigned int i;

	if (NAME_(core_port)(_cpssp, port, &regno, &bitno)) {
		return;
	}

	/* Lookup Entry */
	for (i = 0; ; i++) {
		assert(i < sizeof(cpssp->fault) / sizeof(cpssp->fault[0]));
		if (cpssp->fault[i].used
		 && cpssp->fault[i].regno == regno
		 && cpssp->fault[i].bitno == bitno) {
			/* Entry found. */
			break;
		}
	}

	// sig_boolean_disconnect_in(cpssp->fault[i].sig, cpssp);

	/* Disable Entry */
	cpssp->fault[i].used = 0;
}

#if 80486 <= CONFIG_CPU && CONFIG_CPU_APIC_SUPPORT
void
NAME_(core_startup)(struct cpssp *cpssp, uint8_t vector)
{
	cpssp->state_startup_vec = vector;
	cpssp->state_startup = 1;
}

void
NAME_(core_init_by_apic)(struct cpssp *cpssp)
{
	cpssp->state_ext |= STATE_N_INIT_ACK;
}
#endif

static void
NAME_(core_power_set)(struct cpssp *cpssp, unsigned int val)
{
	if (val) {
		cpssp->state_ext |= STATE_POWER;
	} else {
		cpssp->state_ext &= ~STATE_POWER;
	}
}

static void
NAME_(core_n_reset_set)(struct cpssp *cpssp, unsigned int n_val)
{
	if (n_val) {
		/* Reset gone. */
		cpssp->state_ext &= ~STATE_RESET;
	} else {
		/* New reset. */
		cpssp->state_ext |= STATE_RESET | STATE_N_RESET_ACK;
	}
}

#if 80486 <= CONFIG_CPU
static void
NAME_(core_n_init_set)(struct cpssp *cpssp, unsigned int n_val)
{
	if (n_val) {
		/* Init gone. */
		cpssp->state_ext &= ~STATE_INIT;
	} else {
		/* New init. */
		cpssp->state_ext |= STATE_INIT | STATE_N_INIT_ACK;
	}
}
#endif /* 80386 <= CONFIG_CPU */

static void
NAME_(core_n_ignne_set)(struct cpssp *cpssp, unsigned int n_val)
{
	cpssp->state_n_ignne = n_val;
}
