/*
 * $Id: arch_gen_cpu_x86_code_fast.h,v 1.2 2014/02/07 15:58:45 sieh Exp $
 *
 * Derived from QEMU sources.
 * Modified for FAUmachine by Volkmar Sieh.
 *
 *  Copyright (c) 2007-2009 FAUmachine Team.
 *  Copyright (c) 2003 Fabrice Bellard.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

#ifndef FAST
#error "Don't include in non-fast modules."
#endif

#ifndef __CPU_MMU_FAST_H_INCLUDED
#define __CPU_MMU_FAST_H_INCLUDED

#include "exec-all.h"
#include "arch_gen_cpu_x86_mmui.h"
#include "arch_gen_cpu_x86_mmud.h"

#define ldul_user ldl_user
#define ldul_kernel ldl_kernel

#define ACCESS_TYPE 0
#define MEMSUFFIX _kernel
#define DATA_SIZE 1
#include "arch_gen_cpu_x86_code_template.h"

#define DATA_SIZE 2
#include "arch_gen_cpu_x86_code_template.h"

#define DATA_SIZE 4
#include "arch_gen_cpu_x86_code_template.h"

#define DATA_SIZE 8
#include "arch_gen_cpu_x86_code_template.h"
#undef ACCESS_TYPE
#undef MEMSUFFIX

#define ACCESS_TYPE 1
#define MEMSUFFIX _user
#define DATA_SIZE 1
#include "arch_gen_cpu_x86_code_template.h"

#define DATA_SIZE 2
#include "arch_gen_cpu_x86_code_template.h"

#define DATA_SIZE 4
#include "arch_gen_cpu_x86_code_template.h"

#define DATA_SIZE 8
#include "arch_gen_cpu_x86_code_template.h"
#undef ACCESS_TYPE
#undef MEMSUFFIX

/* these access are slower, they must be as rare as possible */
#define ACCESS_TYPE 2
#define MEMSUFFIX _data
#define DATA_SIZE 1
#include "arch_gen_cpu_x86_code_template.h"

#define DATA_SIZE 2
#include "arch_gen_cpu_x86_code_template.h"

#define DATA_SIZE 4
#include "arch_gen_cpu_x86_code_template.h"

#define DATA_SIZE 8
#include "arch_gen_cpu_x86_code_template.h"
#undef ACCESS_TYPE
#undef MEMSUFFIX

#define ldub(p) ldub_data(p)
#define ldsb(p) ldsb_data(p)
#define lduw(p) lduw_data(p)
#define ldsw(p) ldsw_data(p)
#define ldl(p) ldl_data(p)
#define ldq(p) ldq_data(p)

#define stb(p, v) stb_data(p, v)
#define stw(p, v) stw_data(p, v)
#define stl(p, v) stl_data(p, v)
#define stq(p, v) stq_data(p, v)

static inline double ldfq(Vaddr ptr)
{
	union {
		double d;
		uint64_t i;
	} u;
	u.i = ldq(ptr);
	return u.d;
}

static inline void stfq(Vaddr ptr, double v)
{
	union {
		double d;
		uint64_t i;
	} u;
	u.d = v;
	stq(ptr, u.i);
}

static inline float ldfl(Vaddr ptr)
{
	union {
		float f;
		uint32_t i;
	} u;
	u.i = ldl(ptr);
	return u.f;
}

static inline void stfl(Vaddr ptr, float v)
{
	union {
		float f;
		uint32_t i;
	} u;
	u.f = v;
	stl(ptr, u.i);
}

#endif /* __CPU_MMU_FAST_H_INCLUDED */
