/*
 * $Id: arch_gen_cpu_x86_cache1d.c,v 1.2 2014/02/27 11:52:05 sieh Exp $
 *
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define COUNT	0

#define SETS	(CONFIG_CPU_L1D_ASSOC)
#define LINES	(CONFIG_CPU_L1D_SIZE / CONFIG_CPU_CACHE_LINE_SIZE / SETS)

#ifdef STATE
struct {
#ifdef CONFIG_CPU_L1D_SIZE
	struct {
		struct NAME_(cache1d_entry) {
			Vaddr vaddr;
			Paddr paddr;
			unsigned int wflag;
			unsigned int uflag;
			Haddr raddr;
			Haddr waddr;
			Haddr xaddr;
		} set[SETS];
		LRU_DECL(SETS, lru);
	} line[LINES];
#if COUNT
	int hit;
	int remap;
	int miss;
#endif
#endif
} NAME_(cache1d);
#endif /* STATE */

#ifdef BEHAVIOR
#include "arch_gen_cpu_x86_cache1d.h"

#ifdef CONFIG_CPU_L1D_SIZE
static struct NAME_(cache1d_entry) *
NAME_(cache1d_entry)(struct cpssp *cpssp, Vaddr vaddr, unsigned int wflag, unsigned int uflag)
{
	int line;
	int set;

	line = (vaddr / CONFIG_CPU_CACHE_LINE_SIZE) % LINES;
	for (set = 0; ; set++) {
		struct NAME_(cache1d_entry) *entry;

		if (set == SETS) {
			/* Miss */
			Paddr paddr;

#if COUNT
			cpssp->NAME_(cache1d).miss++;
#endif

			set = NAME_(lru_oldest)(SETS, cpssp->NAME_(cache1d).line[line].lru);
			NAME_(lru_use)(SETS, cpssp->NAME_(cache1d).line[line].lru, set);
			entry = &cpssp->NAME_(cache1d).line[line].set[set];

		remap:	;
			if (unlikely(NAME_(mmud_map)(cpssp, vaddr, wflag, uflag, &paddr))) {
				return NULL;
			}

			entry->vaddr = (vaddr & CACHE_LINE_MASK);
			entry->paddr = (paddr & CACHE_LINE_MASK);
			entry->wflag = wflag;
			entry->uflag = uflag;
			entry->raddr = NULL;
			entry->waddr = NULL;
			entry->xaddr = NULL;
			return entry;
		}
		entry = &cpssp->NAME_(cache1d).line[line].set[set];
		if ((vaddr & CACHE_LINE_MASK) == entry->vaddr) {
			/* Hit */
			if (entry->wflag < wflag
			 || entry->uflag < uflag) {
#if COUNT
				cpssp->NAME_(cache1d).remap++;
#endif
				goto remap;
			}
#if COUNT
			cpssp->NAME_(cache1d).hit++;
#endif
			NAME_(lru_use)(SETS, cpssp->NAME_(cache1d).line[line].lru, set);
			return entry;
		}
	}
}
#endif /* CONFIG_CPU_L1I_SIZE */

#ifdef CONFIG_CPU_L1D_SIZE
int
NAME_(cache1d_map_r)(struct cpssp *cpssp, Vaddr vaddr, int u, Paddr *paddrp, char **haddrp)
{
	struct NAME_(cache1d_entry) *entry;

	entry = NAME_(cache1d_entry)(cpssp, vaddr, 0, u);
	if (unlikely(! entry)) {
		return 1;
	}
	if (unlikely(! entry->raddr)) {
		NAME_(a20gate_map_r)(cpssp, entry->paddr, &entry->raddr);
	}
	*paddrp = entry->paddr;
	*haddrp = entry->raddr;

	return 0;
}

int
NAME_(cache1d_map_w)(struct cpssp *cpssp, Vaddr vaddr, int u, Paddr *paddrp, char **haddrp)
{
	struct NAME_(cache1d_entry) *entry;

	entry = NAME_(cache1d_entry)(cpssp, vaddr, 1, u);
	if (unlikely(! entry)) {
		return 1;
	}
	if (unlikely(! entry->waddr)) {
		NAME_(a20gate_map_w)(cpssp, entry->paddr, &entry->waddr);
	}
	*paddrp = entry->paddr;
	*haddrp = entry->waddr;

	return 0;
}

#else /* CONFIG_CPU_L1D_SIZE */

int
NAME_(cache1d_map_r)(struct cpssp *cpssp, Vaddr vaddr, int u, Paddr *paddrp, char **haddrp)
{
	if (NAME_(mmud_map)(cpssp, vaddr, 0, u, paddrp)) {
		return 1;
	}
	NAME_(a20gate_map_r)(cpssp, *paddrp, haddrp);
	return 0;
}

int
NAME_(cache1d_map_w)(struct cpssp *cpssp, Vaddr vaddr, int u, Paddr *paddrp, char **haddrp)
{
	if (NAME_(mmud_map)(cpssp, vaddr, 1, u, paddrp)) {
		return 1;
	}
	NAME_(a20gate_map_w)(cpssp, *paddrp, haddrp);
	return 0;
}

#endif /* CONFIG_CPU_L1I_SIZE */

void
NAME_(cache1d_invlpg)(struct cpssp *cpssp, Vaddr vaddr)
{
	NAME_(cache1d_reset)(cpssp); /* FIXME */
}

void
NAME_(cache1d_flush_all)(struct cpssp *cpssp, int global)
{
	NAME_(cache1d_reset)(cpssp); /* FIXME */
}

void
NAME_(cache1d_reset)(struct cpssp *cpssp)
{
#ifdef CONFIG_CPU_L1D_SIZE
	int line;
	int set;

	for (line = 0; line < LINES; line++) {
		for (set = 0; set < SETS; set++) {
			cpssp->NAME_(cache1d).line[line].set[set].vaddr = -1; /* Invalid */
		}
		NAME_(lru_reset)(SETS, cpssp->NAME_(cache1d).line[line].lru);
	}
#endif /* CONFIG_CPU_L1D_SIZE */
}

static void
NAME_(cache1d_create)(struct cpssp *cpssp)
{
#ifdef CONFIG_CPU_L1D_SIZE
#if COUNT
	cpssp->NAME_(cache1d).hit = 0;
	cpssp->NAME_(cache1d).remap = 0;
	cpssp->NAME_(cache1d).miss = 0;
#endif
#endif /* CONFIG_CPU_L1D_SIZE */
}

static void
NAME_(cache1d_destroy)(struct cpssp *cpssp)
{
#ifdef CONFIG_CPU_L1D_SIZE
#if COUNT
	fprintf(stderr, "%s %p: %d %d %d\n", __FUNCTION__, cpssp,
			cpssp->NAME_(cache1d).hit,
			cpssp->NAME_(cache1d).remap,
			cpssp->NAME_(cache1d).miss);
#endif
#endif /* CONFIG_CPU_L1D_SIZE */
}

#endif /* BEHAVIOR */

#undef LINES
#undef SETS
