/*
 * Copyright (C) 2007-2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
	uint32_t cr2_pfla;
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR
static void
NAME_(uiorb)(struct cpssp *cpssp, uint32_t port, uint8_t *valp)
{
	uint32_t val0;

	NAME_(ior)(cpssp, port & ~3, 1 << (port & 3), &val0);
	*valp = (val0 >> ((port & 3) * 8)) & 0xff;
}

static void
NAME_(uiorw)(struct cpssp *cpssp, uint32_t port, uint16_t *valp)
{
	uint32_t val0;
	uint32_t val1;

	if ((port & 3) == 3) {
		NAME_(ior)(cpssp, port & ~3, (0x3 << (port & 3)) & 0xf, &val0);
		NAME_(ior)(cpssp, (port & ~3) + 4, (0x3 >> (4 - (port & 3))), &val1);
		*valp = (val0 >> ((port & 3) * 8))
			| (val1 << ((4 - (port & 3)) * 8));
	} else {
		NAME_(ior)(cpssp, port & ~3, 3 << (port & 3), &val0);
		*valp = (val0 >> ((port & 3) * 8)) & 0xffff;
	}
}

static void
NAME_(uiord)(struct cpssp *cpssp, uint32_t port, uint32_t *valp)
{
	uint32_t val0;
	uint32_t val1;

	if (port & 3) {
		NAME_(ior)(cpssp, port & ~3, (0xf << (port & 3)) & 0xf, &val0);
		NAME_(ior)(cpssp, (port & ~3) + 4, 0xf >> (4 - (port & 3)), &val1);

		*valp = (val0 >> ((port & 3) * 8))
			| (val1 << ((4 - (port & 3)) * 8));

	} else {
		NAME_(ior)(cpssp, port & ~3, 0xf, &val0);
		*valp = val0;
	}
}

static void
NAME_(uiowb)(struct cpssp *cpssp, uint32_t port, uint8_t value)
{
	uint32_t val0;

	val0 = value << ((port & 3) * 8);
	NAME_(iow)(cpssp, port & ~3, 1 << (port & 3), val0);
}

static void
NAME_(uioww)(struct cpssp *cpssp, uint32_t port, uint16_t value)
{
	uint32_t val0;
	uint32_t val1;

	if ((port & 3) == 3) {
		val0 = value << ((port & 3) * 8);
		val1 = value >> ((4 - (port & 3)) * 8);

		NAME_(iow)(cpssp, port & ~3, (0x3 << (port & 3)) & 0xf, val0);
		NAME_(iow)(cpssp, (port & ~3) + 4, 0x3 >> (4 - (port & 3)), val1);
	} else {
		val0 = value << ((port & 3) * 8);
		NAME_(iow)(cpssp, port & ~3, 3 << (port & 3), val0);
	}
}

static void
NAME_(uiowd)(struct cpssp *cpssp, uint32_t port, uint32_t value)
{
	uint32_t val0;
	uint32_t val1;

	if (port & 3) {
		val0 = value << ((port & 3) * 8);
		val1 = value >> ((4 - (port & 3)) * 8);

		NAME_(iow)(cpssp, port & ~3, (0xf << (port & 3)) & 0xf, val0);
		NAME_(iow)(cpssp, (port & ~3) + 4, 0xf >> (4 - (port & 3)), val1);

	} else {
		val0 = value;
		NAME_(iow)(cpssp, port & ~3, 0xf, val0);
	}
}

static void
NAME_(umxb)(
	struct cpssp *cpssp,
	uint32_t addr,
	bool user,
	uint8_t *valp,
	uint8_t *merrp
)
{
	uint32_t val0;

	NAME_(vmx)(cpssp, addr & ~3, 1 << (addr & 3), user, &val0, merrp);
	if (*merrp) {
		*valp = 0;
		cpssp->NAME.cr2_pfla = addr & ~3;
		return;
	}
	*valp = (val0 >> ((addr & 3) * 8)) & 0xff;
}

static void
NAME_(umxw)(
	struct cpssp *cpssp,
	uint32_t addr,
	bool user,
	uint16_t *valp,
	uint8_t *merrp
)
{
	uint32_t val0;
	uint32_t val1;

	if ((addr & 3) == 3) {
		NAME_(vmx)(cpssp, addr & ~3, (0x3 << (addr & 3)) & 0xf, user, &val0, merrp);
		if (*merrp) goto error;
		addr += 4;
		NAME_(vmx)(cpssp, addr & ~3, 0x3 >> (4 - (addr & 3)), user, &val1, merrp);
		if (*merrp) goto error;
		*valp = (val0 >> ((addr & 3) * 8))
			| (val1 << ((4 - (addr & 3)) * 8));
	} else {
		NAME_(vmx)(cpssp, addr & ~3, 3 << (addr & 3), user, &val0, merrp);
		if (*merrp) {
		error:	;
			*valp = 0;
			cpssp->NAME.cr2_pfla = addr & ~3;
			return;
		}
		*valp = (val0 >> ((addr & 3) * 8)) & 0xffff;
	}
}

static void
NAME_(umxd)(
	struct cpssp *cpssp,
	uint32_t addr,
	bool user,
	uint32_t *valp,
	uint8_t *merrp
)
{
	uint32_t val0;
	uint32_t val1;

	if (addr & 3) {
		NAME_(vmx)(cpssp, addr & ~3, (0xf << (addr & 3)) & 0xf, user, &val0, merrp);
		if (*merrp) goto error;
		addr += 4;
		NAME_(vmx)(cpssp, addr & ~3, 0xf >> (4 - (addr & 3)), user, &val1, merrp);
		if (*merrp) goto error;

		*valp = (val0 >> ((addr & 3) * 8))
		      | (val1 << ((4 - (addr & 3)) * 8));

	} else {
		NAME_(vmx)(cpssp, addr & ~3, 0xf, user, &val0, merrp);
		if (*merrp) {
		error:	;
			*valp = 0;
			cpssp->NAME.cr2_pfla = addr & ~3;
			return;
		}
		*valp = val0;
	}
}

static void
NAME_(umrb)(
	struct cpssp *cpssp,
	uint32_t addr,
	bool user,
	uint8_t *valp,
	uint8_t *merrp,
	bool w_test
)
{
	uint32_t val0;

	NAME_(vmr)(cpssp, addr & ~3, 1 << (addr & 3), user, &val0, merrp, w_test);
	if (*merrp) {
		*valp = 0;
		cpssp->NAME.cr2_pfla = addr & ~3;
		return;
	}
	*valp = (val0 >> ((addr & 3) * 8)) & 0xff;
}

static void
NAME_(umrw)(
	struct cpssp *cpssp,
	uint32_t addr,
	bool user,
	uint16_t *valp,
	uint8_t *merrp,
	bool w_test
)
{
	uint32_t val0;
	uint32_t val1;

	if ((addr & 3) == 3) {
		NAME_(vmr)(cpssp, addr & ~3, (0x3 << (addr & 3)) & 0xf, user, &val0, merrp, w_test);
		if (*merrp) goto error;
		addr += 4;
		NAME_(vmr)(cpssp, addr & ~3, 0x3 >> (4 - (addr & 3)), user, &val1, merrp, w_test);
		if (*merrp) goto error;
		*valp = (val0 >> ((addr & 3) * 8))
			| (val1 << ((4 - (addr & 3)) * 8));
	} else {
		NAME_(vmr)(cpssp, addr & ~3, 3 << (addr & 3), user, &val0, merrp, w_test);
		if (*merrp) {
		error:	;
			*valp = 0;
			cpssp->NAME.cr2_pfla = addr & ~3;
			return;
		}
		*valp = (val0 >> ((addr & 3) * 8)) & 0xffff;
	}
}

static void
NAME_(umrd)(
	struct cpssp *cpssp,
	uint32_t addr,
	bool user,
	uint32_t *valp,
	uint8_t *merrp,
	bool w_test
)
{
	uint32_t val0;
	uint32_t val1;

	if (addr & 3) {
		NAME_(vmr)(cpssp, addr & ~3, (0xf << (addr & 3)) & 0xf, user, &val0, merrp, w_test);
		if (*merrp) goto error;
		addr += 4;
		NAME_(vmr)(cpssp, addr & ~3, 0xf >> (4 - (addr & 3)), user, &val1, merrp, w_test);
		if (*merrp) goto error;

		*valp = (val0 >> ((addr & 3) * 8))
		      | (val1 << ((4 - (addr & 3)) * 8));

	} else {
		NAME_(vmr)(cpssp, addr & ~3, 0xf, user, &val0, merrp, w_test);
		if (*merrp) {
		error:	;
			*valp = 0;
			cpssp->NAME.cr2_pfla = addr & ~3;
			return;
		}
		*valp = val0;
	}
}

static void
NAME_(umwb)(
	struct cpssp *cpssp,
	uint32_t addr,
	bool user,
	uint8_t val,
	uint8_t *merrp
)
{
	uint32_t val0;

	val0 = val << ((addr & 3) * 8);
	NAME_(vmw)(cpssp, addr & ~3, 1 << (addr & 3), user, val0, merrp);
	if (*merrp) {
		cpssp->NAME.cr2_pfla = addr & ~3;
		return;
	}
}

static void
NAME_(umww)(
	struct cpssp *cpssp,
	uint32_t addr,
	bool user,
	uint16_t val,
	uint8_t *merrp
)
{
	uint32_t val0;
	uint32_t val1;

	if ((addr & 3) == 3) {
		val0 = val << ((addr & 3) * 8);
		val1 = val >> ((4 - (addr & 3)) * 8);

		NAME_(vmw)(cpssp, addr & ~3, (0x3 << (addr & 3)) & 0xf, user, val0, merrp);
		if (*merrp) goto error;
		addr += 4;
		NAME_(vmw)(cpssp, addr & ~3, 0x3 >> (4 - (addr & 3)), user, val1,merrp);
		if (*merrp) goto error;
	} else {
		val0 = val << ((addr & 3) * 8);
		NAME_(vmw)(cpssp, addr & ~3, 3 << (addr & 3), user, val0, merrp);
		if (*merrp) {
		error:	;
			cpssp->NAME.cr2_pfla = addr & ~3;
			return;
		}
	}
}

static void
NAME_(umwd)(
	struct cpssp *cpssp,
	uint32_t addr,
	bool user,
	uint32_t val,
	uint8_t *merrp
)
{
	uint32_t val0;
	uint32_t val1;

	if (addr & 3) {
		val0 = val << ((addr & 3) * 8);
		val1 = val >> ((4 - (addr & 3)) * 8);

		NAME_(vmw)(cpssp, addr & ~3, (0xf << (addr & 3)) & 0xf, user, val0, merrp);
		if (*merrp) goto error;
		addr += 4;
		NAME_(vmw)(cpssp, addr & ~3, 0xf >> (4 - (addr & 3)), user, val1, merrp);
		if (*merrp) goto error;
	} else {
		val0 = val;
		NAME_(vmw)(cpssp, addr & ~3, 0xf, user, val0, merrp);
		if (*merrp) {
		error:	;
			cpssp->NAME.cr2_pfla = addr & ~3;
			return;
		}
	}
}

#endif /* BEHAVIOR */
