/*
 * Copyright (C) 2007-2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ALIGN_H_INCLUDED
#define __ALIGN_H_INCLUDED

extern uint8_t
NAME_(inb)(struct cpssp *cpssp, uint16_t port);
extern uint16_t
NAME_(inw)(struct cpssp *cpssp, uint16_t port);
#if 80386 <= CONFIG_CPU
extern uint32_t
NAME_(inl)(struct cpssp *cpssp, uint16_t port);
#endif /* 80386 <= CONFIG_CPU */

extern void
NAME_(outb)(struct cpssp *cpssp, uint8_t value, uint16_t port);
extern void
NAME_(outw)(struct cpssp *cpssp, uint16_t value, uint16_t port);
#if 80386 <= CONFIG_CPU
extern void
NAME_(outl)(struct cpssp *cpssp, uint32_t value, uint16_t port);
#endif /* 80386 <= CONFIG_CPU */

extern uint32_t
NAME_(mr_data_b)(struct cpssp *cpssp, Paddr pa);
extern uint32_t
NAME_(mr_data_w)(struct cpssp *cpssp, Paddr pa);
extern uint32_t
NAME_(mr_data_l)(struct cpssp *cpssp, Paddr pa);
extern uint64_t
NAME_(mr_data_q)(struct cpssp *cpssp, Paddr pa);

extern void
NAME_(mw_data_b)(struct cpssp *cpssp, Paddr pa, uint32_t val);
extern void
NAME_(mw_data_w)(struct cpssp *cpssp, Paddr pa, uint32_t val);
extern void
NAME_(mw_data_l)(struct cpssp *cpssp, Paddr pa, uint32_t val);
extern void
NAME_(mw_data_q)(struct cpssp *cpssp, Paddr pa, uint64_t val);

extern uint32_t
NAME_(mx_code_b)(struct cpssp *cpssp, Paddr pa);
extern uint32_t
NAME_(mx_code_w)(struct cpssp *cpssp, Paddr pa);
extern uint32_t
NAME_(mx_code_l)(struct cpssp *cpssp, Paddr pa);

#endif /* __ALIGN_H_INCLUDED */
