/*
 * Copyright (C) 2007-2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE
struct {
#if 80386 <= CONFIG_CPU
	Paddr mask;
#endif
} NAME_(a20gate);
#endif /* STATE */

#ifdef BEHAVIOR
#include "arch_gen_cpu_x86_a20gate.h"

static void
NAME_(a20gate_map_r)(struct cpssp *cpssp, Paddr pa, Haddr *haddrp)
{
#if 80386 <= CONFIG_CPU
	pa &= cpssp->NAME_(a20gate).mask;
#endif
	NAME_(cache2_map_r)(cpssp, pa, haddrp);
}

static void
NAME_(a20gate_map_w)(struct cpssp *cpssp, Paddr pa, Haddr *haddrp)
{
#if 80386 <= CONFIG_CPU
	pa &= cpssp->NAME_(a20gate).mask;
#endif
	NAME_(cache2_map_w)(cpssp, pa, haddrp);
}

static void
NAME_(a20gate_map_x)(struct cpssp *cpssp, Paddr pa, Haddr *haddrp)
{
#if 80386 <= CONFIG_CPU
	pa &= cpssp->NAME_(a20gate).mask;
#endif
	NAME_(cache2_map_x)(cpssp, pa, haddrp);
}


static void
NAME_(a20gate_mr)(struct cpssp *cpssp, Paddr pa, unsigned int bs, Data *valp)
{
#if 80386 <= CONFIG_CPU
	pa &= cpssp->NAME_(a20gate).mask;
#endif
	NAME_(cache2_mr)(cpssp, pa, bs, valp);
}

static void
NAME_(a20gate_mw)(struct cpssp *cpssp, Paddr pa, unsigned int bs, Data val)
{
#if 80386 <= CONFIG_CPU
	pa &= cpssp->NAME_(a20gate).mask;
#endif

	NAME_(cache2_mw)(cpssp, pa, bs, val);
}

static void
NAME_(a20gate_mx)(struct cpssp *cpssp, Paddr pa, unsigned int bs, Data *valp)
{
#if 80386 <= CONFIG_CPU
	pa &= cpssp->NAME_(a20gate).mask;
#endif

	NAME_(cache2_mx)(cpssp, pa, bs, valp);
}

#if 80386 <= CONFIG_CPU
static void
NAME_(a20gate_a20m_set)(struct cpssp *cpssp, unsigned int val)
{
	assert(val == 0 || val == 1);

	if (val != ((cpssp->NAME_(a20gate).mask >> 20) & 1)) {
		/*
		 * When a20 is changed, all the MMU mappings are
		 * invalid, so we must flush everything.
		 */
		NAME_(mmui_flush_all)(cpssp, 1);
		NAME_(mmud_flush_all)(cpssp, 1);
		cpssp->NAME_(a20gate).mask = (Paddr) (~(1ULL << 20) | (val << 20));
	}
}
#endif /* 80386 <= CONFIG_CPU */

void
NAME_(a20gate_reset)(struct cpssp *cpssp)
{
#if 80386 <= CONFIG_CPU
	cpssp->NAME_(a20gate).mask = ~(Paddr) 0;
#endif
}

static void
NAME_(a20gate_create)(struct cpssp *cpssp)
{
}

static void
NAME_(a20gate_destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */
