/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* Flash Interface (FLASH) */

/*
 * For most of the comments, infos, ... see:
 * ST - RM0383 - Reference Manual - STM32F411xC/E advanced ARM-based
 * 32-bit MCUs
 */

#define DEBUG_CONTROL_FLOW	1

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
	/* Flash access control register (FLASH_ACR) */
	uint8_t dcrst;
	uint8_t icrst;
	uint8_t dcen;
	uint8_t icen;
	uint8_t prften;
	uint8_t latency;

	uint32_t reg[0x1000 >> 2];
} NAME;

#endif /* STATE */
#ifdef BEHAVIOR

static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	addr &= 0x3ff;

	if (DEBUG_CONTROL_FLOW) {
		fprintf(stderr, "%s: addr=0x%08x, bs=0x%x, val=0x%08x\n",
				__FUNCTION__, addr, bs, val);
	}

	switch (addr) {
	case 0x000:
		/* Flash access control register (FLASH_ACR) */
		if ((bs >> 3) & 1) {
			/* Bit 31-24: Reserved */
		}
		if ((bs >> 2) & 1) {
			/* Bit 23-16: Reserved */
		}
		if ((bs >> 1) & 1) {
			/* Bit 15-13: Reserved */
			cpssp->NAME.dcrst = (val >> 12) & 1;
			if (cpssp->NAME.dcrst) {
				/* FIXME */
			}
			cpssp->NAME.icrst = (val >> 11) & 1;
			if (cpssp->NAME.icrst) {
				/* FIXME */
			}
			cpssp->NAME.dcen = (val >> 10) & 1;
			cpssp->NAME.icen = (val >> 9) & 1;
			cpssp->NAME.prften = (val >> 8) & 1;
		}
		if ((bs >> 0) & 1) {
			/* Bit 7-4: Reserved */
			cpssp->NAME.latency = (val >> 0) & 0xf;
		}
		break;
	default:
		fprintf(stderr, "WARNING: %s: addr=0x%08x\n",
				__FUNCTION__, addr);

		cpssp->NAME.reg[addr >> 2] = val;
		break;
	}
}

static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	addr &= 0x3ff;

	switch (addr) {
	case 0x000:
		/* Flash access control register (FLASH_ACR) */
		*valp = 0;

		/* Bit 31-24: Reserved */

		/* Bit 23-16: Reserved */

		/* Bit 15-13: Reserved */
		*valp |= cpssp->NAME.dcrst << 12;
		*valp |= cpssp->NAME.icrst << 11;
		*valp |= cpssp->NAME.dcen << 10;
		*valp |= cpssp->NAME.icen << 9;
		*valp |= cpssp->NAME.prften << 8;

		/* Bit 7-4: Reserved */
		*valp |= cpssp->NAME.latency << 0;
		break;
	default:
		*valp = cpssp->NAME.reg[addr >> 2];

		fprintf(stderr, "WARNING: %s: addr=0x%08x\n",
				__FUNCTION__, addr);
		break;
	}

	if (DEBUG_CONTROL_FLOW) {
		fprintf(stderr, "%s: addr=0x%08x, bs=0x%x, *valp=0x%08x\n",
				__FUNCTION__, addr, bs, *valp);
	}
}

static void
NAME_(reset)(struct cpssp *cpssp)
{
	/* Flash access control register (FLASH_ACR) */
	cpssp->NAME.dcrst = 0;
	cpssp->NAME.icrst = 0;
	cpssp->NAME.dcen = 0;
	cpssp->NAME.icen = 0;
	cpssp->NAME.prften = 0;
	cpssp->NAME.latency = 0;
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef DEBUG_CONTROL_FLOW
