/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * For infos look at:
 * "KL02 Sub-Family Reference Manual for 48 MHz devices 32 pin package
 * Reference Manual".
 *
 * "27: Timer/PWM Module (TPM)"
 */

#define DEBUG	0

#ifdef INCLUDE

#endif /* INCLUDE */

#ifdef STATE

struct {
	uint8_t dummy;
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	assert(bs == 0b1111);

	addr &= 0x1000 - 1;
	*valp = 0;

	switch (addr) {
	case 0x000:
		/* Status and Control (TPMx_SC) */
	case 0x004:
		/* Counter (TPMx_CNT) */
	case 0x008:
		/* Modulo (TPMx_MOD) */
	case 0x00c:
	case 0x014:
	case 0x01c:
	case 0x024:
	case 0x02c:
	case 0x034:
		/* Channel (n) Status and Control (TPMx_CnSC) */
	case 0x010:
	case 0x018:
	case 0x020:
	case 0x028:
	case 0x030:
	case 0x038:
		/* Channel (n) Value (TPMx_CnV) */
	case 0x050:
		/* Capture and Compare Status (TPMx_STATUS) */
	case 0x084:
		/* Configuration (TPMx_CONF) */

	default:
		fprintf(stderr, "WARNING: %s: addr=0x%03x bs=0x%x\n",
				__FUNCTION__, addr, bs);
		assert(0); /* FIXME */
		*valp = 0;
		break;
	}

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%03x bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, *valp);
	}
}

static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	assert(bs == 0b1111);

	addr &= 0x1000 - 1;

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%03x bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
	}

	switch (addr) {
	case 0x000:
		/* Status and Control (TPMx_SC) */
	case 0x004:
		/* Counter (TPMx_CNT) */
	case 0x008:
		/* Modulo (TPMx_MOD) */
	case 0x00c:
	case 0x014:
	case 0x01c:
	case 0x024:
	case 0x02c:
	case 0x034:
		/* Channel (n) Status and Control (TPMx_CnSC) */
	case 0x010:
	case 0x018:
	case 0x020:
	case 0x028:
	case 0x030:
	case 0x038:
		/* Channel (n) Value (TPMx_CnV) */
	case 0x050:
		/* Capture and Compare Status (TPMx_STATUS) */
	case 0x084:
		/* Configuration (TPMx_CONF) */

	default:
		fprintf(stderr, "WARNING: %s: addr=0x%08lx bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
		assert(0); /* FIXME */
		break;
	}
}

static void
NAME_(ch_inN_set)(struct cpssp *cpssp, int n, unsigned int val)
{
	/* FIXME */
}

static void
NAME_(clock)(struct cpssp *cpssp)
{
	/* FIXME */
}

static void
NAME_(reset)(struct cpssp *cpssp)
{
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef DEBUG
