/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * Serial Peripheral Interface (SPI)
 */

#define DEBUG	0

#ifdef INCLUDE

#include <assert.h>
#include <stdio.h>

#endif /* INCLUDE */

#ifdef STATE

struct {
	int dummy;
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	addr &= 0x1000 - 1;
	*valp = 0;

	switch (addr) {
	default:
		fprintf(stderr, "WARNING: %s: addr=0x%04x bs=0x%x\n",
				__FUNCTION__, addr, bs);
		assert(0); /* FIXME */
		break;
	}

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%03x bs=0x%x val=0x%08x\n",
				__FUNCTION__, addr, bs, *valp);
	}
}

static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	addr &= 0x1000 - 1;

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%03x bs=0x%x val=0x%08x\n",
				__FUNCTION__, addr, bs, val);
	}

	switch (addr) {
	default:
		fprintf(stderr, "WARNING: %s: addr=0x%04x bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
		assert(0); /* FIXME */
		break;
	}
}

static void
NAME_(sck_in_set)(struct cpssp *cpssp, unsigned int val)
{
}

static void
NAME_(mosi_in_set)(struct cpssp *cpssp, unsigned int val)
{
}

static void
NAME_(miso_in_set)(struct cpssp *cpssp, unsigned int val)
{
}

static void
NAME_(ss_in_set)(struct cpssp *cpssp, unsigned int val)
{
}

static void
NAME_(reset)(struct cpssp *cpssp)
{
	/* FIXME */
	NAME_(miso_out_set)(cpssp, SIG_STD_LOGIC_Z);
	NAME_(mosi_out_set)(cpssp, SIG_STD_LOGIC_Z);
	NAME_(sck_out_set)(cpssp, SIG_STD_LOGIC_Z);
	NAME_(ss_out_set)(cpssp, SIG_STD_LOGIC_Z);
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef DEBUG
