/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * Segment LCD (SLCD)
 */

#define DEBUG	0

#ifdef INCLUDE

#include <assert.h>
#include <stdio.h>

#endif /* INCLUDE */

#ifdef STATE

struct {
	uint64_t pen;
	uint64_t bpen;
	uint8_t wf[64];
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static void
NAME_(update)(struct cpssp *cpssp)
{
	unsigned int n;
	unsigned int i;

	/* Reset all backplane pins. */
	for (i = 0; i < 64; i++) {
		if (! ((cpssp->NAME.pen >> i) & 1)) continue;
		if (! ((cpssp->NAME.bpen >> i) & 1)) continue;
		NAME_(p_outN_set)(cpssp, i, SIG_STD_LOGIC_Z);
	}

#if 0
	for (n = 0; n < 8; n++) {
		/* Set segment pin(s). */
		fprintf(stderr, "%d: ", n);
		for (i = 0; i < 64; i++) {
			if (! ((cpssp->NAME.pen >> i) & 1)) {
				fprintf(stderr, "-");
			} else if ((cpssp->NAME.bpen >> i) & 1) {
				if ((cpssp->NAME.wf[i] >> n) & 1) {
					fprintf(stderr, "X");
				} else {
					fprintf(stderr, "x");
				}
			} else {
				if ((cpssp->NAME.wf[i] >> n) & 1) {
					fprintf(stderr, "O");
				} else {
					fprintf(stderr, "o");
				}
			}
		}
		fprintf(stderr, "\n");
	}
#endif

	for (n = 0; n < 8; n++) {
		/* Set segment pin(s). */
		for (i = 0; i < 64; i++) {
			if (! ((cpssp->NAME.pen >> i) & 1)) continue;
			if ((cpssp->NAME.bpen >> i) & 1) continue;
			NAME_(p_outN_set)(cpssp, i,
					((cpssp->NAME.wf[i] >> n) & 1)
					? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
		}

		/* Set backplane pin(s). */
		for (i = 0; i < 64; i++) {
			if (! ((cpssp->NAME.pen >> i) & 1)) continue;
			if (! ((cpssp->NAME.bpen >> i) & 1)) continue;
			NAME_(p_outN_set)(cpssp, i,
					((cpssp->NAME.wf[i] >> n) & 1)
					? SIG_STD_LOGIC_0 : SIG_STD_LOGIC_Z);
			NAME_(p_outN_set)(cpssp, i, SIG_STD_LOGIC_Z);
		}
	}
}

static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	addr &= 0x1000 - 1;
	*valp = 0;

	switch (addr) {
	case 0x000:
		/* LCD General Control Register (LCD_GCR) */
		/* FIXME */
		break;
	case 0x004:
		/* LCD Auxillary Register (LCD_AR) */
		/* FIXME */
		break;
	case 0x008:
		/* LCD Fault Detect Control Register (LCD_FDCR) */
		/* FIXME */
		break;
	case 0x00c:
		/* LCD Fault Detect Status Register (LCD_FDSR) */
		/* FIXME */
		break;
	case 0x010:
		/* LCD Pin Enable Register Low (LCD_PENL) */
		if ((bs >> 0) & 1) {
			*valp |= ((cpssp->NAME.pen >> 0) & 0xff) << 0;
		}
		if ((bs >> 1) & 1) {
			*valp |= ((cpssp->NAME.pen >> 8) & 0xff) << 8;
		}
		if ((bs >> 2) & 1) {
			*valp |= ((cpssp->NAME.pen >> 16) & 0xff) << 16;
		}
		if ((bs >> 3) & 1) {
			*valp |= ((cpssp->NAME.pen >> 24) & 0xff) << 24;
		}
		break;
	case 0x014:
		/* LCD Pin Enable Register High (LCD_PENH) */
		if ((bs >> 0) & 1) {
			*valp |= ((cpssp->NAME.pen >> 32) & 0xff) << 0;
		}
		if ((bs >> 1) & 1) {
			*valp |= ((cpssp->NAME.pen >> 40) & 0xff) << 8;
		}
		if ((bs >> 2) & 1) {
			*valp |= ((cpssp->NAME.pen >> 48) & 0xff) << 16;
		}
		if ((bs >> 3) & 1) {
			*valp |= ((cpssp->NAME.pen >> 56) & 0xff) << 24;
		}
		break;
	case 0x018:
		/* LCD Back Plane Enable Register Low (LCD_BPENL) */
		if ((bs >> 0) & 1) {
			*valp |= ((cpssp->NAME.bpen >> 0) & 0xff) << 0;
		}
		if ((bs >> 1) & 1) {
			*valp |= ((cpssp->NAME.bpen >> 8) & 0xff) << 8;
		}
		if ((bs >> 2) & 1) {
			*valp |= ((cpssp->NAME.bpen >> 16) & 0xff) << 16;
		}
		if ((bs >> 3) & 1) {
			*valp |= ((cpssp->NAME.bpen >> 24) & 0xff) << 24;
		}
		break;
	case 0x01c:
		/* LCD Back Plane Enable Register High (LCD_BPENH) */
		if ((bs >> 0) & 1) {
			*valp |= ((cpssp->NAME.bpen >> 32) & 0xff) << 0;
		}
		if ((bs >> 1) & 1) {
			*valp |= ((cpssp->NAME.bpen >> 40) & 0xff) << 8;
		}
		if ((bs >> 2) & 1) {
			*valp |= ((cpssp->NAME.bpen >> 48) & 0xff) << 16;
		}
		if ((bs >> 3) & 1) {
			*valp |= ((cpssp->NAME.bpen >> 56) & 0xff) << 24;
		}
		break;
	case 0x020:
		/* LCD Waveform Register (LCD_WF3TO0) */
	case 0x024:
		/* LCD Waveform Register (LCD_WF7TO4) */
	case 0x028:
		/* LCD Waveform Register (LCD_WF11TO8) */
	case 0x02c:
		/* LCD Waveform Register (LCD_WF15TO12) */
	case 0x030:
		/* LCD Waveform Register (LCD_WF19TO16) */
	case 0x034:
		/* LCD Waveform Register (LCD_WF23TO20) */
	case 0x038:
		/* LCD Waveform Register (LCD_WF27TO24) */
	case 0x03c:
		/* LCD Waveform Register (LCD_WF31TO28) */
	case 0x040:
		/* LCD Waveform Register (LCD_WF35TO32) */
	case 0x044:
		/* LCD Waveform Register (LCD_WF39TO36) */
	case 0x048:
		/* LCD Waveform Register (LCD_WF43TO40) */
	case 0x04c:
		/* LCD Waveform Register (LCD_WF47TO44) */
	case 0x050:
		/* LCD Waveform Register (LCD_WF51TO48) */
	case 0x054:
		/* LCD Waveform Register (LCD_WF55TO52) */
	case 0x058:
		/* LCD Waveform Register (LCD_WF59TO56) */
	case 0x05c:
		/* LCD Waveform Register (LCD_WF63TO60) */
		if ((bs >> 0) & 1) {
			*valp |= cpssp->NAME.wf[addr - 0x20 + 0] << 0;
		}
		if ((bs >> 1) & 1) {
			*valp |= cpssp->NAME.wf[addr - 0x20 + 1] << 8;
		}
		if ((bs >> 2) & 1) {
			*valp |= cpssp->NAME.wf[addr - 0x20 + 2] << 16;
		}
		if ((bs >> 3) & 1) {
			*valp |= cpssp->NAME.wf[addr - 0x20 + 3] << 24;
		}
		break;
	default:
		/* FIXME */
		fprintf(stderr, "WARNING: %s: addr=0x%04x bs=0x%x\n",
				__FUNCTION__, addr, bs);
		assert(0); /* FIXME */
		break;
	}

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%03x bs=0x%x val=0x%08x\n",
				__FUNCTION__, addr, bs, *valp);
	}
}

static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	addr &= 0x1000 - 1;

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%03x bs=0x%x val=0x%08x\n",
				__FUNCTION__, addr, bs, val);
	}

	switch (addr) {
	case 0x000:
		/* LCD General Control Register (LCD_GCR) */
		/* FIXME */
		break;
	case 0x004:
		/* LCD Auxillary Register (LCD_AR) */
		/* FIXME */
		break;
	case 0x008:
		/* LCD Fault Detect Control Register (LCD_FDCR) */
		/* FIXME */
		break;
	case 0x00c:
		/* LCD Fault Detect Status Register (LCD_FDSR) */
		/* FIXME */
		break;
	case 0x010:
		/* LCD Pin Enable Register Low (LCD_PENL) */
		if ((bs >> 0) & 1) {
			cpssp->NAME.pen &= ~((uint64_t) 0xff << 0);
			cpssp->NAME.pen |= ((uint64_t) (val >> 0) & 0xff) << 0;
		}
		if ((bs >> 1) & 1) {
			cpssp->NAME.pen &= ~((uint64_t) 0xff << 8);
			cpssp->NAME.pen |= ((uint64_t) (val >> 8) & 0xff) << 8;
		}
		if ((bs >> 2) & 1) {
			cpssp->NAME.pen &= ~((uint64_t) 0xff << 16);
			cpssp->NAME.pen |= ((uint64_t) (val >> 16) & 0xff) << 16;
		}
		if ((bs >> 3) & 1) {
			cpssp->NAME.pen &= ~((uint64_t) 0xff << 24);
			cpssp->NAME.pen |= ((uint64_t) (val >> 24) & 0xff) << 24;
		}
		NAME_(update)(cpssp);
		break;
	case 0x014:
		/* LCD Pin Enable Register High (LCD_PENH) */
		if ((bs >> 0) & 1) {
			cpssp->NAME.pen &= ~((uint64_t) 0xff << 32);
			cpssp->NAME.pen |= ((uint64_t) (val >> 0) & 0xff) << 32;
		}
		if ((bs >> 1) & 1) {
			cpssp->NAME.pen &= ~((uint64_t) 0xff << 40);
			cpssp->NAME.pen |= ((uint64_t) (val >> 8) & 0xff) << 40;
		}
		if ((bs >> 2) & 1) {
			cpssp->NAME.pen &= ~((uint64_t) 0xff << 48);
			cpssp->NAME.pen |= ((uint64_t) (val >> 16) & 0xff) << 48;
		}
		if ((bs >> 3) & 1) {
			cpssp->NAME.pen &= ~((uint64_t) 0xff << 56);
			cpssp->NAME.pen |= ((uint64_t) (val >> 24) & 0xff) << 56;
		}
		NAME_(update)(cpssp);
		break;
	case 0x018:
		/* LCD Back Plane Enable Register Low (LCD_BPENL) */
		if ((bs >> 0) & 1) {
			cpssp->NAME.bpen &= ~((uint64_t) 0xff << 0);
			cpssp->NAME.bpen |= ((uint64_t) (val >> 0) & 0xff) << 0;
		}
		if ((bs >> 1) & 1) {
			cpssp->NAME.bpen &= ~((uint64_t) 0xff << 8);
			cpssp->NAME.bpen |= ((uint64_t) (val >> 8) & 0xff) << 8;
		}
		if ((bs >> 2) & 1) {
			cpssp->NAME.bpen &= ~((uint64_t) 0xff << 16);
			cpssp->NAME.bpen |= ((uint64_t) (val >> 16) & 0xff) << 16;
		}
		if ((bs >> 3) & 1) {
			cpssp->NAME.bpen &= ~((uint64_t) 0xff << 24);
			cpssp->NAME.bpen |= ((uint64_t) (val >> 24) & 0xff) << 24;
		}
		NAME_(update)(cpssp);
		break;
	case 0x01c:
		/* LCD Back Plane Enable Register High (LCD_BPENH) */
		if ((bs >> 0) & 1) {
			cpssp->NAME.bpen &= ~((uint64_t) 0xff << 32);
			cpssp->NAME.bpen |= ((uint64_t) (val >> 0) & 0xff) << 32;
		}
		if ((bs >> 1) & 1) {
			cpssp->NAME.bpen &= ~((uint64_t) 0xff << 40);
			cpssp->NAME.bpen |= ((uint64_t) (val >> 8) & 0xff) << 40;
		}
		if ((bs >> 2) & 1) {
			cpssp->NAME.bpen &= ~((uint64_t) 0xff << 48);
			cpssp->NAME.bpen |= ((uint64_t) (val >> 16) & 0xff) << 48;
		}
		if ((bs >> 3) & 1) {
			cpssp->NAME.bpen &= ~((uint64_t) 0xff << 56);
			cpssp->NAME.bpen |= ((uint64_t) (val >> 24) & 0xff) << 56;
		}
		NAME_(update)(cpssp);
		break;
	case 0x020:
		/* LCD Waveform Register (LCD_WF3TO0) */
	case 0x024:
		/* LCD Waveform Register (LCD_WF7TO4) */
	case 0x028:
		/* LCD Waveform Register (LCD_WF11TO8) */
	case 0x02c:
		/* LCD Waveform Register (LCD_WF15TO12) */
	case 0x030:
		/* LCD Waveform Register (LCD_WF19TO16) */
	case 0x034:
		/* LCD Waveform Register (LCD_WF23TO20) */
	case 0x038:
		/* LCD Waveform Register (LCD_WF27TO24) */
	case 0x03c:
		/* LCD Waveform Register (LCD_WF31TO28) */
	case 0x040:
		/* LCD Waveform Register (LCD_WF35TO32) */
	case 0x044:
		/* LCD Waveform Register (LCD_WF39TO36) */
	case 0x048:
		/* LCD Waveform Register (LCD_WF43TO40) */
	case 0x04c:
		/* LCD Waveform Register (LCD_WF47TO44) */
	case 0x050:
		/* LCD Waveform Register (LCD_WF51TO48) */
	case 0x054:
		/* LCD Waveform Register (LCD_WF55TO52) */
	case 0x058:
		/* LCD Waveform Register (LCD_WF59TO56) */
	case 0x05c:
		/* LCD Waveform Register (LCD_WF63TO60) */
		if ((bs >> 0) & 1) {
			cpssp->NAME.wf[addr - 0x20 + 0] = (val >> 0) & 0xff;
		}
		if ((bs >> 1) & 1) {
			cpssp->NAME.wf[addr - 0x20 + 1] = (val >> 8) & 0xff;
		}
		if ((bs >> 2) & 1) {
			cpssp->NAME.wf[addr - 0x20 + 2] = (val >> 16) & 0xff;
		}
		if ((bs >> 3) & 1) {
			cpssp->NAME.wf[addr - 0x20 + 3] = (val >> 24) & 0xff;
		}
		NAME_(update)(cpssp);
		break;
	default:
		/* FIXME */
		fprintf(stderr, "WARNING: %s: addr=0x%04x bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
		assert(0); /* FIXME */
		break;
	}
}

static void
NAME_(clk0)(struct cpssp *cpssp)
{
}

static void
NAME_(clk1)(struct cpssp *cpssp)
{
}

static void
NAME_(clk2)(struct cpssp *cpssp)
{
}

static void
NAME_(reset)(struct cpssp *cpssp)
{
	unsigned int i;

	/* LCD Pin Enable Register (LCD_PEN) */
	cpssp->NAME.pen = 0;

	/* LCD Backplane Enable Register (LCD_BPEN) */
	cpssp->NAME.bpen = 0;

	/* LCD Waveform Registers (LCD_WFxTOy) */
	for (i = 0; i < sizeof(cpssp->NAME.wf) / sizeof(cpssp->NAME.wf[0]); i++) {
		cpssp->NAME.wf[i] = 0x00;
	}

	NAME_(update)(cpssp);
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef DEBUG
