/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * For infos look at:
 * "KL02 Sub-Family Reference Manual for 48 MHz devices 32 pin package
 * Reference Manual".
 *
 * "14: Power Management Controller (PMC)"
 */

#ifdef INCLUDE

#include <assert.h>
#include <stdio.h>

#endif /* INCLUDE */

#ifdef STATE

struct {
	/* 14.5.1 */
	uint8_t lvdf;
	uint8_t lvdie;
	uint8_t lvdre;
	uint8_t lvdv;
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	addr &= 0x1000 - 1;
	*valp = 0;

	switch (addr) {
	case 0x000:
		if ((bs >> 0) & 1) {
			/* Low Voltage Detect Status and Control 1 Register */
			/* 14.5.1 */
			*valp |= cpssp->NAME.lvdf << 7;
			/* 6: Write-only */
			*valp |= cpssp->NAME.lvdie << 5;
			*valp |= cpssp->NAME.lvdre << 4;
			/* 3-2: reserved */
			*valp |= cpssp->NAME.lvdv << 0;
		}
		if ((bs >> 1) & 1) {
			/* Low Voltage Detect Status and Control 2 Register */
			/* 14.5.2 */
		}
		if ((bs >> 2) & 1) {
			/* Regulator Status and Control Register */
			/* 14.5.3 */
		}
		if ((bs >> 3) & 1) {
			/* reserved */
		}
		break;

	default:
		/* FIXME */
		fprintf(stderr, "WARNING: %s: addr=0x%03x bs=0x%x\n",
				__FUNCTION__, addr, bs);
		assert(0); /* FIXME */
		break;
	}
}

static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	addr &= 0x1000 - 1;

	switch (addr) {
	case 0x000:
		if ((bs >> 0) & 1) {
			/* Low Voltage Detect Status and Control 1 Register */
			/* 14.5.1 */
			/* 7: Read-only */
			cpssp->NAME.lvdf &= ~((val >> 6) & 1);
			cpssp->NAME.lvdie = (val >> 5) & 1;
			cpssp->NAME.lvdre = (val >> 4) & 1;
			/* 3-2: reserved */
			cpssp->NAME.lvdv = (val >> 0) & 0b11;
		}
		if ((bs >> 1) & 1) {
			/* Low Voltage Detect Status and Control 2 Register */
			/* 14.5.2 */
		}
		if ((bs >> 2) & 1) {
			/* Regulator Status and Control Register */
			/* 14.5.3 */
		}
		if ((bs >> 3) & 1) {
			/* reserved */
		}
		break;

	default:
		/* FIXME */
		fprintf(stderr, "WARNING: %s: addr=0x%03x bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
		assert(0); /* FIXME */
		break;
	}
}

static void
NAME_(1kHz)(struct cpssp *cpssp)
{
	NAME_(lpo)(cpssp);
}

static void
NAME_(reset)(struct cpssp *cpssp)
{
	/* 14.5.1 */
	cpssp->NAME.lvdf = 0;
	cpssp->NAME.lvdie = 0;
	cpssp->NAME.lvdre = 1;
	cpssp->NAME.lvdv = 0b00;
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */
