/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * Low Leakage Wakeup Unit (LLWU)
 */

#define DEBUG	0

#ifdef INCLUDE

#endif /* INCLUDE */

#ifdef STATE

struct {
	unsigned int module_state[8];
	unsigned int port_state[16];

	/* Pin Enable */
	uint8_t pe_fe[16];
	uint8_t pe_re[16];

	/* Module Enable */
	uint8_t wume[8];

	/* Flag Register */
	uint8_t wuf[16];
	uint8_t mwuf[8];
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static void
NAME_(update_irq)(struct cpssp *cpssp)
{
	int irq;
	int i;

	/* FIXME */
	irq = 0;
	for (i = 0; i < 8; i++) {
		irq |= cpssp->NAME.module_state[i] & cpssp->NAME.wume[i];
	}
	for (i = 0; i < 16; i++) {
		irq |= cpssp->NAME.port_state[i] & cpssp->NAME.wuf[i];
	}

	if (irq) {
		NAME_(start)(cpssp);
	}
	NAME_(irq_set)(cpssp, irq);
}

static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	addr &= 0x1000 - 1;
	*valp = 0;

	switch (addr) {
	case 0x0:
		/* Wakeup Pin Enable */
		if ((bs >> 0) & 1) {
			/* Pin Enable 1 register (LLWU_PE1) */
			*valp |= cpssp->NAME.pe_fe[0*4 + 3] << (7+0);
			*valp |= cpssp->NAME.pe_re[0*4 + 3] << (6+0);
			*valp |= cpssp->NAME.pe_fe[0*4 + 2] << (5+0);
			*valp |= cpssp->NAME.pe_re[0*4 + 2] << (4+0);
			*valp |= cpssp->NAME.pe_fe[0*4 + 1] << (3+0);
			*valp |= cpssp->NAME.pe_re[0*4 + 1] << (2+0);
			*valp |= cpssp->NAME.pe_fe[0*4 + 0] << (1+0);
			*valp |= cpssp->NAME.pe_re[0*4 + 0] << (0+0);
		}
		if ((bs >> 1) & 1) {
			/* Pin Enable 2 register (LLWU_PE2) */
			*valp |= cpssp->NAME.pe_fe[1*4 + 3] << (7+8);
			*valp |= cpssp->NAME.pe_re[1*4 + 3] << (6+8);
			*valp |= cpssp->NAME.pe_fe[1*4 + 2] << (5+8);
			*valp |= cpssp->NAME.pe_re[1*4 + 2] << (4+8);
			*valp |= cpssp->NAME.pe_fe[1*4 + 1] << (3+8);
			*valp |= cpssp->NAME.pe_re[1*4 + 1] << (2+8);
			*valp |= cpssp->NAME.pe_fe[1*4 + 0] << (1+8);
			*valp |= cpssp->NAME.pe_re[1*4 + 0] << (0+8);
		}
		if ((bs >> 2) & 1) {
			/* Pin Enable 3 register (LLWU_PE3) */
			*valp |= cpssp->NAME.pe_fe[2*4 + 3] << (7+16);
			*valp |= cpssp->NAME.pe_re[2*4 + 3] << (6+16);
			*valp |= cpssp->NAME.pe_fe[2*4 + 2] << (5+16);
			*valp |= cpssp->NAME.pe_re[2*4 + 2] << (4+16);
			*valp |= cpssp->NAME.pe_fe[2*4 + 1] << (3+16);
			*valp |= cpssp->NAME.pe_re[2*4 + 1] << (2+16);
			*valp |= cpssp->NAME.pe_fe[2*4 + 0] << (1+16);
			*valp |= cpssp->NAME.pe_re[2*4 + 0] << (0+16);
		}
		if ((bs >> 3) & 1) {
			/* Pin Enable 4 register (LLWU_PE4) */
			*valp |= cpssp->NAME.pe_fe[3*4 + 3] << (7+24);
			*valp |= cpssp->NAME.pe_re[3*4 + 3] << (6+24);
			*valp |= cpssp->NAME.pe_fe[3*4 + 2] << (5+24);
			*valp |= cpssp->NAME.pe_re[3*4 + 2] << (4+24);
			*valp |= cpssp->NAME.pe_fe[3*4 + 1] << (3+24);
			*valp |= cpssp->NAME.pe_re[3*4 + 1] << (2+24);
			*valp |= cpssp->NAME.pe_fe[3*4 + 0] << (1+24);
			*valp |= cpssp->NAME.pe_re[3*4 + 0] << (0+24);
		}
		break;
	case 0x4:
		if ((bs >> 0) & 1) {
			/* Module Enable register (LLWU_ME) */
			*valp |= cpssp->NAME.wume[7] << (7+0);
			*valp |= cpssp->NAME.wume[6] << (6+0);
			*valp |= cpssp->NAME.wume[5] << (5+0);
			*valp |= cpssp->NAME.wume[4] << (4+0);
			*valp |= cpssp->NAME.wume[3] << (3+0);
			*valp |= cpssp->NAME.wume[2] << (2+0);
			*valp |= cpssp->NAME.wume[1] << (1+0);
			*valp |= cpssp->NAME.wume[0] << (0+0);
		}
		if ((bs >> 1) & 1) {
			/* Flag 1 Register (LLWU_F1) */
			*valp |= cpssp->NAME.wuf[7] << (7+8);
			*valp |= cpssp->NAME.wuf[6] << (6+8);
			*valp |= cpssp->NAME.wuf[5] << (5+8);
			*valp |= cpssp->NAME.wuf[4] << (4+8);
			*valp |= cpssp->NAME.wuf[3] << (3+8);
			*valp |= cpssp->NAME.wuf[2] << (2+8);
			*valp |= cpssp->NAME.wuf[1] << (1+8);
			*valp |= cpssp->NAME.wuf[0] << (0+8);
		}
		if ((bs >> 2) & 1) {
			/* Flag 2 Register (LLWU_F1) */
			*valp |= cpssp->NAME.wuf[15] << (7+16);
			*valp |= cpssp->NAME.wuf[14] << (6+16);
			*valp |= cpssp->NAME.wuf[13] << (5+16);
			*valp |= cpssp->NAME.wuf[12] << (4+16);
			*valp |= cpssp->NAME.wuf[11] << (3+16);
			*valp |= cpssp->NAME.wuf[10] << (2+16);
			*valp |= cpssp->NAME.wuf[9] << (1+16);
			*valp |= cpssp->NAME.wuf[8] << (0+16);
		}
		if ((bs >> 3) & 1) {
			/* Flag 3 Register (LLWU_F1) */
			*valp |= cpssp->NAME.mwuf[7] << (7+24);
			*valp |= cpssp->NAME.mwuf[6] << (6+24);
			*valp |= cpssp->NAME.mwuf[5] << (5+24);
			*valp |= cpssp->NAME.mwuf[4] << (4+24);
			*valp |= cpssp->NAME.mwuf[3] << (3+24);
			*valp |= cpssp->NAME.mwuf[2] << (2+24);
			*valp |= cpssp->NAME.mwuf[1] << (1+24);
			*valp |= cpssp->NAME.mwuf[0] << (0+24);
		}
		break;
	default:
		fprintf(stderr, "WARNING: %s: addr=0x%03x bs=0x%x\n",
				__FUNCTION__, addr, bs);
		assert(0); /* FIXME */
		*valp = 0;
		break;
	}

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%03x bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, *valp);
	}
}

static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	addr &= 0x1000 - 1;

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%03x bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
	}

	switch (addr) {
	case 0x0:
		if ((bs >> 0) & 1) {
			/* Pin Enable 1 register (LLWU_PE1) */
			cpssp->NAME.pe_fe[0*4 + 3] = (val >> (7+0)) & 1;
			cpssp->NAME.pe_re[0*4 + 3] = (val >> (6+0)) & 1;
			cpssp->NAME.pe_fe[0*4 + 2] = (val >> (5+0)) & 1;
			cpssp->NAME.pe_re[0*4 + 2] = (val >> (4+0)) & 1;
			cpssp->NAME.pe_fe[0*4 + 1] = (val >> (3+0)) & 1;
			cpssp->NAME.pe_re[0*4 + 1] = (val >> (2+0)) & 1;
			cpssp->NAME.pe_fe[0*4 + 0] = (val >> (1+0)) & 1;
			cpssp->NAME.pe_re[0*4 + 0] = (val >> (0+0)) & 1;
		}
		if ((bs >> 1) & 1) {
			/* Pin Enable 2 register (LLWU_PE1) */
			cpssp->NAME.pe_fe[1*4 + 3] = (val >> (7+8)) & 1;
			cpssp->NAME.pe_re[1*4 + 3] = (val >> (6+8)) & 1;
			cpssp->NAME.pe_fe[1*4 + 2] = (val >> (5+8)) & 1;
			cpssp->NAME.pe_re[1*4 + 2] = (val >> (4+8)) & 1;
			cpssp->NAME.pe_fe[1*4 + 1] = (val >> (3+8)) & 1;
			cpssp->NAME.pe_re[1*4 + 1] = (val >> (2+8)) & 1;
			cpssp->NAME.pe_fe[1*4 + 0] = (val >> (1+8)) & 1;
			cpssp->NAME.pe_re[1*4 + 0] = (val >> (0+8)) & 1;
		}
		if ((bs >> 2) & 1) {
			/* Pin Enable 3 register (LLWU_PE1) */
			cpssp->NAME.pe_fe[2*4 + 3] = (val >> (7+16)) & 1;
			cpssp->NAME.pe_re[2*4 + 3] = (val >> (6+16)) & 1;
			cpssp->NAME.pe_fe[2*4 + 2] = (val >> (5+16)) & 1;
			cpssp->NAME.pe_re[2*4 + 2] = (val >> (4+16)) & 1;
			cpssp->NAME.pe_fe[2*4 + 1] = (val >> (3+16)) & 1;
			cpssp->NAME.pe_re[2*4 + 1] = (val >> (2+16)) & 1;
			cpssp->NAME.pe_fe[2*4 + 0] = (val >> (1+16)) & 1;
			cpssp->NAME.pe_re[2*4 + 0] = (val >> (0+16)) & 1;
		}
		if ((bs >> 3) & 1) {
			/* Pin Enable 4 register (LLWU_PE1) */
			cpssp->NAME.pe_fe[3*4 + 3] = (val >> (7+24)) & 1;
			cpssp->NAME.pe_re[3*4 + 3] = (val >> (6+24)) & 1;
			cpssp->NAME.pe_fe[3*4 + 2] = (val >> (5+24)) & 1;
			cpssp->NAME.pe_re[3*4 + 2] = (val >> (4+24)) & 1;
			cpssp->NAME.pe_fe[3*4 + 1] = (val >> (3+24)) & 1;
			cpssp->NAME.pe_re[3*4 + 1] = (val >> (2+24)) & 1;
			cpssp->NAME.pe_fe[3*4 + 0] = (val >> (1+24)) & 1;
			cpssp->NAME.pe_re[3*4 + 0] = (val >> (0+24)) & 1;
		}
		break;
	case 0x4:
		if ((bs >> 0) & 1) {
			/* Module Enable register (LLWU_ME) */
			cpssp->NAME.wume[7] = (val >> (7+0)) & 1;
			cpssp->NAME.wume[6] = (val >> (6+0)) & 1;
			cpssp->NAME.wume[5] = (val >> (5+0)) & 1;
			cpssp->NAME.wume[4] = (val >> (4+0)) & 1;
			cpssp->NAME.wume[3] = (val >> (3+0)) & 1;
			cpssp->NAME.wume[2] = (val >> (2+0)) & 1;
			cpssp->NAME.wume[1] = (val >> (1+0)) & 1;
			cpssp->NAME.wume[0] = (val >> (0+0)) & 1;
			NAME_(update_irq)(cpssp);
		}
		if ((bs >> 1) & 1) {
			/* Flag 1 Register (LLWU_F1) */
			cpssp->NAME.wuf[7] &= ~((val >> (7+8)) & 1);
			cpssp->NAME.wuf[6] &= ~((val >> (6+8)) & 1);
			cpssp->NAME.wuf[5] &= ~((val >> (5+8)) & 1);
			cpssp->NAME.wuf[4] &= ~((val >> (4+8)) & 1);
			cpssp->NAME.wuf[3] &= ~((val >> (3+8)) & 1);
			cpssp->NAME.wuf[2] &= ~((val >> (2+8)) & 1);
			cpssp->NAME.wuf[1] &= ~((val >> (1+8)) & 1);
			cpssp->NAME.wuf[0] &= ~((val >> (0+8)) & 1);
			NAME_(update_irq)(cpssp);
		}
		if ((bs >> 2) & 1) {
			/* Flag 2 Register (LLWU_F1) */
			cpssp->NAME.wuf[15] &= ~((val >> (7+16)) & 1);
			cpssp->NAME.wuf[14] &= ~((val >> (6+16)) & 1);
			cpssp->NAME.wuf[13] &= ~((val >> (5+16)) & 1);
			cpssp->NAME.wuf[12] &= ~((val >> (4+16)) & 1);
			cpssp->NAME.wuf[11] &= ~((val >> (3+16)) & 1);
			cpssp->NAME.wuf[10] &= ~((val >> (2+16)) & 1);
			cpssp->NAME.wuf[9] &= ~((val >> (1+16)) & 1);
			cpssp->NAME.wuf[8] &= ~((val >> (0+16)) & 1);
			NAME_(update_irq)(cpssp);
		}
		if ((bs >> 3) & 1) {
			/* Flag 3 Register (LLWU_F1) */
			/* Read-only */
		}
		break;
	default:
		fprintf(stderr, "WARNING: %s: addr=0x%08lx bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
		assert(0); /* FIXME */
		break;
	}
}

static void
NAME_(moduleN_set)(struct cpssp *cpssp, int N, unsigned int val)
{
	cpssp->NAME.module_state[N] = val;
	NAME_(update_irq)(cpssp);
}

static void
NAME_(p_inN_set)(struct cpssp *cpssp, int N, unsigned int val)
{
	unsigned int old;

	val = 3300/2 < SIG_mV(val);

	old = cpssp->NAME.port_state[N];
	cpssp->NAME.port_state[N] = val;

	if ((old == 0 && val == 1 && cpssp->NAME.pe_re[N]) /* Rising Edge */
	 || (old == 1 && val == 0 && cpssp->NAME.pe_fe[N]) /* Falling Edge */) {
		cpssp->NAME.wuf[N] = 1;
		NAME_(update_irq)(cpssp);
	}
}

static void
NAME_(reset)(struct cpssp *cpssp)
{
	int i;

	/* Pin Enable n Register (LLWU_PEn) */
	for (i = 0; i < 16; i++) {
		cpssp->NAME.pe_fe[i] = 0;
		cpssp->NAME.pe_re[i] = 0;
	}

	/* Module Enable Register (LLWU_ME) */
	for (i = 0; i < 8; i++) {
		cpssp->NAME.wume[i] = 0;
	}

	/* Flag Register */
	for (i = 0; i < 16; i++) {
		cpssp->NAME.wuf[i] = 0;
	}
	for (i = 0; i < 8; i++) {
		cpssp->NAME.mwuf[i] = 0;
	}
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef DEBUG
