/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * For infos look at:
 * "KL02 Sub-Family Reference Manual for 48 MHz devices 32 pin package
 * Reference Manual".
 *
 * "23: Flash Memory Controller (FMC)"
 */

#define DEBUG	0

#ifdef INCLUDE

#include <assert.h>
#include <stdio.h>
#include <string.h>

#endif /* INCLUDE */

#ifdef STATE

/* FIXME */
#define LRU_DECL(count, name)   uint8_t name[(count + 7) / 8]

struct {
	uint8_t spec_buf_enabled[2];
	uint8_t spec_buf_valid[2];
	uint32_t spec_buf_addr[2];
	uint32_t spec_buf_data[2];

	uint8_t cache_enabled[2];
	struct {
		struct {
			uint8_t valid;
			uint32_t addr;
			uint32_t data;
		} line[4];
		LRU_DECL(4, lru);
	} cache[2][2];
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

#include "arch_gen_lru.h"
#include "arch_gen_lru.c"

static void
NAME_(read)(struct cpssp *cpssp, int dflag, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	uint32_t data;
	int set;
	int i;

	set = (addr >> 3) & 1;

	/*
	 * Lookup speculative buffer.
	 */
	if (cpssp->NAME.spec_buf_valid[dflag]
	 && cpssp->NAME.spec_buf_addr[dflag] == addr) {
		data = cpssp->NAME.spec_buf_data[dflag];
		goto found;
	}
	
	/*
	 * Lookup cache.
	 */
	for (i = 0; ; i++) {
		if (i == 4) {
			/* Not found. */
			break;
		}
		if (cpssp->NAME.cache[dflag][set].line[i].valid
		 && cpssp->NAME.cache[dflag][set].line[i].addr == addr) {
			data = cpssp->NAME.cache[dflag][set].line[i].data;
			/* Found. */
			NAME_(lru_use)(4, cpssp->NAME.cache[dflag][set].lru, i);
			break;
		}
	}

	/*
	 * Read from flash.
	 */
	NAME_(flash_read)(cpssp, addr, &data);

found:	;
	if (cpssp->NAME.cache_enabled[dflag]) {
		/*
		 * Insert into cache.
		 */
		i = NAME_(lru_oldest)(4, cpssp->NAME.cache[dflag][set].lru);
		NAME_(lru_use)(4, cpssp->NAME.cache[dflag][set].lru, i);
		cpssp->NAME.cache[dflag][set].line[i].valid = 1;
		cpssp->NAME.cache[dflag][set].line[i].addr = addr;
		cpssp->NAME.cache[dflag][set].line[i].data = data;
	}
	if (cpssp->NAME.spec_buf_enabled[dflag]) {
		if ((bs >> 2) & 0b11) {
			/*
			 * Get next data into speculative buffer.
			 */
			cpssp->NAME.spec_buf_addr[dflag] = addr + 4;
			NAME_(flash_read)(cpssp, cpssp->NAME.spec_buf_addr[dflag],
					&cpssp->NAME.spec_buf_data[dflag]);
			cpssp->NAME.spec_buf_valid[dflag] = 1;
		}
	}

	*valp = data;

	if (DEBUG) {
		fprintf(stderr, "%s: dflag=%d addr=0x%08lx bs=0x%x val=0x%08lx\n",
				__FUNCTION__, dflag, addr, bs, *valp);
	}
}

static void
NAME_(mx)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	NAME_(read)(cpssp, 0, addr, bs, valp);
}

static void
NAME_(mr)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	NAME_(read)(cpssp, 1, addr, bs, valp);
}

static void
NAME_(mw)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%08lx bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
	}
	assert(0);
}

static void
NAME_(reset)(struct cpssp *cpssp)
{
	int dflag;
	int set;
	int i;

	cpssp->NAME.spec_buf_enabled[0] = 1;
	cpssp->NAME.spec_buf_enabled[1] = 0;
	cpssp->NAME.cache_enabled[0] = 1;
	cpssp->NAME.cache_enabled[1] = 1;

	for (dflag = 0; dflag <= 1; dflag++) {
		/* Clear speculative buffer. */
		cpssp->NAME.spec_buf_valid[dflag] = 0;

		/* Clear cache. */
		for (set = 0; set < 2; set++) {
			for (i = 0; i < 4; i++) {
				cpssp->NAME.cache[dflag][set].line[i].valid = 0;
			}
			NAME_(lru_reset)(4, cpssp->NAME.cache[dflag][set].lru);
		}
	}
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef DEBUG
