/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * For infos look at:
 * "KL02 Sub-Family Reference Manual for 48 MHz devices 32 pin package
 * Reference Manual".
 *
 * "SRAM" - FIXME
 */

#define DEBUG	0

#ifdef INCLUDE

#include <assert.h>
#include <stdio.h>
#include <string.h>

#endif /* INCLUDE */

#ifdef STATE

struct {
	uint8_t data[SRAM_SIZE];
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	addr &= sizeof(cpssp->NAME.data) - 1;

	*valp = (cpssp->NAME.data[addr + 0] << 0)
		| (cpssp->NAME.data[addr + 1] << 8)
		| (cpssp->NAME.data[addr + 2] << 16)
		| (cpssp->NAME.data[addr + 3] << 24);

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%08lx bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, *valp);
	}
}

static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	addr &= sizeof(cpssp->NAME.data) - 1;

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%08lx bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
	}

	if ((bs >> 0) & 1) {
		cpssp->NAME.data[addr + 0] = val >> 0;
	}
	if ((bs >> 1) & 1) {
		cpssp->NAME.data[addr + 1] = val >> 8;
	}
	if ((bs >> 2) & 1) {
		cpssp->NAME.data[addr + 2] = val >> 16;
	}
	if ((bs >> 3) & 1) {
		cpssp->NAME.data[addr + 3] = val >> 24;
	}
}

static void
NAME_(create)(struct cpssp *cpssp)
{
	memset(cpssp->NAME.data, 0, sizeof(cpssp->NAME.data));
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef DEBUG
