/*
 * $Id: arch_gen_lru.c,v 1.1 2014/02/28 14:54:27 sieh Exp $
 *
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define DUMP	0

static const uint8_t NAME_(lru4_use_table)[8][4] = {
/*0b000*/ { 0b000, 0b001, 0b100, 0b110, },
/*0b001*/ { 0b000, 0b001, 0b101, 0b111, },
/*0b010*/ { 0b010, 0b011, 0b100, 0b110, },
/*0b011*/ { 0b010, 0b011, 0b101, 0b111, },
/*0b100*/ { 0b000, 0b001, 0b100, 0b110, },
/*0b101*/ { 0b000, 0b001, 0b101, 0b111, },
/*0b110*/ { 0b010, 0b011, 0b100, 0b110, },
/*0b111*/ { 0b010, 0b011, 0b101, 0b111, },
};
static const uint8_t NAME_(lru4_old_table)[8] = {
/*0b000*/ 0b0011,
/*0b001*/ 0b0011,
/*0b010*/ 0b0010,
/*0b011*/ 0b0010,
/*0b100*/ 0b0001,
/*0b101*/ 0b0000,
/*0b110*/ 0b0001,
/*0b111*/ 0b0000,
};
static const uint8_t NAME_(lru8_use_table)[128][8] = {
/*0b0000000*/ { 0b0000000, 0b0000001, 0b0010000, 0b0010010, 0b1000000, 0b1000100, 0b1100000, 0b1101000, },
/*0b0000001*/ { 0b0000000, 0b0000001, 0b0010001, 0b0010011, 0b1000001, 0b1000101, 0b1100001, 0b1101001, },
/*0b0000010*/ { 0b0000010, 0b0000011, 0b0010000, 0b0010010, 0b1000010, 0b1000110, 0b1100010, 0b1101010, },
/*0b0000011*/ { 0b0000010, 0b0000011, 0b0010001, 0b0010011, 0b1000011, 0b1000111, 0b1100011, 0b1101011, },
/*0b0000100*/ { 0b0000100, 0b0000101, 0b0010100, 0b0010110, 0b1000000, 0b1000100, 0b1100100, 0b1101100, },
/*0b0000101*/ { 0b0000100, 0b0000101, 0b0010101, 0b0010111, 0b1000001, 0b1000101, 0b1100101, 0b1101101, },
/*0b0000110*/ { 0b0000110, 0b0000111, 0b0010100, 0b0010110, 0b1000010, 0b1000110, 0b1100110, 0b1101110, },
/*0b0000111*/ { 0b0000110, 0b0000111, 0b0010101, 0b0010111, 0b1000011, 0b1000111, 0b1100111, 0b1101111, },
/*0b0001000*/ { 0b0001000, 0b0001001, 0b0011000, 0b0011010, 0b1001000, 0b1001100, 0b1100000, 0b1101000, },
/*0b0001001*/ { 0b0001000, 0b0001001, 0b0011001, 0b0011011, 0b1001001, 0b1001101, 0b1100001, 0b1101001, },
/*0b0001010*/ { 0b0001010, 0b0001011, 0b0011000, 0b0011010, 0b1001010, 0b1001110, 0b1100010, 0b1101010, },
/*0b0001011*/ { 0b0001010, 0b0001011, 0b0011001, 0b0011011, 0b1001011, 0b1001111, 0b1100011, 0b1101011, },
/*0b0001100*/ { 0b0001100, 0b0001101, 0b0011100, 0b0011110, 0b1001000, 0b1001100, 0b1100100, 0b1101100, },
/*0b0001101*/ { 0b0001100, 0b0001101, 0b0011101, 0b0011111, 0b1001001, 0b1001101, 0b1100101, 0b1101101, },
/*0b0001110*/ { 0b0001110, 0b0001111, 0b0011100, 0b0011110, 0b1001010, 0b1001110, 0b1100110, 0b1101110, },
/*0b0001111*/ { 0b0001110, 0b0001111, 0b0011101, 0b0011111, 0b1001011, 0b1001111, 0b1100111, 0b1101111, },
/*0b0010000*/ { 0b0000000, 0b0000001, 0b0010000, 0b0010010, 0b1010000, 0b1010100, 0b1110000, 0b1111000, },
/*0b0010001*/ { 0b0000000, 0b0000001, 0b0010001, 0b0010011, 0b1010001, 0b1010101, 0b1110001, 0b1111001, },
/*0b0010010*/ { 0b0000010, 0b0000011, 0b0010000, 0b0010010, 0b1010010, 0b1010110, 0b1110010, 0b1111010, },
/*0b0010011*/ { 0b0000010, 0b0000011, 0b0010001, 0b0010011, 0b1010011, 0b1010111, 0b1110011, 0b1111011, },
/*0b0010100*/ { 0b0000100, 0b0000101, 0b0010100, 0b0010110, 0b1010000, 0b1010100, 0b1110100, 0b1111100, },
/*0b0010101*/ { 0b0000100, 0b0000101, 0b0010101, 0b0010111, 0b1010001, 0b1010101, 0b1110101, 0b1111101, },
/*0b0010110*/ { 0b0000110, 0b0000111, 0b0010100, 0b0010110, 0b1010010, 0b1010110, 0b1110110, 0b1111110, },
/*0b0010111*/ { 0b0000110, 0b0000111, 0b0010101, 0b0010111, 0b1010011, 0b1010111, 0b1110111, 0b1111111, },
/*0b0011000*/ { 0b0001000, 0b0001001, 0b0011000, 0b0011010, 0b1011000, 0b1011100, 0b1110000, 0b1111000, },
/*0b0011001*/ { 0b0001000, 0b0001001, 0b0011001, 0b0011011, 0b1011001, 0b1011101, 0b1110001, 0b1111001, },
/*0b0011010*/ { 0b0001010, 0b0001011, 0b0011000, 0b0011010, 0b1011010, 0b1011110, 0b1110010, 0b1111010, },
/*0b0011011*/ { 0b0001010, 0b0001011, 0b0011001, 0b0011011, 0b1011011, 0b1011111, 0b1110011, 0b1111011, },
/*0b0011100*/ { 0b0001100, 0b0001101, 0b0011100, 0b0011110, 0b1011000, 0b1011100, 0b1110100, 0b1111100, },
/*0b0011101*/ { 0b0001100, 0b0001101, 0b0011101, 0b0011111, 0b1011001, 0b1011101, 0b1110101, 0b1111101, },
/*0b0011110*/ { 0b0001110, 0b0001111, 0b0011100, 0b0011110, 0b1011010, 0b1011110, 0b1110110, 0b1111110, },
/*0b0011111*/ { 0b0001110, 0b0001111, 0b0011101, 0b0011111, 0b1011011, 0b1011111, 0b1110111, 0b1111111, },
/*0b0100000*/ { 0b0100000, 0b0100001, 0b0110000, 0b0110010, 0b1000000, 0b1000100, 0b1100000, 0b1101000, },
/*0b0100001*/ { 0b0100000, 0b0100001, 0b0110001, 0b0110011, 0b1000001, 0b1000101, 0b1100001, 0b1101001, },
/*0b0100010*/ { 0b0100010, 0b0100011, 0b0110000, 0b0110010, 0b1000010, 0b1000110, 0b1100010, 0b1101010, },
/*0b0100011*/ { 0b0100010, 0b0100011, 0b0110001, 0b0110011, 0b1000011, 0b1000111, 0b1100011, 0b1101011, },
/*0b0100100*/ { 0b0100100, 0b0100101, 0b0110100, 0b0110110, 0b1000000, 0b1000100, 0b1100100, 0b1101100, },
/*0b0100101*/ { 0b0100100, 0b0100101, 0b0110101, 0b0110111, 0b1000001, 0b1000101, 0b1100101, 0b1101101, },
/*0b0100110*/ { 0b0100110, 0b0100111, 0b0110100, 0b0110110, 0b1000010, 0b1000110, 0b1100110, 0b1101110, },
/*0b0100111*/ { 0b0100110, 0b0100111, 0b0110101, 0b0110111, 0b1000011, 0b1000111, 0b1100111, 0b1101111, },
/*0b0101000*/ { 0b0101000, 0b0101001, 0b0111000, 0b0111010, 0b1001000, 0b1001100, 0b1100000, 0b1101000, },
/*0b0101001*/ { 0b0101000, 0b0101001, 0b0111001, 0b0111011, 0b1001001, 0b1001101, 0b1100001, 0b1101001, },
/*0b0101010*/ { 0b0101010, 0b0101011, 0b0111000, 0b0111010, 0b1001010, 0b1001110, 0b1100010, 0b1101010, },
/*0b0101011*/ { 0b0101010, 0b0101011, 0b0111001, 0b0111011, 0b1001011, 0b1001111, 0b1100011, 0b1101011, },
/*0b0101100*/ { 0b0101100, 0b0101101, 0b0111100, 0b0111110, 0b1001000, 0b1001100, 0b1100100, 0b1101100, },
/*0b0101101*/ { 0b0101100, 0b0101101, 0b0111101, 0b0111111, 0b1001001, 0b1001101, 0b1100101, 0b1101101, },
/*0b0101110*/ { 0b0101110, 0b0101111, 0b0111100, 0b0111110, 0b1001010, 0b1001110, 0b1100110, 0b1101110, },
/*0b0101111*/ { 0b0101110, 0b0101111, 0b0111101, 0b0111111, 0b1001011, 0b1001111, 0b1100111, 0b1101111, },
/*0b0110000*/ { 0b0100000, 0b0100001, 0b0110000, 0b0110010, 0b1010000, 0b1010100, 0b1110000, 0b1111000, },
/*0b0110001*/ { 0b0100000, 0b0100001, 0b0110001, 0b0110011, 0b1010001, 0b1010101, 0b1110001, 0b1111001, },
/*0b0110010*/ { 0b0100010, 0b0100011, 0b0110000, 0b0110010, 0b1010010, 0b1010110, 0b1110010, 0b1111010, },
/*0b0110011*/ { 0b0100010, 0b0100011, 0b0110001, 0b0110011, 0b1010011, 0b1010111, 0b1110011, 0b1111011, },
/*0b0110100*/ { 0b0100100, 0b0100101, 0b0110100, 0b0110110, 0b1010000, 0b1010100, 0b1110100, 0b1111100, },
/*0b0110101*/ { 0b0100100, 0b0100101, 0b0110101, 0b0110111, 0b1010001, 0b1010101, 0b1110101, 0b1111101, },
/*0b0110110*/ { 0b0100110, 0b0100111, 0b0110100, 0b0110110, 0b1010010, 0b1010110, 0b1110110, 0b1111110, },
/*0b0110111*/ { 0b0100110, 0b0100111, 0b0110101, 0b0110111, 0b1010011, 0b1010111, 0b1110111, 0b1111111, },
/*0b0111000*/ { 0b0101000, 0b0101001, 0b0111000, 0b0111010, 0b1011000, 0b1011100, 0b1110000, 0b1111000, },
/*0b0111001*/ { 0b0101000, 0b0101001, 0b0111001, 0b0111011, 0b1011001, 0b1011101, 0b1110001, 0b1111001, },
/*0b0111010*/ { 0b0101010, 0b0101011, 0b0111000, 0b0111010, 0b1011010, 0b1011110, 0b1110010, 0b1111010, },
/*0b0111011*/ { 0b0101010, 0b0101011, 0b0111001, 0b0111011, 0b1011011, 0b1011111, 0b1110011, 0b1111011, },
/*0b0111100*/ { 0b0101100, 0b0101101, 0b0111100, 0b0111110, 0b1011000, 0b1011100, 0b1110100, 0b1111100, },
/*0b0111101*/ { 0b0101100, 0b0101101, 0b0111101, 0b0111111, 0b1011001, 0b1011101, 0b1110101, 0b1111101, },
/*0b0111110*/ { 0b0101110, 0b0101111, 0b0111100, 0b0111110, 0b1011010, 0b1011110, 0b1110110, 0b1111110, },
/*0b0111111*/ { 0b0101110, 0b0101111, 0b0111101, 0b0111111, 0b1011011, 0b1011111, 0b1110111, 0b1111111, },
/*0b1000000*/ { 0b0000000, 0b0000001, 0b0010000, 0b0010010, 0b1000000, 0b1000100, 0b1100000, 0b1101000, },
/*0b1000001*/ { 0b0000000, 0b0000001, 0b0010001, 0b0010011, 0b1000001, 0b1000101, 0b1100001, 0b1101001, },
/*0b1000010*/ { 0b0000010, 0b0000011, 0b0010000, 0b0010010, 0b1000010, 0b1000110, 0b1100010, 0b1101010, },
/*0b1000011*/ { 0b0000010, 0b0000011, 0b0010001, 0b0010011, 0b1000011, 0b1000111, 0b1100011, 0b1101011, },
/*0b1000100*/ { 0b0000100, 0b0000101, 0b0010100, 0b0010110, 0b1000000, 0b1000100, 0b1100100, 0b1101100, },
/*0b1000101*/ { 0b0000100, 0b0000101, 0b0010101, 0b0010111, 0b1000001, 0b1000101, 0b1100101, 0b1101101, },
/*0b1000110*/ { 0b0000110, 0b0000111, 0b0010100, 0b0010110, 0b1000010, 0b1000110, 0b1100110, 0b1101110, },
/*0b1000111*/ { 0b0000110, 0b0000111, 0b0010101, 0b0010111, 0b1000011, 0b1000111, 0b1100111, 0b1101111, },
/*0b1001000*/ { 0b0001000, 0b0001001, 0b0011000, 0b0011010, 0b1001000, 0b1001100, 0b1100000, 0b1101000, },
/*0b1001001*/ { 0b0001000, 0b0001001, 0b0011001, 0b0011011, 0b1001001, 0b1001101, 0b1100001, 0b1101001, },
/*0b1001010*/ { 0b0001010, 0b0001011, 0b0011000, 0b0011010, 0b1001010, 0b1001110, 0b1100010, 0b1101010, },
/*0b1001011*/ { 0b0001010, 0b0001011, 0b0011001, 0b0011011, 0b1001011, 0b1001111, 0b1100011, 0b1101011, },
/*0b1001100*/ { 0b0001100, 0b0001101, 0b0011100, 0b0011110, 0b1001000, 0b1001100, 0b1100100, 0b1101100, },
/*0b1001101*/ { 0b0001100, 0b0001101, 0b0011101, 0b0011111, 0b1001001, 0b1001101, 0b1100101, 0b1101101, },
/*0b1001110*/ { 0b0001110, 0b0001111, 0b0011100, 0b0011110, 0b1001010, 0b1001110, 0b1100110, 0b1101110, },
/*0b1001111*/ { 0b0001110, 0b0001111, 0b0011101, 0b0011111, 0b1001011, 0b1001111, 0b1100111, 0b1101111, },
/*0b1010000*/ { 0b0000000, 0b0000001, 0b0010000, 0b0010010, 0b1010000, 0b1010100, 0b1110000, 0b1111000, },
/*0b1010001*/ { 0b0000000, 0b0000001, 0b0010001, 0b0010011, 0b1010001, 0b1010101, 0b1110001, 0b1111001, },
/*0b1010010*/ { 0b0000010, 0b0000011, 0b0010000, 0b0010010, 0b1010010, 0b1010110, 0b1110010, 0b1111010, },
/*0b1010011*/ { 0b0000010, 0b0000011, 0b0010001, 0b0010011, 0b1010011, 0b1010111, 0b1110011, 0b1111011, },
/*0b1010100*/ { 0b0000100, 0b0000101, 0b0010100, 0b0010110, 0b1010000, 0b1010100, 0b1110100, 0b1111100, },
/*0b1010101*/ { 0b0000100, 0b0000101, 0b0010101, 0b0010111, 0b1010001, 0b1010101, 0b1110101, 0b1111101, },
/*0b1010110*/ { 0b0000110, 0b0000111, 0b0010100, 0b0010110, 0b1010010, 0b1010110, 0b1110110, 0b1111110, },
/*0b1010111*/ { 0b0000110, 0b0000111, 0b0010101, 0b0010111, 0b1010011, 0b1010111, 0b1110111, 0b1111111, },
/*0b1011000*/ { 0b0001000, 0b0001001, 0b0011000, 0b0011010, 0b1011000, 0b1011100, 0b1110000, 0b1111000, },
/*0b1011001*/ { 0b0001000, 0b0001001, 0b0011001, 0b0011011, 0b1011001, 0b1011101, 0b1110001, 0b1111001, },
/*0b1011010*/ { 0b0001010, 0b0001011, 0b0011000, 0b0011010, 0b1011010, 0b1011110, 0b1110010, 0b1111010, },
/*0b1011011*/ { 0b0001010, 0b0001011, 0b0011001, 0b0011011, 0b1011011, 0b1011111, 0b1110011, 0b1111011, },
/*0b1011100*/ { 0b0001100, 0b0001101, 0b0011100, 0b0011110, 0b1011000, 0b1011100, 0b1110100, 0b1111100, },
/*0b1011101*/ { 0b0001100, 0b0001101, 0b0011101, 0b0011111, 0b1011001, 0b1011101, 0b1110101, 0b1111101, },
/*0b1011110*/ { 0b0001110, 0b0001111, 0b0011100, 0b0011110, 0b1011010, 0b1011110, 0b1110110, 0b1111110, },
/*0b1011111*/ { 0b0001110, 0b0001111, 0b0011101, 0b0011111, 0b1011011, 0b1011111, 0b1110111, 0b1111111, },
/*0b1100000*/ { 0b0100000, 0b0100001, 0b0110000, 0b0110010, 0b1000000, 0b1000100, 0b1100000, 0b1101000, },
/*0b1100001*/ { 0b0100000, 0b0100001, 0b0110001, 0b0110011, 0b1000001, 0b1000101, 0b1100001, 0b1101001, },
/*0b1100010*/ { 0b0100010, 0b0100011, 0b0110000, 0b0110010, 0b1000010, 0b1000110, 0b1100010, 0b1101010, },
/*0b1100011*/ { 0b0100010, 0b0100011, 0b0110001, 0b0110011, 0b1000011, 0b1000111, 0b1100011, 0b1101011, },
/*0b1100100*/ { 0b0100100, 0b0100101, 0b0110100, 0b0110110, 0b1000000, 0b1000100, 0b1100100, 0b1101100, },
/*0b1100101*/ { 0b0100100, 0b0100101, 0b0110101, 0b0110111, 0b1000001, 0b1000101, 0b1100101, 0b1101101, },
/*0b1100110*/ { 0b0100110, 0b0100111, 0b0110100, 0b0110110, 0b1000010, 0b1000110, 0b1100110, 0b1101110, },
/*0b1100111*/ { 0b0100110, 0b0100111, 0b0110101, 0b0110111, 0b1000011, 0b1000111, 0b1100111, 0b1101111, },
/*0b1101000*/ { 0b0101000, 0b0101001, 0b0111000, 0b0111010, 0b1001000, 0b1001100, 0b1100000, 0b1101000, },
/*0b1101001*/ { 0b0101000, 0b0101001, 0b0111001, 0b0111011, 0b1001001, 0b1001101, 0b1100001, 0b1101001, },
/*0b1101010*/ { 0b0101010, 0b0101011, 0b0111000, 0b0111010, 0b1001010, 0b1001110, 0b1100010, 0b1101010, },
/*0b1101011*/ { 0b0101010, 0b0101011, 0b0111001, 0b0111011, 0b1001011, 0b1001111, 0b1100011, 0b1101011, },
/*0b1101100*/ { 0b0101100, 0b0101101, 0b0111100, 0b0111110, 0b1001000, 0b1001100, 0b1100100, 0b1101100, },
/*0b1101101*/ { 0b0101100, 0b0101101, 0b0111101, 0b0111111, 0b1001001, 0b1001101, 0b1100101, 0b1101101, },
/*0b1101110*/ { 0b0101110, 0b0101111, 0b0111100, 0b0111110, 0b1001010, 0b1001110, 0b1100110, 0b1101110, },
/*0b1101111*/ { 0b0101110, 0b0101111, 0b0111101, 0b0111111, 0b1001011, 0b1001111, 0b1100111, 0b1101111, },
/*0b1110000*/ { 0b0100000, 0b0100001, 0b0110000, 0b0110010, 0b1010000, 0b1010100, 0b1110000, 0b1111000, },
/*0b1110001*/ { 0b0100000, 0b0100001, 0b0110001, 0b0110011, 0b1010001, 0b1010101, 0b1110001, 0b1111001, },
/*0b1110010*/ { 0b0100010, 0b0100011, 0b0110000, 0b0110010, 0b1010010, 0b1010110, 0b1110010, 0b1111010, },
/*0b1110011*/ { 0b0100010, 0b0100011, 0b0110001, 0b0110011, 0b1010011, 0b1010111, 0b1110011, 0b1111011, },
/*0b1110100*/ { 0b0100100, 0b0100101, 0b0110100, 0b0110110, 0b1010000, 0b1010100, 0b1110100, 0b1111100, },
/*0b1110101*/ { 0b0100100, 0b0100101, 0b0110101, 0b0110111, 0b1010001, 0b1010101, 0b1110101, 0b1111101, },
/*0b1110110*/ { 0b0100110, 0b0100111, 0b0110100, 0b0110110, 0b1010010, 0b1010110, 0b1110110, 0b1111110, },
/*0b1110111*/ { 0b0100110, 0b0100111, 0b0110101, 0b0110111, 0b1010011, 0b1010111, 0b1110111, 0b1111111, },
/*0b1111000*/ { 0b0101000, 0b0101001, 0b0111000, 0b0111010, 0b1011000, 0b1011100, 0b1110000, 0b1111000, },
/*0b1111001*/ { 0b0101000, 0b0101001, 0b0111001, 0b0111011, 0b1011001, 0b1011101, 0b1110001, 0b1111001, },
/*0b1111010*/ { 0b0101010, 0b0101011, 0b0111000, 0b0111010, 0b1011010, 0b1011110, 0b1110010, 0b1111010, },
/*0b1111011*/ { 0b0101010, 0b0101011, 0b0111001, 0b0111011, 0b1011011, 0b1011111, 0b1110011, 0b1111011, },
/*0b1111100*/ { 0b0101100, 0b0101101, 0b0111100, 0b0111110, 0b1011000, 0b1011100, 0b1110100, 0b1111100, },
/*0b1111101*/ { 0b0101100, 0b0101101, 0b0111101, 0b0111111, 0b1011001, 0b1011101, 0b1110101, 0b1111101, },
/*0b1111110*/ { 0b0101110, 0b0101111, 0b0111100, 0b0111110, 0b1011010, 0b1011110, 0b1110110, 0b1111110, },
/*0b1111111*/ { 0b0101110, 0b0101111, 0b0111101, 0b0111111, 0b1011011, 0b1011111, 0b1110111, 0b1111111, },
};
static const uint8_t NAME_(lru8_old_table)[128] = {
/*0b0000000*/ 0b00000111,
/*0b0000001*/ 0b00000111,
/*0b0000010*/ 0b00000111,
/*0b0000011*/ 0b00000111,
/*0b0000100*/ 0b00000111,
/*0b0000101*/ 0b00000111,
/*0b0000110*/ 0b00000111,
/*0b0000111*/ 0b00000111,
/*0b0001000*/ 0b00000110,
/*0b0001001*/ 0b00000110,
/*0b0001010*/ 0b00000110,
/*0b0001011*/ 0b00000110,
/*0b0001100*/ 0b00000110,
/*0b0001101*/ 0b00000110,
/*0b0001110*/ 0b00000110,
/*0b0001111*/ 0b00000110,
/*0b0010000*/ 0b00000111,
/*0b0010001*/ 0b00000111,
/*0b0010010*/ 0b00000111,
/*0b0010011*/ 0b00000111,
/*0b0010100*/ 0b00000111,
/*0b0010101*/ 0b00000111,
/*0b0010110*/ 0b00000111,
/*0b0010111*/ 0b00000111,
/*0b0011000*/ 0b00000110,
/*0b0011001*/ 0b00000110,
/*0b0011010*/ 0b00000110,
/*0b0011011*/ 0b00000110,
/*0b0011100*/ 0b00000110,
/*0b0011101*/ 0b00000110,
/*0b0011110*/ 0b00000110,
/*0b0011111*/ 0b00000110,
/*0b0100000*/ 0b00000101,
/*0b0100001*/ 0b00000101,
/*0b0100010*/ 0b00000101,
/*0b0100011*/ 0b00000101,
/*0b0100100*/ 0b00000100,
/*0b0100101*/ 0b00000100,
/*0b0100110*/ 0b00000100,
/*0b0100111*/ 0b00000100,
/*0b0101000*/ 0b00000101,
/*0b0101001*/ 0b00000101,
/*0b0101010*/ 0b00000101,
/*0b0101011*/ 0b00000101,
/*0b0101100*/ 0b00000100,
/*0b0101101*/ 0b00000100,
/*0b0101110*/ 0b00000100,
/*0b0101111*/ 0b00000100,
/*0b0110000*/ 0b00000101,
/*0b0110001*/ 0b00000101,
/*0b0110010*/ 0b00000101,
/*0b0110011*/ 0b00000101,
/*0b0110100*/ 0b00000100,
/*0b0110101*/ 0b00000100,
/*0b0110110*/ 0b00000100,
/*0b0110111*/ 0b00000100,
/*0b0111000*/ 0b00000101,
/*0b0111001*/ 0b00000101,
/*0b0111010*/ 0b00000101,
/*0b0111011*/ 0b00000101,
/*0b0111100*/ 0b00000100,
/*0b0111101*/ 0b00000100,
/*0b0111110*/ 0b00000100,
/*0b0111111*/ 0b00000100,
/*0b1000000*/ 0b00000011,
/*0b1000001*/ 0b00000011,
/*0b1000010*/ 0b00000010,
/*0b1000011*/ 0b00000010,
/*0b1000100*/ 0b00000011,
/*0b1000101*/ 0b00000011,
/*0b1000110*/ 0b00000010,
/*0b1000111*/ 0b00000010,
/*0b1001000*/ 0b00000011,
/*0b1001001*/ 0b00000011,
/*0b1001010*/ 0b00000010,
/*0b1001011*/ 0b00000010,
/*0b1001100*/ 0b00000011,
/*0b1001101*/ 0b00000011,
/*0b1001110*/ 0b00000010,
/*0b1001111*/ 0b00000010,
/*0b1010000*/ 0b00000001,
/*0b1010001*/ 0b00000000,
/*0b1010010*/ 0b00000001,
/*0b1010011*/ 0b00000000,
/*0b1010100*/ 0b00000001,
/*0b1010101*/ 0b00000000,
/*0b1010110*/ 0b00000001,
/*0b1010111*/ 0b00000000,
/*0b1011000*/ 0b00000001,
/*0b1011001*/ 0b00000000,
/*0b1011010*/ 0b00000001,
/*0b1011011*/ 0b00000000,
/*0b1011100*/ 0b00000001,
/*0b1011101*/ 0b00000000,
/*0b1011110*/ 0b00000001,
/*0b1011111*/ 0b00000000,
/*0b1100000*/ 0b00000011,
/*0b1100001*/ 0b00000011,
/*0b1100010*/ 0b00000010,
/*0b1100011*/ 0b00000010,
/*0b1100100*/ 0b00000011,
/*0b1100101*/ 0b00000011,
/*0b1100110*/ 0b00000010,
/*0b1100111*/ 0b00000010,
/*0b1101000*/ 0b00000011,
/*0b1101001*/ 0b00000011,
/*0b1101010*/ 0b00000010,
/*0b1101011*/ 0b00000010,
/*0b1101100*/ 0b00000011,
/*0b1101101*/ 0b00000011,
/*0b1101110*/ 0b00000010,
/*0b1101111*/ 0b00000010,
/*0b1110000*/ 0b00000001,
/*0b1110001*/ 0b00000000,
/*0b1110010*/ 0b00000001,
/*0b1110011*/ 0b00000000,
/*0b1110100*/ 0b00000001,
/*0b1110101*/ 0b00000000,
/*0b1110110*/ 0b00000001,
/*0b1110111*/ 0b00000000,
/*0b1111000*/ 0b00000001,
/*0b1111001*/ 0b00000000,
/*0b1111010*/ 0b00000001,
/*0b1111011*/ 0b00000000,
/*0b1111100*/ 0b00000001,
/*0b1111101*/ 0b00000000,
/*0b1111110*/ 0b00000001,
/*0b1111111*/ 0b00000000,
};

static void
NAME_(_lru_set)(uint8_t *info, int off, int bit)
{
	info[off / 8] &= ~(1 << (off % 8));
	info[off / 8] |= bit << (off % 8);
}

static int
NAME_(_lru_get)(uint8_t *info, int off)
{
	return (info[off / 8] >> (off % 8)) & 1;
}

#if DUMP
static void
NAME_(_lru_dump)(int count, uint8_t *info, int off)
{
	int i;

	fprintf(stderr, "lru %p: ", info);
	for (i = 0; i < count - 1; i++) {
		fprintf(stderr, "%d", NAME_(_lru_get)(info, off + i));
	}
	fprintf(stderr, "\n");
}
#endif

static void
NAME_(_lru_use)(int count, uint8_t *info, int off, int used)
{
	if (1 < count) {
		int bit;

		bit = used & 1;
		used >>= 1;
		count >>= 1;
		NAME_(_lru_set)(info, off + used, bit);
		NAME_(_lru_use)(count, info, off + count, used);
	}
}

static void
NAME_(lrux_use)(int count, uint8_t *info, int used)
{
#if DUMP
	fprintf(stderr, "%s: %p, %d\n", __FUNCTION__, info, used);
	NAME_(_lru_dump)(count, info, 0);
#endif
	NAME_(_lru_use)(count, info, 0, used);
#if DUMP
	NAME_(_lru_dump)(count, info, 0);
#endif
}

static int
NAME_(_lru_oldest)(int count, uint8_t *info, int off)
{
	int oldest;

	if (1 < count) {
		count >>= 1;
		oldest = NAME_(_lru_oldest)(count, info, off + count);
		oldest = (oldest << 1) + ! NAME_(_lru_get)(info, off + oldest);
	} else {
		oldest = 0;
	}

	return oldest;
}

static int
NAME_(lrux_oldest)(int count, uint8_t *info)
{
	int oldest;

#if DUMP
	fprintf(stderr, "%s: %p\n", __FUNCTION__, info);
	NAME_(_lru_dump)(count, info, 0);
#endif
	oldest = NAME_(_lru_oldest)(count, info, 0);
#if DUMP
	fprintf(stderr, "-> %d\n", oldest);
#endif

	return oldest;
}

static void
NAME_(lrux_reset)(int count, uint8_t *info)
{
	int i;

#if DUMP
	fprintf(stderr, "%s: %p\n", __FUNCTION__, info);
#endif
	for (i = 0; i < count; i++) {
		NAME_(_lru_set)(info, i, 0);
	}
#if DUMP
	NAME_(_lru_dump)(count, info, 0);
#endif
}

static void
NAME_(lru_use)(int count, uint8_t *info, int used)
{
        switch (count) {
        case 1:
                break;
        case 2:
                *info = used;
                break;
        case 4:
                *info = NAME_(lru4_use_table)[*info][used];
                break;
        case 8: 
                *info = NAME_(lru8_use_table)[*info][used];
                break;
        default:
                NAME_(lrux_use)(count, info, used);
                break;
        }
}       

static int
NAME_(lru_oldest)(int count, uint8_t *info)
{
        switch (count) {
        case 1:
                return 0;
        case 2:
                return ! *info;
        case 4: 
                return NAME_(lru4_old_table)[*info];
        case 8:
                return NAME_(lru8_old_table)[*info];
        default:
                return NAME_(lrux_oldest)(count, info);
        }       
}               
        
static void
NAME_(lru_reset)(int count, uint8_t *info)
{
        switch (count) {
        case 1:
        case 2:
        case 4:
        case 8:
                *info = 0;
                break;
        default:
                NAME_(lrux_reset)(count, info);
                break;
        }
}
