# $Id: acinclude.m4,v 1.45 2011-08-14 21:08:11 potyra Exp $
#
# Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.

# usage: AC_USE_LIB(VARIABLE, LIB, FUNC)
# will add to <VARIABLE>_LIBS or undef HAVE_<VARIABLE>
# Martin Waitz <tali@admingilde.org>
AC_DEFUN([AC_USE_LIB], [
	AC_CHECK_LIB($2, $3, [
		$1_LIBS="-l$2 $$1_LIBS"
	], [HAVE_$1=], "$$1_LIBS")
])

# usage: AC_SEARCH_HEADER(VARIABLE, header.h, possible dirs)
# will make sure that header.h can be included with VARIABLE_CFLAGS
# possible dirs are searched for.
# Martin Waitz <tali@admingilde.org>
AC_DEFUN([AC_SEARCH_HEADER], [
	AC_MSG_CHECKING([for $2])
	ac_save_CFLAGS="$CFLAGS"
	CFLAGS="$$1_CFLAGS"
	ac_search_header_result=no
	AC_COMPILE_IFELSE([AC_LANG_SOURCE([@%:@include <$2>])], 
		ac_search_header_result=yes, [
		for ac_dir in $3; do
			CFLAGS="$$1_CFLAGS -I$ac_dir"
			AC_COMPILE_IFELSE([AC_LANG_SOURCE([@%:@include <$2>])], 
				[$1_CFLAGS="$CFLAGS"; ac_search_header_result="-I$ac_dir"; break])
		done
	])
	CFLAGS="$ac_save_CFLAGS"
	if test $ac_search_header_result = no; then
		HAVE_$1=no
	fi
	AC_MSG_RESULT([$ac_search_header_result])
])

# usage: AC_PROG_CC_OPTION(--compiler-option, if-supported, if-unsupported)
# add this option to $(CC) if it is supported by the compiler
# if no sc
# Martin Waitz <tali@admingilde.org>
AC_DEFUN([AC_PROG_CC_OPTION], [
	AC_MSG_CHECKING([whether $CC supports $1])
	ac_save_CC="$CC"
	CC="$CC $1"
	AC_COMPILE_IFELSE([AC_LANG_PROGRAM([])],[
		AC_MSG_RESULT([yes])
		ifelse($2, , [], [
		CC="$ac_save_CC"
		$2])
	], [
		AC_MSG_RESULT([no])
		CC="$ac_save_CC"
		$3
	])
])


# as-ac-expand.m4 0.1.0
# autostars m4 macro for expanding directories using configure's prefix
# thomas@apestaart.org 

dnl AS_AC_EXPAND(VAR, CONFIGURE_VAR)
dnl
dnl example
dnl AS_AC_EXPAND(SYSCONFDIR, $sysconfdir)
dnl will set SYSCONFDIR to /usr/local/etc if prefix=/usr/local

AC_DEFUN([AS_AC_EXPAND],
[
  EXP_VAR=[$1]
  FROM_VAR=[$2]

  dnl first expand prefix and exec_prefix if necessary
  prefix_save=$prefix
  exec_prefix_save=$exec_prefix

  dnl if no prefix given, then use /usr/local, the default prefix
  if test "x$prefix" = "xNONE"; then
    prefix=$ac_default_prefix
  fi
  dnl if no exec_prefix given, then use prefix
  if test "x$exec_prefix" = "xNONE"; then
    exec_prefix=$prefix
  fi

  full_var="$FROM_VAR"
  dnl loop until it doesn't change anymore
  while true; do
    new_full_var="`eval echo $full_var`"
    if test "x$new_full_var" = "x$full_var"; then break; fi
    full_var=$new_full_var
  done

  dnl clean up
  full_var=$new_full_var
  AC_SUBST([$1], "$full_var")

  dnl restore prefix and exec_prefix
  prefix=$prefix_save
  exec_prefix=$exec_prefix_save
])


# AC_ARG_DEFINE(argument, variable, default, help text)
# will add a commandline switch --enable/disable-argument which
# controls the C preprocessor define 'variable'.
# 'default' should be yes or no.
# 'help text' will be used for commandline description and for config.h
# Martin Waitz <tali@admingilde.org>
AC_DEFUN([AC_ARG_DEFINE],
[
AC_ARG_ENABLE($1,
	ifelse([$3], yes,
		AC_HELP_STRING([--disable-$1], [don't $4]),
		AC_HELP_STRING([--enable-$1], [$4])),
	[ac_arg_define_$2=$enableval], [ac_arg_define_$2=$3]
)
if test "$ac_arg_define_$2" = yes; then ac_arg_define_$2=1; fi
if test "$ac_arg_define_$2" = no;  then ac_arg_define_$2=0; fi
AC_DEFINE_UNQUOTED([$2], $ac_arg_define_$2, $4)
])


dnl check for macosx core audio

AC_DEFUN([CHECK_MACOSX_AUDIO],
[
	AC_ARG_ENABLE(macosx, [  --enable-macosx         include MAC OS X audio output plugin ],
	[ BUILD_MACOSX_AUDIO="$enableval" ], [ BUILD_MACOSX_AUDIO="yes" ])

	if test "$BUILD_MACOSX_AUDIO" = "yes"; then
		AC_MSG_CHECKING([for macosx audio])

		case ${host} in
			*-apple-darwin*)
				macosx_version=yes
				;;
			*)
				macosx_version=no
				;;
		esac

		ao_macosx=no
		if test "$macosx_version" = "yes"; then
			AC_DEFINE([USE_MACOSX_AUDIO],[1],[support macosx])
			ao_macosx=yes
			LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -framework Carbon -framework CoreAudio -framework AudioUnit"
		fi

		AM_CONDITIONAL(AO_MACOSX, test $ao_macosx = yes)
		AC_SUBST([LIBAO_DEP_LIBS])

		AC_MSG_RESULT($macosx_version)
	fi

])

dnl check for installed oss

dnl JOSEF FIXME ... test with correct dyn. inc
dnl	#include ${oss_inc}]],[[int arg = SNDCTL_DSP_SETFRAGMENT;

AC_DEFUN([CHECK_OSS],
[
	AC_ARG_ENABLE(oss, [  --enable-oss            include OSS output plugin ],
	[ BUILD_OSS="$enableval" ], [ BUILD_OSS="yes" ])

	if test "$BUILD_OSS" = "yes"; then
		AC_CHECK_HEADERS(sys/soundcard.h,[oss_inc="#include<sys/soundcard.h>"])
		if test "$ac_cv_header_sys_soundcard_h" != "yes"; then
			AC_CHECK_HEADERS(soundcard.h,[oss_inc="#include<soundcard.h>"])
		fi
		AC_MSG_CHECKING([for oss])
		AC_CACHE_VAL(faum_cv_oss_version,
			[
			AC_LINK_IFELSE(
				[AC_LANG_PROGRAM([[
					#include <sys/ioctl.h>
					#include <sys/soundcard.h>]],[[int arg = SNDCTL_DSP_SETFRAGMENT;
					exit(0);
					]])
				],
				faum_cv_oss_version=yes,
				faum_cv_oss_version=no)

		])

		ao_oss=no
		if test "$faum_cv_oss_version" = "yes"; then
			AC_DEFINE([USE_OSS_AUDIO],[1],[support oss])
			ao_oss=yes
			AC_DEFINE([PATH_DEV_DSP],
				["/dev/dsp"],
				[dsp sound device])
			AC_DEFINE([PATH_DEV_MIXER],
				["/dev/mixer"],
				[sound mixer device])
		fi

		AM_CONDITIONAL(AO_OSS, test $ao_oss = yes)

		AC_MSG_RESULT($faum_cv_oss_version)
	fi

])

dnl checks for alsa version between 0.5 and 1.0

AC_DEFUN([CHECK_ALSA],
[
	AC_ARG_ENABLE(alsa, [  --enable-alsa           include appropriate alsa output plugin ],
		[ BUILD_ALSA="$enableval" ],[ BUILD_ALSA="yes" ])

	if test "$BUILD_ALSA" = "yes"; then
		AC_CHECK_HEADERS(alsa/asoundlib.h sys/asoundlib.h)
		AC_MSG_CHECKING([for alsa version >= 0.5])
		AC_CACHE_VAL(faum_cv_alsa_version,
		[
			save_libs="$LIBS"
			LIBS="-lasound $LIBS"
			AC_RUN_IFELSE(
				[AC_LANG_PROGRAM(
					[[#include <sys/asoundlib.h>]],
					[[exit(!(SND_LIB_MAJOR==0 &&
					SND_LIB_MINOR==5));]])],
				faum_cv_alsa_version=0.5.x,
				faum_cv_alsa_version=no)
			LIBS="$save_LIBS"
			
			if test "$faum_cv_alsa_version" = "no"; then
				save_libs="$LIBS"
				LIBS="-lasound $LIBS"
				AC_RUN_IFELSE(
					[AC_LANG_PROGRAM(
						[[#include <alsa/asoundlib.h>]],
						[[exit(!(SND_LIB_MAJOR==0 &&
						SND_LIB_MINOR==9));]])],
					faum_cv_alsa_version=0.9.x-alsa,
					faum_cv_alsa_version=no)
				LIBS="$save_LIBS"
			fi
			
			if test "$faum_cv_alsa_version" = "no"; then
				save_libs="$LIBS"
				LIBS="-lasound $LIBS"
				AC_RUN_IFELSE(
					[AC_LANG_PROGRAM(
						[[#include <sys/asoundlib.h>]],
						[[exit(!(SND_LIB_MAJOR==0 &&
						SND_LIB_MINOR==9));]])],
					faum_cv_alsa_version=0.9.x-sys,
					faum_cv_alsa_version=no)
				LIBS="$save_LIBS"
			fi
			
			if test "$faum_cv_alsa_version" = "no"; then
				save_libs="$LIBS"
				LIBS="-lasound $LIBS"
				AC_RUN_IFELSE(
					[AC_LANG_PROGRAM(
						[[#include <alsa/asoundlib.h>]],
						[[exit(!(SND_LIB_MAJOR==1 &&
						SND_LIB_MINOR==0));]])],
					faum_cv_alsa_version=1.0.x-alsa,
					faum_cv_alsa_version=no)
				LIBS="$save_LIBS"
			fi
			
			if test "$faum_cv_alsa_version" = "no"; then
				save_libs="$LIBS"
				LIBS="-lasound $LIBS"
				AC_RUN_IFELSE(
					[AC_LANG_PROGRAM(
						[[#include <sys/asoundlib.h>]],
						[[exit(!(SND_LIB_MAJOR==1 &&
						SND_LIB_MINOR==0));]])],
					faum_cv_alsa_version=1.0.x-sys,
					faum_cv_alsa_version=no)
				LIBS="$save_LIBS"
			fi
		])

		ao_alsa1x="no"

		if test "$faum_cv_alsa_version" != "no" ; then
			if test "$faum_cv_alsa_version" = "1.0.x-sys" ; then
				AC_DEFINE([HAVE_ALSA1X],[1],[using alsa 1.x])
				ao_alsa1x="yes"
				echo "yes (using alsa 1.0.x and sys/asoundlib.h)"
			elif test "$faum_cv_alsa_version" = "1.0.x-alsa" ; then
				AC_DEFINE([HAVE_ALSA1X],[1],[using alsa 1.x])
				ao_alsa1x="yes"
				echo "yes (using alsa 1.0.x and alsa/asoundlib.h)"
			fi
dnl			LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -lasound -ldl -lpthread"
			LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -ldl"
			AC_DEFINE(MAX_OUTBURST, 65536, [ set up max. outburst. use 65536 for ALSA0.5, for others 16384 is enough])
			AC_DEFINE(OUTBURST, 512, [audio outburst, no clue what this means])

		else 
			AC_MSG_RESULT($faum_cv_alsa_version)
		fi
	fi

	AC_SUBST([LIBAO_DEP_LIBS])
	AM_CONDITIONAL(AO_ALSA1X, test "$ao_alsa1x" = "yes")
])

dnl Check for PulseAudio

AC_DEFUN([CHECK_PULSE],
[
	AC_ARG_ENABLE(pulse, [  --enable-pulse          include PulseAudio output plugin ],
	        [ BUILD_PULSE="$enableval" ], [ BUILD_PULSE="yes" ])
	
	ao_pulse="no"

	if test "$BUILD_PULSE" = "yes"; then
		AC_CHECK_HEADERS(pulse/pulseaudio.h)
		AC_MSG_CHECKING([for pulse])
		if test "$ac_cv_header_pulse_pulseaudio_h" = "yes"; then
		   ao_pulse="yes"
		   LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -ldl"
dnl		   LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -lpulse"
		   AC_DEFINE([USE_PULSE],[1],[pulse plugin])
		   AC_MSG_RESULT($ao_pulse)
		fi
	fi

	AC_SUBST([LIBAO_DEP_LIBS])
	AM_CONDITIONAL(AO_PULSE, test "$ao_pulse" = "yes")
])

dnl Check for eSound

AC_DEFUN([CHECK_ESD],
[
	AC_ARG_ENABLE(esd, [  --enable-esd            include eSound output plugin ],
	        [ BUILD_ESD="$enableval" ], [ BUILD_ESD="yes" ])
	
	ao_esd="no"

	if test "$BUILD_ESD" = "yes"; then
		AC_CHECK_HEADERS(esd.h)
		AC_MSG_CHECKING([for esd])
		if test "$ac_cv_header_esd_h" = "yes"; then
		   ao_esd="yes"
		   LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -ldl"
dnl		   LIBAO_DEP_LIBS="$LIBAO_DEP_LIBS -lesd -laudiofile -lm"
		   AC_DEFINE([USE_ESD],[1],[esd plugin])
		   AC_MSG_RESULT($ao_esd)
		fi
	fi

	AC_SUBST([LIBAO_DEP_LIBS])
	AM_CONDITIONAL(AO_ESD, test "$ao_esd" = "yes")
])

# ===========================================================================
#        http://www.gnu.org/software/autoconf-archive/ax_pthread.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_PTHREAD([ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]])
#
# DESCRIPTION
#
#   This macro figures out how to build C programs using POSIX threads. It
#   sets the PTHREAD_LIBS output variable to the threads library and linker
#   flags, and the PTHREAD_CFLAGS output variable to any special C compiler
#   flags that are needed. (The user can also force certain compiler
#   flags/libs to be tested by setting these environment variables.)
#
#   Also sets PTHREAD_CC to any special C compiler that is needed for
#   multi-threaded programs (defaults to the value of CC otherwise). (This
#   is necessary on AIX to use the special cc_r compiler alias.)
#
#   NOTE: You are assumed to not only compile your program with these flags,
#   but also link it with them as well. e.g. you should link with
#   $PTHREAD_CC $CFLAGS $PTHREAD_CFLAGS $LDFLAGS ... $PTHREAD_LIBS $LIBS
#
#   If you are only building threads programs, you may wish to use these
#   variables in your default LIBS, CFLAGS, and CC:
#
#     LIBS="$PTHREAD_LIBS $LIBS"
#     CFLAGS="$CFLAGS $PTHREAD_CFLAGS"
#     CC="$PTHREAD_CC"
#
#   In addition, if the PTHREAD_CREATE_JOINABLE thread-attribute constant
#   has a nonstandard name, defines PTHREAD_CREATE_JOINABLE to that name
#   (e.g. PTHREAD_CREATE_UNDETACHED on AIX).
#
#   Also HAVE_PTHREAD_PRIO_INHERIT is defined if pthread is found and the
#   PTHREAD_PRIO_INHERIT symbol is defined when compiling with
#   PTHREAD_CFLAGS.
#
#   ACTION-IF-FOUND is a list of shell commands to run if a threads library
#   is found, and ACTION-IF-NOT-FOUND is a list of commands to run it if it
#   is not found. If ACTION-IF-FOUND is not specified, the default action
#   will define HAVE_PTHREAD.
#
#   Please let the authors know if this macro fails on any platform, or if
#   you have any other suggestions or comments. This macro was based on work
#   by SGJ on autoconf scripts for FFTW (http://www.fftw.org/) (with help
#   from M. Frigo), as well as ac_pthread and hb_pthread macros posted by
#   Alejandro Forero Cuervo to the autoconf macro repository. We are also
#   grateful for the helpful feedback of numerous users.
#
#   Updated for Autoconf 2.68 by Daniel Richard G.
#
# LICENSE
#
#   Copyright (c) 2008 Steven G. Johnson <stevenj@alum.mit.edu>
#   Copyright (c) 2011 Daniel Richard G. <skunk@iSKUNK.ORG>
#
#   This program is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation, either version 3 of the License, or (at your
#   option) any later version.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
#   Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program. If not, see <http://www.gnu.org/licenses/>.
#
#   As a special exception, the respective Autoconf Macro's copyright owner
#   gives unlimited permission to copy, distribute and modify the configure
#   scripts that are the output of Autoconf when processing the Macro. You
#   need not follow the terms of the GNU General Public License when using
#   or distributing such scripts, even though portions of the text of the
#   Macro appear in them. The GNU General Public License (GPL) does govern
#   all other use of the material that constitutes the Autoconf Macro.
#
#   This special exception to the GPL applies to versions of the Autoconf
#   Macro released by the Autoconf Archive. When you make and distribute a
#   modified version of the Autoconf Macro, you may extend this special
#   exception to the GPL to apply to your modified version as well.

AU_ALIAS([ACX_PTHREAD], [AX_PTHREAD])
AC_DEFUN([AX_PTHREAD], [
AC_REQUIRE([AC_CANONICAL_HOST])
AC_LANG_PUSH([C])
ax_pthread_ok=no

# We used to check for pthread.h first, but this fails if pthread.h
# requires special compiler flags (e.g. on True64 or Sequent).
# It gets checked for in the link test anyway.

# First of all, check if the user has set any of the PTHREAD_LIBS,
# etcetera environment variables, and if threads linking works using
# them:
if test x"$PTHREAD_LIBS$PTHREAD_CFLAGS" != x; then
        save_CFLAGS="$CFLAGS"
        CFLAGS="$CFLAGS $PTHREAD_CFLAGS"
        save_LIBS="$LIBS"
        LIBS="$PTHREAD_LIBS $LIBS"
        AC_MSG_CHECKING([for pthread_join in LIBS=$PTHREAD_LIBS with CFLAGS=$PTHREAD_CFLAGS])
        AC_TRY_LINK_FUNC(pthread_join, ax_pthread_ok=yes)
        AC_MSG_RESULT($ax_pthread_ok)
        if test x"$ax_pthread_ok" = xno; then
                PTHREAD_LIBS=""
                PTHREAD_CFLAGS=""
        fi
        LIBS="$save_LIBS"
        CFLAGS="$save_CFLAGS"
fi

# We must check for the threads library under a number of different
# names; the ordering is very important because some systems
# (e.g. DEC) have both -lpthread and -lpthreads, where one of the
# libraries is broken (non-POSIX).

# Create a list of thread flags to try.  Items starting with a "-" are
# C compiler flags, and other items are library names, except for "none"
# which indicates that we try without any flags at all, and "pthread-config"
# which is a program returning the flags for the Pth emulation library.

ax_pthread_flags="pthreads none -Kthread -kthread lthread -pthread -pthreads -mthreads pthread --thread-safe -mt pthread-config"

# The ordering *is* (sometimes) important.  Some notes on the
# individual items follow:

# pthreads: AIX (must check this before -lpthread)
# none: in case threads are in libc; should be tried before -Kthread and
#       other compiler flags to prevent continual compiler warnings
# -Kthread: Sequent (threads in libc, but -Kthread needed for pthread.h)
# -kthread: FreeBSD kernel threads (preferred to -pthread since SMP-able)
# lthread: LinuxThreads port on FreeBSD (also preferred to -pthread)
# -pthread: Linux/gcc (kernel threads), BSD/gcc (userland threads)
# -pthreads: Solaris/gcc
# -mthreads: Mingw32/gcc, Lynx/gcc
# -mt: Sun Workshop C (may only link SunOS threads [-lthread], but it
#      doesn't hurt to check since this sometimes defines pthreads too;
#      also defines -D_REENTRANT)
#      ... -mt is also the pthreads flag for HP/aCC
# pthread: Linux, etcetera
# --thread-safe: KAI C++
# pthread-config: use pthread-config program (for GNU Pth library)

case ${host_os} in
        solaris*)

        # On Solaris (at least, for some versions), libc contains stubbed
        # (non-functional) versions of the pthreads routines, so link-based
        # tests will erroneously succeed.  (We need to link with -pthreads/-mt/
        # -lpthread.)  (The stubs are missing pthread_cleanup_push, or rather
        # a function called by this macro, so we could check for that, but
        # who knows whether they'll stub that too in a future libc.)  So,
        # we'll just look for -pthreads and -lpthread first:

        ax_pthread_flags="-pthreads pthread -mt -pthread $ax_pthread_flags"
        ;;

        darwin*)
        ax_pthread_flags="-pthread $ax_pthread_flags"
        ;;
esac

if test x"$ax_pthread_ok" = xno; then
for flag in $ax_pthread_flags; do

        case $flag in
                none)
                AC_MSG_CHECKING([whether pthreads work without any flags])
                ;;

                -*)
                AC_MSG_CHECKING([whether pthreads work with $flag])
                PTHREAD_CFLAGS="$flag"
                ;;

                pthread-config)
                AC_CHECK_PROG(ax_pthread_config, pthread-config, yes, no)
                if test x"$ax_pthread_config" = xno; then continue; fi
                PTHREAD_CFLAGS="`pthread-config --cflags`"
                PTHREAD_LIBS="`pthread-config --ldflags` `pthread-config --libs`"
                ;;

                *)
                AC_MSG_CHECKING([for the pthreads library -l$flag])
                PTHREAD_LIBS="-l$flag"
                ;;
        esac

        save_LIBS="$LIBS"
        save_CFLAGS="$CFLAGS"
        LIBS="$PTHREAD_LIBS $LIBS"
        CFLAGS="$CFLAGS $PTHREAD_CFLAGS"

        # Check for various functions.  We must include pthread.h,
        # since some functions may be macros.  (On the Sequent, we
        # need a special flag -Kthread to make this header compile.)
        # We check for pthread_join because it is in -lpthread on IRIX
        # while pthread_create is in libc.  We check for pthread_attr_init
        # due to DEC craziness with -lpthreads.  We check for
        # pthread_cleanup_push because it is one of the few pthread
        # functions on Solaris that doesn't have a non-functional libc stub.
        # We try pthread_create on general principles.
        AC_LINK_IFELSE([AC_LANG_PROGRAM([#include <pthread.h>
                        static void routine(void *a) { a = 0; }
                        static void *start_routine(void *a) { return a; }],
                       [pthread_t th; pthread_attr_t attr;
                        pthread_create(&th, 0, start_routine, 0);
                        pthread_join(th, 0);
                        pthread_attr_init(&attr);
                        pthread_cleanup_push(routine, 0);
                        pthread_cleanup_pop(0) /* ; */])],
                [ax_pthread_ok=yes],
                [])

        LIBS="$save_LIBS"
        CFLAGS="$save_CFLAGS"

        AC_MSG_RESULT($ax_pthread_ok)
        if test "x$ax_pthread_ok" = xyes; then
                break;
        fi

        PTHREAD_LIBS=""
        PTHREAD_CFLAGS=""
done
fi

# Various other checks:
if test "x$ax_pthread_ok" = xyes; then
        save_LIBS="$LIBS"
        LIBS="$PTHREAD_LIBS $LIBS"
        save_CFLAGS="$CFLAGS"
        CFLAGS="$CFLAGS $PTHREAD_CFLAGS"

        # Detect AIX lossage: JOINABLE attribute is called UNDETACHED.
        AC_MSG_CHECKING([for joinable pthread attribute])
        attr_name=unknown
        for attr in PTHREAD_CREATE_JOINABLE PTHREAD_CREATE_UNDETACHED; do
            AC_LINK_IFELSE([AC_LANG_PROGRAM([#include <pthread.h>],
                           [int attr = $attr; return attr /* ; */])],
                [attr_name=$attr; break],
                [])
        done
        AC_MSG_RESULT($attr_name)
        if test "$attr_name" != PTHREAD_CREATE_JOINABLE; then
            AC_DEFINE_UNQUOTED(PTHREAD_CREATE_JOINABLE, $attr_name,
                               [Define to necessary symbol if this constant
                                uses a non-standard name on your system.])
        fi

        AC_MSG_CHECKING([if more special flags are required for pthreads])
        flag=no
        case ${host_os} in
            aix* | freebsd* | darwin*) flag="-D_THREAD_SAFE";;
            osf* | hpux*) flag="-D_REENTRANT";;
            solaris*)
            if test "$GCC" = "yes"; then
                flag="-D_REENTRANT"
            else
                flag="-mt -D_REENTRANT"
            fi
            ;;
        esac
        AC_MSG_RESULT(${flag})
        if test "x$flag" != xno; then
            PTHREAD_CFLAGS="$flag $PTHREAD_CFLAGS"
        fi

        AC_CACHE_CHECK([for PTHREAD_PRIO_INHERIT],
            ax_cv_PTHREAD_PRIO_INHERIT, [
                AC_LINK_IFELSE([
                    AC_LANG_PROGRAM([[#include <pthread.h>]], [[int i = PTHREAD_PRIO_INHERIT;]])],
                    [ax_cv_PTHREAD_PRIO_INHERIT=yes],
                    [ax_cv_PTHREAD_PRIO_INHERIT=no])
            ])
        AS_IF([test "x$ax_cv_PTHREAD_PRIO_INHERIT" = "xyes"],
            AC_DEFINE([HAVE_PTHREAD_PRIO_INHERIT], 1, [Have PTHREAD_PRIO_INHERIT.]))

        LIBS="$save_LIBS"
        CFLAGS="$save_CFLAGS"

        # More AIX lossage: must compile with xlc_r or cc_r
        if test x"$GCC" != xyes; then
          AC_CHECK_PROGS(PTHREAD_CC, xlc_r cc_r, ${CC})
        else
          PTHREAD_CC=$CC
        fi
else
        PTHREAD_CC="$CC"
fi

AC_SUBST(PTHREAD_LIBS)
AC_SUBST(PTHREAD_CFLAGS)
AC_SUBST(PTHREAD_CC)

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test x"$ax_pthread_ok" = xyes; then
        ifelse([$1],,AC_DEFINE(HAVE_PTHREAD,1,[Define if you have POSIX threads libraries and header files.]),[$1])
        :
else
        ax_pthread_ok=no
        $2
fi
AC_LANG_POP
])dnl AX_PTHREAD
