/*
 * $Id: conn_dio24.c,v 1.11 2012-02-22 09:27:20 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "conn_dio24.h"

#define CONN_(x) conn_dio24_ ## x

struct cpssp {
	int dummy;
};

void *
CONN_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_dio24 *port_dev,
	struct sig_std_logic *port_A0,
	struct sig_std_logic *port_A1,
	struct sig_std_logic *port_A2,
	struct sig_std_logic *port_A3,
	struct sig_std_logic *port_A4,
	struct sig_std_logic *port_A5,
	struct sig_std_logic *port_A6,
	struct sig_std_logic *port_A7,
	struct sig_std_logic *port_B0,
	struct sig_std_logic *port_B1,
	struct sig_std_logic *port_B2,
	struct sig_std_logic *port_B3,
	struct sig_std_logic *port_B4,
	struct sig_std_logic *port_B5,
	struct sig_std_logic *port_B6,
	struct sig_std_logic *port_B7,
	struct sig_std_logic *port_C0,
	struct sig_std_logic *port_C1,
	struct sig_std_logic *port_C2,
	struct sig_std_logic *port_C3,
	struct sig_std_logic *port_C4,
	struct sig_std_logic *port_C5,
	struct sig_std_logic *port_C6,
	struct sig_std_logic *port_C7
)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 0], port_A0);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 1], port_A1);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 2], port_A2);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 3], port_A3);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 4], port_A4);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 5], port_A5);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 6], port_A6);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 7], port_A7);

	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 0], port_B0);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 1], port_B1);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 2], port_B2);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 3], port_B3);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 4], port_B4);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 5], port_B5);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 6], port_B6);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 7], port_B7);

	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 0], port_C0);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 1], port_C1);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 2], port_C2);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 3], port_C3);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 4], port_C4);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 5], port_C5);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 6], port_C6);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 7], port_C7);

	return cpssp;
}

void
CONN_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	/* FIXME */

	shm_free(cpssp);
}

void
CONN_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
CONN_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
