.\" dpkg manual page - dpkg(1)
.\"
.\" Copyright © 1996 Juho Vuori <javuori@cc.helsinki.fi>
.\" Copyright © 1999 Jim Van Zandt <jrv@vanzandt.mv.com>
.\" Copyright © 1999-2003 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2000-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2002 Josip Rodin
.\" Copyright © 2004-2005 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2006-2016 Guillem Jover <guillem@debian.org>
.\" Copyright © 2007-2008 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg 1 %RELEASE_DATE% %VERSION% dpkg\-suite
.nh
.SH NAAM
dpkg \- pakketbeheerder voor Debian
.
.SH OVERZICHT
\fBdpkg\fP [\fIoptie\fP...] \fIactie\fP
.
.SH WAARSCHUWING
Deze handleiding is bedoeld voor gebruikers die de commandoregelopties van
dpkg en de pakkettoestanden meer in detail willen begrijpen dan met de info
van \fBdpkg \-\-help\fP mogelijk is.

Zij zou \fIniet\fP gebruikt moeten worden door pakketonderhouders die willen
begrijpen hoe \fBdpkg\fP hun pakketten installeert. De beschrijving van wat
\fBdpkg\fP doet bij het installeren en verwijderen van pakketten is bijzonder
inadequaat.
.
.SH BESCHRIJVING
\fBdpkg\fP is gereedschap voor het installeren, bouwen, verwijderen en beheren
van Debian pakketten. Het belangrijkste en meer gebruikersvriendelijke
frontend voor \fBdpkg\fP is \fBaptitude\fP(1). \fBdpkg\fP zelf wordt volledig
gestuurd via commandoregelparameters, die bestaan uit exact één actie en nul
of meer opties. De actieparameter zegt \fBdpkg\fP wat het moet doen en de
opties sturen in zekere zin het gedrag van de actie.

\fBdpkg\fP kan ook gebruikt worden als een frontend voor \fBdpkg\-deb\fP(1) en
\fBdpkg\-query\fP(1). De lijst van ondersteunde acties kunt u verderop in het
onderdeel \fBACTIES\fP vinden. Indien \fBdpkg\fP een dergelijke actie tegenkomt,
voert het gewoon \fBdpkg\-deb\fP of \fBdpkg\-query\fP uit met de parameters die het
meekreeg. Maar momenteel worden aan hen geen specifieke opties
doorgegeven. Indien u een dergelijke optie wenst te gebruiken moet u deze
programma's rechtstreeks gebruiken.
.
.SH "INFORMATIE OVER PAKKETTEN"
\fBdpkg\fP houdt bruikbare informatie bij over beschikbare pakketten. De
informatie wordt ingedeeld in drie klassen: \fBstates\fP (toestand) ,
\fBselection states\fP (selectietoestand) en \fBflags\fP (vlaggen). Het is de
bedoeling deze waarden hoofdzakelijk met behulp van \fBdselect\fP aan te
passen.
.SS Pakketstatus
.TP 
\fBnot\-installed\fP (niet geïnstalleerd)
Het pakket is niet op uw systeem geïnstalleerd.
.TP 
\fBconfig\-files\fP (configuratiebestanden)
Enkel de configuratiebestanden van het pakket bevinden zich op het systeem.
.TP 
\fBhalf\-installed\fP (gedeeltelijk geïnstalleerd)
De installatie van het pakket werd begonnen, maar om een of andere reden
niet afgerond.
.TP 
\fBunpacked\fP (uitgepakt)
Het pakket is uitgepakt, maar niet geconfigureerd.
.TP 
\fBhalf\-configured\fP (gedeeltelijk geconfigureerd)
Het pakket is uitgepakt en de configuratie werd aangevat, maar om een of
andere reden niet afgerond.
.TP 
\fBtriggers\-awaited\fP (afhandeling triggers wordt afgewacht)
Het pakket wacht het verwerken van triggers door een ander pakket af.
.TP 
\fBtriggers\-pending\fP (aanhangige triggers)
Het pakket werd getriggerd.
.TP 
\fBinstalled\fP (geïnstalleerd)
Het pakket werd correct uitgepakt en geconfigureerd.
.SS Pakketselectiestatus
.TP 
\fBinstall\fP (installeren)
Het pakket werd geselecteerd om geïnstalleerd te worden.
.TP 
\fBhold\fP (te handhaven)
Een pakket dat als \fBte handhaven\fP werd gemarkeerd, wordt niet behandeld
door \fBdpkg\fP, tenzij het ertoe gedwongen wordt met de optie \fB\-\-force\-hold\fP.
.TP 
\fBdeinstall\fP (de\-installeren)
Het pakket werd geselecteerd om gede\-installeerd te worden (d.w.z. dat we
alle bestanden wensen te verwijderen, op de configuratiebestanden na)
.TP 
\fBpurge\fP (wissen)
Het pakket werd geselecteerd om gewist te worden (d.w.z. dat we alles uit de
systeemmappen wensen te verwijderen, zelfs de configuratiebestanden).
.SS Pakketvlaggen
.TP 
\fBok\fP
Een pakket dat als \fBok\fP gemarkeerd staat bevindt zich in een gekende
toestand, maar verdere afhandeling kan nog nodig zijn.
.TP 
\fBreinstreq\fP
Een pakket dat als \fBreinstreq\fP gemarkeerd werd, is defect en moet opnieuw
geïnstalleerd worden. Deze pakketten kunnen niet verwijderd worden, tenzij
dit met de optie \fB\-\-force\-remove\-reinstreq\fP geforceerd wordt.
.
.SH ACTIES
.TP 
\fB\-i\fP, \fB\-\-install\fP \fIpakketbestand\fP...
Installeer het pakket. Indien de optie \fB\-\-recursive\fP of \fB\-R\fP opgegeven
werd, moet \fIpakketbestand\fP evenwel naar een map verwijzen.

Een installatie bestaat uit de volgende stappen:
.br

\fB1.\fP Het extraheren van de controle\-bestanden van het nieuwe pakket.
.br

\fB2.\fP Indien voorafgaand aan de nieuwe installatie een andere versie van
hetzelfde pakket geïnstalleerd was, het \fIprerm\fP\-script van het oude pakket
uitvoeren.
.br

\fB3.\fP Indien het pakket een \fIpreinst\fP\-script meelevert, dat uitvoeren.
.br

\fB4.\fP Het uitpakken van de nieuwe bestanden en tegelijk een reservekopie van
de oude bestanden maken, zodat ze hersteld kunnen worden mocht er iets fout
lopen.
.br

\fB5.\fP Indien voorafgaand aan de nieuwe installatie een andere versie van
hetzelfde pakket geïnstalleerd was, het \fIpostrm\fP\-script van het oude pakket
uitvoeren. Merk op dat dit script uitgevoerd wordt na het \fIpreinst\fP\-script
van het nieuwe pakket, omdat nieuwe bestanden neergeschreven worden tegelijk
met het verwijderen van oude bestanden.
.br

\fB6.\fP Het configureren van het pakket. Zie \fB\-\-configure\fP voor
gedetailleerde informatie over hoe dit gebeurt.
.TP 
\fB\-\-unpack \fP\fIpakketbestand\fP...
Pak het pakket uit, maar configureer het niet. Indien de optie
\fB\-\-recursive\fP of \fB\-R\fP opgegeven werd, moet \fIpakketbestand\fP evenwel naar
een map verwijzen.
.TP 
\fB\-\-configure \fP\fIpakket\fP...|\fB\-a\fP|\fB\-\-pending\fP
Configureer een pakket dat uitgepakt, maar nog niet geconfigureerd
werd. Indien echter \fB\-a\fP of \fB\-\-pending\fP opgegeven wordt in plaats van
\fIpakket\fP, worden alle uitgepakte maar niet\-geconfigureerde pakketten
geconfigureerd.

Om een pakket dat reeds geconfigureerd werd opnieuw te configureren, moet u
echter het commando \fBdpkg\-reconfigure\fP(8) gebruiken.

Het configureren bestaat uit de volgende stappen:
.br

\fB1.\fP Het uitpakken van de conffiles (configuratiebestanden) en tegelijk een
reservekopie maken van de oude conffiles, zodat ze hersteld kunnen worden
mocht er iets fout lopen.
.br

\fB2.\fP Indien het pakket een \fIpostinst\fP\-script meelevert, dat uitvoeren.
.TP 
\fB\-\-triggers\-only\fP \fIpakket\fP...|\fB\-a\fP|\fB\-\-pending\fP
Verwerkt enkel triggers (sinds dpkg 1.14.17). Alle aanhangige triggers
zullen verwerkt worden. Indien pakketnamen opgegeven werden, zullen enkel de
triggers van die pakketten verwerkt worden, elk exact eenmaal waar
nodig. Het gebruiken van deze optie kan pakketten achterlaten in een
ongepaste toestand van \fBtriggers\-awaited\fP (wachten op triggerafhandeling)
of \fBtriggers\-pending\fP (aanhangige triggers). Dit kan later gerepareerd
worden door het uitvoeren van \fBdpkg \-\-configure \-\-pending\fP.
.TP 
\fB\-r\fP, \fB\-\-remove\fP \fIpakket\fP...|\fB\-a\fP|\fB\-\-pending\fP
Verwijder een geïnstalleerd pakket. Dit verwijdert alles behalve de
conffiles (configuratiebestanden), waardoor vermeden kan worden dat het
pakket opnieuw geconfigureerd moet worden als het opnieuw geïnstalleerd
wordt (conffiles zijn configuratiebestanden die vermeld worden in het
controlebestand \fIDEBIAN/conffiles\fP). Indien \fB\-a\fP of \fB\-\-pending\fP opgegeven
werd in plaats van een pakketnaam, zullen alle pakketten die uitgepakt zijn
maar in het bestand \fI%ADMINDIR%/status\fP gemarkeerd staan om verwijderd te
worden, verwijderd worden.

Het verwijderen van een pakket bestaat uit de volgende stappen:
.br

\fB1.\fP Het uitvoeren van het \fIprerm\fP\-script
.br

\fB2.\fP Het verwijderen van de geïnstalleerde bestanden
.br

\fB3.\fP Het uitvoeren van het \fIpostrm\fP\-script
.br

.TP 
\fB\-P\fP, \fB\-\-purge\fP \fIpakket\fP...|\fB\-a\fP|\fB\-\-pending\fP
Wis een geïnstalleerd of een reeds verwijderd pakket. Dit verwijdert alles,
inclusief conffiles (configuratiebestanden). Indien \fB\-a\fP of \fB\-\-pending\fP
opgegeven werd in plaats van een pakketnaam, dan zullen alle uitgepakte of
verwijderde pakketten die echter in het bestand \fI%ADMINDIR%/status\fP
gemarkeerd zijn om gewist te worden, gewist worden.

Merk op: sommige configuratiebestanden kunnen niet gekend zijn door \fBdpkg\fP
omdat ze via de configuratiescripts gecreëerd en afzonderlijk afgehandeld
worden. In dat geval zal \fBdpkg\fP ze niet zelf verwijderen, maar het
\fIpostrm\fP\-script van het pakket (dat door \fBdpkg\fP geactiveerd wordt) moet
tijdens een wis\-operatie voor hun verwijdering zorgen. Dit is uiteraard
enkel van toepassing op bestanden in systeemmappen, niet op
configuratiebestanden die neergeschreven werden in de persoonlijke map van
gebruikers.

Het wissen van een pakket bestaat uit de volgende stappen:
.br

\fB1.\fP Het verwijderen van het pakket als het nog niet verwijderd was. Zie
\fB\-\-remove\fP voor gedetailleerde informatie over hoe dit gebeurt.
.br

\fB2.\fP Het uitvoeren van het \fIpostrm\fP\-script
.br
.TP 
\fB\-V\fP, \fB\-\-verify\fP [\fIpakketnaam\fP...]
Controleert de integriteit van \fIpakketnaam\fP of van alle pakketten indien er
geen naam opgegeven werd. De controle gebeurt door een vergelijking te maken
van informatie uit de bestanden die door een pakket geïnstalleerd worden met
de metadata\-informatie over die bestanden die in de database van \fBdpkg\fP
opgeslagen is (sinds dpkg 1.17.2). De metadata\-informatie over die bestanden
in de database is afkomstig van het binaire pakket zelf. Die metadata worden
verzameld tijdens het installatieproces op het moment van het uitpakken van
het pakket.

Momenteel is de enige functionele toets die uitgevoerd wordt, een
verificatie van de md5\-controlesom van de inhoud van het bestand tegenover
de opgeslagen waarde in de bestandsdatabase. De toets wordt enkel uitgevoerd
als de database de md5\-controlesom van het bestand bevat. Om na te gaan of
er eventueel metadata ontbreken in de database, kan het commando \fB\-\-audit\fP
gebruikt worden.

De indeling van de uitvoer kan met de optie \fB\-\-verify\-format\fP gekozen
worden. Standaard wordt de indeling \fBrpm\fP gebruikt, maar dit kan in de
toekomst veranderen en om die reden zouden programma's die de uitvoer van
dit commando ontleden, expliciet moeten aangeven welke indeling zij
verwachten.
.TP 
\fB\-C\fP, \fB\-\-audit\fP [\fIpakketnaam\fP...]
Voert op de database correctheids\- en consistentietoetsen uit met betrekking
tot \fIpakketnaam\fP of alle pakketten als er geen pakketnaam opgegeven werd
(individuele pakkettoetsen sinds dpkg 1.17.10). Voorbeelden zijn: zoeken
naar pakketten die slechts gedeeltelijk geïnstalleerd werden op uw systeem
of met ontbrekende, foute of verouderde controlegegevens of
\-bestanden. \fBdpkg\fP zal een suggestie geven over wat er te doen staat om ze
te repareren.
.TP 
\fB\-\-update\-avail\fP [\fIPackages\-bestand\fP]
.TQ
\fB\-\-merge\-avail\fP [\fIPackages\-bestand\fP]
Werk de kennis bij van \fBdpkg\fP en \fBdselect\fP over welke pakketten
beschikbaar zijn. Bij de actie \fB\-\-merge\-avail\fP wordt oude informatie
gecombineerd met informatie uit het \fIPackages\-bestand\fP. Bij de actie
\fB\-\-update\-avail\fP wordt de oude informatie vervangen door de informatie uit
het \fIPackages\-bestand\fP. Het \fIPackages\-bestand\fP dat door Debian verdeeld
wordt, heeft gewoon «\fIPackages\fP» als naam. Indien het argument
\fIPackages\-bestand\fP ontbreekt of «\fB\-\fP» als naam heeft, zal het gelezen
worden van de standaardinvoer (sinds dpkg 1.17.7). \fBdpkg\fP houdt zijn
overzicht van beschikbare pakketten bij in \fI%ADMINDIR%/available\fP.

Een eenvoudiger commando om in één keer het bestand \fIavailable\fP op te halen
en bij te werken is \fBdselect update\fP. Merk op dat dit bestand grotendeels
nutteloos is als u niet \fBdselect\fP gebruikt, maar een op APT gebaseerd
frontend: APT heeft zijn eigen systeem om zicht te houden op de beschikbare
pakketten.
.TP 
\fB\-A\fP, \fB\-\-record\-avail\fP \fIpakketbestand\fP...
Werk de kennis van \fBdpkg\fP en \fBdselect\fP over welke pakketten beschikbaar
zijn, bij met informatie uit het pakket \fIpakketbestand\fP. Indien de optie
\fB\-\-recursive\fP of \fB\-R\fP opgegeven werd, moet \fIpakketbestand\fP evenwel
verwijzen naar een map.
.TP 
\fB\-\-forget\-old\-unavail\fP
Nu \fBverouderd\fP en een bewerkingsloze opdracht aangezien \fBdpkg\fP automatisch
geen kennis meer heeft van gede\-installeerde niet\-beschikbare pakketten
(sinds dpkg 1.15.4), maar enkel van die welke geen gebruikersinformatie,
zoals pakketselecties, bevatten.
.TP 
\fB\-\-clear\-avail\fP
Wis de huidige informatie over de beschikbaarheid van pakketten.
.TP 
\fB\-\-get\-selections\fP [\fIpakketnaampatroon\fP...]
Haal de lijst van pakketselecties op en schrijf die naar de
standaarduitvoer. Als geen patroon opgegeven wordt, zullen
niet\-geïnstalleerde pakketten (d.w.z. die welke voordien gewist werden) niet
getoond worden.
.TP 
\fB\-\-set\-selections\fP
Stel pakketselecties in met behulp van het bestand dat van de
standaardinvoer gelezen wordt. Dit bestand moet als indeling “\fIpakket\fP
\fIstatus\fP” hebben, waarbij status \fBinstall\fP (installeren), \fBhold\fP (te
handhaven), \fBdeinstall\fP (de\-installeren) of \fBpurge\fP (wissen) kan
zijn. Lege regels en commentaarregels die met ‘\fB#\fP’ beginnen, zijn ook
toegelaten.

Het bestand \fIavailable\fP moet up\-to\-date zijn opdat dit commando dienstig
zou zijn, anders zullen niet\-gekende pakketten genegeerd worden en zal er in
dat verband een waarschuwing gegeven worden. Zie de commando's
\fB\-\-update\-avail\fP en \fB\-\-merge\-avail\fP voor meer informatie.
.TP 
\fB\-\-clear\-selections\fP
Stel de aangevraagde status voor elk niet\-essentieel pakket in op deinstall
(de\-installeren) (sinds dpkg 1.13.18). Dit is bedoeld om gebruikt te worden
onmiddellijk voor \fB\-\-set\-selections\fP om eventuele pakketten te
de\-installeren die niet in de lijst staan die doorgegeven wordt aan
\fB\-\-set\-selections\fP.
.TP 
\fB\-\-yet\-to\-unpack\fP
Zoekt pakketten op die geselecteerd werden om geïnstalleerd te worden, maar
die om één of andere reden nog niet geïnstalleerd werden.
.TP 
\fB\-\-predep\-package\fP
Toon een enkel pakket dat het doel is van een of meer relevante voorafgaande
vereisten en dat zelf geen niet\-voldane voorafgaande vereisten heeft.
.IP
Indien er een dergelijk pakket is, geef het dan weer in de vorm van een item
voor het bestand Packages dat passend verder bewerkt kan worden.
.IP
Geeft 0 terug als een pakket weergegeven werd, 1 als geen geschikt pakket te
vinden is en 2 in geval van een fout.
.TP 
\fB\-\-add\-architecture \fP\fIarchitectuur\fP
Voeg \fIarchitectuur\fP toe aan de lijst van architecturen waarvoor pakketten
geïnstalleerd kunnen worden zonder \fB\-\-force\-architecture\fP te gebruiken
(sinds dpkg 1.16.2). De architectuur waarvoor \fBdpkg\fP gebouwd werd
(d.w.z. de uitvoer van \fB\-\-print\-architecture\fP), maakt steeds deel uit van
die lijst.
.TP 
\fB\-\-remove\-architecture \fP\fIarchitectuur\fP
Verwijder \fIarchitectuur\fP uit de lijst van architecturen waarvoor pakketten
geïnstalleerd kunnen worden zonder \fB\-\-force\-architecture\fP te gebruiken
(sinds dpkg 1.16.2). Indien de architectuur momenteel in de database in
gebruik is, dan zal deze operatie geweigerd worden, behalve wanneer
\fB\-\-force\-architecture\fP opgegeven wordt. De architectuur waarvoor \fBdpkg\fP
gebouwd werd (d.w.z. de uitvoer van \fB\-\-print\-architecture\fP), kan nooit uit
die lijst verwijderd worden.
.TP 
\fB\-\-print\-architecture\fP
Toon de architectuur van de pakketten die \fBdpkg\fP installeert (bijvoorbeeld
“i386”).
.TP 
\fB\-\-print\-foreign\-architectures\fP
Toon een lijst, met regeleindes als scheidingsteken, van de bijkomende
architecturen waarvoor pakketten mogen geïnstalleerd worden volgens de
configuratie van \fBdpkg\fP (sinds dpkg 1.16.2).
.TP 
\fB\-\-assert\-\fP\fIfunctionaliteit\fP
Bevestigt dat \fBdpkg\fP de gevraagde functionaliteit ondersteunt. Geeft de
waarde 0 terug als de functionaliteit volledig ondersteund wordt, 1 als de
functionaliteit gekend is maar \fBdpkg\fP er nog geen ondersteuning voor kan
bieden en 2 als de functionaliteit niet gekend is. De huidige lijst van
functionaliteiten die kunnen bevestigd worden, is:
.RS
.TP 
\fBsupport\-predepends\fP
Biedt ondersteuning voor het veld \fBPre\-Depends\fP (sinds dpkg 1.1.0).
.TP 
\fBworking\-epoch\fP
Biedt ondersteuning voor epoches in versietekenreeksen (sinds dpkg 1.4.0.7).
.TP 
\fBlong\-filenames\fP
Biedt ondersteuning voor lange bestandsnamen in archieven van het type
\fBdeb\fP(5) (sinds dpkg 1.4.1.17).
.TP 
\fBmulti\-conrep\fP
Biedt ondersteuning voor meervoudige \fBConflicts\fP (tegenstrijdig met) en
\fBReplaces\fP (vervangt) (sinds dpkg 1.4.1.19).
.TP 
\fBmulti\-arch\fP
Biedt ondersteuning voor multi\-architectuurvelden en hun semantiek (sinds
dpkg 1.16.2).
.TP 
\fBversioned\-provides\fP
Biedt ondersteuning voor versiespecifieke \fBProvides\fP (voorziet in) (sinds
dpkg 1.17.11).
.RE
.TP 
\fB\-\-validate\-\fP\fIthing string\fP
Validate that the \fIthing\fP \fIstring\fP has a correct syntax (since dpkg
1.18.16).  Returns 0 if the \fIstring\fP is valid, 1 if the \fIstring\fP is
invalid but might be accepted in lax contexts, and 2 if the \fIstring\fP is
invalid.  The current list of validatable \fIthing\fPs is:
.RS
.TP 
\fBpkgname\fP
Validates the given package name (since dpkg 1.18.16).
.TP 
\fBtrigname\fP
Validates the given trigger name (since dpkg 1.18.16).
.TP 
\fBpkgname\fP
Validates the given architecture name (since dpkg 1.18.16).
.TP 
\fBversion\fP
Validates the given version (since dpkg 1.18.16).
.RE
.TP 
\fB\-\-compare\-versions \fP\fIver1 op ver2\fP
.\" .TP
.\" .B \-\-command\-fd \fIn\fP
.\" Accept a series of commands on input file descriptor \fIn\fP. Note:
.\" additional options set on the command line, and through this file descriptor,
.\" are not reset for subsequent commands executed during the same run.
Vergelijk versienummers, waarbij \fIop\fP een binaire operator is. \fBdpkg\fP
geeft de waarde waar (\fB0\fP) terug indien voldaan werd aan de opgegeven
conditie, en onwaar (\fB1\fP) in het andere geval. Er zijn twee groepen
operatoren, die van elkaar verschillen in de manier waarop zij omgaan met
een lege \fIver1\fP of \fIver2\fP. Voor de volgende operatoren komt een lege
versie voor elke andere versie: \fBlt le eq ne ge gt\fP. Voor de volgende
operatoren komt een lege versie na elke andere versie: \fBlt\-nl le\-nl ge\-nl
gt\-nl\fP. In de volgende operatoren wordt enkel voorzien met het oog op
compatibiliteit met de syntaxis van het bestand control: \fB< <<
<= = >= >> >\fP. De operatoren \fB<\fP en \fB>\fP zijn
verouderd en zouden omwille van de verwarrende semantiek \fBniet\fP gebruikt
mogen worden. Om dit te illustreren: \fB0.1 < 0.1\fP wordt als waar
beoordeeld.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Geef een korte hulptekst weer.
.TP 
\fB\-\-force\-help\fP
Geef hulp over de opties \fB\-\-force\-\fP\fIiets\fP.
.TP 
\fB\-Dh\fP, \fB\-\-debug=help\fP
Geef hulp over debug\-opties.
.TP 
\fB\-\-version\fP
Geef versie\-informatie over \fBdpkg\fP.
.TP 
\fBdpkg\-deb acties\fP
Zie \fBdpkg\-deb\fP(1) voor meer informatie over de volgende acties.

.nf
\fB\-b\fP, \fB\-\-build\fP \fImap\fP [\fIarchief\fP|\fImap\fP]
    Bouw een deb\-pakket.
\fB\-c\fP, \fB\-\-contents\fP \fIarchief\fP
    Geef de inhoud van een deb\-pakket weer.
\fB\-e\fP, \fB\-\-control\fP \fIarchief\fP [\fImap\fP]
    Extraheer de controle\-informatie uit een pakket.
\fB\-x\fP, \fB\-\-extract\fP \fIarchief map\fP
    Extraheer de bestanden die een pakket bevat.
\fB\-X\fP, \fB\-\-vextract\fP \fIarchief map\fP
    Extraheer de bestandsnamen die een pakket bevat
    en geef ze weer.
\fB\-f\fP, \fB\-\-field\fP  \fIarchief\fP [\fIcontroleveld\fP...]
    Geef controleveld(en) van een pakket weer.
\fB\-\-ctrl\-tarfile\fP \fIarchief\fP
    Schrijf het controle\-tar\-bestand dat een Debian pakket
    bevat, weg.
\fB\-\-fsys\-tarfile\fP \fIarchief\fP
    Schrijf het bestandssysteem\-tar\-bestand dat een Debian
    pakket bevat, weg.
\fB\-I\fP, \fB\-\-info\fP \fIarchief\fP [\fIcontrolebestand\fP...]
    Toon informatie over een pakket.
.fi

.TP 
\fBdpkg\-query acties\fP
Zie \fBdpkg\-query\fP(1) voor meer informatie over de volgende acties.

.nf

\fB\-l\fP, \fB\-\-list\fP \fIpakketnaampatroon\fP...
    Som de pakketten op die aan het opgegeven
    patroon beantwoorden.
\fB\-s\fP, \fB\-\-status\fP \fIpakketnaam\fP...
    Rapporteer de status van het opgegeven pakket.
\fB\-L\fP, \fB\-\-listfiles\fP \fIpakketnaam\fP...
    Som de bestanden op die uit \fIpakketnaam\fP
    op uw systeem geïnstalleerd worden.
\fB\-S\fP, \fB\-\-search\fP \fIbestandsnaamzoekpatroon\fP...
    Zoek naar een bestandsnaam uit een geïnstalleerd
    pakket.
\fB\-p\fP, \fB\-\-print\-avail\fP \fIpakketnaam\fP...
    Geef over \fIpakketnaam\fP de details weer
    die te vinden zijn in \fI%ADMINDIR%/available\fP.
    Gebruikers van op APT gebaseerde frontends
    moeten in plaats hiervan
    \fBapt\-cache show\fP \fIpakketnaam\fP gebruiken.
.fi
.
.SH OPTIES
Alle opties kunnen zowel aan de commandoregel opgegeven worden als in het
\fBdpkg\fP configuratiebestand \fI%PKGCONFDIR%/dpkg.cfg\fP of in fragmentbestanden
(met namen die overeenkomen met het shellpatroon '[0\-9a\-zA\-Z_\-]*') in de
configuratiemap \fI%PKGCONFDIR%/dpkg.cfg.d/\fP. Elke regel in het
configuratiebestand is ofwel een optie (exact hetzelfde als de
commandoregeloptie maar zonder de verbindingstekens aan het begin) of een
commentaar (als hij begint met een ‘\fB#\fP’).
.br
.TP 
\fB\-\-abort\-after=\fP\fIaantal\fP
Pas aan na hoeveel fouten \fBdpkg\fP moet afbreken. Standaard is dat 50.
.TP 
\fB\-B\fP, \fB\-\-auto\-deconfigure\fP
Het is mogelijk dat wanneer een pakket verwijderd wordt, een ander
geïnstalleerd pakket het verwijderde pakket nodig heeft. Deze optie
gebruiken heeft tot gevolg dat het pakket dat van het verwijderde pakket
afhankelijk was, automatisch gedeconfigureerd wordt.
.TP 
\fB\-D\fP\fIoctaal\fP\fB, \-\-debug=\fP\fIoctaal\fP
Schakel debuggen in. \fIoctaal\fP wordt gevormd door op de gewenste waarden uit
de onderstaande lijst de bitwise OR\-bewerking uit te voeren (merk op dat
deze waarden in toekomstige uitgaven kunnen veranderen). \fB\-Dh\fP of
\fB\-\-debug=help\fP geeft deze debugwaarden weer.

     Getal   Beschrijving
         1   Algemene informatieve voortgangsinformatie
         2   Activering en status van beheerdersscripts
        10   Uitvoer voor elk verwerkt bestand
       100   Veel uitvoer voor elk verwerkt bestand
        20   Uitvoer voor elk configuratiebestand
       200   Veel uitvoer voor elk configuratiebestand
        40   Vereisten en tegenstrijdigheden
       400   Veel uitvoer i.v.m. vereisten/tegenstrijdigheden
     10000   Activatie en verwerking van triggers
     20000   Veel uitvoer i.v.m. triggers
     40000   Belachelijk veel uitvoer i.v.m. triggers
      1000   Veel geleuter over bijv. de map dpkg/info
      2000   Belachelijk veel geleuter
.TP 
\fB\-\-force\-\fP\fIdingen\fP
.TQ
\fB\-\-no\-force\-\fP\fIdingen\fP, \fB\-\-refuse\-\fP\fIdingen\fP
Het uitvoeren van sommige dingen opleggen of weigeren (\fBno\-force\fP en
\fBrefuse\fP betekenen hetzelfde). \fIdingen\fP is een door komma's gescheiden
lijst van hierna gespecificeerde zaken. \fB\-\-force\-help\fP geeft er een
beschrijving van weer. Zaken die met een (*) gemarkeerd zijn, worden
standaard opgelegd.

\fIWaarschuwing: Deze opties zijn vooral bedoeld om enkel door experts
gebruikt te worden. Er gebruik van maken zonder een volkomen begrip van hun
effecten kan uw volledig systeem defect maken.\fP

\fBall\fP: Schakelt alle forceer\-opties aan (of uit).

\fBdowngrade\fP(*): Installeer een pakket, zelfs als reeds een nieuwere versie
ervan geïnstalleerd is.

\fIWaarschuwing: Momenteel voert \fP\fBdpkg\fP\fI geen enkele vereistencontrole uit
bij degradaties en zal dan ook niet waarschuwen indien een degradatie een
vereiste van een ander pakket defect maakt. Dit kan ernstige neveneffecten
hebben. Degraderen van essentiële componenten van het systeem kan zelfs uw
hele systeem onbruikbaar maken. Te gebruiken met voorzichtigheid.\fP

\fBconfigure\-any\fP: Configureer ook elk uitgepakt maar niet\-geconfigureerd
pakket waarvan het huidige pakket afhankelijk is.

\fBhold\fP: Behandel ook pakketten die met “hold” (te handhaven) gemarkeerd
zijn.

\fBremove\-reinstreq\fP: Verwijder een pakket, zelfs als het defect is en er
aangegeven staat dat een herinstallatie nodig is. Dit kan bijvoorbeeld tot
gevolg hebben dat delen van het pakket op het systeem achterblijven, maar
\fBdpkg\fP zal er dan niet meer van op de hoogte zijn.

\fBremove\-essential\fP: Verwijder het pakket, zelfs al wordt het als essentieel
beschouwd. Essentiële pakketten bevatten meestal hele basale Unix
commando's. Ze verwijderen kan tot gevolg hebben dat het hele systeem stopt
met werken. Gebruik dit dus met voorzichtigheid.

\fBdepends\fP: Verander alle vereistenproblemen in waarschuwingen.

\fBdepends\-version\fP: Bekommer u niet om versies bij het toetsen van
vereisten.

\fBbreaks\fP: Installeer, zelfs als dit een ander pakket defect zou maken
(sinds dpkg 1.14.6).

\fBconflicts\fP: Installeer, zelfs als er een tegenstelling is met een ander
pakket. Dit is gevaarlijk, want gewoonlijk zal dit het overschrijven van
bepaalde bestanden tot gevolg hebben.

\fBconfmiss\fP: Always install the missing conffile without prompting. This is
dangerous, since it means not preserving a change (removing) made to the
file.

\fBconfnew\fP: Als een conffile (configuratiebestand) aangepast werd en de
versie uit het pakket gewijzigd werd, installeer dan steeds zonder vragen de
nieuwe versie, tenzij ook \fB\-\-force\-confdef\fP opgegeven werd. In dat geval
wordt de voorkeur gegeven aan de standaardactie.

\fBconfold\fP: Als een conffile (configuratiebestand) aangepast werd en de
versie uit het pakket gewijzigd werd, behoud dan steeds zonder vragen de
oude versie, tenzij ook \fB\-\-force\-confdef\fP opgegeven werd. In dat geval
wordt de voorkeur gegeven aan de standaardactie.

\fBconfdef\fP: Als een conffile (configuratiebestand) aangepast werd en de
versie uit het pakket gewijzigd werd, kies dan steeds zonder vragen voor de
standaardactie. Indien er geen standaardactie is, zal het programma stoppen
en de gebruiker een vraag stellen, tenzij ook \fB\-\-force\-confnew\fP of
\fB\-\-force\-confold\fP opgegeven werd. In dat geval zal het dit gebruiken om
over de uiteindelijke actie te beslissen.

\fBconfask\fP: If a conffile has been modified always offer to replace it with
the version in the package, even if the version in the package did not
change (since dpkg 1.15.8).  If any of \fB\-\-force\-confnew\fP,
\fB\-\-force\-confold\fP, or \fB\-\-force\-confdef\fP is also given, it will be used to
decide the final action.

\fBoverwrite\fP: Overschrijf een bestand van een pakket met het bestand van een
ander pakket.

\fBoverwrite\-dir\fP: Overschrijf een map van een pakket met het bestand van een
ander pakket.

\fBoverwrite\-diverted\fP: Overschrijf een omgeleid bestand met een
niet\-omgeleide versie.

\fBunsafe\-io\fP: Voer bij het uitpakken geen veilige I/O\-operaties uit (sinds
dpkg 1.15.8.6). Momenteel houdt dit in dat geen
bestandssysteemsynchronisatie gebeurt vooraleer bestanden hernoemd
worden. Daarvan is geweten dat dit op sommige bestandssystemen tot
aanzienlijk slechtere prestaties leidt, en dit jammer genoeg vooral op die
bestandssystemen die veilige I/O het meest nodig hebben omwille van hun
onbetrouwbaar gedrag, hetgeen bij abrupte systeemcrashes aanleiding kan
geven tot bestanden met lengte zero.

\fIOpmerking\fP: Overweeg liever om voor ext4, de belangrijkste betrokkene,
gebruik te maken van de aankoppeloptie \fBnodelalloc\fP, waardoor zowel het
prestatieverlies als de problemen inzake de betrouwbaarheid van gegevens
opgevangen worden. Dit laatste door er voor te zorgen dat het
bestandssysteem geen bestanden aanmaakt met lengte zero als er zich een
abrupte crash voordoet en software actief is die geen synchronisatie
uitvoert voorafgaand aan een atomische hernoeming.

\fIWaarschuwing: Het gebruik van deze optie kan de prestaties verbeteren ten
koste van het verlies van gegevens. Gebruik ze behoedzaam.\fP

\fBscript\-chrootless\fP: Voer de scripts van de pakketonderhouder uit zonder te
\fBchroot\fP(2)en naar \fBinstdir\fP, zelfs als het pakket deze werkwijze niet
ondersteunt (sinds dpkg 1.18.5).

\fIWaarschuwing: Dit kan uw computersysteem vernietigen, gebruik dit uiterst
behoedzaam.\fP

\fBarchitecture\fP: Verwerk pakketten zelfs als ze de verkeerde of geen
architectuur hebben.

\fBbad\-version\fP: Verwerk pakketten zelfs als ze een verkeerde versie hebben
(sinds dpkg 1.16.1).

\fBbad\-path\fP: In \fBPATH\fP ontbreken belangrijke programma's, waardoor het
waarschijnlijk is dat er zich problemen zullen voordoen.

\fBnot\-root\fP: Tracht zaken te (de\-)installeren, zelfs als
niet\-systeembeheerder.

\fBbad\-verify\fP: Installeer een pakket zelfs als de authenticiteitscontrole
mislukt.

.TP 
\fB\-\-ignore\-depends\fP=\fIpakket\fP,...
Negeer het toetsen van afhankelijkheden voor de opgegeven pakketten
(eigenlijk wordt de controle wel uitgevoerd, maar er worden enkel
waarschuwingen in verband met tegenstrijdigheden gegeven en verder niets).
.TP 
\fB\-\-no\-act\fP, \fB\-\-dry\-run\fP, \fB\-\-simulate\fP
Voer alles wat gedaan moet worden, uit, maar schrijf geen veranderingen
weg. Dit wordt gebruikt om te zien wat er bij de opgegeven actie zou
gebeuren, zonder dat er effectief iets gewijzigd wordt.

Zorg ervoor om \fB\-\-no\-act\fP voor de actie\-parameter op te geven, anders zou u
ongewenste resultaten kunnen bekomen. (bijvoorbeeld zal \fBdpkg \-\-purge foo
\-\-no\-act\fP eerst pakket foo wissen en dan proberen pakket \-\-no\-act te wissen,
ook al verwachtte u wellicht dat er niets gedaan zou worden)
.TP 
\fB\-R\fP, \fB\-\-recursive\fP
Behandel alle gewone bestanden die beantwoorden aan het patroon \fB*.deb\fP
recursief in de opgegeven mappen en al hun onderliggende mappen. Dit kan
gebruikt worden samen met de acties \fB\-i\fP, \fB\-A\fP, \fB\-\-install\fP, \fB\-\-unpack\fP
en \fB\-\-record\-avail\fP.
.TP 
\fB\-G\fP
Installeer een pakket niet als reeds een nieuwere versie van dat pakket
geïnstalleerd is. Dit is een alias voor \fB\-\-refuse\-downgrade\fP.
.TP 
\fB\-\-admindir=\fP\fImap\fP
Wijzig de standaard administratieve map waarin veel bestanden zitten met
informatie over de status van geïnstalleerde of gede\-installeerde pakketten,
enz. (Standaard is dat «\fI%ADMINDIR%\fP»)
.TP 
\fB\-\-instdir=\fP\fImap\fP
Wijzig de standaard installatiemap, wat een aanduiding is voor de map waarin
pakketten geïnstalleerd zullen worden. \fBinstdir\fP is ook de map die aan
\fBchroot\fP(2) doorgegeven wordt vooraleer de installatiescripts van een
pakket uitgevoerd worden, waardoor de scripts \fBinstdir\fP als de hoofdmap
beschouwen. (Standaard is dat «\fI/\fP»)
.TP 
\fB\-\-root=\fP\fImap\fP
Het wijzigen van \fBroot\fP verandert \fBinstdir\fP naar «\fImap\fP» en \fBadmindir\fP
naar «\fIdir\fP\fB%ADMINDIR%\fP».
.TP 
\fB\-O\fP, \fB\-\-selected\-only\fP
Verwerk enkel de pakketten die geselecteerd werden om geïnstalleerd te
worden. Het eigenlijke markeren gebeurt door \fBdselect\fP of door \fBdpkg\fP als
het de pakketten behandelt. Als bijvoorbeeld een pakket verwijderd wordt,
zal het als geselecteerd om verwijderd te worden gemarkeerd worden.
.TP 
\fB\-E\fP, \fB\-\-skip\-same\-version\fP
Installeer het pakket niet als dezelfde versie van dat pakket reeds
geïnstalleerd is.
.TP 
\fB\-\-pre\-invoke=\fP\fIcommando\fP
.TQ
\fB\-\-post\-invoke=\fP\fIcommando\fP
Stel in dat een uitbreiding (hook) \fIcommando\fP via \*(lqsh \-c\*(rq moet uitgevoerd
worden voor of na het uitvoeren van \fBdpkg\fP bij de acties \fIunpack\fP,
\fIconfigure\fP, \fIinstall\fP, \fItriggers\-only\fP, \fIremove\fP, \fIpurge\fP,
\fIadd\-architecture\fP en \fIremove\-architecture\fP van \fBdpkg\fP (sinds dpkg 1.15.4
en de acties \fIadd\-architecture\fP en \fIremove\-architecture\fP sinds dpkg
1.17.19). Deze optie kan meermaals opgegeven worden. De volgorde waarin de
opties opgegeven worden, wordt behouden, waarbij die uit de
configuratiebestanden voorrang hebben. De omgevingsvariabele
\fBDPKG_HOOK_ACTION\fP wordt ingesteld voor de uitbreidingen (hooks) bij de
huidige actie van \fBdpkg\fP. Merk op dat frontends die uitgevoerd worden,
\fBdpkg\fP meermaals kunnen activeren, waardoor de uitbreidingen meer keren dan
verwacht uitgevoerd kunnen worden.
.TP 
\fB\-\-path\-exclude=\fP\fIglob\-patroon\fP
.TQ
\fB\-\-path\-include=\fP\fIglob\-patroon\fP
Stel \fIglob\-patroon\fP bij het installeren in als een filter voor paden, ofwel
door paden die aan het opgegeven patroon beantwoorden, uit te sluiten ofwel
door eerder uitgesloten paden opnieuw toe te voegen (sinds dpkg 1.15.8).

\fIWaarschuwing: houd er rekening mee dat u, afhankelijk van de paden die
uitgesloten worden, uw systeem volledig defect kunt maken. Gebruik dit
behoedzaam.\fP

In de glob\-patronen kunnen dezelfde jokertekens gebruikt worden als in de
shell, waarbij ‘*’ overeenkomt met om het even welke reeks tekens, met
inbegrip van de lege tekenreeks evenals van ‘/’. Bijvoorbeeld,
«\fI/usr/*/READ*\fP» komt overeen met «\fI/usr/share/doc/package/README\fP». Zoals
gebruikelijk komt ‘?’ overeen met één willekeurig teken (opnieuw met
inbegrip van ‘/’). En ‘[’ geeft het begin aan van een klasse van tekens, die
een lijst van tekens, bereiken of complementaties kan bevatten. Zie
\fBglob\fP(7) voor gedetailleerde informatie over het gebruik van
glob\-patronen. Merk op dat het mogelijk is dat de huidige implementatie meer
mappen en symbolische koppelingen terug toevoegt dan nodig is. Dit is om op
veilig te spelen en mogelijke mislukkingen bij het uitpakken te
vermijden. In de toekomst kan eraan gewerkt worden om dit te verbeteren.

Dit kan gebruikt worden om alle paden te verwijderen op enkele specifieke
paden na. Een typische casus is:

.nf
\fB\-\-path\-exclude=/usr/share/doc/*\fP
\fB\-\-path\-include=/usr/share/doc/*/copyright\fP
.fi

om alle documentatiebestanden op de copyrightbestanden na te verwijderen.

Deze twee opties kunnen meermaals opgegeven en afwisselend ingevoegd
worden. Ze worden allebei in de opgegeven volgorde verwerkt, waarbij de
laatste regel die een overeenkomst met een bestandsnaam oplevert, de
uiteindelijke beslissing geeft.

De filters worden toegepast bij het uitpakken van de binaire pakketten en
hebben als zodanig enkel weet van het type object dat op dat ogenblik
gefilterd wordt (bijv. een gewoon bestand of een map) en hebben geen zicht
op welke objecten nadien zullen komen. Omdat deze filters neveneffecten
hebben (in tegenstelling tot \fBfind\fP(1)\-filters), zal het uitsluiten van een
exacte padnaam, die toevallig een map\-object, zoals \fI/usr/share/doc\fP,
blijkt te zijn, niet het gewenste effect hebben en zal enkel die padnaam
uitgesloten worden (die automatisch terug toegevoegd kan worden als de code
dit noodzakelijk acht). Van alle erop volgende bestanden die zich in die
mappen bevinden, zal het uitpakken mislukken.

Suggestie: zorg ervoor dat de glob\-patronen niet weggewerkt worden door uw
shell.
.TP 
\fB\-\-verify\-format\fP\fI naam\-van\-indeling\fP
Stelt de indeling in van de uitvoer van het commando \fB\-\-verify\fP (sinds dpkg
1.17.2).

Momenteel is \fBrpm\fP de enige ondersteunde indeling van de uitvoer. Ze
bestaat uit een regel voor elk pad waarvoor een toets mislukte. De regels
beginnen met 9 tekens om van iedere specifieke toets het resultaat te
rapporteren, waarbij een ‘\fB?\fP’ betekent dat de toets niet uitgevoerd kon
worden (ontbrekende ondersteuning, bestandspermissies, enz.), een ‘\fB.\fP’
betekent dat de toets slaagde en een alfanumeriek teken betekent dat een
specifieke toets mislukte. Een mislukte toets van de md5\-controlesom (de
inhoud van het bestand werd gewijzigd) wordt aangegeven met een ‘\fB5\fP’ op de
plaats van het derde teken. De regel wordt gevolgd door een spatie en een
attribuutteken (momenteel ‘\fBc\fP’ voor conffiles (configuratiebestanden)),
nog een spatie en de padnaam.
.TP 
\fB\-\-status\-fd \fP\fIn\fP
Stuur status\- en voortgangsinformatie die leesbaar is voor machines naar
bestandsindicator \fIn\fP. Deze optie kan meermaals opgegeven worden. Meestal
wordt de informatie met één item per regel weergegeven in een van de
volgende vormen:
.RS
.TP 
\fBstatus: \fP\fIpakket\fP\fB: \fP\fIstatus\fP
De status van het pakket wijzigde. \fIstatus\fP is zoals in het statusbestand.
.TP 
\fBstatus: \fP\fIpakket\fP\fB : error : \fP\fIomstandig\-foutbericht\fP
Er trad een fout op. Eventuele regeleindes in het \fIomstandig\-foutbericht\fP
zullen voor de uitvoer omgezet worden naar spaties.
.TP 
\fBstatus: \fP\fIbestand\fP\fB : conffile\-prompt : '\fP\fIecht\-oud\fP\fB' '\fP\fIecht\-nieuw\fP\fB' \fP\fIdoor\-gebruiker\-bewerkt\fP\fB \fP\fIdoor\-distributie\-bewerkt\fP
Er wordt een vraag in verband met een conffile (configuratiebestand) gesteld
aan de gebruiker.
.TP 
\fBprocessing: \fP\fIfase\fP\fB: \fP\fIpakket\fP
Verzonden juist voor het begin van een verwerkingsfase. \fIfase\fP is een van
de volgende: \fBupgrade\fP, \fBinstall\fP (beide verzonden voor het uitpakken),
\fBconfigure\fP, \fBtrigproc\fP, \fBdisappear\fP, \fBremove\fP, \fBpurge\fP.
.RE
.TP 
\fB\-\-status\-logger\fP=\fIcommando\fP
Verstuur door een machine te lezen informatie over pakketstatus en voortgang
naar de standaardinvoer van het shell\-commando \fIcommando\fP dat via \*(lqsh \-c\*(rq
moet uitgevoerd worden (sinds dpkg 1.16.0). Deze optie kan meermaals
opgegeven worden. De indeling van de uitvoer is dezelfde als bij
\fB\-\-status\-fd\fP.
.TP 
\fB\-\-log=\fP\fIbestandsnaam\fP
Log updates van toestandswijzigingen en acties in \fIbestandsnaam\fP in plaats
van in het standaardlogbestand \fI%LOGDIR%/dpkg.log\fP. Indien deze optie
meerdere keren opgegeven wordt, wordt de laatst opgegeven bestandsnaam
gebruikt. Log\-berichten zijn in de volgende vorm:
.RS
.TP 
YYYY\-MM\-DD HH:MM:SS \fBstartup\fP \fItype\fP \fIcommando\fP
Voor elke aanroep van dpkg waarbij \fItype\fP ofwel \fBarchives\fP (met een
\fIcommando\fP \fBunpack\fP of \fBinstall\fP) is ofwel \fBpackages\fP (met een
\fIcommando\fP \fBconfigure\fP, \fBtriggers\-only\fP, \fBremove\fP of \fBpurge\fP).
.TP 
YYYY\-MM\-DD HH:MM:SS \fBstatus\fP \fItoestand\fP \fIpkt\fP \fIgeïnstalleerde\-versie\fP
Voor updates van toestandswijzigingen.
.TP 
YYYY\-MM\-DD HH:MM:SS \fIactie\fP \fIpkt\fP \fIgeïnstalleerde\-versie\fP \fIbeschikbare\-versie\fP
Voor acties waarbij \fIactie\fP een van de volgende is: \fBinstall\fP, \fBupgrade\fP,
\fBconfigure\fP, \fBtrigproc\fP, \fBdisappear\fP, \fBremove\fP of \fBpurge\fP.
.TP 
YYYY\-MM\-DD HH:MM:SS \fBconffile\fP \fIbestandsnaam\fP \fIbeslissing\fP
Voor conffile\-wijzigingen (wijzigingen aan een configuratiebestand) waarbij
\fIbeslissing\fP ofwel \fBinstall\fP ofwel \fBkeep\fP is.
.RE
.TP 
\fB\-\-no\-debsig\fP
Tracht pakket\-ondertekeningen niet te verifiëren.
.TP 
\fB\-\-no\-triggers\fP
Voer in deze doorloop geen triggers uit (sinds dpkg 1.14.17), maar
activeringen blijven wel opgetekend worden. Indien het gebruikt wordt in
combinatie met \fB\-\-configure\fP \fIpakket\fP of \fB\-\-triggers\-only\fP \fIpakket\fP, dan
zullen de postinst\-scripts van het vermelde pakket nog steeds uitgevoerd
worden, zelfs als enkel nog het uitvoeren van triggers dient te
gebeuren. Het gebruik van deze optie kan pakketten achterlaten in een
ongepaste toestand van \fBtriggers\-awaited\fP en \fBtriggers\-pending\fP. Dit kan
later gerepareerd worden door \fBdpkg \-\-configure \-\-pending\fP uit te voeren.
.TP 
\fB\-\-triggers\fP
Annuleert een eerder gegeven \fB\-\-no\-triggers\fP (sinds dpkg 1.14.17).
.
.SH AFSLUITSTATUS
.TP 
\fB0\fP
De gevraagde actie werd succesvol uitgevoerd. Of een commando dat een toets
of een assertie verrichtte gaf waar als resultaat.
.TP 
\fB1\fP
Een commando dat een toets of een assertie verrichtte gaf onwaar als
resultaat.
.TP 
\fB2\fP
Fatale of onherstelbare fout die te wijten is aan ongeldig gebruik van de
commandoregel of aan interacties met het systeem, zoals het benaderen van de
database, het toewijzen van geheugen, enz.
.
.SH OMGEVING
.SS "Externe omgeving"
.TP 
\fBPATH\fP
Er wordt verwacht dat deze variabele in de omgeving gedefinieerd wordt en de
systeempaden aangeeft waar verschillende noodzakelijke programma's gevonden
kunnen worden. Indien deze variabele niet ingesteld is of de programma's
niet gevonden kunnen worden, zal \fBdpkg\fP afbreken.
.TP 
\fBHOME\fP
Indien de variabele ingesteld is, zal \fBdpkg\fP hem gebruiken als de map waar
het gebruikersspecifieke configuratiebestand kan gelezen worden.
.TP 
\fBTMPDIR\fP
Indien de variabele ingesteld is, zal \fBdpkg\fP hem gebruiken als de map
waarin tijdelijke bestanden en mappen kunnen aangemaakt worden.
.TP 
\fBPAGER\fP
Het programma dat door \fBdpkg\fP zal uitgevoerd worden bij het tonen van de
conffiles (configuratiebestanden).
.TP 
\fBSHELL\fP
Het programma dat \fBdpkg\fP zal uitvoeren bij het starten van een nieuwe
interactieve shell.
.TP 
\fBCOLUMNS\fP
Stelt het aantal kolommen in dat \fBdpkg\fP moet gebruiken bij het laten zien
van opgemaakte tekst. Wordt momenteel enkel gebruikt door \fB\-\-list\fP.
.TP 
\fBDPKG_COLORS\fP
Stelt de kleurmodus in (sinds dpkg 1.18.5). Waarden die momenteel gebruikt
mogen worden zijn: \fBauto\fP (standaard), \fBalways\fP en \fBnever\fP.
.SS "Interne omgeving"
.TP 
\fBDPKG_ROOT\fP
Gedefinieerd door \fBdpkg\fP in de omgeving van het pakketonderhouderscript om
aan te geven op welke installatie gewerkt moet worden (sinds dpkg
1.18.5). Het is de bedoeling dat deze waarde vooraan toegevoegd wordt aan
elk pad waarop scripts van de pakketonderhouder ageren. Tijdens een normale
operatie is deze variabele leeg. Indien pakketten geïnstalleerd worden in
een afwijkende \fBinstdir\fP (installatiemap), zal \fBdpkg\fP de scripts van de
pakketonderhouder normaal uitvoeren met behulp van \fBchroot\fP(2) en deze
variabele leeg laten, maar indien \fB\-\-force\-script\-chrootless\fP opgegeven
werd, wordt het aanroepen van \fBchroot\fP(2) overgeslagen en is \fBinstdir\fP
niet leeg.
.TP 
\fBDPKG_ADMINDIR\fP
Defined by \fBdpkg\fP on the maintainer script environment to indicate the
\fBdpkg\fP administrative directory to use (since dpkg 1.16.0).  This variable
is always set to the current \fB\-\-admindir\fP value.
.TP 
\fBDPKG_SHELL_REASON\fP
Gedefinieerd door \fBdpkg\fP in de shell die door de conffile\-prompt (een vraag
in verband met de configuratie) geactiveerd wordt met het oog op het
onderzoeken van de situatie (sinds dpkg 1.15.6). Momenteel is de geldige
waarde: \fBconffile\-prompt\fP.
.TP 
\fBDPKG_CONFFILE_OLD\fP
Gedefinieerd door \fBdpkg\fP in de shell die door de conffile\-prompt (een vraag
in verband met de configuratie) geactiveerd wordt om de situatie te
onderzoeken (sinds dpkg 1.15.6). Bevat het pad naar de oude conffile
(configuratiebestand).
.TP 
\fBDPKG_CONFFILE_NEW\fP
Gedefinieerd door \fBdpkg\fP in de shell die door de conffile\-prompt (een vraag
in verband met de configuratie) geactiveerd wordt om de situatie te
onderzoeken (sinds dpkg 1.15.6). Bevat het pad naar de nieuwe conffile
(configuratiebestand).
.TP 
\fBDPKG_HOOK_ACTION\fP
Gedefinieerd door \fBdpkg\fP in de shell die geactiveerd wordt bij het
uitvoeren van een uitbreiding (hook) (sinds dpkg 1.15.4). Bevat de huidige
actie van \fBdpkg\fP.
.TP 
\fBDPKG_RUNNING_VERSION\fP
Gedefinieerd door \fBdpkg\fP binnen de omgeving van het script van de
pakketonderhouder als de versie van het exemplaar van \fBdpkg\fP dat momenteel
uitgevoerd wordt (sinds dpkg 1.14.17).
.TP 
\fBDPKG_MAINTSCRIPT_PACKAGE\fP
Gedefinieerd door \fBdpkg\fP binnen de omgeving van het script van de
pakketonderhouder als de naam van het pakket (zonder
architectuurkwalificatie) dat behandeld wordt (sinds dpkg 1.14.17).
.TP 
\fBDPKG_MAINTSCRIPT_PACKAGE_REFCOUNT\fP
Gedefinieerd door \fBdpkg\fP binnen de omgeving van het script van de
pakketonderhouder als het pakketreferentieaantal, d.w.z. het aantal
pakketexemplaren met een status groter dan \fBnot\-installed\fP
(niet\-geïnstalleerd) (sinds dpkg 1.17.2).
.TP 
\fBDPKG_MAINTSCRIPT_ARCH\fP
Gedefinieerd door \fBdpkg\fP binnen de omgeving van het script van de
pakketonderhouder als de architectuur waarvoor het pakket gebouwd werd
(sinds dpkg 1.15.4).
.TP 
\fBDPKG_MAINTSCRIPT_NAME\fP
Gedefinieerd door \fBdpkg\fP binnen de omgeving van het script van de
pakketonderhouder als de naam van het script dat uitgevoerd wordt. Dit is
een van de volgende: \fBpreinst\fP, \fBpostinst\fP, \fBprerm\fP of \fBpostrm\fP (sinds
dpkg 1.15.7).
.TP 
\fBDPKG_MAINTSCRIPT_DEBUG\fP
Gedefinieerd door \fBdpkg\fP binnen de omgeving van het script van de
pakketonderhouder als de waarde (‘\fB0\fP’ of ‘\fB1\fP’), waarmee nota genomen
wordt van het feit of debuggen aangevraagd werd (met de optie \fB\-\-debug\fP)
voor de scripts van de pakketonderhouder (sinds dpkg 1.18.4).
.
.SH BESTANDEN
.TP 
\fI%PKGCONFDIR%/dpkg.cfg.d/[0\-9a\-zA\-Z_\-]*\fP
Bestanden met configuratiefragmenten (sinds dpkg 1.15.4).
.TP 
\fI%PKGCONFDIR%/dpkg.cfg\fP
Configuratiebestand met standaardopties.
.TP 
\fI%LOGDIR%/dpkg.log\fP
Standaard logbestand (zie \fI%PKGCONFDIR%/dpkg.cfg\fP en de optie \fB\-\-log\fP).
.P
De andere bestanden worden hieronder weergegeven in hun standaardmap. Zie de
optie \fB\-\-admindir\fP om te weten hoe u de locatie van deze bestanden kunt
wijzigen.
.TP 
\fI%ADMINDIR%/available\fP
Lijst van beschikbare pakketten.
.TP 
\fI%ADMINDIR%/status\fP
Status van de beschikbare pakketten. Dit bestand bevat informatie over het
feit of een pakket al dan niet gemarkeerd werd om verwijderd te worden, of
het al dan niet geïnstalleerd is, enz. Zie het onderdeel \fBINFORMATIE OVER
PAKKETTEN\fP voor meer informatie.

Dagelijks wordt een reservekopie van het statusbestand gemaakt in
\fI/var/backups\fP. Die kan nuttig zijn mocht het bestand verloren gegaan zijn
of beschadigd ten gevolge van problemen met het bestandssysteem.
.P
De volgende bestanden zijn componenten van een binair pakket. Zie \fBdeb\fP(5)
voor meer informatie over hen:
.RS
.nf
\fIcontrol\fP (\fBdeb\-control\fP(5))
\fIconffiles\fP (\fBdeb\-conffiles\fP(5))
\fIpreinst\fP (\fBdeb\-preinst\fP(5))
\fIpostinst\fP (\fBdeb\-postinst\fP(5))
\fIprerm\fP (\fBdeb\-prerm\fP(5))
\fIpostrm\fP (\fBdeb\-postrm\fP(5))
\fItriggers\fP (\fBdeb\-triggers\fP(5))
\fIshlibs\fP (\fBdeb\-shlibs\fP(5))
\fIsymbols\fP (\fBdeb\-symbols\fP(5))
.fi
.RE
.
.SH BUGS
\fB\-\-no\-act\fP geeft gewoonlijk minder informatie dan nuttig kan zijn.
.
.SH VOORBEELDEN
Om de geïnstalleerde pakketten op te sommen die verband houden met de editor
\fBvi\fP(1) (merk op dat \fBdpkg\-query\fP standaard niet langer het bestand
\fIavailable\fP laadt en dat in de plaats daarvan daarvoor de optie
\fBdpkg\-query\fP \fB\-\-load\-avail\fP gebruikt moet worden):
.br
     \fBdpkg \-l '*vi*'\fP
.br

Om de items uit \fI%ADMINDIR%/available\fP over twee pakketten te zien:
.br
     \fBdpkg \-\-print\-avail elvis vim | less\fP
.br

Om zelf in de lijst van pakketten te zoeken:
.br
     \fBless %ADMINDIR%/available\fP
.br

Om een geïnstalleerde pakket elvis te verwijderen:
.br
     \fBdpkg \-r elvis\fP
.br

Om een pakket te installeren moet u het eerst zoeken in een archief of op
een CD. Het bestand \fIavailable\fP laat zien dat het pakket vim zich in de
sectie \fBeditors\fP bevindt:
.br
     \fBcd /media/cdrom/pool/main/v/vim\fP
     \fBdpkg \-i vim_4.5\-3.deb\fP
.br

Om een lokale kopie te maken van de pakketselectietoestand:
.br
     \fBdpkg \-\-get\-selections >myselections\fP
.br

U zou dit bestand kunnen overbrengen naar een andere computer en nadat u
daar het bestand \fIavailable\fP bijgewerkt hebt met het frontend voor
pakketbeheer van uw voorkeur (zie https://wiki.debian.org/Teams/Dpkg/FAQ
voor meer details), bijvoorbeeld:
.br
     \fBapt\-cache dumpavail | dpkg \-\-merge\-avail\fP
.br
of met dpkg 1.17.6 of vroegere versies:
.br
     \fBavail=`mktemp`\fP
     \fBapt\-cache dumpavail >"$avail"\fP
     \fBdpkg \-\-merge\-avail "$avail"\fP
     \fBrm "$avail"\fP
.br
kunt u het installeren met:
.br
     \fBdpkg \-\-clear\-selections\fP
     \fBdpkg \-\-set\-selections <myselections\fP
.br

Merk op dat dit eigenlijk niet echt iets installeert of verwijdert, maar
enkel de selectiestatus voor de gevraagde pakketten instelt. U heeft een
andere toepassing nodig om de gevraagde pakketten echt te downloaden en te
installeren. Voer bijvoorbeeld \fBapt\-get dselect\-upgrade\fP uit.

U zult ondervinden dat \fBdselect\fP(1) gewoonlijk een meer comfortabele manier
biedt om de selectiestatus van pakketten te wijzigen.
.br
.
.SH "BIJKOMENDE FUNCTIONALITEIT"
U kunt bijkomende functionaliteit verkrijgen door het installeren van elk
van de volgende pakketten: \fBapt\fP, \fBaptitude\fP en \fBdebsums\fP.
.
.SH "ZIE OOK"
.ad l
\fBaptitude\fP(1), \fBapt\fP(1), \fBdselect\fP(1), \fBdpkg\-deb\fP(1), \fBdpkg\-query\fP(1),
\fBdeb\fP(5), \fBdeb\-control\fP(5), \fBdpkg.cfg\fP(5), en \fBdpkg\-reconfigure\fP(8).
.
.SH AUTEURS
Zie \fI%PKGDOCDIR%/THANKS\fP voor een lijst van mensen die bijgedragen hebben
aan \fBdpkg\fP.
