.\" dpkg manual page - dpkg-architecture(1)
.\"
.\" Copyright © 2005 Marcus Brinkmann <brinkmd@debian.org>
.\" Copyright © 2005 Scott James Remnant <scott@netsplit.com>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2009-2012 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-architecture 1 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
dpkg\-architecture \- Architektur zum Paketbau setzen und bestimmen
.
.SH ÜBERSICHT
\fBdpkg\-architecture\fP [\fIOption\fP …] [\fIBefehl\fP]
.PP
.
.SH BESCHREIBUNG
\fBdpkg\-architecture\fP stellt eine Möglichkeit bereit, die Rechner\-Architektur
für den Paketbau zu bestimmen und zu setzen.
.PP
Die Bau\-Architektur wird immer über einen externen Aufruf an \fBdpkg\fP(1)
bestimmt und kann nicht auf der Befehlszeile gesetzt werden.
.PP
Sie können die Host\-Architektur (Wirt\-Architektur) spezifizieren, indem Sie
eine oder beide der Optionen \fB\-\-host\-arch\fP oder \fB\-\-host\-type\fP
verwenden. Der Standardwert wird über einen externen Aufruf an \fBgcc\fP(1)
ermittelt oder ist identisch mit der Bauarchitektur, falls sowohl \fBCC\fP als
auch Gcc nicht verfügbar sind. Einer von \fB\-\-host\-arch\fP oder \fB\-\-host\-type\fP
ist ausreichend, der Wert des anderen wird auf einen brauchbaren Wert
gesetzt. Tatsächlich ist es oft besser, nur einen der beiden anzugeben, da
\fBdpkg\-architecture\fP Sie warnen wird, falls Ihre Wahl nicht mit dem
Standardwert übereinstimmt.
.
.SH BEFEHLE
.TP 
\fB\-l\fP, \fB\-\-list\fP
Zeige die Umgebungsvariablen, eine pro Zeile, in dem Format
\fIVARIABLE=Wert\fP. Dies ist die Standardaktion.
.TP 
\fB\-e\fP, \fB\-\-equal\fP \fIArchitektur\fP
Überprüfe auf Gleichheit der Architekturen (seit Dpkg 1.13.13). Es prüft die
aktuelle oder angegebene Debian\-Host\-Architektur mit \fIArchitektur\fP auf
Gleichheit. Diese Aktion expandiert nicht die Architektur\-Platzhalter
(Wildcards). Der Befehl beendet sich mit einem Exit\-Status von 0, falls eine
Übereinstimmung besteht, andernfalls mit 1.

.TP 
\fB\-i\fP, \fB\-\-is\fP \fIArchitektur\-Platzhalter\fP
Überprüfe auf Gleichheit der Architekturen (seit Dpkg 1.13.13). Es prüft die
aktuelle oder angegebene Debian\-Host\-Architektur mit
\fIArchitektur\-Platzhalter\fP, nachdem dieser zu einem Architektur\-Platzhalter
expandiert wurde und prüft, ob sie passen. Der Befehl beendet sich mit einem
Exit\-Status von 0, falls eine Übereinstimmung besteht, andernfalls mit 1.
.TP 
\fB\-q\fP, \fB\-\-query\fP \fIVariablenname\fP
Zeige den Wert einer einzelnen Variablen an.
.TP 
\fB\-s\fP, \fB\-\-print\-set\fP
Zeige einen Export\-Befehl. Dies kann dazu verwendet werden, um
Umgebungsvariablen mittels eval zu setzen.
.TP 
\fB\-u\fP, \fB\-\-print\-unset\fP
Ähnlich wie \fB\-\-print\-unset\fP, gebe einen Export\-Befehl aus, der alle
Variablen löscht.
.TP 
\fB\-c\fP, \fB\-\-command\fP \fIBefehl\fP
Führe einen \fIBefehl\fP in einer Umgebung aus, in der alle Variablen auf die
festgelegten Werte gesetzt sind.
.TP 
\fB\-L\fP, \fB\-\-list\-known\fP
Gib eine Liste von gültigen Architekturnamen aus. Möglicherweise durch eine
oder mehrere der Abgleich\-Optionen \fB\-\-match\-wildcard\fP, \fB\-\-match\-bits\fP oder
\fB\-\-match\-endian\fP eingeschränkt (seit Dpkg 1.17.14).
.TP 
\fB\-?\fP, \fB\-\-help\fP
Zeige den Bedienungshinweis und beende.
.TP 
\fB\-\-version\fP
Gebe die Version aus und beende sich.
.
.SH OPTIONEN
.TP 
\fB\-a\fP, \fB\-\-host\-arch\fP \fIArchitektur\fP
Setzt die Debian\-Host\-Architektur.
.TP 
\fB\-t\fP, \fB\-\-host\-type\fP \fIGNU\-Systemtyp\fP
Setzt den Host\-GNU\-Systemtyp.
.TP 
\fB\-A\fP, \fB\-\-target\-arch\fP \fIArchitektur\fP
Setzt die Ziel\-Debian\-Architektur (seit Dpkg 1.17.14).
.TP 
\fB\-T\fP, \fB\-\-target\-type\fP \fIGNU\-Systemtyp\fP
Setzt den Ziel\-GNU\-Systemtyp (seit Dpkg 1.17.14).
.TP 
\fB\-W\fP, \fB\-\-match\-wildcard\fP \fIArchitektur\-Platzhalter\fP
Begrenzt die mit \fB\-\-list\-known\fP aufgeführten Architekturen auf solche, die
auf den angegebenen Architektur\-Platzhalter passen (seit Dpkg 1.17.14).
.TP 
\fB\-B\fP, \fB\-\-match\-bits\fP \fIArchitektur\-Bits\fP
Begrenzt die mit \fB\-\-list\-known\fP aufgeführten Architekturen auf solche mit
den angegebenen CPU\-Bits (seit Dpkg 1.17.14). Entweder \fB32\fP oder \fB64\fP.
.TP 
\fB\-E\fP, \fB\-\-match\-endian\fP \fIArchitektur\-Endianness\fP
Begrenzt die mit \fB\-\-list\-known\fP aufgeführten Architekturen auf solche mit
der angegebenen Endianness (seit Dpkg 1.17.14). Entweder \fBlittle\fP oder
\fBbig\fP.
.TP 
\fB\-f\fP, \fB\-\-force\fP
Existierende Umgebungsvariablen mit dem gleichen Namen wie vom Skript
verwendet werden nicht überschrieben (d.h. sie werden von
\fBdpkg\-architecture\fP verwendet), es sei denn, die »force«\-Markierung ist
gesetzt. Dies erlaubt es dem Benutzer einen Wert zu überschreiben, selbst
wenn der Aufruf von \fBdpkg\-architecture\fP tief in einem anderen Skript
versteckt ist (beispielsweise \fBdpkg\-buildpackage\fP(1)).
.
.SH AUSDRÜCKE
.IP Baumaschine 4
Die Maschine, auf der das Paket gebaut wird.
.IP Host\-Maschine 4
Die Maschine, für die das Paket gebaut ist.
.IP Ziel\-Maschine 4
Die Maschine, für die der Compiler baut. Dies wird nur beim Bau einer
Cross\-Toolchain und zum Bau von Code für die Ziel\-Architektur benötigt. Die
Cross\-Toolchain wird auf der Bauarchitektur gebaut und läuft dann auf der
Host\-Architektur.
.IP Debian\-Architektur 4
Die Debian\-Architektur\-Zeichenkette, die den binären Baum im FTP\-Archiv
spezifiziert. Beispiele: i386, sparc, hurd\-i386.
.IP Debian\-Architekturtupel 4
Ein Debian\-Architekturtupel ist eine vollqualifizierte Architektur mit allen
Komponenten ausgeschrieben. Dies unterscheidet sich von der
Debian\-Architektur zumindestens in der Weise, dass das \fIABI\fP nicht
eingebettet ist. Das aktuelle Tupel hat die Form
\fIABI\fP\-\fILibc\fP\-\fIOS\fP\-\fICPU\fP. Beispiele: base\-gnu\-linux\-amd64,
eabihf\-musl\-linux\-arm.
.IP Debian\-Architektur\-Platzhalter 4
Ein Debian\-Architektur\-Platzhalter ist eine spezielle
Architektur\-Zeichenkette, die auf jede reale Architektur, die ein Teil davon
ist, passt. Die allgemeine Form ist ein Debian\-Architektur\-Tupel mit vier
oder weniger Elementen und bei dem mindestens eines \fBany\fP ist. Fehlende
Elemente des Tupels werden implizit als \fBany\fP vorangestellt und daher sind
die folgenden Tupel äquivalent:
.nf
    \fBany\fP\-\fBany\fP\-\fBany\fP\-\fBany\fP = \fBany\fP
    \fBany\fP\-\fBany\fP\-\fIos\fP\-\fBany\fP = \fIos\fP\-\fBany\fP
    \fBany\fP\-\fIlibc\fP\-\fBany\fP\-\fBany\fP = \fIlibc\fP\-\fBany\fP\-\fBany\fP
.fi
Beispiele: linux\-any, any\-i386, hurd\-any, eabi\-any\-any\-arm, musl\-any\-any.
.IP GNU\-Systemtyp 4
Eine Architektur\-Spezifikations\-Zeichenkette besteht aus zwei, durch einen
Bindestrich getrennten Teilen: CPU und System. Beispiele: i586\-linux\-gnu,
sparc\-linux\-gnu, i686\-gnu, x86_64\-netbsd.
.IP Multiarch\-Tripel 4
Der bereinigte GNU\-Systemtyp, wird für Dateipfade verwandt. Dieses Tripel
ändert sich auch nicht, wenn das zugrundeliegende ISA erhöht wird, so dass
die daraus resultierenden Pfade dauerhaft stabil bleiben. Derzeit ist der
einzige Unterschied zum GNU\-Sytemtyp, dass der CPU\-Anteil für i386\-basierte
Systeme immer i386 lautet. Beispiele: i386\-linux\-gnu,
x86_64\-linux\-gnu. Beispielpfade: /lib/powerpc64le\-linux\-gnu/,
/usr/lib/i386\-kfreebsd\-gnu/.
.
.SH VARIABLEN
Die folgenden Variablen werden von \fBdpkg\-architecture\fP gesetzt:
.IP \fBDEB_BUILD_ARCH\fP 4
Die Debian\-Architektur der Baumaschine.
.IP \fBDEB_BUILD_ARCH_ABI\fP 4
Der Debian\-ABI\-Name der Baumaschine. (Seit Dpkg 1.18.11).
.IP \fBDEB_BUILD_ARCH_LIBC\fP 4
Der Debian\-Libc\-Name der Baumaschine. (Seit Dpkg 1.18.11).
.IP \fBDEB_BUILD_ARCH_OS\fP 4
Der Debian\-Systemname der Baumaschine. (Seit Dpkg 1.13.2).
.IP \fBDEB_BUILD_ARCH_CPU\fP 4
Der Debian\-CPU\-Name der Baumaschine. (Seit Dpkg 1.13.2).
.IP \fBDEB_BUILD_ARCH_BITS\fP 4
Die Zeigergröße der Baumaschine in Bits. (Seit Dpkg 1.15.4).
.IP \fBDEB_BUILD_ARCH_ENDIAN\fP 4
Die Endianness der Baumaschine (little/big; seit Dpkg 1.15.4).
.IP \fBDEB_BUILD_GNU_CPU\fP 4
Der CPU\-Teil von \fBDEB_BUILD_GNU_TYPE\fP.
.IP \fBDEB_BUILD_GNU_SYSTEM\fP 4
Der System\-Teil von \fBDEB_BUILD_GNU_TYPE\fP.
.IP \fBDEB_BUILD_GNU_TYPE\fP 4
Der GNU\-Systemtyp der Baumaschine.
.IP \fBDEB_BUILD_MULTIARCH\fP 4
Der klargestellte GNU\-Systemtyp der Baumaschine, wird für Dateisystempfade
benutzt.
.IP \fBDEB_HOST_ARCH\fP 4
Die Debian\-Architektur der Host\-Maschine.
.IP \fBDEB_HOST_ARCH_ABI\fP 4
Der Debian\-ABI\-Name der Host\-Maschine. (Seit Dpkg 1.18.11).
.IP \fBDEB_HOST_ARCH_LIBC\fP 4
Der Debian\-Libc\-Name der Host\-Maschine. (Seit Dpkg 1.18.11).
.IP \fBDEB_HOST_ARCH_OS\fP 4
Der Debian\-Systemname der Host\-Maschine. (Seit Dpkg 1.13.2).
.IP \fBDEB_HOST_ARCH_CPU\fP 4
Der Debian\-CPU\-Name der Host\-Maschine. (Seit Dpkg 1.13.2).
.IP \fBDEB_HOST_ARCH_BITS\fP 4
Die Zeigergröße der Host\-Maschine in Bits. (Seit Dpkg 1.15.4).
.IP \fBDEB_HOST_ARCH_ENDIAN\fP 4
Die Endianness der Host\-Maschine (little/big; seit Dpkg 1.15.4).
.IP \fBDEB_HOST_GNU_CPU\fP 4
Der CPU\-Teil von \fBDEB_HOST_GNU_TYPE\fP.
.IP \fBDEB_HOST_GNU_SYSTEM\fP 4
Der System\-Teil von \fBDEB_HOST_GNU_TYPE\fP.
.IP \fBDEB_HOST_GNU_TYPE\fP 4
Der GNU\-Systemtyp der Host\-Maschine.
.IP \fBDEB_HOST_MULTIARCH\fP 4
Der klargestellte GNU\-Systemtyp der Host\-Maschine, wird für Dateisystempfade
benutzt. (Seit Dpkg 1.16.0).
.IP \fBDEB_TARGET_ARCH\fP 4
Die Debian\-Architektur der Ziel\-Maschine (seit Dpkg 1.17.14).
.IP \fBDEB_TARGET_ARCH_ABI\fP 4
Der Debian\-ABI\-Name der Ziel\-Maschine. (Seit Dpkg 1.18.11).
.IP \fBDEB_TARGET_ARCH_LIBC\fP 4
Der Debian\-Libc\-Name der Ziel\-Maschine. (Seit Dpkg 1.18.11).
.IP \fBDEB_TARGET_ARCH_OS\fP 4
Der Debian\-Systemname der Ziel\-Maschine. (Seit Dpkg 1.17.14).
.IP \fBDEB_TARGET_ARCH_CPU\fP 4
Der Debian\-CPU\-Name der Ziel\-Maschine. (Seit Dpkg 1.17.14).
.IP \fBDEB_TARGET_ARCH_BITS\fP 4
Die Zeigergröße der Ziel\-Maschine in Bits. (Seit Dpkg 1.17.14).
.IP \fBDEB_TARGET_ARCH_ENDIAN\fP 4
Die Endianness der Ziel\-Maschine (little/big; seit Dpkg 1.17.14).
.IP \fBDEB_TARGET_GNU_CPU\fP 4
Der CPU\-Teil von \fBDEB_TARGET_GNU_TYPE\fP. (Seit Dpkg 1.17.14).
.IP \fBDEB_TARGET_GNU_SYSTEM\fP 4
Der System\-Teil von \fBDEB_TARGET_GNU_TYPE\fP. (Seit Dpkg 1.17.14).
.IP \fBDEB_TARGET_GNU_TYPE\fP 4
Der GNU\-Systemtyp der Ziel\-Maschine. (Seit Dpkg 1.17.14).
.IP \fBDEB_TARGET_MULTIARCH\fP 4
Der klargestellte GNU\-Systemtyp der Ziel\-Maschine, wird für Dateisystempfade
benutzt. (Seit Dpkg 1.17.14).
.
.SH DATEIEN
.SS Architekturtabellen
Alle diese Dateien müssen vorhanden sein, damit \fBdpkg\-architecture\fP
funktioniert. Ihr Ort kann zur Laufzeit mit der Umgebungsvariable
\fBDPKG_DATADIR\fP überschrieben werden. Diese Tabellen enthalten in der ersten
Zeile ein Format\-\fBVersion\fPs\-Pseudofeld, um ihre Version zu kennzeichnen, so
dass Auswerteprogramme prüfen können, ob sie es verstehen. Beispiel: »#
Version=1.0«.
.TP 
\fI%PKGDATADIR%/cputable\fP
Tabelle der bekannten CPU\-Namen und Abbildungen auf ihre
GNU\-Namen. Formatversion 1.0 (seit Dpkg 1.13.2).
.TP 
\fI%PKGDATADIR%/ostable\fP
Tabelle der bekannten Betriebssystemnamen und Abbildungen auf ihre
GNU\-Namen. Formatversion 2.0 (seit Dpkg 1.18.11).
.TP 
\fI%PKGDATADIR%/tupletable\fP
Abbildung zwischen den Debian\-Architektur\-Tupeln und den
Debian\-Architekturnamen. Formatversion 1.0 (seit Dpkg 1.18.11).
.TP 
\fI%PKGDATADIR%/abitable\fP
Tabelle von
Debian\-Architektur\-ABI\-Attributs\-Außerkraftsetzungen. Formatversion 2.0
(seit Dpkg 1.18.11).
.SS Paketierungsunterstützung
.TP 
\fI%PKGDATADIR%/architecture.mk\fP
Makefile\-Schnipsel, das alle Variablen, die \fBdpkg\-architecture\fP ausgibt,
korrekt setzt und exportiert (seit Dpkg 1.16.1).
.
.SH BEISPIELE
\fBdpkg\-buildpackage\fP akzeptiert die \fB\-a\fP\-Option und gibt dies an
\fBdpkg\-architecture\fP weiter. Weitere Beispiele:
.IP
CC=i386\-gnu\-gcc dpkg\-architecture \-c debian/rules build
.IP
eval \`dpkg\-architecture \-u\`
.PP
Überprüfe, ob die aktuelle oder angegebene Host\-Architektur identisch zu
einer Architektur ist:
.IP
dpkg\-architecture \-elinux\-alpha
.IP
dpkg\-architecture \-amips \-elinux\-mips
.PP
Überprüfe, ob die aktuelle oder angegebene Host\-Architektur ein Linux\-System
ist:
.IP
dpkg\-architecture \-ilinux\-any
.IP
dpkg\-architecture \-ai386 \-ilinux\-any
.
.SS "Verwendung in debian/rules"
Die Umgebungsvariablen, die von \fBdpkg\-architecture\fP gesetzt werden, werden
an \fIdebian/rules\fP als Make\-Variablen weitergegeben (lesen Sie hierzu die
Make\-Dokumentation). Allerdings sollten Sie sich nicht auf diese verlassen,
da damit der manuelle Aufruf des Skripts verhindert wird. Stattdessen
sollten Sie sie immer mit \fBdpkg\-architecture\fP mit der \fB\-q\fP\-Option
initialisieren. Hier sind einige Beispiele, die auch zeigen, wie sie die
Cross\-Kompilierungs\-Unterstützung in Ihrem Paket verbessern können:
.PP
Ermitteln des GNU\-Systemtyps und dessen Weiterleitung an ./configure:
.PP
.RS 4
.nf
DEB_BUILD_GNU_TYPE ?= $(shell dpkg\-architecture \-qDEB_BUILD_GNU_TYPE)
DEB_HOST_GNU_TYPE ?= $(shell dpkg\-architecture \-qDEB_HOST_GNU_TYPE)
[...]
ifeq ($(DEB_BUILD_GNU_TYPE), $(DEB_HOST_GNU_TYPE))
  confflags += \-\-build=$(DEB_HOST_GNU_TYPE)
else
  confflags += \-\-build=$(DEB_BUILD_GNU_TYPE) \e
               \-\-host=$(DEB_HOST_GNU_TYPE)
endif
[…]
\&./configure $(confflags)
.fi
.RE
.PP
Etwas nur für eine bestimmte Architektur erledigen:
.PP
.RS 4
.nf
DEB_HOST_ARCH ?= $(shell dpkg\-architecture \-qDEB_HOST_ARCH)

ifeq ($(DEB_HOST_ARCH),alpha)
  […]
endif
.fi
.RE
.PP
oder, falls Sie nur den CPU\- oder OS\-Typ überprüfen müssen, verwenden Sie
die \fBDEB_HOST_ARCH_CPU\fP\- oder \fBDEB_HOST_ARCH_OS\fP\-Variablen.
.PP
Beachten Sie, dass Sie sich auch auf ein externes Makefile\-Schnipsel
abstützen können, um alle Variablen, die \fBdpkg\-architecture\fP bereitstellen
kann, korrekt zu setzen:
.PP
.RS 4
.nf
include %PKGDATADIR%/architecture.mk

ifeq ($(DEB_HOST_ARCH),alpha)
  […]
endif
.fi
.RE
.PP
Auf jeden Fall sollten Sie niemals \fBdpkg \-\-print\-architecture\fP verwenden,
um die Architekturinformationen während eines Paketbaus zu erhalten.
.
.SH UMGEBUNG
.TP 
\fBDPKG_DATADIR\fP
If set, it will be used as the \fBdpkg\fP data directory, where the
architecture tables are located (since dpkg 1.14.17).  Defaults to
«%PKGDATADIR%».
.SH BEMERKUNGEN
Alle langen Befehle und Optionennamen sind seit Dpkg 1.17.17 verfügbar.
.
.SH "SIEHE AUCH"
\fBdpkg\-buildpackage\fP(1), \fBdpkg\-cross\fP(1).
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2016 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
