package bridge

import (
	"net"
	"testing"

	"github.com/docker/libnetwork/sandbox"
)

func TestSetupFixedCIDRv6(t *testing.T) {
	defer sandbox.SetupTestOSContext(t)()

	config := &networkConfiguration{}
	br := newInterface(config)

	_, config.FixedCIDRv6, _ = net.ParseCIDR("2002:db8::/48")
	if err := setupDevice(config, br); err != nil {
		t.Fatalf("Bridge creation failed: %v", err)
	}
	if err := setupBridgeIPv4(config, br); err != nil {
		t.Fatalf("Assign IPv4 to bridge failed: %v", err)
	}

	if err := setupBridgeIPv6(config, br); err != nil {
		t.Fatalf("Assign IPv4 to bridge failed: %v", err)
	}

	if err := setupFixedCIDRv6(config, br); err != nil {
		t.Fatalf("Failed to setup bridge FixedCIDRv6: %v", err)
	}

	var ip net.IP
	if ip, err := ipAllocator.RequestIP(config.FixedCIDRv6, nil); err != nil {
		t.Fatalf("Failed to request IP to allocator: %v", err)
	} else if expected := "2002:db8::1"; ip.String() != expected {
		t.Fatalf("Expected allocated IP %s, got %s", expected, ip)
	}

	if err := ipAllocator.ReleaseIP(config.FixedCIDRv6, ip); err != nil {
		t.Fatalf("Failed to release IP from allocator: %v", err)
	} else if _, err := ipAllocator.RequestIP(config.FixedCIDRv6, ip); err != nil {
		t.Fatalf("Failed to request a released IP: %v", err)
	}
}
