<!--[metadata]>
+++
title = "list"
description = "List the nodes in a cluster."
keywords = ["swarm, list"]
[menu.main]
identifier="swarm.list"
parent="smn_swarm_subcmds"
+++
<![end-metadata]-->

# list — List the nodes in a cluster

Use `list` to display a list of the nodes in a cluster.

To list the nodes in a cluster, use the following syntax:

    docker run swarm list [OPTIONS] <discovery>

The following examples show a few different syntaxes for the `<discovery>` argument:

etcd:

    swarm list etcd://<etcd_addr1>,<etcd_addr2>/<optional path prefix> <node_ip:port>

Consul:

    swarm list consul://<consul_addr>/<optional path prefix> <node_ip:port>

ZooKeeper:

    swarm list zk://<zookeeper_addr1>,<zookeeper_addr2>/<optional path prefix> <node_ip:port>

<!--tbd - show and explain the output from a real example-->

## Arguments

The `list` command has only one argument:

### `<discovery>` — Discovery backend

When you use the `list` command, use the `<discovery>` argument to specify one of the following discovery backends:

* `token://<token>`
* `consul://<ip1>/<path>`
* `etcd://<ip1>,<ip2>,<ip2>/<path>`
* `file://<path/to/file>`
* `zk://<ip1>,<ip2>/<path>`
* `[nodes://]<iprange>,<iprange>`

Where:

* `<token>` is a discovery token generated by Docker Hub's hosted discovery service. To generate this discovery token, use the [`create`](create.md) command.
    > Warning: Docker Hub's hosted discovery backend is not recommended for production use. It’s intended only for testing/development.

* `ip1`, `ip2`, `ip3` are each the IP address and port numbers of a discovery backend node.
* `path` (optional) is a path to a key-value store on the discovery backend. When you use a single backend to service multiple clusters, you use paths to maintain separate key-value stores for each cluster.
* `path/to/file` is the path to a file that contains a static list of the Swarm managers and nodes that are members the cluster. <!--tbd - can the file contain ipranges?-->
* `iprange` is an IP address or a range of IP addresses followed by a port number.

For example:

* A discovery token: `token://0ac50ef75c9739f5bfeeaf00503d4e6e`
* A Consul node: `consul://172.30.0.165:8500`

The environment variable for `<discovery>` is `$SWARM_DISCOVERY`.

For more information and examples, see the [Docker Swarm Discovery](../discovery.md) topic.

## Options

The `list` command has the following options:

### `--timeout` — Timeout period

Use `--timeout "<interval>s"` to specify the timeout period, in seconds, to wait for the discovery backend to return the list. The default interval is `10s`.

### `--discovery-opt` — Discovery options

Use `--discovery-opt <value>` to discovery options, such as paths to the TLS files; the CA's public key certificate, the certificate, and the private key of the distributed K/V store on a Consul or etcd discovery backend. You can enter multiple discovery options. For example:

    --discovery-opt kv.cacertfile=/path/to/mycacert.pem \
    --discovery-opt kv.certfile=/path/to/mycert.pem \
    --discovery-opt kv.keyfile=/path/to/mykey.pem \

For more information, see [Use TLS with distributed key/value discovery](../discovery.md)
