.\"
.\" ipptool man page for CUPS.
.\"
.\" Copyright 2010-2015 by Apple Inc.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH ipptool 1 "CUPS" "26 August 2015" "Apple Inc."
.SH NAME
ipptool \- perform internet printing protocol requests
.SH SYNOPSIS
.B ipptool
[
.B \-\-help
] [
.B \-\-stop\-after\-include\-error
] [
.B \-\-version
] [
.B \-4
] [
.B \-6
] [
.B \-C
] [
.B \-E
] [
.B \-I
] [
.B \-L
] [
.B \-P
.I filename.plist
] [
.B \-S
] [
.B \-T
.I seconds
] [
.B \-V
.I version
] [
.B \-X
] [
.B \-c
] [
.B \-d
.I name=value
] [
.B \-f
.I filename
] [
.B \-i
.I seconds
] [
.B \-n
.I repeat-count
] [
.B \-q
] [
.B \-t
] [
.B \-v ]
.I printer-uri
.I testfile
[ ...
.I testfile
]
.SH DESCRIPTION
.B ipptool
sends IPP requests to the specified
.I printer-uri
and tests and/or displays the results.
Each named
.I testfile
defines one or more requests, including the expected response status, attributes, and values.
Output is either a plain text, formatted text, CSV, or XML report on the standard output, with a non-zero exit status indicating that one or more tests have failed.
The
.I testfile
format is described in
.BR ipptoolfile (5).
.SH OPTIONS
The following options are recognized by
.B ipptool:
.TP 5
.B \-\-help
Shows program help.
.TP 5
.B \-\-stop-after-include-error
Tells
.B ipptool
to stop if an error occurs in an included file. Normally
.B ipptool
will continue with subsequent tests after the INCLUDE directive.
.TP 5
.B \-\-version
Shows the version of
.B ipptool
being used.
.TP 5
.B \-4
Specifies that
.B ipptool
must connect to the printer or server using IPv4.
.TP 5
.B \-6
Specifies that
.B ipptool
must connect to the printer or server using IPv6.
.TP 5
.B \-C
Specifies that requests should be sent using the HTTP/1.1 "Transfer\-Encoding: chunked" header, which is required for conformance by all versions of IPP.
The default is to use "Transfer\-Encoding: chunked" for requests with attached files and "Content\-Length:" for requests without attached files.
.TP 5
.B \-E
Forces TLS encryption when connecting to the server using the HTTP "Upgrade" header.
.TP 5
.B \-I
Specifies that
.B ipptool
will continue past errors.
.TP 5
.B \-L
Specifies that requests should be sent using the HTTP/1.0 "Content\-Length:" header, which is required for conformance by all versions of IPP.
The default is to use "Transfer\-Encoding: chunked" for requests with attached files and "Content\-Length:" for requests without attached files.
.TP 5
.BI \-P \ filename.plist
Specifies that the test results should be written to the named XML (Apple plist) file in addition to the regular test report (\fB\-t\fR).
This option is incompatible with the \fB\-i\fR (interval) and \fB\-n\fR (repeat\-count) options.
.TP 5
.B \-S
Forces (dedicated) TLS encryption when connecting to the server.
.TP 5
.BI \-T \ seconds
Specifies a timeout for IPP requests in seconds.
.TP 5
.BI \-V \ version
Specifies the default IPP version to use: 1.0, 1.1, 2.0, 2.1, or 2.2. If not specified, version 1.1 is used.
.TP 5
.B \-X
Specifies that XML (Apple plist) output is desired instead of the plain text report.
This option is incompatible with the \fB\-i\fR (interval) and \fB\-n\fR (repeat\-count) options.
.TP 5
.B \-c
Specifies that CSV (comma\-separated values) output is desired instead of the plain text output.
.TP 5
.BI \-d \ name=value
Defines the named variable.
.TP 5
.BI \-f \ filename
Defines the default request filename for tests.
.TP 5
.BI \-i \ seconds
Specifies that the (last)
.I testfile
should be repeated at the specified interval.
This option is incompatible with the \fB\-X\fR (XML plist output) option.
.TP 5
.B \-l
Specifies that plain text output is desired.
.TP 5
.BI \-n \ repeat\-count
Specifies that the (last)
.I testfile
should be repeated the specified number of times.
This option is incompatible with the \fI\-X\fR (XML plist output) option.
.TP 5
.B \-q
Be quiet and produce no output.
.TP 5
.B \-t
Specifies that CUPS test report output is desired instead of the plain text output.
.TP 5
.B \-v
Specifies that all request and response attributes should be output in CUPS test mode (\fB\-t\fR).
This is the default for XML output.
.SH EXIT STATUS
The
.B ipptool
program returns 0 if all tests were successful and 1 otherwise.
.SH FILES
The following standard files are available:
.nf
.I color.jpg
.I create\-printer\-subscription.test
.I document\-a4.pdf
.I document\-a4.ps
.I document\-letter.pdf
.I document\-letter.ps
.I get\-completed\-jobs.test
.I get\-jobs.test
.I get\-notifications.test
.I get\-printer\-attributes.test
.I get\-subscriptions.test
.I gray.jpg
.I ipp\-1.1.test
.I ipp\-2.0.test
.I ipp\-2.1.test
.I ipp\-2.2.test
.I ipp\-everywhere.test
.I onepage\-a4.pdf
.I onepage\-a4.ps
.I onepage\-letter.pdf
.I onepage\-letter.ps
.I print\-job.test
.I print\-job\-deflate.test
.I print\-job\-gzip.test
.I testfile.jpg
.I testfile.pcl
.I testfile.pdf
.I testfile.ps
.I testfile.txt
.I validate\-job.test
.fi
.SH CONFORMING TO
The
.B ipptool
program is unique to CUPS and conforms to the Internet Printing Protocol up to version 2.2.
.SH EXAMPLES
Get a list of completed jobs for "myprinter":
.nf

    ipptool ipp://localhost/printers/myprinter get\-completed\-jobs.test
.fi
.LP
Send email notifications to "user@example.com" when "myprinter" changes:
.nf

    ipptool \-d recipient=mailto:user@example.com \\
        ipp://localhost/printers/myprinter create\-printer\-subscription.test
.fi
.SH SEE ALSO
.BR ipptoolfile (5),
CUPS Online Help (http://localhost:631/help),
IANA IPP Registry (http://www.iana.org/assignments/ipp\-registrations),
PWG Internet Printing Protocol Workgroup (http://www.pwg.org/ipp)
RFC 2911 (http://tools.ietf.org/html/rfc2911),
.SH COPYRIGHT
Copyright \[co] 2007-2016 by Apple Inc.
