// $Id$
/* --------------------------------------------------------------------------
CppAD: C++ Algorithmic Differentiation: Copyright (C) 2003-16 Bradley M. Bell

CppAD is distributed under multiple licenses. This distribution is under
the terms of the
                    GNU General Public License Version 3.

A copy of this license is included in the COPYING file of this distribution.
Please visit http://www.coin-or.org/CppAD/ for information on other licenses.
-------------------------------------------------------------------------- */
// system include files used for I/O
# include <iostream>

// C style asserts
# include <cassert>

// for thread_alloc
# include <cppad/utility/thread_alloc.hpp>

// external complied tests
extern bool compare_op(void);
extern bool conditional_skip(void);
extern bool cumulative_sum(void);
extern bool forward_active(void);
extern bool nest_conditional(void);
extern bool print_for(void);
extern bool reverse_active(void);

namespace {
	// function that runs one test
	static size_t Run_ok_count    = 0;
	static size_t Run_error_count = 0;
	bool Run(bool TestOk(void), const char *name)
	{	bool ok = true;
		ok &= TestOk();
		if( ok )
		{	std::cout << "OK:    " << "optimize: " << name << std::endl;
			Run_ok_count++;
		}
		else
		{	std::cout << "Error: " << "optimize: " << name << std::endl;
			Run_error_count++;
		}
		return ok;
	}
}

// main program that runs all the tests
int main(void)
{	bool ok = true;

	// This line is used by test_one.sh

	// external compiled tests
	ok &= Run( cumulative_sum,      "compare_op"         );
	ok &= Run( cumulative_sum,      "cumulative_sum"     );
	ok &= Run( conditional_skip,    "conditional_skip"   );
	ok &= Run( forward_active,      "forward_active"     );
	ok &= Run( nest_conditional,    "nest_conditional"   );
	ok &= Run( print_for,           "print_for"          );
	ok &= Run( reverse_active,      "reverse_active"     );

	// check for errors
	using std::cout;
	using std::endl;
	assert( ok || (Run_error_count > 0) );
	if( CppAD::thread_alloc::free_all() )
	{	Run_ok_count++;
		cout << "OK:    " << "No memory leak detected" << endl;
	}
	else
	{	ok = false;
		Run_error_count++;
		cout << "Error: " << "memory leak detected" << endl;
	}
	// convert int(size_t) to avoid warning on _MSC_VER systems
	if( ok )
		cout << "All " << int(Run_ok_count) << " tests passed." << endl;
	else	cout << int(Run_error_count) << " tests failed." << endl;

	return static_cast<int>( ! ok );
}
