// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/core/base.proto

package core

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import types "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"

import bytes "bytes"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Envoy supports :ref:`upstream priority routing
// <arch_overview_http_routing_priority>` both at the route and the virtual
// cluster level. The current priority implementation uses different connection
// pool and circuit breaking settings for each priority level. This means that
// even for HTTP/2 requests, two physical connections will be used to an
// upstream host. In the future Envoy will likely support true HTTP/2 priority
// over a single upstream connection.
type RoutingPriority int32

const (
	RoutingPriority_DEFAULT RoutingPriority = 0
	RoutingPriority_HIGH    RoutingPriority = 1
)

var RoutingPriority_name = map[int32]string{
	0: "DEFAULT",
	1: "HIGH",
}
var RoutingPriority_value = map[string]int32{
	"DEFAULT": 0,
	"HIGH":    1,
}

func (x RoutingPriority) String() string {
	return proto.EnumName(RoutingPriority_name, int32(x))
}
func (RoutingPriority) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{0}
}

// HTTP request method.
type RequestMethod int32

const (
	METHOD_UNSPECIFIED RequestMethod = 0
	GET                RequestMethod = 1
	HEAD               RequestMethod = 2
	POST               RequestMethod = 3
	PUT                RequestMethod = 4
	DELETE             RequestMethod = 5
	CONNECT            RequestMethod = 6
	OPTIONS            RequestMethod = 7
	TRACE              RequestMethod = 8
)

var RequestMethod_name = map[int32]string{
	0: "METHOD_UNSPECIFIED",
	1: "GET",
	2: "HEAD",
	3: "POST",
	4: "PUT",
	5: "DELETE",
	6: "CONNECT",
	7: "OPTIONS",
	8: "TRACE",
}
var RequestMethod_value = map[string]int32{
	"METHOD_UNSPECIFIED": 0,
	"GET":                1,
	"HEAD":               2,
	"POST":               3,
	"PUT":                4,
	"DELETE":             5,
	"CONNECT":            6,
	"OPTIONS":            7,
	"TRACE":              8,
}

func (x RequestMethod) String() string {
	return proto.EnumName(RequestMethod_name, int32(x))
}
func (RequestMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{1}
}

type SocketOption_SocketState int32

const (
	// Socket options are applied after socket creation but before binding the socket to a port
	STATE_PREBIND SocketOption_SocketState = 0
	// Socket options are applied after binding the socket to a port but before calling listen()
	STATE_BOUND SocketOption_SocketState = 1
	// Socket options are applied after calling listen()
	STATE_LISTENING SocketOption_SocketState = 2
)

var SocketOption_SocketState_name = map[int32]string{
	0: "STATE_PREBIND",
	1: "STATE_BOUND",
	2: "STATE_LISTENING",
}
var SocketOption_SocketState_value = map[string]int32{
	"STATE_PREBIND":   0,
	"STATE_BOUND":     1,
	"STATE_LISTENING": 2,
}

func (x SocketOption_SocketState) String() string {
	return proto.EnumName(SocketOption_SocketState_name, int32(x))
}
func (SocketOption_SocketState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{8, 0}
}

// Identifies location of where either Envoy runs or where upstream hosts run.
type Locality struct {
	// Region this :ref:`zone <envoy_api_field_core.Locality.zone>` belongs to.
	Region string `protobuf:"bytes,1,opt,name=region,proto3" json:"region,omitempty"`
	// Defines the local service zone where Envoy is running. Though optional, it
	// should be set if discovery service routing is used and the discovery
	// service exposes :ref:`zone data <config_cluster_manager_sds_api_host_az>`,
	// either in this message or via :option:`--service-zone`. The meaning of zone
	// is context dependent, e.g. `Availability Zone (AZ)
	// <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html>`_
	// on AWS, `Zone <https://cloud.google.com/compute/docs/regions-zones/>`_ on
	// GCP, etc.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// When used for locality of upstream hosts, this field further splits zone
	// into smaller chunks of sub-zones so they can be load balanced
	// independently.
	SubZone              string   `protobuf:"bytes,3,opt,name=sub_zone,json=subZone,proto3" json:"sub_zone,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Locality) Reset()         { *m = Locality{} }
func (m *Locality) String() string { return proto.CompactTextString(m) }
func (*Locality) ProtoMessage()    {}
func (*Locality) Descriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{0}
}
func (m *Locality) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Locality) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Locality.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Locality) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Locality.Merge(dst, src)
}
func (m *Locality) XXX_Size() int {
	return m.Size()
}
func (m *Locality) XXX_DiscardUnknown() {
	xxx_messageInfo_Locality.DiscardUnknown(m)
}

var xxx_messageInfo_Locality proto.InternalMessageInfo

func (m *Locality) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *Locality) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Locality) GetSubZone() string {
	if m != nil {
		return m.SubZone
	}
	return ""
}

// Identifies a specific Envoy instance. The node identifier is presented to the
// management server, which may use this identifier to distinguish per Envoy
// configuration for serving.
type Node struct {
	// An opaque node identifier for the Envoy node. This also provides the local
	// service node name. It should be set if any of the following features are
	// used: :ref:`statsd <arch_overview_statistics>`, :ref:`CDS
	// <config_cluster_manager_cds>`, and :ref:`HTTP tracing
	// <arch_overview_tracing>`, either in this message or via
	// :option:`--service-node`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Defines the local service cluster name where Envoy is running. Though
	// optional, it should be set if any of the following features are used:
	// :ref:`statsd <arch_overview_statistics>`, :ref:`health check cluster
	// verification <config_cluster_manager_cluster_hc_service_name>`,
	// :ref:`runtime override directory <config_runtime_override_subdirectory>`,
	// :ref:`user agent addition <config_http_conn_man_add_user_agent>`,
	// :ref:`HTTP global rate limiting <config_http_filters_rate_limit>`,
	// :ref:`CDS <config_cluster_manager_cds>`, and :ref:`HTTP tracing
	// <arch_overview_tracing>`, either in this message or via
	// :option:`--service-cluster`.
	Cluster string `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Opaque metadata extending the node identifier. Envoy will pass this
	// directly to the management server.
	Metadata *types.Struct `protobuf:"bytes,3,opt,name=metadata" json:"metadata,omitempty"`
	// Locality specifying where the Envoy instance is running.
	Locality *Locality `protobuf:"bytes,4,opt,name=locality" json:"locality,omitempty"`
	// This is motivated by informing a management server during canary which
	// version of Envoy is being tested in a heterogeneous fleet. This will be set
	// by Envoy in management server RPCs.
	BuildVersion         string   `protobuf:"bytes,5,opt,name=build_version,json=buildVersion,proto3" json:"build_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Node) Reset()         { *m = Node{} }
func (m *Node) String() string { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()    {}
func (*Node) Descriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{1}
}
func (m *Node) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Node) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Node.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Node) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Node.Merge(dst, src)
}
func (m *Node) XXX_Size() int {
	return m.Size()
}
func (m *Node) XXX_DiscardUnknown() {
	xxx_messageInfo_Node.DiscardUnknown(m)
}

var xxx_messageInfo_Node proto.InternalMessageInfo

func (m *Node) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Node) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *Node) GetMetadata() *types.Struct {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Node) GetLocality() *Locality {
	if m != nil {
		return m.Locality
	}
	return nil
}

func (m *Node) GetBuildVersion() string {
	if m != nil {
		return m.BuildVersion
	}
	return ""
}

// Metadata provides additional inputs to filters based on matched listeners,
// filter chains, routes and endpoints. It is structured as a map from filter
// name (in reverse DNS format) to metadata specific to the filter. Metadata
// key-values for a filter are merged as connection and request handling occurs,
// with later values for the same key overriding earlier values.
//
// An example use of metadata is providing additional values to
// http_connection_manager in the envoy.http_connection_manager.access_log
// namespace.
//
// For load balancing, Metadata provides a means to subset cluster endpoints.
// Endpoints have a Metadata object associated and routes contain a Metadata
// object to match against. There are some well defined metadata used today for
// this purpose:
//
// * ``{"envoy.lb": {"canary": <bool> }}`` This indicates the canary status of an
//   endpoint and is also used during header processing
//   (x-envoy-upstream-canary) and for stats purposes.
type Metadata struct {
	// Key is the reverse DNS filter name, e.g. com.acme.widget. The envoy.*
	// namespace is reserved for Envoy's built-in filters.
	FilterMetadata       map[string]*types.Struct `protobuf:"bytes,1,rep,name=filter_metadata,json=filterMetadata" json:"filter_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Metadata) Reset()         { *m = Metadata{} }
func (m *Metadata) String() string { return proto.CompactTextString(m) }
func (*Metadata) ProtoMessage()    {}
func (*Metadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{2}
}
func (m *Metadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Metadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Metadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Metadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metadata.Merge(dst, src)
}
func (m *Metadata) XXX_Size() int {
	return m.Size()
}
func (m *Metadata) XXX_DiscardUnknown() {
	xxx_messageInfo_Metadata.DiscardUnknown(m)
}

var xxx_messageInfo_Metadata proto.InternalMessageInfo

func (m *Metadata) GetFilterMetadata() map[string]*types.Struct {
	if m != nil {
		return m.FilterMetadata
	}
	return nil
}

// Runtime derived uint32 with a default when not specified.
type RuntimeUInt32 struct {
	// Default value if runtime value is not available.
	DefaultValue uint32 `protobuf:"varint,2,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// Runtime key to get value for comparison. This value is used if defined.
	RuntimeKey           string   `protobuf:"bytes,3,opt,name=runtime_key,json=runtimeKey,proto3" json:"runtime_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RuntimeUInt32) Reset()         { *m = RuntimeUInt32{} }
func (m *RuntimeUInt32) String() string { return proto.CompactTextString(m) }
func (*RuntimeUInt32) ProtoMessage()    {}
func (*RuntimeUInt32) Descriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{3}
}
func (m *RuntimeUInt32) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeUInt32) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeUInt32.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RuntimeUInt32) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeUInt32.Merge(dst, src)
}
func (m *RuntimeUInt32) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeUInt32) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeUInt32.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeUInt32 proto.InternalMessageInfo

func (m *RuntimeUInt32) GetDefaultValue() uint32 {
	if m != nil {
		return m.DefaultValue
	}
	return 0
}

func (m *RuntimeUInt32) GetRuntimeKey() string {
	if m != nil {
		return m.RuntimeKey
	}
	return ""
}

// Header name/value pair.
type HeaderValue struct {
	// Header name.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Header value.
	//
	// The same :ref:`format specifier <config_access_log_format>` as used for
	// :ref:`HTTP access logging <config_access_log>` applies here, however
	// unknown header values are replaced with the empty string instead of `-`.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HeaderValue) Reset()         { *m = HeaderValue{} }
func (m *HeaderValue) String() string { return proto.CompactTextString(m) }
func (*HeaderValue) ProtoMessage()    {}
func (*HeaderValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{4}
}
func (m *HeaderValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HeaderValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HeaderValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *HeaderValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HeaderValue.Merge(dst, src)
}
func (m *HeaderValue) XXX_Size() int {
	return m.Size()
}
func (m *HeaderValue) XXX_DiscardUnknown() {
	xxx_messageInfo_HeaderValue.DiscardUnknown(m)
}

var xxx_messageInfo_HeaderValue proto.InternalMessageInfo

func (m *HeaderValue) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *HeaderValue) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Header name/value pair plus option to control append behavior.
type HeaderValueOption struct {
	// Header name/value pair that this option applies to.
	Header *HeaderValue `protobuf:"bytes,1,opt,name=header" json:"header,omitempty"`
	// Should the value be appended? If true (default), the value is appended to
	// existing values.
	Append               *types.BoolValue `protobuf:"bytes,2,opt,name=append" json:"append,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *HeaderValueOption) Reset()         { *m = HeaderValueOption{} }
func (m *HeaderValueOption) String() string { return proto.CompactTextString(m) }
func (*HeaderValueOption) ProtoMessage()    {}
func (*HeaderValueOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{5}
}
func (m *HeaderValueOption) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HeaderValueOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HeaderValueOption.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *HeaderValueOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HeaderValueOption.Merge(dst, src)
}
func (m *HeaderValueOption) XXX_Size() int {
	return m.Size()
}
func (m *HeaderValueOption) XXX_DiscardUnknown() {
	xxx_messageInfo_HeaderValueOption.DiscardUnknown(m)
}

var xxx_messageInfo_HeaderValueOption proto.InternalMessageInfo

func (m *HeaderValueOption) GetHeader() *HeaderValue {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *HeaderValueOption) GetAppend() *types.BoolValue {
	if m != nil {
		return m.Append
	}
	return nil
}

// Data source consisting of either a file or an inline value.
type DataSource struct {
	// Types that are valid to be assigned to Specifier:
	//	*DataSource_Filename
	//	*DataSource_InlineBytes
	//	*DataSource_InlineString
	Specifier            isDataSource_Specifier `protobuf_oneof:"specifier"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *DataSource) Reset()         { *m = DataSource{} }
func (m *DataSource) String() string { return proto.CompactTextString(m) }
func (*DataSource) ProtoMessage()    {}
func (*DataSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{6}
}
func (m *DataSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *DataSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataSource.Merge(dst, src)
}
func (m *DataSource) XXX_Size() int {
	return m.Size()
}
func (m *DataSource) XXX_DiscardUnknown() {
	xxx_messageInfo_DataSource.DiscardUnknown(m)
}

var xxx_messageInfo_DataSource proto.InternalMessageInfo

type isDataSource_Specifier interface {
	isDataSource_Specifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type DataSource_Filename struct {
	Filename string `protobuf:"bytes,1,opt,name=filename,proto3,oneof"`
}
type DataSource_InlineBytes struct {
	InlineBytes []byte `protobuf:"bytes,2,opt,name=inline_bytes,json=inlineBytes,proto3,oneof"`
}
type DataSource_InlineString struct {
	InlineString string `protobuf:"bytes,3,opt,name=inline_string,json=inlineString,proto3,oneof"`
}

func (*DataSource_Filename) isDataSource_Specifier()     {}
func (*DataSource_InlineBytes) isDataSource_Specifier()  {}
func (*DataSource_InlineString) isDataSource_Specifier() {}

func (m *DataSource) GetSpecifier() isDataSource_Specifier {
	if m != nil {
		return m.Specifier
	}
	return nil
}

func (m *DataSource) GetFilename() string {
	if x, ok := m.GetSpecifier().(*DataSource_Filename); ok {
		return x.Filename
	}
	return ""
}

func (m *DataSource) GetInlineBytes() []byte {
	if x, ok := m.GetSpecifier().(*DataSource_InlineBytes); ok {
		return x.InlineBytes
	}
	return nil
}

func (m *DataSource) GetInlineString() string {
	if x, ok := m.GetSpecifier().(*DataSource_InlineString); ok {
		return x.InlineString
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DataSource) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DataSource_OneofMarshaler, _DataSource_OneofUnmarshaler, _DataSource_OneofSizer, []interface{}{
		(*DataSource_Filename)(nil),
		(*DataSource_InlineBytes)(nil),
		(*DataSource_InlineString)(nil),
	}
}

func _DataSource_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DataSource)
	// specifier
	switch x := m.Specifier.(type) {
	case *DataSource_Filename:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Filename)
	case *DataSource_InlineBytes:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.InlineBytes)
	case *DataSource_InlineString:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.InlineString)
	case nil:
	default:
		return fmt.Errorf("DataSource.Specifier has unexpected type %T", x)
	}
	return nil
}

func _DataSource_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DataSource)
	switch tag {
	case 1: // specifier.filename
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Specifier = &DataSource_Filename{x}
		return true, err
	case 2: // specifier.inline_bytes
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Specifier = &DataSource_InlineBytes{x}
		return true, err
	case 3: // specifier.inline_string
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Specifier = &DataSource_InlineString{x}
		return true, err
	default:
		return false, nil
	}
}

func _DataSource_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DataSource)
	// specifier
	switch x := m.Specifier.(type) {
	case *DataSource_Filename:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Filename)))
		n += len(x.Filename)
	case *DataSource_InlineBytes:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.InlineBytes)))
		n += len(x.InlineBytes)
	case *DataSource_InlineString:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.InlineString)))
		n += len(x.InlineString)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Configuration for transport socket in :ref:`listeners <config_listeners>` and
// :ref:`clusters <config_cluster_manager_cluster>`. If the configuration is
// empty, a default transport socket implementation and configuration will be
// chosen based on the platform and existence of tls_context.
type TransportSocket struct {
	// The name of the transport socket to instantiate. The name must match a supported transport
	// socket implementation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Implementation specific configuration which depends on the implementation being instantiated.
	// See the supported transport socket implementations for further documentation.
	Config               *types.Struct `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *TransportSocket) Reset()         { *m = TransportSocket{} }
func (m *TransportSocket) String() string { return proto.CompactTextString(m) }
func (*TransportSocket) ProtoMessage()    {}
func (*TransportSocket) Descriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{7}
}
func (m *TransportSocket) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransportSocket) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TransportSocket.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *TransportSocket) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransportSocket.Merge(dst, src)
}
func (m *TransportSocket) XXX_Size() int {
	return m.Size()
}
func (m *TransportSocket) XXX_DiscardUnknown() {
	xxx_messageInfo_TransportSocket.DiscardUnknown(m)
}

var xxx_messageInfo_TransportSocket proto.InternalMessageInfo

func (m *TransportSocket) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TransportSocket) GetConfig() *types.Struct {
	if m != nil {
		return m.Config
	}
	return nil
}

// Generic socket option message. This would be used to set socket options that
// might not exist in upstream kernels or precompiled Envoy binaries.
type SocketOption struct {
	// An optional name to give this socket option for debugging, etc.
	// Uniqueness is not required and no special meaning is assumed.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
	Level int64 `protobuf:"varint,2,opt,name=level,proto3" json:"level,omitempty"`
	// The numeric name as passed to setsockopt
	Name int64 `protobuf:"varint,3,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are valid to be assigned to Value:
	//	*SocketOption_IntValue
	//	*SocketOption_BufValue
	Value isSocketOption_Value `protobuf_oneof:"value"`
	// The state in which the option will be applied. When used in BindConfig
	// STATE_PREBIND is currently the only valid value.
	State                SocketOption_SocketState `protobuf:"varint,6,opt,name=state,proto3,enum=envoy.api.v2.core.SocketOption_SocketState" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *SocketOption) Reset()         { *m = SocketOption{} }
func (m *SocketOption) String() string { return proto.CompactTextString(m) }
func (*SocketOption) ProtoMessage()    {}
func (*SocketOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_base_0126f5109e43fb63, []int{8}
}
func (m *SocketOption) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SocketOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SocketOption.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *SocketOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SocketOption.Merge(dst, src)
}
func (m *SocketOption) XXX_Size() int {
	return m.Size()
}
func (m *SocketOption) XXX_DiscardUnknown() {
	xxx_messageInfo_SocketOption.DiscardUnknown(m)
}

var xxx_messageInfo_SocketOption proto.InternalMessageInfo

type isSocketOption_Value interface {
	isSocketOption_Value()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type SocketOption_IntValue struct {
	IntValue int64 `protobuf:"varint,4,opt,name=int_value,json=intValue,proto3,oneof"`
}
type SocketOption_BufValue struct {
	BufValue []byte `protobuf:"bytes,5,opt,name=buf_value,json=bufValue,proto3,oneof"`
}

func (*SocketOption_IntValue) isSocketOption_Value() {}
func (*SocketOption_BufValue) isSocketOption_Value() {}

func (m *SocketOption) GetValue() isSocketOption_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *SocketOption) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *SocketOption) GetLevel() int64 {
	if m != nil {
		return m.Level
	}
	return 0
}

func (m *SocketOption) GetName() int64 {
	if m != nil {
		return m.Name
	}
	return 0
}

func (m *SocketOption) GetIntValue() int64 {
	if x, ok := m.GetValue().(*SocketOption_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (m *SocketOption) GetBufValue() []byte {
	if x, ok := m.GetValue().(*SocketOption_BufValue); ok {
		return x.BufValue
	}
	return nil
}

func (m *SocketOption) GetState() SocketOption_SocketState {
	if m != nil {
		return m.State
	}
	return STATE_PREBIND
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SocketOption) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SocketOption_OneofMarshaler, _SocketOption_OneofUnmarshaler, _SocketOption_OneofSizer, []interface{}{
		(*SocketOption_IntValue)(nil),
		(*SocketOption_BufValue)(nil),
	}
}

func _SocketOption_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SocketOption)
	// value
	switch x := m.Value.(type) {
	case *SocketOption_IntValue:
		_ = b.EncodeVarint(4<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.IntValue))
	case *SocketOption_BufValue:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.BufValue)
	case nil:
	default:
		return fmt.Errorf("SocketOption.Value has unexpected type %T", x)
	}
	return nil
}

func _SocketOption_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SocketOption)
	switch tag {
	case 4: // value.int_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &SocketOption_IntValue{int64(x)}
		return true, err
	case 5: // value.buf_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Value = &SocketOption_BufValue{x}
		return true, err
	default:
		return false, nil
	}
}

func _SocketOption_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SocketOption)
	// value
	switch x := m.Value.(type) {
	case *SocketOption_IntValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.IntValue))
	case *SocketOption_BufValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.BufValue)))
		n += len(x.BufValue)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*Locality)(nil), "envoy.api.v2.core.Locality")
	proto.RegisterType((*Node)(nil), "envoy.api.v2.core.Node")
	proto.RegisterType((*Metadata)(nil), "envoy.api.v2.core.Metadata")
	proto.RegisterMapType((map[string]*types.Struct)(nil), "envoy.api.v2.core.Metadata.FilterMetadataEntry")
	proto.RegisterType((*RuntimeUInt32)(nil), "envoy.api.v2.core.RuntimeUInt32")
	proto.RegisterType((*HeaderValue)(nil), "envoy.api.v2.core.HeaderValue")
	proto.RegisterType((*HeaderValueOption)(nil), "envoy.api.v2.core.HeaderValueOption")
	proto.RegisterType((*DataSource)(nil), "envoy.api.v2.core.DataSource")
	proto.RegisterType((*TransportSocket)(nil), "envoy.api.v2.core.TransportSocket")
	proto.RegisterType((*SocketOption)(nil), "envoy.api.v2.core.SocketOption")
	proto.RegisterEnum("envoy.api.v2.core.RoutingPriority", RoutingPriority_name, RoutingPriority_value)
	proto.RegisterEnum("envoy.api.v2.core.RequestMethod", RequestMethod_name, RequestMethod_value)
	proto.RegisterEnum("envoy.api.v2.core.SocketOption_SocketState", SocketOption_SocketState_name, SocketOption_SocketState_value)
}
func (this *Locality) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Locality)
	if !ok {
		that2, ok := that.(Locality)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Region != that1.Region {
		return false
	}
	if this.Zone != that1.Zone {
		return false
	}
	if this.SubZone != that1.SubZone {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Node) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Node)
	if !ok {
		that2, ok := that.(Node)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.Cluster != that1.Cluster {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Locality.Equal(that1.Locality) {
		return false
	}
	if this.BuildVersion != that1.BuildVersion {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Metadata) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Metadata)
	if !ok {
		that2, ok := that.(Metadata)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.FilterMetadata) != len(that1.FilterMetadata) {
		return false
	}
	for i := range this.FilterMetadata {
		if !this.FilterMetadata[i].Equal(that1.FilterMetadata[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RuntimeUInt32) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RuntimeUInt32)
	if !ok {
		that2, ok := that.(RuntimeUInt32)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.DefaultValue != that1.DefaultValue {
		return false
	}
	if this.RuntimeKey != that1.RuntimeKey {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HeaderValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HeaderValue)
	if !ok {
		that2, ok := that.(HeaderValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HeaderValueOption) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HeaderValueOption)
	if !ok {
		that2, ok := that.(HeaderValueOption)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Header.Equal(that1.Header) {
		return false
	}
	if !this.Append.Equal(that1.Append) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *DataSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DataSource)
	if !ok {
		that2, ok := that.(DataSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Specifier == nil {
		if this.Specifier != nil {
			return false
		}
	} else if this.Specifier == nil {
		return false
	} else if !this.Specifier.Equal(that1.Specifier) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *DataSource_Filename) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DataSource_Filename)
	if !ok {
		that2, ok := that.(DataSource_Filename)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Filename != that1.Filename {
		return false
	}
	return true
}
func (this *DataSource_InlineBytes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DataSource_InlineBytes)
	if !ok {
		that2, ok := that.(DataSource_InlineBytes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.InlineBytes, that1.InlineBytes) {
		return false
	}
	return true
}
func (this *DataSource_InlineString) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DataSource_InlineString)
	if !ok {
		that2, ok := that.(DataSource_InlineString)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.InlineString != that1.InlineString {
		return false
	}
	return true
}
func (this *TransportSocket) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TransportSocket)
	if !ok {
		that2, ok := that.(TransportSocket)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *SocketOption) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SocketOption)
	if !ok {
		that2, ok := that.(SocketOption)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Description != that1.Description {
		return false
	}
	if this.Level != that1.Level {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if that1.Value == nil {
		if this.Value != nil {
			return false
		}
	} else if this.Value == nil {
		return false
	} else if !this.Value.Equal(that1.Value) {
		return false
	}
	if this.State != that1.State {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *SocketOption_IntValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SocketOption_IntValue)
	if !ok {
		that2, ok := that.(SocketOption_IntValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.IntValue != that1.IntValue {
		return false
	}
	return true
}
func (this *SocketOption_BufValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SocketOption_BufValue)
	if !ok {
		that2, ok := that.(SocketOption_BufValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.BufValue, that1.BufValue) {
		return false
	}
	return true
}
func (m *Locality) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Locality) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Region) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Region)))
		i += copy(dAtA[i:], m.Region)
	}
	if len(m.Zone) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Zone)))
		i += copy(dAtA[i:], m.Zone)
	}
	if len(m.SubZone) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.SubZone)))
		i += copy(dAtA[i:], m.SubZone)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Node) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Node) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Cluster) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Cluster)))
		i += copy(dAtA[i:], m.Cluster)
	}
	if m.Metadata != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Metadata.Size()))
		n1, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Locality != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Locality.Size()))
		n2, err := m.Locality.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.BuildVersion) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.BuildVersion)))
		i += copy(dAtA[i:], m.BuildVersion)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Metadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metadata) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.FilterMetadata) > 0 {
		for k, _ := range m.FilterMetadata {
			dAtA[i] = 0xa
			i++
			v := m.FilterMetadata[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovBase(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovBase(uint64(len(k))) + msgSize
			i = encodeVarintBase(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintBase(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintBase(dAtA, i, uint64(v.Size()))
				n3, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n3
			}
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RuntimeUInt32) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeUInt32) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DefaultValue != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.DefaultValue))
	}
	if len(m.RuntimeKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.RuntimeKey)))
		i += copy(dAtA[i:], m.RuntimeKey)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HeaderValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeaderValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HeaderValueOption) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeaderValueOption) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Header != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Header.Size()))
		n4, err := m.Header.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Append != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Append.Size()))
		n5, err := m.Append.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DataSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Specifier != nil {
		nn6, err := m.Specifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn6
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DataSource_Filename) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintBase(dAtA, i, uint64(len(m.Filename)))
	i += copy(dAtA[i:], m.Filename)
	return i, nil
}
func (m *DataSource_InlineBytes) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.InlineBytes != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.InlineBytes)))
		i += copy(dAtA[i:], m.InlineBytes)
	}
	return i, nil
}
func (m *DataSource_InlineString) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintBase(dAtA, i, uint64(len(m.InlineString)))
	i += copy(dAtA[i:], m.InlineString)
	return i, nil
}
func (m *TransportSocket) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransportSocket) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Config != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Config.Size()))
		n7, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SocketOption) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SocketOption) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Description) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if m.Level != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Level))
	}
	if m.Name != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Name))
	}
	if m.Value != nil {
		nn8, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn8
	}
	if m.State != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.State))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SocketOption_IntValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x20
	i++
	i = encodeVarintBase(dAtA, i, uint64(m.IntValue))
	return i, nil
}
func (m *SocketOption_BufValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.BufValue != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.BufValue)))
		i += copy(dAtA[i:], m.BufValue)
	}
	return i, nil
}
func encodeVarintBase(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Locality) Size() (n int) {
	var l int
	_ = l
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	l = len(m.Zone)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	l = len(m.SubZone)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Node) Size() (n int) {
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	l = len(m.Cluster)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovBase(uint64(l))
	}
	if m.Locality != nil {
		l = m.Locality.Size()
		n += 1 + l + sovBase(uint64(l))
	}
	l = len(m.BuildVersion)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Metadata) Size() (n int) {
	var l int
	_ = l
	if len(m.FilterMetadata) > 0 {
		for k, v := range m.FilterMetadata {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovBase(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovBase(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovBase(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RuntimeUInt32) Size() (n int) {
	var l int
	_ = l
	if m.DefaultValue != 0 {
		n += 1 + sovBase(uint64(m.DefaultValue))
	}
	l = len(m.RuntimeKey)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HeaderValue) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HeaderValueOption) Size() (n int) {
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovBase(uint64(l))
	}
	if m.Append != nil {
		l = m.Append.Size()
		n += 1 + l + sovBase(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DataSource) Size() (n int) {
	var l int
	_ = l
	if m.Specifier != nil {
		n += m.Specifier.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DataSource_Filename) Size() (n int) {
	var l int
	_ = l
	l = len(m.Filename)
	n += 1 + l + sovBase(uint64(l))
	return n
}
func (m *DataSource_InlineBytes) Size() (n int) {
	var l int
	_ = l
	if m.InlineBytes != nil {
		l = len(m.InlineBytes)
		n += 1 + l + sovBase(uint64(l))
	}
	return n
}
func (m *DataSource_InlineString) Size() (n int) {
	var l int
	_ = l
	l = len(m.InlineString)
	n += 1 + l + sovBase(uint64(l))
	return n
}
func (m *TransportSocket) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovBase(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SocketOption) Size() (n int) {
	var l int
	_ = l
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	if m.Level != 0 {
		n += 1 + sovBase(uint64(m.Level))
	}
	if m.Name != 0 {
		n += 1 + sovBase(uint64(m.Name))
	}
	if m.Value != nil {
		n += m.Value.Size()
	}
	if m.State != 0 {
		n += 1 + sovBase(uint64(m.State))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SocketOption_IntValue) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovBase(uint64(m.IntValue))
	return n
}
func (m *SocketOption_BufValue) Size() (n int) {
	var l int
	_ = l
	if m.BufValue != nil {
		l = len(m.BufValue)
		n += 1 + l + sovBase(uint64(l))
	}
	return n
}

func sovBase(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBase(x uint64) (n int) {
	return sovBase(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Locality) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Locality: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Locality: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Zone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Zone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubZone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubZone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Node) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Node: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Node: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &types.Struct{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locality", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Locality == nil {
				m.Locality = &Locality{}
			}
			if err := m.Locality.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BuildVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Metadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterMetadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FilterMetadata == nil {
				m.FilterMetadata = make(map[string]*types.Struct)
			}
			var mapkey string
			var mapvalue *types.Struct
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBase
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBase
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthBase
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBase
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthBase
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthBase
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Struct{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipBase(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthBase
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.FilterMetadata[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuntimeUInt32) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RuntimeUInt32: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RuntimeUInt32: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultValue", wireType)
			}
			m.DefaultValue = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DefaultValue |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeaderValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeaderValueOption) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderValueOption: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderValueOption: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &HeaderValue{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Append", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Append == nil {
				m.Append = &types.BoolValue{}
			}
			if err := m.Append.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filename", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Specifier = &DataSource_Filename{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InlineBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Specifier = &DataSource_InlineBytes{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InlineString", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Specifier = &DataSource_InlineString{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransportSocket) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransportSocket: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransportSocket: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &types.Struct{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SocketOption) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SocketOption: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SocketOption: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			m.Level = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Level |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			m.Name = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Name |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntValue", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = &SocketOption_IntValue{v}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BufValue", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Value = &SocketOption_BufValue{v}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (SocketOption_SocketState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBase(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBase
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBase
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBase
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthBase
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBase
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBase(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBase = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBase   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/api/v2/core/base.proto", fileDescriptor_base_0126f5109e43fb63) }

var fileDescriptor_base_0126f5109e43fb63 = []byte{
	// 974 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x54, 0x4f, 0x6f, 0xe3, 0xc4,
	0x1b, 0xee, 0xe4, 0x5f, 0x93, 0x37, 0x49, 0xeb, 0xce, 0x56, 0xdd, 0xfe, 0xba, 0xdb, 0xa8, 0xca,
	0xef, 0x40, 0x55, 0x84, 0x8d, 0xd2, 0x03, 0x88, 0x13, 0x75, 0xe3, 0x36, 0x11, 0x6d, 0x12, 0x6c,
	0x77, 0x41, 0xbd, 0x04, 0x27, 0x9e, 0x64, 0x47, 0xeb, 0x7a, 0xc2, 0x78, 0x1c, 0x94, 0x3d, 0x22,
	0x0e, 0x08, 0x3e, 0x06, 0x17, 0x24, 0xbe, 0x00, 0xe2, 0x54, 0x89, 0x0b, 0x37, 0xf8, 0x08, 0xa8,
	0xb7, 0xfd, 0x16, 0x68, 0xc6, 0x93, 0x6e, 0xa0, 0x15, 0xdc, 0xde, 0xf7, 0x79, 0x9f, 0xe7, 0xfd,
	0x37, 0xaf, 0x0d, 0xcf, 0x49, 0x3c, 0x67, 0x0b, 0x2b, 0x98, 0x51, 0x6b, 0xde, 0xb2, 0xc6, 0x8c,
	0x13, 0x6b, 0x14, 0x24, 0xc4, 0x9c, 0x71, 0x26, 0x18, 0xde, 0x52, 0x51, 0x33, 0x98, 0x51, 0x73,
	0xde, 0x32, 0x65, 0x74, 0xef, 0xf9, 0x94, 0xb1, 0x69, 0x44, 0x2c, 0x45, 0x18, 0xa5, 0x13, 0x2b,
	0x11, 0x3c, 0x1d, 0x8b, 0x4c, 0xb0, 0xd7, 0xf8, 0x67, 0xf4, 0x2b, 0x1e, 0xcc, 0x66, 0x84, 0x27,
	0x3a, 0xfe, 0x74, 0x1e, 0x44, 0x34, 0x0c, 0x04, 0xb1, 0x96, 0x86, 0x0e, 0x6c, 0x4f, 0xd9, 0x94,
	0x29, 0xd3, 0x92, 0x56, 0x86, 0x36, 0x3f, 0x85, 0xf2, 0x05, 0x1b, 0x07, 0x11, 0x15, 0x0b, 0xbc,
	0x03, 0x25, 0x4e, 0xa6, 0x94, 0xc5, 0xbb, 0xe8, 0x00, 0x1d, 0x56, 0x5c, 0xed, 0x61, 0x0c, 0x85,
	0xd7, 0x2c, 0x26, 0xbb, 0x39, 0x85, 0x2a, 0x1b, 0xff, 0x0f, 0xca, 0x49, 0x3a, 0x1a, 0x2a, 0x3c,
	0xaf, 0xf0, 0xf5, 0x24, 0x1d, 0x5d, 0xb3, 0x98, 0x34, 0x7f, 0x45, 0x50, 0xe8, 0xb1, 0x90, 0xe0,
	0x0d, 0xc8, 0xd1, 0x50, 0xe7, 0xca, 0xd1, 0x10, 0xef, 0xc2, 0xfa, 0x38, 0x4a, 0x13, 0x41, 0xb8,
	0x4e, 0xb5, 0x74, 0xf1, 0x31, 0x94, 0x6f, 0x88, 0x08, 0xc2, 0x40, 0x04, 0x2a, 0x5b, 0xb5, 0xf5,
	0xd4, 0xcc, 0xe6, 0x34, 0x97, 0x73, 0x9a, 0x9e, 0xda, 0x82, 0x7b, 0x4f, 0xc4, 0x1f, 0x40, 0x39,
	0xd2, 0xad, 0xef, 0x16, 0x94, 0xe8, 0x99, 0xf9, 0x60, 0x9b, 0xe6, 0x72, 0x3a, 0xf7, 0x9e, 0x8c,
	0xff, 0x0f, 0xf5, 0x51, 0x4a, 0xa3, 0x70, 0x38, 0x27, 0x3c, 0x91, 0xe3, 0x16, 0x55, 0x37, 0x35,
	0x05, 0xbe, 0xc8, 0xb0, 0xe6, 0x2d, 0x82, 0xf2, 0xe5, 0xb2, 0xd4, 0xe7, 0xb0, 0x39, 0xa1, 0x91,
	0x20, 0x7c, 0x78, 0xdf, 0x26, 0x3a, 0xc8, 0x1f, 0x56, 0x5b, 0xd6, 0x23, 0x15, 0x97, 0x2a, 0xf3,
	0x4c, 0x49, 0x96, 0xae, 0x13, 0x0b, 0xbe, 0x70, 0x37, 0x26, 0x7f, 0x03, 0xf7, 0xae, 0xe1, 0xc9,
	0x23, 0x34, 0x6c, 0x40, 0xfe, 0x15, 0x59, 0xe8, 0xdd, 0x49, 0x13, 0xbf, 0x07, 0xc5, 0x79, 0x10,
	0xa5, 0xd9, 0x2b, 0xfc, 0xcb, 0x7e, 0x32, 0xd6, 0x47, 0xb9, 0x0f, 0x51, 0xf3, 0x0b, 0xa8, 0xbb,
	0x69, 0x2c, 0xe8, 0x0d, 0xb9, 0xea, 0xc6, 0xe2, 0xb8, 0x25, 0x07, 0x0f, 0xc9, 0x24, 0x48, 0x23,
	0x31, 0x7c, 0x9b, 0xab, 0xee, 0xd6, 0x34, 0xf8, 0x42, 0x62, 0xf8, 0x08, 0xaa, 0x3c, 0x53, 0x0d,
	0x65, 0x0b, 0xea, 0x71, 0xed, 0xca, 0x2f, 0x6f, 0x6e, 0xf3, 0x05, 0x9e, 0x3b, 0x40, 0x2e, 0xe8,
	0xe8, 0x27, 0x64, 0xd1, 0xfc, 0x18, 0xaa, 0x1d, 0x12, 0x84, 0x84, 0x67, 0xd2, 0x67, 0x2b, 0x5d,
	0xaf, 0x4a, 0xd4, 0x00, 0xdb, 0xab, 0x03, 0x54, 0x74, 0x9f, 0xcd, 0xef, 0x11, 0x6c, 0xad, 0xa4,
	0xe8, 0xcf, 0x84, 0xbc, 0x38, 0x1b, 0x4a, 0x2f, 0x15, 0xa8, 0x72, 0x55, 0x5b, 0x8d, 0x47, 0xd6,
	0xbc, 0xa2, 0xb2, 0x41, 0xd6, 0x2a, 0x7e, 0x87, 0x72, 0x06, 0x72, 0xb5, 0x12, 0xb7, 0xa0, 0x24,
	0x3f, 0x8c, 0x38, 0xd4, 0x1b, 0xdb, 0x7b, 0xb0, 0x31, 0x9b, 0xb1, 0x48, 0xe9, 0x5d, 0xcd, 0x6c,
	0xfe, 0x84, 0x00, 0xda, 0x81, 0x08, 0x3c, 0x96, 0xf2, 0x31, 0xc1, 0xef, 0x40, 0x79, 0x42, 0x23,
	0x12, 0x07, 0x37, 0xe4, 0xc1, 0x50, 0x9d, 0x35, 0xf7, 0x3e, 0x88, 0x4d, 0xa8, 0xd1, 0x38, 0xa2,
	0x31, 0x19, 0x8e, 0x16, 0x82, 0x24, 0xaa, 0x62, 0x4d, 0x93, 0x5f, 0xe7, 0x0c, 0x49, 0xae, 0x66,
	0x04, 0x5b, 0xc6, 0xf1, 0xfb, 0x50, 0xd7, 0xfc, 0x44, 0x70, 0x1a, 0x4f, 0x1f, 0x6c, 0xb9, 0xb3,
	0xe6, 0xea, 0x8c, 0x9e, 0x22, 0xd8, 0x18, 0x2a, 0xc9, 0x8c, 0x8c, 0xe9, 0x84, 0x12, 0x8e, 0x8b,
	0x3f, 0xbf, 0xb9, 0xcd, 0xa3, 0x66, 0x00, 0x9b, 0x3e, 0x0f, 0xe2, 0x64, 0xc6, 0xb8, 0xf0, 0xd8,
	0xf8, 0x15, 0x11, 0x78, 0x1f, 0x0a, 0x8f, 0x76, 0xeb, 0x2a, 0x18, 0x5b, 0x50, 0x1a, 0xb3, 0x78,
	0x42, 0xa7, 0xff, 0x75, 0x45, 0x9a, 0xd6, 0xfc, 0x3d, 0x07, 0xb5, 0x2c, 0xb5, 0x7e, 0x99, 0x03,
	0xa8, 0x86, 0x24, 0x19, 0x73, 0xaa, 0x5c, 0x7d, 0xa0, 0xab, 0x90, 0x7c, 0xe7, 0x88, 0xcc, 0x49,
	0xa4, 0x4a, 0xe4, 0xdd, 0xcc, 0x91, 0xff, 0x10, 0xd5, 0x58, 0x5e, 0x81, 0x59, 0x37, 0xfb, 0x50,
	0xa1, 0xf1, 0xf2, 0x14, 0xe5, 0x17, 0x9c, 0x97, 0x4b, 0xa5, 0xb1, 0x3e, 0xc4, 0x7d, 0xa8, 0x8c,
	0xd2, 0x89, 0x0e, 0xcb, 0x4f, 0xb4, 0x26, 0xc3, 0xa3, 0x74, 0x92, 0x85, 0x3f, 0x83, 0x62, 0x22,
	0x02, 0x41, 0x76, 0x4b, 0x07, 0xe8, 0x70, 0xa3, 0xf5, 0xee, 0x23, 0x27, 0xb2, 0xda, 0xb9, 0x76,
	0x3c, 0x29, 0xb1, 0xb7, 0xdf, 0xde, 0x8b, 0xb2, 0xbe, 0x56, 0x97, 0x93, 0xe5, 0x6b, 0x5e, 0x40,
	0x75, 0x85, 0x8b, 0xb7, 0xa0, 0xee, 0xf9, 0x27, 0xbe, 0x33, 0x1c, 0xb8, 0x8e, 0xdd, 0xed, 0xb5,
	0x8d, 0x35, 0xbc, 0x09, 0xd5, 0x0c, 0xb2, 0xfb, 0x57, 0xbd, 0xb6, 0x81, 0xf0, 0x13, 0xd8, 0xcc,
	0x80, 0x8b, 0xae, 0xe7, 0x3b, 0xbd, 0x6e, 0xef, 0xdc, 0xc8, 0xed, 0x15, 0xbe, 0xfd, 0xa1, 0xb1,
	0x66, 0x6f, 0xe8, 0xb3, 0xd7, 0x8f, 0x76, 0x74, 0x08, 0x9b, 0x2e, 0x4b, 0x05, 0x8d, 0xa7, 0x03,
	0x4e, 0x19, 0x97, 0xff, 0xa3, 0x2a, 0xac, 0xb7, 0x9d, 0xb3, 0x93, 0xab, 0x0b, 0xdf, 0x58, 0xc3,
	0x65, 0x28, 0x74, 0xba, 0xe7, 0x1d, 0x03, 0x1d, 0x7d, 0x83, 0xa0, 0xee, 0x92, 0x2f, 0x53, 0x92,
	0x88, 0x4b, 0x22, 0x5e, 0xb2, 0x10, 0xef, 0x00, 0xbe, 0x74, 0xfc, 0x4e, 0xbf, 0x3d, 0xbc, 0xea,
	0x79, 0x03, 0xe7, 0xb4, 0x7b, 0xd6, 0x75, 0x64, 0x3f, 0xeb, 0x90, 0x3f, 0x77, 0x7c, 0x03, 0x29,
	0xb1, 0x73, 0xd2, 0x36, 0x72, 0xd2, 0x1a, 0xf4, 0x3d, 0xdf, 0xc8, 0xcb, 0xe0, 0xe0, 0xca, 0x37,
	0x0a, 0x18, 0xa0, 0xd4, 0x76, 0x2e, 0x1c, 0xdf, 0x31, 0x8a, 0xb2, 0xe4, 0x69, 0xbf, 0xd7, 0x73,
	0x4e, 0x7d, 0xa3, 0x24, 0x9d, 0xfe, 0xc0, 0xef, 0xf6, 0x7b, 0x9e, 0xb1, 0x8e, 0x2b, 0x50, 0xf4,
	0xdd, 0x93, 0x53, 0xc7, 0x28, 0xeb, 0x01, 0x76, 0x7e, 0xbc, 0x6b, 0xa0, 0xdf, 0xee, 0x1a, 0xe8,
	0x8f, 0xbb, 0x06, 0xfa, 0xf3, 0xae, 0x81, 0xae, 0x0b, 0x72, 0xb9, 0xa3, 0x92, 0xba, 0x99, 0xe3,
	0xbf, 0x02, 0x00, 0x00, 0xff, 0xff, 0xa0, 0x2e, 0x4d, 0x11, 0xe0, 0x06, 0x00, 0x00,
}
